<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailProcessing StructType
 * @subpackage Structs
 */
class EmailProcessing extends Entity
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $Account;
    /**
     * The AccountEmailAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AccountEmailAccountID;
    /**
     * The AssignedToMe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $AssignedToMe;
    /**
     * The AssignedToOwner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AssignedToOwner;
    /**
     * The IncludeFailed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IncludeFailed;
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Result
     */
    public $Result;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for EmailProcessing
     * @uses EmailProcessing::setAccount()
     * @uses EmailProcessing::setAccountEmailAccountID()
     * @uses EmailProcessing::setAssignedToMe()
     * @uses EmailProcessing::setAssignedToOwner()
     * @uses EmailProcessing::setIncludeFailed()
     * @uses EmailProcessing::setResult()
     * @uses EmailProcessing::setType()
     * @param \AcumaticaConfig\StructType\IntValue $account
     * @param \AcumaticaConfig\StructType\StringValue $accountEmailAccountID
     * @param \AcumaticaConfig\StructType\BooleanValue $assignedToMe
     * @param \AcumaticaConfig\StructType\StringValue $assignedToOwner
     * @param \AcumaticaConfig\StructType\BooleanValue $includeFailed
     * @param \AcumaticaConfig\StructType\Result $result
     * @param \AcumaticaConfig\StructType\StringValue $type
     */
    public function __construct(\AcumaticaConfig\StructType\IntValue $account = null, \AcumaticaConfig\StructType\StringValue $accountEmailAccountID = null, \AcumaticaConfig\StructType\BooleanValue $assignedToMe = null, \AcumaticaConfig\StructType\StringValue $assignedToOwner = null, \AcumaticaConfig\StructType\BooleanValue $includeFailed = null, \AcumaticaConfig\StructType\Result $result = null, \AcumaticaConfig\StructType\StringValue $type = null)
    {
        $this
            ->setAccount($account)
            ->setAccountEmailAccountID($accountEmailAccountID)
            ->setAssignedToMe($assignedToMe)
            ->setAssignedToOwner($assignedToOwner)
            ->setIncludeFailed($includeFailed)
            ->setResult($result)
            ->setType($type);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $account
     * @return \AcumaticaConfig\StructType\EmailProcessing
     */
    public function setAccount(\AcumaticaConfig\StructType\IntValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountEmailAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccountEmailAccountID()
    {
        return isset($this->AccountEmailAccountID) ? $this->AccountEmailAccountID : null;
    }
    /**
     * Set AccountEmailAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $accountEmailAccountID
     * @return \AcumaticaConfig\StructType\EmailProcessing
     */
    public function setAccountEmailAccountID(\AcumaticaConfig\StructType\StringValue $accountEmailAccountID = null)
    {
        if (is_null($accountEmailAccountID) || (is_array($accountEmailAccountID) && empty($accountEmailAccountID))) {
            unset($this->AccountEmailAccountID);
        } else {
            $this->AccountEmailAccountID = $accountEmailAccountID;
        }
        return $this;
    }
    /**
     * Get AssignedToMe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getAssignedToMe()
    {
        return isset($this->AssignedToMe) ? $this->AssignedToMe : null;
    }
    /**
     * Set AssignedToMe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $assignedToMe
     * @return \AcumaticaConfig\StructType\EmailProcessing
     */
    public function setAssignedToMe(\AcumaticaConfig\StructType\BooleanValue $assignedToMe = null)
    {
        if (is_null($assignedToMe) || (is_array($assignedToMe) && empty($assignedToMe))) {
            unset($this->AssignedToMe);
        } else {
            $this->AssignedToMe = $assignedToMe;
        }
        return $this;
    }
    /**
     * Get AssignedToOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAssignedToOwner()
    {
        return isset($this->AssignedToOwner) ? $this->AssignedToOwner : null;
    }
    /**
     * Set AssignedToOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $assignedToOwner
     * @return \AcumaticaConfig\StructType\EmailProcessing
     */
    public function setAssignedToOwner(\AcumaticaConfig\StructType\StringValue $assignedToOwner = null)
    {
        if (is_null($assignedToOwner) || (is_array($assignedToOwner) && empty($assignedToOwner))) {
            unset($this->AssignedToOwner);
        } else {
            $this->AssignedToOwner = $assignedToOwner;
        }
        return $this;
    }
    /**
     * Get IncludeFailed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIncludeFailed()
    {
        return isset($this->IncludeFailed) ? $this->IncludeFailed : null;
    }
    /**
     * Set IncludeFailed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $includeFailed
     * @return \AcumaticaConfig\StructType\EmailProcessing
     */
    public function setIncludeFailed(\AcumaticaConfig\StructType\BooleanValue $includeFailed = null)
    {
        if (is_null($includeFailed) || (is_array($includeFailed) && empty($includeFailed))) {
            unset($this->IncludeFailed);
        } else {
            $this->IncludeFailed = $includeFailed;
        }
        return $this;
    }
    /**
     * Get Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Result|null
     */
    public function getResult()
    {
        return isset($this->Result) ? $this->Result : null;
    }
    /**
     * Set Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Result $result
     * @return \AcumaticaConfig\StructType\EmailProcessing
     */
    public function setResult(\AcumaticaConfig\StructType\Result $result = null)
    {
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->Result);
        } else {
            $this->Result = $result;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @return \AcumaticaConfig\StructType\EmailProcessing
     */
    public function setType(\AcumaticaConfig\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\EmailProcessing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
