<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountDetails StructType
 * @subpackage Structs
 */
class DiscountDetails extends AbstractStructBase
{
    /**
     * The SalesOrdersDiscountDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SalesOrdersDiscountDetails[]
     */
    public $SalesOrdersDiscountDetails;
    /**
     * Constructor method for DiscountDetails
     * @uses DiscountDetails::setSalesOrdersDiscountDetails()
     * @param \AcumaticaConfig\StructType\SalesOrdersDiscountDetails[] $salesOrdersDiscountDetails
     */
    public function __construct(array $salesOrdersDiscountDetails = array())
    {
        $this
            ->setSalesOrdersDiscountDetails($salesOrdersDiscountDetails);
    }
    /**
     * Get SalesOrdersDiscountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SalesOrdersDiscountDetails[]|null
     */
    public function getSalesOrdersDiscountDetails()
    {
        return isset($this->SalesOrdersDiscountDetails) ? $this->SalesOrdersDiscountDetails : null;
    }
    /**
     * Set SalesOrdersDiscountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesOrdersDiscountDetails[] $salesOrdersDiscountDetails
     * @return \AcumaticaConfig\StructType\DiscountDetails
     */
    public function setSalesOrdersDiscountDetails(array $salesOrdersDiscountDetails = array())
    {
        foreach ($salesOrdersDiscountDetails as $discountDetailsSalesOrdersDiscountDetailsItem) {
            // validation for constraint: itemType
            if (!$discountDetailsSalesOrdersDiscountDetailsItem instanceof \AcumaticaConfig\StructType\SalesOrdersDiscountDetails) {
                throw new \InvalidArgumentException(sprintf('The SalesOrdersDiscountDetails property can only contain items of \AcumaticaConfig\StructType\SalesOrdersDiscountDetails, "%s" given', is_object($discountDetailsSalesOrdersDiscountDetailsItem) ? get_class($discountDetailsSalesOrdersDiscountDetailsItem) : gettype($discountDetailsSalesOrdersDiscountDetailsItem)), __LINE__);
            }
        }
        if (is_null($salesOrdersDiscountDetails) || (is_array($salesOrdersDiscountDetails) && empty($salesOrdersDiscountDetails))) {
            unset($this->SalesOrdersDiscountDetails);
        } else {
            $this->SalesOrdersDiscountDetails = $salesOrdersDiscountDetails;
        }
        return $this;
    }
    /**
     * Add item to SalesOrdersDiscountDetails value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesOrdersDiscountDetails $item
     * @return \AcumaticaConfig\StructType\DiscountDetails
     */
    public function addToSalesOrdersDiscountDetails(\AcumaticaConfig\StructType\SalesOrdersDiscountDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\SalesOrdersDiscountDetails) {
            throw new \InvalidArgumentException(sprintf('The SalesOrdersDiscountDetails property can only contain items of \AcumaticaConfig\StructType\SalesOrdersDiscountDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesOrdersDiscountDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\DiscountDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
