<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Details StructType
 * @subpackage Structs
 */
class Details extends AbstractStructBase
{
    /**
     * The PhysicalInventoryCountDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PhysicalInventoryCountDetail[]
     */
    public $PhysicalInventoryCountDetail;
    /**
     * The PurchaseOrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PurchaseOrderDetail[]
     */
    public $PurchaseOrderDetail;
    /**
     * The FinancialPeriodDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\FinancialPeriodDetail[]
     */
    public $FinancialPeriodDetail;
    /**
     * The SalesOrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SalesOrderDetail[]
     */
    public $SalesOrderDetail;
    /**
     * The FinancialYearPeriodDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\FinancialYearPeriodDetail[]
     */
    public $FinancialYearPeriodDetail;
    /**
     * The AdjustmentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\AdjustmentDetail[]
     */
    public $AdjustmentDetail;
    /**
     * The JournalTransactionDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\JournalTransactionDetail[]
     */
    public $JournalTransactionDetail;
    /**
     * The InventoryReceiptDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\InventoryReceiptDetail[]
     */
    public $InventoryReceiptDetail;
    /**
     * The SalesInvoiceDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SalesInvoiceDetail[]
     */
    public $SalesInvoiceDetail;
    /**
     * The JournalVoucherDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\JournalVoucherDetail[]
     */
    public $JournalVoucherDetail;
    /**
     * The ShippingTermDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShippingTermDetail[]
     */
    public $ShippingTermDetail;
    /**
     * The TaxCategoryTaxDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TaxCategoryTaxDetail[]
     */
    public $TaxCategoryTaxDetail;
    /**
     * The InvoiceDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\InvoiceDetail[]
     */
    public $InvoiceDetail;
    /**
     * The ShipmentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShipmentDetail[]
     */
    public $ShipmentDetail;
    /**
     * The CashSaleDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CashSaleDetail[]
     */
    public $CashSaleDetail;
    /**
     * The TrialBalanceDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TrialBalanceDetail[]
     */
    public $TrialBalanceDetail;
    /**
     * The CheckDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CheckDetail[]
     */
    public $CheckDetail;
    /**
     * The ProjectTransactionDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ProjectTransactionDetail[]
     */
    public $ProjectTransactionDetail;
    /**
     * The TransferOrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TransferOrderDetail[]
     */
    public $TransferOrderDetail;
    /**
     * The BillDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BillDetail[]
     */
    public $BillDetail;
    /**
     * The CustomerPaymentMethodDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CustomerPaymentMethodDetail[]
     */
    public $CustomerPaymentMethodDetail;
    /**
     * The PhysicalInventoryReviewDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail[]
     */
    public $PhysicalInventoryReviewDetail;
    /**
     * The PurchaseReceiptDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PurchaseReceiptDetail[]
     */
    public $PurchaseReceiptDetail;
    /**
     * Constructor method for Details
     * @uses Details::setPhysicalInventoryCountDetail()
     * @uses Details::setPurchaseOrderDetail()
     * @uses Details::setFinancialPeriodDetail()
     * @uses Details::setSalesOrderDetail()
     * @uses Details::setFinancialYearPeriodDetail()
     * @uses Details::setAdjustmentDetail()
     * @uses Details::setJournalTransactionDetail()
     * @uses Details::setInventoryReceiptDetail()
     * @uses Details::setSalesInvoiceDetail()
     * @uses Details::setJournalVoucherDetail()
     * @uses Details::setShippingTermDetail()
     * @uses Details::setTaxCategoryTaxDetail()
     * @uses Details::setInvoiceDetail()
     * @uses Details::setShipmentDetail()
     * @uses Details::setCashSaleDetail()
     * @uses Details::setTrialBalanceDetail()
     * @uses Details::setCheckDetail()
     * @uses Details::setProjectTransactionDetail()
     * @uses Details::setTransferOrderDetail()
     * @uses Details::setBillDetail()
     * @uses Details::setCustomerPaymentMethodDetail()
     * @uses Details::setPhysicalInventoryReviewDetail()
     * @uses Details::setPurchaseReceiptDetail()
     * @param \AcumaticaConfig\StructType\PhysicalInventoryCountDetail[] $physicalInventoryCountDetail
     * @param \AcumaticaConfig\StructType\PurchaseOrderDetail[] $purchaseOrderDetail
     * @param \AcumaticaConfig\StructType\FinancialPeriodDetail[] $financialPeriodDetail
     * @param \AcumaticaConfig\StructType\SalesOrderDetail[] $salesOrderDetail
     * @param \AcumaticaConfig\StructType\FinancialYearPeriodDetail[] $financialYearPeriodDetail
     * @param \AcumaticaConfig\StructType\AdjustmentDetail[] $adjustmentDetail
     * @param \AcumaticaConfig\StructType\JournalTransactionDetail[] $journalTransactionDetail
     * @param \AcumaticaConfig\StructType\InventoryReceiptDetail[] $inventoryReceiptDetail
     * @param \AcumaticaConfig\StructType\SalesInvoiceDetail[] $salesInvoiceDetail
     * @param \AcumaticaConfig\StructType\JournalVoucherDetail[] $journalVoucherDetail
     * @param \AcumaticaConfig\StructType\ShippingTermDetail[] $shippingTermDetail
     * @param \AcumaticaConfig\StructType\TaxCategoryTaxDetail[] $taxCategoryTaxDetail
     * @param \AcumaticaConfig\StructType\InvoiceDetail[] $invoiceDetail
     * @param \AcumaticaConfig\StructType\ShipmentDetail[] $shipmentDetail
     * @param \AcumaticaConfig\StructType\CashSaleDetail[] $cashSaleDetail
     * @param \AcumaticaConfig\StructType\TrialBalanceDetail[] $trialBalanceDetail
     * @param \AcumaticaConfig\StructType\CheckDetail[] $checkDetail
     * @param \AcumaticaConfig\StructType\ProjectTransactionDetail[] $projectTransactionDetail
     * @param \AcumaticaConfig\StructType\TransferOrderDetail[] $transferOrderDetail
     * @param \AcumaticaConfig\StructType\BillDetail[] $billDetail
     * @param \AcumaticaConfig\StructType\CustomerPaymentMethodDetail[] $customerPaymentMethodDetail
     * @param \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail[] $physicalInventoryReviewDetail
     * @param \AcumaticaConfig\StructType\PurchaseReceiptDetail[] $purchaseReceiptDetail
     */
    public function __construct(array $physicalInventoryCountDetail = array(), array $purchaseOrderDetail = array(), array $financialPeriodDetail = array(), array $salesOrderDetail = array(), array $financialYearPeriodDetail = array(), array $adjustmentDetail = array(), array $journalTransactionDetail = array(), array $inventoryReceiptDetail = array(), array $salesInvoiceDetail = array(), array $journalVoucherDetail = array(), array $shippingTermDetail = array(), array $taxCategoryTaxDetail = array(), array $invoiceDetail = array(), array $shipmentDetail = array(), array $cashSaleDetail = array(), array $trialBalanceDetail = array(), array $checkDetail = array(), array $projectTransactionDetail = array(), array $transferOrderDetail = array(), array $billDetail = array(), array $customerPaymentMethodDetail = array(), array $physicalInventoryReviewDetail = array(), array $purchaseReceiptDetail = array())
    {
        $this
            ->setPhysicalInventoryCountDetail($physicalInventoryCountDetail)
            ->setPurchaseOrderDetail($purchaseOrderDetail)
            ->setFinancialPeriodDetail($financialPeriodDetail)
            ->setSalesOrderDetail($salesOrderDetail)
            ->setFinancialYearPeriodDetail($financialYearPeriodDetail)
            ->setAdjustmentDetail($adjustmentDetail)
            ->setJournalTransactionDetail($journalTransactionDetail)
            ->setInventoryReceiptDetail($inventoryReceiptDetail)
            ->setSalesInvoiceDetail($salesInvoiceDetail)
            ->setJournalVoucherDetail($journalVoucherDetail)
            ->setShippingTermDetail($shippingTermDetail)
            ->setTaxCategoryTaxDetail($taxCategoryTaxDetail)
            ->setInvoiceDetail($invoiceDetail)
            ->setShipmentDetail($shipmentDetail)
            ->setCashSaleDetail($cashSaleDetail)
            ->setTrialBalanceDetail($trialBalanceDetail)
            ->setCheckDetail($checkDetail)
            ->setProjectTransactionDetail($projectTransactionDetail)
            ->setTransferOrderDetail($transferOrderDetail)
            ->setBillDetail($billDetail)
            ->setCustomerPaymentMethodDetail($customerPaymentMethodDetail)
            ->setPhysicalInventoryReviewDetail($physicalInventoryReviewDetail)
            ->setPurchaseReceiptDetail($purchaseReceiptDetail);
    }
    /**
     * Get PhysicalInventoryCountDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PhysicalInventoryCountDetail[]|null
     */
    public function getPhysicalInventoryCountDetail()
    {
        return isset($this->PhysicalInventoryCountDetail) ? $this->PhysicalInventoryCountDetail : null;
    }
    /**
     * Set PhysicalInventoryCountDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PhysicalInventoryCountDetail[] $physicalInventoryCountDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setPhysicalInventoryCountDetail(array $physicalInventoryCountDetail = array())
    {
        foreach ($physicalInventoryCountDetail as $detailsPhysicalInventoryCountDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPhysicalInventoryCountDetailItem instanceof \AcumaticaConfig\StructType\PhysicalInventoryCountDetail) {
                throw new \InvalidArgumentException(sprintf('The PhysicalInventoryCountDetail property can only contain items of \AcumaticaConfig\StructType\PhysicalInventoryCountDetail, "%s" given', is_object($detailsPhysicalInventoryCountDetailItem) ? get_class($detailsPhysicalInventoryCountDetailItem) : gettype($detailsPhysicalInventoryCountDetailItem)), __LINE__);
            }
        }
        if (is_null($physicalInventoryCountDetail) || (is_array($physicalInventoryCountDetail) && empty($physicalInventoryCountDetail))) {
            unset($this->PhysicalInventoryCountDetail);
        } else {
            $this->PhysicalInventoryCountDetail = $physicalInventoryCountDetail;
        }
        return $this;
    }
    /**
     * Add item to PhysicalInventoryCountDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PhysicalInventoryCountDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToPhysicalInventoryCountDetail(\AcumaticaConfig\StructType\PhysicalInventoryCountDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\PhysicalInventoryCountDetail) {
            throw new \InvalidArgumentException(sprintf('The PhysicalInventoryCountDetail property can only contain items of \AcumaticaConfig\StructType\PhysicalInventoryCountDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhysicalInventoryCountDetail[] = $item;
        return $this;
    }
    /**
     * Get PurchaseOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PurchaseOrderDetail[]|null
     */
    public function getPurchaseOrderDetail()
    {
        return isset($this->PurchaseOrderDetail) ? $this->PurchaseOrderDetail : null;
    }
    /**
     * Set PurchaseOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PurchaseOrderDetail[] $purchaseOrderDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setPurchaseOrderDetail(array $purchaseOrderDetail = array())
    {
        foreach ($purchaseOrderDetail as $detailsPurchaseOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPurchaseOrderDetailItem instanceof \AcumaticaConfig\StructType\PurchaseOrderDetail) {
                throw new \InvalidArgumentException(sprintf('The PurchaseOrderDetail property can only contain items of \AcumaticaConfig\StructType\PurchaseOrderDetail, "%s" given', is_object($detailsPurchaseOrderDetailItem) ? get_class($detailsPurchaseOrderDetailItem) : gettype($detailsPurchaseOrderDetailItem)), __LINE__);
            }
        }
        if (is_null($purchaseOrderDetail) || (is_array($purchaseOrderDetail) && empty($purchaseOrderDetail))) {
            unset($this->PurchaseOrderDetail);
        } else {
            $this->PurchaseOrderDetail = $purchaseOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to PurchaseOrderDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PurchaseOrderDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToPurchaseOrderDetail(\AcumaticaConfig\StructType\PurchaseOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\PurchaseOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The PurchaseOrderDetail property can only contain items of \AcumaticaConfig\StructType\PurchaseOrderDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PurchaseOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get FinancialPeriodDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\FinancialPeriodDetail[]|null
     */
    public function getFinancialPeriodDetail()
    {
        return isset($this->FinancialPeriodDetail) ? $this->FinancialPeriodDetail : null;
    }
    /**
     * Set FinancialPeriodDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\FinancialPeriodDetail[] $financialPeriodDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setFinancialPeriodDetail(array $financialPeriodDetail = array())
    {
        foreach ($financialPeriodDetail as $detailsFinancialPeriodDetailItem) {
            // validation for constraint: itemType
            if (!$detailsFinancialPeriodDetailItem instanceof \AcumaticaConfig\StructType\FinancialPeriodDetail) {
                throw new \InvalidArgumentException(sprintf('The FinancialPeriodDetail property can only contain items of \AcumaticaConfig\StructType\FinancialPeriodDetail, "%s" given', is_object($detailsFinancialPeriodDetailItem) ? get_class($detailsFinancialPeriodDetailItem) : gettype($detailsFinancialPeriodDetailItem)), __LINE__);
            }
        }
        if (is_null($financialPeriodDetail) || (is_array($financialPeriodDetail) && empty($financialPeriodDetail))) {
            unset($this->FinancialPeriodDetail);
        } else {
            $this->FinancialPeriodDetail = $financialPeriodDetail;
        }
        return $this;
    }
    /**
     * Add item to FinancialPeriodDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\FinancialPeriodDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToFinancialPeriodDetail(\AcumaticaConfig\StructType\FinancialPeriodDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\FinancialPeriodDetail) {
            throw new \InvalidArgumentException(sprintf('The FinancialPeriodDetail property can only contain items of \AcumaticaConfig\StructType\FinancialPeriodDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FinancialPeriodDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SalesOrderDetail[]|null
     */
    public function getSalesOrderDetail()
    {
        return isset($this->SalesOrderDetail) ? $this->SalesOrderDetail : null;
    }
    /**
     * Set SalesOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesOrderDetail[] $salesOrderDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setSalesOrderDetail(array $salesOrderDetail = array())
    {
        foreach ($salesOrderDetail as $detailsSalesOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsSalesOrderDetailItem instanceof \AcumaticaConfig\StructType\SalesOrderDetail) {
                throw new \InvalidArgumentException(sprintf('The SalesOrderDetail property can only contain items of \AcumaticaConfig\StructType\SalesOrderDetail, "%s" given', is_object($detailsSalesOrderDetailItem) ? get_class($detailsSalesOrderDetailItem) : gettype($detailsSalesOrderDetailItem)), __LINE__);
            }
        }
        if (is_null($salesOrderDetail) || (is_array($salesOrderDetail) && empty($salesOrderDetail))) {
            unset($this->SalesOrderDetail);
        } else {
            $this->SalesOrderDetail = $salesOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesOrderDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesOrderDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToSalesOrderDetail(\AcumaticaConfig\StructType\SalesOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\SalesOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesOrderDetail property can only contain items of \AcumaticaConfig\StructType\SalesOrderDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get FinancialYearPeriodDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\FinancialYearPeriodDetail[]|null
     */
    public function getFinancialYearPeriodDetail()
    {
        return isset($this->FinancialYearPeriodDetail) ? $this->FinancialYearPeriodDetail : null;
    }
    /**
     * Set FinancialYearPeriodDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\FinancialYearPeriodDetail[] $financialYearPeriodDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setFinancialYearPeriodDetail(array $financialYearPeriodDetail = array())
    {
        foreach ($financialYearPeriodDetail as $detailsFinancialYearPeriodDetailItem) {
            // validation for constraint: itemType
            if (!$detailsFinancialYearPeriodDetailItem instanceof \AcumaticaConfig\StructType\FinancialYearPeriodDetail) {
                throw new \InvalidArgumentException(sprintf('The FinancialYearPeriodDetail property can only contain items of \AcumaticaConfig\StructType\FinancialYearPeriodDetail, "%s" given', is_object($detailsFinancialYearPeriodDetailItem) ? get_class($detailsFinancialYearPeriodDetailItem) : gettype($detailsFinancialYearPeriodDetailItem)), __LINE__);
            }
        }
        if (is_null($financialYearPeriodDetail) || (is_array($financialYearPeriodDetail) && empty($financialYearPeriodDetail))) {
            unset($this->FinancialYearPeriodDetail);
        } else {
            $this->FinancialYearPeriodDetail = $financialYearPeriodDetail;
        }
        return $this;
    }
    /**
     * Add item to FinancialYearPeriodDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\FinancialYearPeriodDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToFinancialYearPeriodDetail(\AcumaticaConfig\StructType\FinancialYearPeriodDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\FinancialYearPeriodDetail) {
            throw new \InvalidArgumentException(sprintf('The FinancialYearPeriodDetail property can only contain items of \AcumaticaConfig\StructType\FinancialYearPeriodDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FinancialYearPeriodDetail[] = $item;
        return $this;
    }
    /**
     * Get AdjustmentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\AdjustmentDetail[]|null
     */
    public function getAdjustmentDetail()
    {
        return isset($this->AdjustmentDetail) ? $this->AdjustmentDetail : null;
    }
    /**
     * Set AdjustmentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AdjustmentDetail[] $adjustmentDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setAdjustmentDetail(array $adjustmentDetail = array())
    {
        foreach ($adjustmentDetail as $detailsAdjustmentDetailItem) {
            // validation for constraint: itemType
            if (!$detailsAdjustmentDetailItem instanceof \AcumaticaConfig\StructType\AdjustmentDetail) {
                throw new \InvalidArgumentException(sprintf('The AdjustmentDetail property can only contain items of \AcumaticaConfig\StructType\AdjustmentDetail, "%s" given', is_object($detailsAdjustmentDetailItem) ? get_class($detailsAdjustmentDetailItem) : gettype($detailsAdjustmentDetailItem)), __LINE__);
            }
        }
        if (is_null($adjustmentDetail) || (is_array($adjustmentDetail) && empty($adjustmentDetail))) {
            unset($this->AdjustmentDetail);
        } else {
            $this->AdjustmentDetail = $adjustmentDetail;
        }
        return $this;
    }
    /**
     * Add item to AdjustmentDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AdjustmentDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToAdjustmentDetail(\AcumaticaConfig\StructType\AdjustmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\AdjustmentDetail) {
            throw new \InvalidArgumentException(sprintf('The AdjustmentDetail property can only contain items of \AcumaticaConfig\StructType\AdjustmentDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdjustmentDetail[] = $item;
        return $this;
    }
    /**
     * Get JournalTransactionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\JournalTransactionDetail[]|null
     */
    public function getJournalTransactionDetail()
    {
        return isset($this->JournalTransactionDetail) ? $this->JournalTransactionDetail : null;
    }
    /**
     * Set JournalTransactionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\JournalTransactionDetail[] $journalTransactionDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setJournalTransactionDetail(array $journalTransactionDetail = array())
    {
        foreach ($journalTransactionDetail as $detailsJournalTransactionDetailItem) {
            // validation for constraint: itemType
            if (!$detailsJournalTransactionDetailItem instanceof \AcumaticaConfig\StructType\JournalTransactionDetail) {
                throw new \InvalidArgumentException(sprintf('The JournalTransactionDetail property can only contain items of \AcumaticaConfig\StructType\JournalTransactionDetail, "%s" given', is_object($detailsJournalTransactionDetailItem) ? get_class($detailsJournalTransactionDetailItem) : gettype($detailsJournalTransactionDetailItem)), __LINE__);
            }
        }
        if (is_null($journalTransactionDetail) || (is_array($journalTransactionDetail) && empty($journalTransactionDetail))) {
            unset($this->JournalTransactionDetail);
        } else {
            $this->JournalTransactionDetail = $journalTransactionDetail;
        }
        return $this;
    }
    /**
     * Add item to JournalTransactionDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\JournalTransactionDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToJournalTransactionDetail(\AcumaticaConfig\StructType\JournalTransactionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\JournalTransactionDetail) {
            throw new \InvalidArgumentException(sprintf('The JournalTransactionDetail property can only contain items of \AcumaticaConfig\StructType\JournalTransactionDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JournalTransactionDetail[] = $item;
        return $this;
    }
    /**
     * Get InventoryReceiptDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\InventoryReceiptDetail[]|null
     */
    public function getInventoryReceiptDetail()
    {
        return isset($this->InventoryReceiptDetail) ? $this->InventoryReceiptDetail : null;
    }
    /**
     * Set InventoryReceiptDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryReceiptDetail[] $inventoryReceiptDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setInventoryReceiptDetail(array $inventoryReceiptDetail = array())
    {
        foreach ($inventoryReceiptDetail as $detailsInventoryReceiptDetailItem) {
            // validation for constraint: itemType
            if (!$detailsInventoryReceiptDetailItem instanceof \AcumaticaConfig\StructType\InventoryReceiptDetail) {
                throw new \InvalidArgumentException(sprintf('The InventoryReceiptDetail property can only contain items of \AcumaticaConfig\StructType\InventoryReceiptDetail, "%s" given', is_object($detailsInventoryReceiptDetailItem) ? get_class($detailsInventoryReceiptDetailItem) : gettype($detailsInventoryReceiptDetailItem)), __LINE__);
            }
        }
        if (is_null($inventoryReceiptDetail) || (is_array($inventoryReceiptDetail) && empty($inventoryReceiptDetail))) {
            unset($this->InventoryReceiptDetail);
        } else {
            $this->InventoryReceiptDetail = $inventoryReceiptDetail;
        }
        return $this;
    }
    /**
     * Add item to InventoryReceiptDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryReceiptDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToInventoryReceiptDetail(\AcumaticaConfig\StructType\InventoryReceiptDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\InventoryReceiptDetail) {
            throw new \InvalidArgumentException(sprintf('The InventoryReceiptDetail property can only contain items of \AcumaticaConfig\StructType\InventoryReceiptDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventoryReceiptDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesInvoiceDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail[]|null
     */
    public function getSalesInvoiceDetail()
    {
        return isset($this->SalesInvoiceDetail) ? $this->SalesInvoiceDetail : null;
    }
    /**
     * Set SalesInvoiceDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesInvoiceDetail[] $salesInvoiceDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setSalesInvoiceDetail(array $salesInvoiceDetail = array())
    {
        foreach ($salesInvoiceDetail as $detailsSalesInvoiceDetailItem) {
            // validation for constraint: itemType
            if (!$detailsSalesInvoiceDetailItem instanceof \AcumaticaConfig\StructType\SalesInvoiceDetail) {
                throw new \InvalidArgumentException(sprintf('The SalesInvoiceDetail property can only contain items of \AcumaticaConfig\StructType\SalesInvoiceDetail, "%s" given', is_object($detailsSalesInvoiceDetailItem) ? get_class($detailsSalesInvoiceDetailItem) : gettype($detailsSalesInvoiceDetailItem)), __LINE__);
            }
        }
        if (is_null($salesInvoiceDetail) || (is_array($salesInvoiceDetail) && empty($salesInvoiceDetail))) {
            unset($this->SalesInvoiceDetail);
        } else {
            $this->SalesInvoiceDetail = $salesInvoiceDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesInvoiceDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToSalesInvoiceDetail(\AcumaticaConfig\StructType\SalesInvoiceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\SalesInvoiceDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceDetail property can only contain items of \AcumaticaConfig\StructType\SalesInvoiceDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesInvoiceDetail[] = $item;
        return $this;
    }
    /**
     * Get JournalVoucherDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\JournalVoucherDetail[]|null
     */
    public function getJournalVoucherDetail()
    {
        return isset($this->JournalVoucherDetail) ? $this->JournalVoucherDetail : null;
    }
    /**
     * Set JournalVoucherDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\JournalVoucherDetail[] $journalVoucherDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setJournalVoucherDetail(array $journalVoucherDetail = array())
    {
        foreach ($journalVoucherDetail as $detailsJournalVoucherDetailItem) {
            // validation for constraint: itemType
            if (!$detailsJournalVoucherDetailItem instanceof \AcumaticaConfig\StructType\JournalVoucherDetail) {
                throw new \InvalidArgumentException(sprintf('The JournalVoucherDetail property can only contain items of \AcumaticaConfig\StructType\JournalVoucherDetail, "%s" given', is_object($detailsJournalVoucherDetailItem) ? get_class($detailsJournalVoucherDetailItem) : gettype($detailsJournalVoucherDetailItem)), __LINE__);
            }
        }
        if (is_null($journalVoucherDetail) || (is_array($journalVoucherDetail) && empty($journalVoucherDetail))) {
            unset($this->JournalVoucherDetail);
        } else {
            $this->JournalVoucherDetail = $journalVoucherDetail;
        }
        return $this;
    }
    /**
     * Add item to JournalVoucherDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\JournalVoucherDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToJournalVoucherDetail(\AcumaticaConfig\StructType\JournalVoucherDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\JournalVoucherDetail) {
            throw new \InvalidArgumentException(sprintf('The JournalVoucherDetail property can only contain items of \AcumaticaConfig\StructType\JournalVoucherDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JournalVoucherDetail[] = $item;
        return $this;
    }
    /**
     * Get ShippingTermDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShippingTermDetail[]|null
     */
    public function getShippingTermDetail()
    {
        return isset($this->ShippingTermDetail) ? $this->ShippingTermDetail : null;
    }
    /**
     * Set ShippingTermDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShippingTermDetail[] $shippingTermDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setShippingTermDetail(array $shippingTermDetail = array())
    {
        foreach ($shippingTermDetail as $detailsShippingTermDetailItem) {
            // validation for constraint: itemType
            if (!$detailsShippingTermDetailItem instanceof \AcumaticaConfig\StructType\ShippingTermDetail) {
                throw new \InvalidArgumentException(sprintf('The ShippingTermDetail property can only contain items of \AcumaticaConfig\StructType\ShippingTermDetail, "%s" given', is_object($detailsShippingTermDetailItem) ? get_class($detailsShippingTermDetailItem) : gettype($detailsShippingTermDetailItem)), __LINE__);
            }
        }
        if (is_null($shippingTermDetail) || (is_array($shippingTermDetail) && empty($shippingTermDetail))) {
            unset($this->ShippingTermDetail);
        } else {
            $this->ShippingTermDetail = $shippingTermDetail;
        }
        return $this;
    }
    /**
     * Add item to ShippingTermDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShippingTermDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToShippingTermDetail(\AcumaticaConfig\StructType\ShippingTermDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ShippingTermDetail) {
            throw new \InvalidArgumentException(sprintf('The ShippingTermDetail property can only contain items of \AcumaticaConfig\StructType\ShippingTermDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShippingTermDetail[] = $item;
        return $this;
    }
    /**
     * Get TaxCategoryTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TaxCategoryTaxDetail[]|null
     */
    public function getTaxCategoryTaxDetail()
    {
        return isset($this->TaxCategoryTaxDetail) ? $this->TaxCategoryTaxDetail : null;
    }
    /**
     * Set TaxCategoryTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaxCategoryTaxDetail[] $taxCategoryTaxDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setTaxCategoryTaxDetail(array $taxCategoryTaxDetail = array())
    {
        foreach ($taxCategoryTaxDetail as $detailsTaxCategoryTaxDetailItem) {
            // validation for constraint: itemType
            if (!$detailsTaxCategoryTaxDetailItem instanceof \AcumaticaConfig\StructType\TaxCategoryTaxDetail) {
                throw new \InvalidArgumentException(sprintf('The TaxCategoryTaxDetail property can only contain items of \AcumaticaConfig\StructType\TaxCategoryTaxDetail, "%s" given', is_object($detailsTaxCategoryTaxDetailItem) ? get_class($detailsTaxCategoryTaxDetailItem) : gettype($detailsTaxCategoryTaxDetailItem)), __LINE__);
            }
        }
        if (is_null($taxCategoryTaxDetail) || (is_array($taxCategoryTaxDetail) && empty($taxCategoryTaxDetail))) {
            unset($this->TaxCategoryTaxDetail);
        } else {
            $this->TaxCategoryTaxDetail = $taxCategoryTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to TaxCategoryTaxDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaxCategoryTaxDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToTaxCategoryTaxDetail(\AcumaticaConfig\StructType\TaxCategoryTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\TaxCategoryTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxCategoryTaxDetail property can only contain items of \AcumaticaConfig\StructType\TaxCategoryTaxDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TaxCategoryTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get InvoiceDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\InvoiceDetail[]|null
     */
    public function getInvoiceDetail()
    {
        return isset($this->InvoiceDetail) ? $this->InvoiceDetail : null;
    }
    /**
     * Set InvoiceDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InvoiceDetail[] $invoiceDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setInvoiceDetail(array $invoiceDetail = array())
    {
        foreach ($invoiceDetail as $detailsInvoiceDetailItem) {
            // validation for constraint: itemType
            if (!$detailsInvoiceDetailItem instanceof \AcumaticaConfig\StructType\InvoiceDetail) {
                throw new \InvalidArgumentException(sprintf('The InvoiceDetail property can only contain items of \AcumaticaConfig\StructType\InvoiceDetail, "%s" given', is_object($detailsInvoiceDetailItem) ? get_class($detailsInvoiceDetailItem) : gettype($detailsInvoiceDetailItem)), __LINE__);
            }
        }
        if (is_null($invoiceDetail) || (is_array($invoiceDetail) && empty($invoiceDetail))) {
            unset($this->InvoiceDetail);
        } else {
            $this->InvoiceDetail = $invoiceDetail;
        }
        return $this;
    }
    /**
     * Add item to InvoiceDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InvoiceDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToInvoiceDetail(\AcumaticaConfig\StructType\InvoiceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\InvoiceDetail) {
            throw new \InvalidArgumentException(sprintf('The InvoiceDetail property can only contain items of \AcumaticaConfig\StructType\InvoiceDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InvoiceDetail[] = $item;
        return $this;
    }
    /**
     * Get ShipmentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShipmentDetail[]|null
     */
    public function getShipmentDetail()
    {
        return isset($this->ShipmentDetail) ? $this->ShipmentDetail : null;
    }
    /**
     * Set ShipmentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentDetail[] $shipmentDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setShipmentDetail(array $shipmentDetail = array())
    {
        foreach ($shipmentDetail as $detailsShipmentDetailItem) {
            // validation for constraint: itemType
            if (!$detailsShipmentDetailItem instanceof \AcumaticaConfig\StructType\ShipmentDetail) {
                throw new \InvalidArgumentException(sprintf('The ShipmentDetail property can only contain items of \AcumaticaConfig\StructType\ShipmentDetail, "%s" given', is_object($detailsShipmentDetailItem) ? get_class($detailsShipmentDetailItem) : gettype($detailsShipmentDetailItem)), __LINE__);
            }
        }
        if (is_null($shipmentDetail) || (is_array($shipmentDetail) && empty($shipmentDetail))) {
            unset($this->ShipmentDetail);
        } else {
            $this->ShipmentDetail = $shipmentDetail;
        }
        return $this;
    }
    /**
     * Add item to ShipmentDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToShipmentDetail(\AcumaticaConfig\StructType\ShipmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ShipmentDetail) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDetail property can only contain items of \AcumaticaConfig\StructType\ShipmentDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentDetail[] = $item;
        return $this;
    }
    /**
     * Get CashSaleDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CashSaleDetail[]|null
     */
    public function getCashSaleDetail()
    {
        return isset($this->CashSaleDetail) ? $this->CashSaleDetail : null;
    }
    /**
     * Set CashSaleDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CashSaleDetail[] $cashSaleDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setCashSaleDetail(array $cashSaleDetail = array())
    {
        foreach ($cashSaleDetail as $detailsCashSaleDetailItem) {
            // validation for constraint: itemType
            if (!$detailsCashSaleDetailItem instanceof \AcumaticaConfig\StructType\CashSaleDetail) {
                throw new \InvalidArgumentException(sprintf('The CashSaleDetail property can only contain items of \AcumaticaConfig\StructType\CashSaleDetail, "%s" given', is_object($detailsCashSaleDetailItem) ? get_class($detailsCashSaleDetailItem) : gettype($detailsCashSaleDetailItem)), __LINE__);
            }
        }
        if (is_null($cashSaleDetail) || (is_array($cashSaleDetail) && empty($cashSaleDetail))) {
            unset($this->CashSaleDetail);
        } else {
            $this->CashSaleDetail = $cashSaleDetail;
        }
        return $this;
    }
    /**
     * Add item to CashSaleDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CashSaleDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToCashSaleDetail(\AcumaticaConfig\StructType\CashSaleDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CashSaleDetail) {
            throw new \InvalidArgumentException(sprintf('The CashSaleDetail property can only contain items of \AcumaticaConfig\StructType\CashSaleDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CashSaleDetail[] = $item;
        return $this;
    }
    /**
     * Get TrialBalanceDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TrialBalanceDetail[]|null
     */
    public function getTrialBalanceDetail()
    {
        return isset($this->TrialBalanceDetail) ? $this->TrialBalanceDetail : null;
    }
    /**
     * Set TrialBalanceDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TrialBalanceDetail[] $trialBalanceDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setTrialBalanceDetail(array $trialBalanceDetail = array())
    {
        foreach ($trialBalanceDetail as $detailsTrialBalanceDetailItem) {
            // validation for constraint: itemType
            if (!$detailsTrialBalanceDetailItem instanceof \AcumaticaConfig\StructType\TrialBalanceDetail) {
                throw new \InvalidArgumentException(sprintf('The TrialBalanceDetail property can only contain items of \AcumaticaConfig\StructType\TrialBalanceDetail, "%s" given', is_object($detailsTrialBalanceDetailItem) ? get_class($detailsTrialBalanceDetailItem) : gettype($detailsTrialBalanceDetailItem)), __LINE__);
            }
        }
        if (is_null($trialBalanceDetail) || (is_array($trialBalanceDetail) && empty($trialBalanceDetail))) {
            unset($this->TrialBalanceDetail);
        } else {
            $this->TrialBalanceDetail = $trialBalanceDetail;
        }
        return $this;
    }
    /**
     * Add item to TrialBalanceDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TrialBalanceDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToTrialBalanceDetail(\AcumaticaConfig\StructType\TrialBalanceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\TrialBalanceDetail) {
            throw new \InvalidArgumentException(sprintf('The TrialBalanceDetail property can only contain items of \AcumaticaConfig\StructType\TrialBalanceDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TrialBalanceDetail[] = $item;
        return $this;
    }
    /**
     * Get CheckDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CheckDetail[]|null
     */
    public function getCheckDetail()
    {
        return isset($this->CheckDetail) ? $this->CheckDetail : null;
    }
    /**
     * Set CheckDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CheckDetail[] $checkDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setCheckDetail(array $checkDetail = array())
    {
        foreach ($checkDetail as $detailsCheckDetailItem) {
            // validation for constraint: itemType
            if (!$detailsCheckDetailItem instanceof \AcumaticaConfig\StructType\CheckDetail) {
                throw new \InvalidArgumentException(sprintf('The CheckDetail property can only contain items of \AcumaticaConfig\StructType\CheckDetail, "%s" given', is_object($detailsCheckDetailItem) ? get_class($detailsCheckDetailItem) : gettype($detailsCheckDetailItem)), __LINE__);
            }
        }
        if (is_null($checkDetail) || (is_array($checkDetail) && empty($checkDetail))) {
            unset($this->CheckDetail);
        } else {
            $this->CheckDetail = $checkDetail;
        }
        return $this;
    }
    /**
     * Add item to CheckDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CheckDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToCheckDetail(\AcumaticaConfig\StructType\CheckDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CheckDetail) {
            throw new \InvalidArgumentException(sprintf('The CheckDetail property can only contain items of \AcumaticaConfig\StructType\CheckDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CheckDetail[] = $item;
        return $this;
    }
    /**
     * Get ProjectTransactionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail[]|null
     */
    public function getProjectTransactionDetail()
    {
        return isset($this->ProjectTransactionDetail) ? $this->ProjectTransactionDetail : null;
    }
    /**
     * Set ProjectTransactionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProjectTransactionDetail[] $projectTransactionDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setProjectTransactionDetail(array $projectTransactionDetail = array())
    {
        foreach ($projectTransactionDetail as $detailsProjectTransactionDetailItem) {
            // validation for constraint: itemType
            if (!$detailsProjectTransactionDetailItem instanceof \AcumaticaConfig\StructType\ProjectTransactionDetail) {
                throw new \InvalidArgumentException(sprintf('The ProjectTransactionDetail property can only contain items of \AcumaticaConfig\StructType\ProjectTransactionDetail, "%s" given', is_object($detailsProjectTransactionDetailItem) ? get_class($detailsProjectTransactionDetailItem) : gettype($detailsProjectTransactionDetailItem)), __LINE__);
            }
        }
        if (is_null($projectTransactionDetail) || (is_array($projectTransactionDetail) && empty($projectTransactionDetail))) {
            unset($this->ProjectTransactionDetail);
        } else {
            $this->ProjectTransactionDetail = $projectTransactionDetail;
        }
        return $this;
    }
    /**
     * Add item to ProjectTransactionDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProjectTransactionDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToProjectTransactionDetail(\AcumaticaConfig\StructType\ProjectTransactionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ProjectTransactionDetail) {
            throw new \InvalidArgumentException(sprintf('The ProjectTransactionDetail property can only contain items of \AcumaticaConfig\StructType\ProjectTransactionDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProjectTransactionDetail[] = $item;
        return $this;
    }
    /**
     * Get TransferOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TransferOrderDetail[]|null
     */
    public function getTransferOrderDetail()
    {
        return isset($this->TransferOrderDetail) ? $this->TransferOrderDetail : null;
    }
    /**
     * Set TransferOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TransferOrderDetail[] $transferOrderDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setTransferOrderDetail(array $transferOrderDetail = array())
    {
        foreach ($transferOrderDetail as $detailsTransferOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsTransferOrderDetailItem instanceof \AcumaticaConfig\StructType\TransferOrderDetail) {
                throw new \InvalidArgumentException(sprintf('The TransferOrderDetail property can only contain items of \AcumaticaConfig\StructType\TransferOrderDetail, "%s" given', is_object($detailsTransferOrderDetailItem) ? get_class($detailsTransferOrderDetailItem) : gettype($detailsTransferOrderDetailItem)), __LINE__);
            }
        }
        if (is_null($transferOrderDetail) || (is_array($transferOrderDetail) && empty($transferOrderDetail))) {
            unset($this->TransferOrderDetail);
        } else {
            $this->TransferOrderDetail = $transferOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to TransferOrderDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TransferOrderDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToTransferOrderDetail(\AcumaticaConfig\StructType\TransferOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\TransferOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The TransferOrderDetail property can only contain items of \AcumaticaConfig\StructType\TransferOrderDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransferOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get BillDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BillDetail[]|null
     */
    public function getBillDetail()
    {
        return isset($this->BillDetail) ? $this->BillDetail : null;
    }
    /**
     * Set BillDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BillDetail[] $billDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setBillDetail(array $billDetail = array())
    {
        foreach ($billDetail as $detailsBillDetailItem) {
            // validation for constraint: itemType
            if (!$detailsBillDetailItem instanceof \AcumaticaConfig\StructType\BillDetail) {
                throw new \InvalidArgumentException(sprintf('The BillDetail property can only contain items of \AcumaticaConfig\StructType\BillDetail, "%s" given', is_object($detailsBillDetailItem) ? get_class($detailsBillDetailItem) : gettype($detailsBillDetailItem)), __LINE__);
            }
        }
        if (is_null($billDetail) || (is_array($billDetail) && empty($billDetail))) {
            unset($this->BillDetail);
        } else {
            $this->BillDetail = $billDetail;
        }
        return $this;
    }
    /**
     * Add item to BillDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BillDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToBillDetail(\AcumaticaConfig\StructType\BillDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BillDetail) {
            throw new \InvalidArgumentException(sprintf('The BillDetail property can only contain items of \AcumaticaConfig\StructType\BillDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillDetail[] = $item;
        return $this;
    }
    /**
     * Get CustomerPaymentMethodDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CustomerPaymentMethodDetail[]|null
     */
    public function getCustomerPaymentMethodDetail()
    {
        return isset($this->CustomerPaymentMethodDetail) ? $this->CustomerPaymentMethodDetail : null;
    }
    /**
     * Set CustomerPaymentMethodDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CustomerPaymentMethodDetail[] $customerPaymentMethodDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setCustomerPaymentMethodDetail(array $customerPaymentMethodDetail = array())
    {
        foreach ($customerPaymentMethodDetail as $detailsCustomerPaymentMethodDetailItem) {
            // validation for constraint: itemType
            if (!$detailsCustomerPaymentMethodDetailItem instanceof \AcumaticaConfig\StructType\CustomerPaymentMethodDetail) {
                throw new \InvalidArgumentException(sprintf('The CustomerPaymentMethodDetail property can only contain items of \AcumaticaConfig\StructType\CustomerPaymentMethodDetail, "%s" given', is_object($detailsCustomerPaymentMethodDetailItem) ? get_class($detailsCustomerPaymentMethodDetailItem) : gettype($detailsCustomerPaymentMethodDetailItem)), __LINE__);
            }
        }
        if (is_null($customerPaymentMethodDetail) || (is_array($customerPaymentMethodDetail) && empty($customerPaymentMethodDetail))) {
            unset($this->CustomerPaymentMethodDetail);
        } else {
            $this->CustomerPaymentMethodDetail = $customerPaymentMethodDetail;
        }
        return $this;
    }
    /**
     * Add item to CustomerPaymentMethodDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CustomerPaymentMethodDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToCustomerPaymentMethodDetail(\AcumaticaConfig\StructType\CustomerPaymentMethodDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CustomerPaymentMethodDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomerPaymentMethodDetail property can only contain items of \AcumaticaConfig\StructType\CustomerPaymentMethodDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerPaymentMethodDetail[] = $item;
        return $this;
    }
    /**
     * Get PhysicalInventoryReviewDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail[]|null
     */
    public function getPhysicalInventoryReviewDetail()
    {
        return isset($this->PhysicalInventoryReviewDetail) ? $this->PhysicalInventoryReviewDetail : null;
    }
    /**
     * Set PhysicalInventoryReviewDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail[] $physicalInventoryReviewDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setPhysicalInventoryReviewDetail(array $physicalInventoryReviewDetail = array())
    {
        foreach ($physicalInventoryReviewDetail as $detailsPhysicalInventoryReviewDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPhysicalInventoryReviewDetailItem instanceof \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail) {
                throw new \InvalidArgumentException(sprintf('The PhysicalInventoryReviewDetail property can only contain items of \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail, "%s" given', is_object($detailsPhysicalInventoryReviewDetailItem) ? get_class($detailsPhysicalInventoryReviewDetailItem) : gettype($detailsPhysicalInventoryReviewDetailItem)), __LINE__);
            }
        }
        if (is_null($physicalInventoryReviewDetail) || (is_array($physicalInventoryReviewDetail) && empty($physicalInventoryReviewDetail))) {
            unset($this->PhysicalInventoryReviewDetail);
        } else {
            $this->PhysicalInventoryReviewDetail = $physicalInventoryReviewDetail;
        }
        return $this;
    }
    /**
     * Add item to PhysicalInventoryReviewDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToPhysicalInventoryReviewDetail(\AcumaticaConfig\StructType\PhysicalInventoryReviewDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail) {
            throw new \InvalidArgumentException(sprintf('The PhysicalInventoryReviewDetail property can only contain items of \AcumaticaConfig\StructType\PhysicalInventoryReviewDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhysicalInventoryReviewDetail[] = $item;
        return $this;
    }
    /**
     * Get PurchaseReceiptDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PurchaseReceiptDetail[]|null
     */
    public function getPurchaseReceiptDetail()
    {
        return isset($this->PurchaseReceiptDetail) ? $this->PurchaseReceiptDetail : null;
    }
    /**
     * Set PurchaseReceiptDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PurchaseReceiptDetail[] $purchaseReceiptDetail
     * @return \AcumaticaConfig\StructType\Details
     */
    public function setPurchaseReceiptDetail(array $purchaseReceiptDetail = array())
    {
        foreach ($purchaseReceiptDetail as $detailsPurchaseReceiptDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPurchaseReceiptDetailItem instanceof \AcumaticaConfig\StructType\PurchaseReceiptDetail) {
                throw new \InvalidArgumentException(sprintf('The PurchaseReceiptDetail property can only contain items of \AcumaticaConfig\StructType\PurchaseReceiptDetail, "%s" given', is_object($detailsPurchaseReceiptDetailItem) ? get_class($detailsPurchaseReceiptDetailItem) : gettype($detailsPurchaseReceiptDetailItem)), __LINE__);
            }
        }
        if (is_null($purchaseReceiptDetail) || (is_array($purchaseReceiptDetail) && empty($purchaseReceiptDetail))) {
            unset($this->PurchaseReceiptDetail);
        } else {
            $this->PurchaseReceiptDetail = $purchaseReceiptDetail;
        }
        return $this;
    }
    /**
     * Add item to PurchaseReceiptDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PurchaseReceiptDetail $item
     * @return \AcumaticaConfig\StructType\Details
     */
    public function addToPurchaseReceiptDetail(\AcumaticaConfig\StructType\PurchaseReceiptDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\PurchaseReceiptDetail) {
            throw new \InvalidArgumentException(sprintf('The PurchaseReceiptDetail property can only contain items of \AcumaticaConfig\StructType\PurchaseReceiptDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PurchaseReceiptDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Details
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
