<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customers StructType
 * @subpackage Structs
 */
class Customers extends AbstractStructBase
{
    /**
     * The DiscountCustomerDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DiscountCustomerDetail[]
     */
    public $DiscountCustomerDetail;
    /**
     * Constructor method for Customers
     * @uses Customers::setDiscountCustomerDetail()
     * @param \AcumaticaConfig\StructType\DiscountCustomerDetail[] $discountCustomerDetail
     */
    public function __construct(array $discountCustomerDetail = array())
    {
        $this
            ->setDiscountCustomerDetail($discountCustomerDetail);
    }
    /**
     * Get DiscountCustomerDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DiscountCustomerDetail[]|null
     */
    public function getDiscountCustomerDetail()
    {
        return isset($this->DiscountCustomerDetail) ? $this->DiscountCustomerDetail : null;
    }
    /**
     * Set DiscountCustomerDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\DiscountCustomerDetail[] $discountCustomerDetail
     * @return \AcumaticaConfig\StructType\Customers
     */
    public function setDiscountCustomerDetail(array $discountCustomerDetail = array())
    {
        foreach ($discountCustomerDetail as $customersDiscountCustomerDetailItem) {
            // validation for constraint: itemType
            if (!$customersDiscountCustomerDetailItem instanceof \AcumaticaConfig\StructType\DiscountCustomerDetail) {
                throw new \InvalidArgumentException(sprintf('The DiscountCustomerDetail property can only contain items of \AcumaticaConfig\StructType\DiscountCustomerDetail, "%s" given', is_object($customersDiscountCustomerDetailItem) ? get_class($customersDiscountCustomerDetailItem) : gettype($customersDiscountCustomerDetailItem)), __LINE__);
            }
        }
        if (is_null($discountCustomerDetail) || (is_array($discountCustomerDetail) && empty($discountCustomerDetail))) {
            unset($this->DiscountCustomerDetail);
        } else {
            $this->DiscountCustomerDetail = $discountCustomerDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountCustomerDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\DiscountCustomerDetail $item
     * @return \AcumaticaConfig\StructType\Customers
     */
    public function addToDiscountCustomerDetail(\AcumaticaConfig\StructType\DiscountCustomerDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\DiscountCustomerDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountCustomerDetail property can only contain items of \AcumaticaConfig\StructType\DiscountCustomerDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DiscountCustomerDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Customers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
