<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerTerms StructType
 * @subpackage Structs
 */
class CustomerTerms extends Entity
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The TermsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TermsID;
    /**
     * Constructor method for CustomerTerms
     * @uses CustomerTerms::setDescription()
     * @uses CustomerTerms::setTermsID()
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $termsID
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $termsID = null)
    {
        $this
            ->setDescription($description)
            ->setTermsID($termsID);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\CustomerTerms
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get TermsID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTermsID()
    {
        return isset($this->TermsID) ? $this->TermsID : null;
    }
    /**
     * Set TermsID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $termsID
     * @return \AcumaticaConfig\StructType\CustomerTerms
     */
    public function setTermsID(\AcumaticaConfig\StructType\StringValue $termsID = null)
    {
        if (is_null($termsID) || (is_array($termsID) && empty($termsID))) {
            unset($this->TermsID);
        } else {
            $this->TermsID = $termsID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CustomerTerms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
