<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerAccounts StructType
 * @subpackage Structs
 */
class CustomerAccounts extends AbstractStructBase
{
    /**
     * The CarrierCustomerAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CarrierCustomerAccount[]
     */
    public $CarrierCustomerAccount;
    /**
     * Constructor method for CustomerAccounts
     * @uses CustomerAccounts::setCarrierCustomerAccount()
     * @param \AcumaticaConfig\StructType\CarrierCustomerAccount[] $carrierCustomerAccount
     */
    public function __construct(array $carrierCustomerAccount = array())
    {
        $this
            ->setCarrierCustomerAccount($carrierCustomerAccount);
    }
    /**
     * Get CarrierCustomerAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CarrierCustomerAccount[]|null
     */
    public function getCarrierCustomerAccount()
    {
        return isset($this->CarrierCustomerAccount) ? $this->CarrierCustomerAccount : null;
    }
    /**
     * Set CarrierCustomerAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CarrierCustomerAccount[] $carrierCustomerAccount
     * @return \AcumaticaConfig\StructType\CustomerAccounts
     */
    public function setCarrierCustomerAccount(array $carrierCustomerAccount = array())
    {
        foreach ($carrierCustomerAccount as $customerAccountsCarrierCustomerAccountItem) {
            // validation for constraint: itemType
            if (!$customerAccountsCarrierCustomerAccountItem instanceof \AcumaticaConfig\StructType\CarrierCustomerAccount) {
                throw new \InvalidArgumentException(sprintf('The CarrierCustomerAccount property can only contain items of \AcumaticaConfig\StructType\CarrierCustomerAccount, "%s" given', is_object($customerAccountsCarrierCustomerAccountItem) ? get_class($customerAccountsCarrierCustomerAccountItem) : gettype($customerAccountsCarrierCustomerAccountItem)), __LINE__);
            }
        }
        if (is_null($carrierCustomerAccount) || (is_array($carrierCustomerAccount) && empty($carrierCustomerAccount))) {
            unset($this->CarrierCustomerAccount);
        } else {
            $this->CarrierCustomerAccount = $carrierCustomerAccount;
        }
        return $this;
    }
    /**
     * Add item to CarrierCustomerAccount value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CarrierCustomerAccount $item
     * @return \AcumaticaConfig\StructType\CustomerAccounts
     */
    public function addToCarrierCustomerAccount(\AcumaticaConfig\StructType\CarrierCustomerAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CarrierCustomerAccount) {
            throw new \InvalidArgumentException(sprintf('The CarrierCustomerAccount property can only contain items of \AcumaticaConfig\StructType\CarrierCustomerAccount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CarrierCustomerAccount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CustomerAccounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
