<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrossSellDetails StructType
 * @subpackage Structs
 */
class CrossSellDetails extends Entity
{
    /**
     * The BaseInventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $BaseInventoryID;
    /**
     * The DefaultPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DefaultPrice;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ItemType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ItemType;
    /**
     * The TaxCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Warehouse;
    /**
     * The CrossSellDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CrossSellDetails[]
     */
    public $CrossSellDetails;
    /**
     * Constructor method for CrossSellDetails
     * @uses CrossSellDetails::setBaseInventoryID()
     * @uses CrossSellDetails::setDefaultPrice()
     * @uses CrossSellDetails::setDescription()
     * @uses CrossSellDetails::setInventoryID()
     * @uses CrossSellDetails::setItemType()
     * @uses CrossSellDetails::setTaxCategory()
     * @uses CrossSellDetails::setWarehouse()
     * @uses CrossSellDetails::setCrossSellDetails()
     * @param \AcumaticaConfig\StructType\IntValue $baseInventoryID
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\StringValue $itemType
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @param \AcumaticaConfig\StructType\CrossSellDetails[] $crossSellDetails
     */
    public function __construct(\AcumaticaConfig\StructType\IntValue $baseInventoryID = null, \AcumaticaConfig\StructType\DecimalValue $defaultPrice = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\StringValue $itemType = null, \AcumaticaConfig\StructType\StringValue $taxCategory = null, \AcumaticaConfig\StructType\StringValue $warehouse = null, array $crossSellDetails = array())
    {
        $this
            ->setBaseInventoryID($baseInventoryID)
            ->setDefaultPrice($defaultPrice)
            ->setDescription($description)
            ->setInventoryID($inventoryID)
            ->setItemType($itemType)
            ->setTaxCategory($taxCategory)
            ->setWarehouse($warehouse)
            ->setCrossSellDetails($crossSellDetails);
    }
    /**
     * Get BaseInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getBaseInventoryID()
    {
        return isset($this->BaseInventoryID) ? $this->BaseInventoryID : null;
    }
    /**
     * Set BaseInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $baseInventoryID
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function setBaseInventoryID(\AcumaticaConfig\StructType\IntValue $baseInventoryID = null)
    {
        if (is_null($baseInventoryID) || (is_array($baseInventoryID) && empty($baseInventoryID))) {
            unset($this->BaseInventoryID);
        } else {
            $this->BaseInventoryID = $baseInventoryID;
        }
        return $this;
    }
    /**
     * Get DefaultPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDefaultPrice()
    {
        return isset($this->DefaultPrice) ? $this->DefaultPrice : null;
    }
    /**
     * Set DefaultPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function setDefaultPrice(\AcumaticaConfig\StructType\DecimalValue $defaultPrice = null)
    {
        if (is_null($defaultPrice) || (is_array($defaultPrice) && empty($defaultPrice))) {
            unset($this->DefaultPrice);
        } else {
            $this->DefaultPrice = $defaultPrice;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $itemType
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function setItemType(\AcumaticaConfig\StructType\StringValue $itemType = null)
    {
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function setTaxCategory(\AcumaticaConfig\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function setWarehouse(\AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Get CrossSellDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CrossSellDetails[]|null
     */
    public function getCrossSellDetails()
    {
        return isset($this->CrossSellDetails) ? $this->CrossSellDetails : null;
    }
    /**
     * Set CrossSellDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CrossSellDetails[] $crossSellDetails
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function setCrossSellDetails(array $crossSellDetails = array())
    {
        foreach ($crossSellDetails as $crossSellDetailsCrossSellDetailsItem) {
            // validation for constraint: itemType
            if (!$crossSellDetailsCrossSellDetailsItem instanceof \AcumaticaConfig\StructType\CrossSellDetails) {
                throw new \InvalidArgumentException(sprintf('The CrossSellDetails property can only contain items of \AcumaticaConfig\StructType\CrossSellDetails, "%s" given', is_object($crossSellDetailsCrossSellDetailsItem) ? get_class($crossSellDetailsCrossSellDetailsItem) : gettype($crossSellDetailsCrossSellDetailsItem)), __LINE__);
            }
        }
        if (is_null($crossSellDetails) || (is_array($crossSellDetails) && empty($crossSellDetails))) {
            unset($this->CrossSellDetails);
        } else {
            $this->CrossSellDetails = $crossSellDetails;
        }
        return $this;
    }
    /**
     * Add item to CrossSellDetails value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CrossSellDetails $item
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public function addToCrossSellDetails(\AcumaticaConfig\StructType\CrossSellDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CrossSellDetails) {
            throw new \InvalidArgumentException(sprintf('The CrossSellDetails property can only contain items of \AcumaticaConfig\StructType\CrossSellDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CrossSellDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CrossSellDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
