<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractUsage StructType
 * @subpackage Structs
 */
class ContractUsage extends Entity
{
    /**
     * The BilledTransactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BilledTransactions
     */
    public $BilledTransactions;
    /**
     * The ContractID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ContractID;
    /**
     * The PostPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PostPeriod;
    /**
     * The UnbilledTransactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\UnbilledTransactions
     */
    public $UnbilledTransactions;
    /**
     * Constructor method for ContractUsage
     * @uses ContractUsage::setBilledTransactions()
     * @uses ContractUsage::setContractID()
     * @uses ContractUsage::setPostPeriod()
     * @uses ContractUsage::setUnbilledTransactions()
     * @param \AcumaticaConfig\StructType\BilledTransactions $billedTransactions
     * @param \AcumaticaConfig\StructType\StringValue $contractID
     * @param \AcumaticaConfig\StructType\StringValue $postPeriod
     * @param \AcumaticaConfig\StructType\UnbilledTransactions $unbilledTransactions
     */
    public function __construct(\AcumaticaConfig\StructType\BilledTransactions $billedTransactions = null, \AcumaticaConfig\StructType\StringValue $contractID = null, \AcumaticaConfig\StructType\StringValue $postPeriod = null, \AcumaticaConfig\StructType\UnbilledTransactions $unbilledTransactions = null)
    {
        $this
            ->setBilledTransactions($billedTransactions)
            ->setContractID($contractID)
            ->setPostPeriod($postPeriod)
            ->setUnbilledTransactions($unbilledTransactions);
    }
    /**
     * Get BilledTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BilledTransactions|null
     */
    public function getBilledTransactions()
    {
        return isset($this->BilledTransactions) ? $this->BilledTransactions : null;
    }
    /**
     * Set BilledTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BilledTransactions $billedTransactions
     * @return \AcumaticaConfig\StructType\ContractUsage
     */
    public function setBilledTransactions(\AcumaticaConfig\StructType\BilledTransactions $billedTransactions = null)
    {
        if (is_null($billedTransactions) || (is_array($billedTransactions) && empty($billedTransactions))) {
            unset($this->BilledTransactions);
        } else {
            $this->BilledTransactions = $billedTransactions;
        }
        return $this;
    }
    /**
     * Get ContractID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getContractID()
    {
        return isset($this->ContractID) ? $this->ContractID : null;
    }
    /**
     * Set ContractID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $contractID
     * @return \AcumaticaConfig\StructType\ContractUsage
     */
    public function setContractID(\AcumaticaConfig\StructType\StringValue $contractID = null)
    {
        if (is_null($contractID) || (is_array($contractID) && empty($contractID))) {
            unset($this->ContractID);
        } else {
            $this->ContractID = $contractID;
        }
        return $this;
    }
    /**
     * Get PostPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPostPeriod()
    {
        return isset($this->PostPeriod) ? $this->PostPeriod : null;
    }
    /**
     * Set PostPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $postPeriod
     * @return \AcumaticaConfig\StructType\ContractUsage
     */
    public function setPostPeriod(\AcumaticaConfig\StructType\StringValue $postPeriod = null)
    {
        if (is_null($postPeriod) || (is_array($postPeriod) && empty($postPeriod))) {
            unset($this->PostPeriod);
        } else {
            $this->PostPeriod = $postPeriod;
        }
        return $this;
    }
    /**
     * Get UnbilledTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\UnbilledTransactions|null
     */
    public function getUnbilledTransactions()
    {
        return isset($this->UnbilledTransactions) ? $this->UnbilledTransactions : null;
    }
    /**
     * Set UnbilledTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\UnbilledTransactions $unbilledTransactions
     * @return \AcumaticaConfig\StructType\ContractUsage
     */
    public function setUnbilledTransactions(\AcumaticaConfig\StructType\UnbilledTransactions $unbilledTransactions = null)
    {
        if (is_null($unbilledTransactions) || (is_array($unbilledTransactions) && empty($unbilledTransactions))) {
            unset($this->UnbilledTransactions);
        } else {
            $this->UnbilledTransactions = $unbilledTransactions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ContractUsage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
