<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Check StructType
 * @subpackage Structs
 */
class Check extends Entity
{
    /**
     * The ApplicationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ApplicationDate;
    /**
     * The CashAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CashAccount;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Details
     */
    public $Details;
    /**
     * The History
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\History
     */
    public $History;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $PaymentAmount;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The ReferenceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Type;
    /**
     * The UnappliedBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UnappliedBalance;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Vendor;
    /**
     * Constructor method for Check
     * @uses Check::setApplicationDate()
     * @uses Check::setCashAccount()
     * @uses Check::setCurrencyID()
     * @uses Check::setDescription()
     * @uses Check::setDetails()
     * @uses Check::setHistory()
     * @uses Check::setHold()
     * @uses Check::setPaymentAmount()
     * @uses Check::setPaymentMethod()
     * @uses Check::setPaymentRef()
     * @uses Check::setReferenceNbr()
     * @uses Check::setStatus()
     * @uses Check::setType()
     * @uses Check::setUnappliedBalance()
     * @uses Check::setVendor()
     * @param \AcumaticaConfig\StructType\DateTimeValue $applicationDate
     * @param \AcumaticaConfig\StructType\StringValue $cashAccount
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\Details $details
     * @param \AcumaticaConfig\StructType\History $history
     * @param \AcumaticaConfig\StructType\BooleanValue $hold
     * @param \AcumaticaConfig\StructType\DecimalValue $paymentAmount
     * @param \AcumaticaConfig\StructType\StringValue $paymentMethod
     * @param \AcumaticaConfig\StructType\StringValue $paymentRef
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @param \AcumaticaConfig\StructType\DecimalValue $unappliedBalance
     * @param \AcumaticaConfig\StructType\StringValue $vendor
     */
    public function __construct(\AcumaticaConfig\StructType\DateTimeValue $applicationDate = null, \AcumaticaConfig\StructType\StringValue $cashAccount = null, \AcumaticaConfig\StructType\StringValue $currencyID = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\Details $details = null, \AcumaticaConfig\StructType\History $history = null, \AcumaticaConfig\StructType\BooleanValue $hold = null, \AcumaticaConfig\StructType\DecimalValue $paymentAmount = null, \AcumaticaConfig\StructType\StringValue $paymentMethod = null, \AcumaticaConfig\StructType\StringValue $paymentRef = null, \AcumaticaConfig\StructType\StringValue $referenceNbr = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\StringValue $type = null, \AcumaticaConfig\StructType\DecimalValue $unappliedBalance = null, \AcumaticaConfig\StructType\StringValue $vendor = null)
    {
        $this
            ->setApplicationDate($applicationDate)
            ->setCashAccount($cashAccount)
            ->setCurrencyID($currencyID)
            ->setDescription($description)
            ->setDetails($details)
            ->setHistory($history)
            ->setHold($hold)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentRef($paymentRef)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setType($type)
            ->setUnappliedBalance($unappliedBalance)
            ->setVendor($vendor);
    }
    /**
     * Get ApplicationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getApplicationDate()
    {
        return isset($this->ApplicationDate) ? $this->ApplicationDate : null;
    }
    /**
     * Set ApplicationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $applicationDate
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setApplicationDate(\AcumaticaConfig\StructType\DateTimeValue $applicationDate = null)
    {
        if (is_null($applicationDate) || (is_array($applicationDate) && empty($applicationDate))) {
            unset($this->ApplicationDate);
        } else {
            $this->ApplicationDate = $applicationDate;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $cashAccount
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setCashAccount(\AcumaticaConfig\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setCurrencyID(\AcumaticaConfig\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Details $details
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setDetails(\AcumaticaConfig\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get History value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\History|null
     */
    public function getHistory()
    {
        return isset($this->History) ? $this->History : null;
    }
    /**
     * Set History value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\History $history
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setHistory(\AcumaticaConfig\StructType\History $history = null)
    {
        if (is_null($history) || (is_array($history) && empty($history))) {
            unset($this->History);
        } else {
            $this->History = $history;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $hold
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setHold(\AcumaticaConfig\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get PaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getPaymentAmount()
    {
        return isset($this->PaymentAmount) ? $this->PaymentAmount : null;
    }
    /**
     * Set PaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $paymentAmount
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setPaymentAmount(\AcumaticaConfig\StructType\DecimalValue $paymentAmount = null)
    {
        if (is_null($paymentAmount) || (is_array($paymentAmount) && empty($paymentAmount))) {
            unset($this->PaymentAmount);
        } else {
            $this->PaymentAmount = $paymentAmount;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $paymentMethod
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setPaymentMethod(\AcumaticaConfig\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $paymentRef
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setPaymentRef(\AcumaticaConfig\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setReferenceNbr(\AcumaticaConfig\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setType(\AcumaticaConfig\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UnappliedBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUnappliedBalance()
    {
        return isset($this->UnappliedBalance) ? $this->UnappliedBalance : null;
    }
    /**
     * Set UnappliedBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $unappliedBalance
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setUnappliedBalance(\AcumaticaConfig\StructType\DecimalValue $unappliedBalance = null)
    {
        if (is_null($unappliedBalance) || (is_array($unappliedBalance) && empty($unappliedBalance))) {
            unset($this->UnappliedBalance);
        } else {
            $this->UnappliedBalance = $unappliedBalance;
        }
        return $this;
    }
    /**
     * Get Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVendor()
    {
        return isset($this->Vendor) ? $this->Vendor : null;
    }
    /**
     * Set Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $vendor
     * @return \AcumaticaConfig\StructType\Check
     */
    public function setVendor(\AcumaticaConfig\StructType\StringValue $vendor = null)
    {
        if (is_null($vendor) || (is_array($vendor) && empty($vendor))) {
            unset($this->Vendor);
        } else {
            $this->Vendor = $vendor;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Check
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
