<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryResult StructType
 * @subpackage Structs
 */
class CategoryResult extends Entity
{
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $Count;
    /**
     * The CategoryResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CategoryResult[]
     */
    public $CategoryResult;
    /**
     * Constructor method for CategoryResult
     * @uses CategoryResult::setCount()
     * @uses CategoryResult::setCategoryResult()
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @param \AcumaticaConfig\StructType\CategoryResult[] $categoryResult
     */
    public function __construct(\AcumaticaConfig\StructType\IntValue $count = null, array $categoryResult = array())
    {
        $this
            ->setCount($count)
            ->setCategoryResult($categoryResult);
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @return \AcumaticaConfig\StructType\CategoryResult
     */
    public function setCount(\AcumaticaConfig\StructType\IntValue $count = null)
    {
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get CategoryResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CategoryResult[]|null
     */
    public function getCategoryResult()
    {
        return isset($this->CategoryResult) ? $this->CategoryResult : null;
    }
    /**
     * Set CategoryResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CategoryResult[] $categoryResult
     * @return \AcumaticaConfig\StructType\CategoryResult
     */
    public function setCategoryResult(array $categoryResult = array())
    {
        foreach ($categoryResult as $categoryResultCategoryResultItem) {
            // validation for constraint: itemType
            if (!$categoryResultCategoryResultItem instanceof \AcumaticaConfig\StructType\CategoryResult) {
                throw new \InvalidArgumentException(sprintf('The CategoryResult property can only contain items of \AcumaticaConfig\StructType\CategoryResult, "%s" given', is_object($categoryResultCategoryResultItem) ? get_class($categoryResultCategoryResultItem) : gettype($categoryResultCategoryResultItem)), __LINE__);
            }
        }
        if (is_null($categoryResult) || (is_array($categoryResult) && empty($categoryResult))) {
            unset($this->CategoryResult);
        } else {
            $this->CategoryResult = $categoryResult;
        }
        return $this;
    }
    /**
     * Add item to CategoryResult value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CategoryResult $item
     * @return \AcumaticaConfig\StructType\CategoryResult
     */
    public function addToCategoryResult(\AcumaticaConfig\StructType\CategoryResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CategoryResult) {
            throw new \InvalidArgumentException(sprintf('The CategoryResult property can only contain items of \AcumaticaConfig\StructType\CategoryResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CategoryResult[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CategoryResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
