<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cases StructType
 * @subpackage Structs
 */
class Cases extends AbstractStructBase
{
    /**
     * The CaseDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CaseDetail[]
     */
    public $CaseDetail;
    /**
     * The BusinessAccountCaseDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountCaseDetail[]
     */
    public $BusinessAccountCaseDetail;
    /**
     * Constructor method for Cases
     * @uses Cases::setCaseDetail()
     * @uses Cases::setBusinessAccountCaseDetail()
     * @param \AcumaticaConfig\StructType\CaseDetail[] $caseDetail
     * @param \AcumaticaConfig\StructType\BusinessAccountCaseDetail[] $businessAccountCaseDetail
     */
    public function __construct(array $caseDetail = array(), array $businessAccountCaseDetail = array())
    {
        $this
            ->setCaseDetail($caseDetail)
            ->setBusinessAccountCaseDetail($businessAccountCaseDetail);
    }
    /**
     * Get CaseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CaseDetail[]|null
     */
    public function getCaseDetail()
    {
        return isset($this->CaseDetail) ? $this->CaseDetail : null;
    }
    /**
     * Set CaseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CaseDetail[] $caseDetail
     * @return \AcumaticaConfig\StructType\Cases
     */
    public function setCaseDetail(array $caseDetail = array())
    {
        foreach ($caseDetail as $casesCaseDetailItem) {
            // validation for constraint: itemType
            if (!$casesCaseDetailItem instanceof \AcumaticaConfig\StructType\CaseDetail) {
                throw new \InvalidArgumentException(sprintf('The CaseDetail property can only contain items of \AcumaticaConfig\StructType\CaseDetail, "%s" given', is_object($casesCaseDetailItem) ? get_class($casesCaseDetailItem) : gettype($casesCaseDetailItem)), __LINE__);
            }
        }
        if (is_null($caseDetail) || (is_array($caseDetail) && empty($caseDetail))) {
            unset($this->CaseDetail);
        } else {
            $this->CaseDetail = $caseDetail;
        }
        return $this;
    }
    /**
     * Add item to CaseDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CaseDetail $item
     * @return \AcumaticaConfig\StructType\Cases
     */
    public function addToCaseDetail(\AcumaticaConfig\StructType\CaseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CaseDetail) {
            throw new \InvalidArgumentException(sprintf('The CaseDetail property can only contain items of \AcumaticaConfig\StructType\CaseDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CaseDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountCaseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountCaseDetail[]|null
     */
    public function getBusinessAccountCaseDetail()
    {
        return isset($this->BusinessAccountCaseDetail) ? $this->BusinessAccountCaseDetail : null;
    }
    /**
     * Set BusinessAccountCaseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountCaseDetail[] $businessAccountCaseDetail
     * @return \AcumaticaConfig\StructType\Cases
     */
    public function setBusinessAccountCaseDetail(array $businessAccountCaseDetail = array())
    {
        foreach ($businessAccountCaseDetail as $casesBusinessAccountCaseDetailItem) {
            // validation for constraint: itemType
            if (!$casesBusinessAccountCaseDetailItem instanceof \AcumaticaConfig\StructType\BusinessAccountCaseDetail) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountCaseDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountCaseDetail, "%s" given', is_object($casesBusinessAccountCaseDetailItem) ? get_class($casesBusinessAccountCaseDetailItem) : gettype($casesBusinessAccountCaseDetailItem)), __LINE__);
            }
        }
        if (is_null($businessAccountCaseDetail) || (is_array($businessAccountCaseDetail) && empty($businessAccountCaseDetail))) {
            unset($this->BusinessAccountCaseDetail);
        } else {
            $this->BusinessAccountCaseDetail = $businessAccountCaseDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountCaseDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountCaseDetail $item
     * @return \AcumaticaConfig\StructType\Cases
     */
    public function addToBusinessAccountCaseDetail(\AcumaticaConfig\StructType\BusinessAccountCaseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountCaseDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountCaseDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountCaseDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountCaseDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Cases
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
