<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaigns StructType
 * @subpackage Structs
 */
class Campaigns extends AbstractStructBase
{
    /**
     * The CampaignDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CampaignDetail[]
     */
    public $CampaignDetail;
    /**
     * Constructor method for Campaigns
     * @uses Campaigns::setCampaignDetail()
     * @param \AcumaticaConfig\StructType\CampaignDetail[] $campaignDetail
     */
    public function __construct(array $campaignDetail = array())
    {
        $this
            ->setCampaignDetail($campaignDetail);
    }
    /**
     * Get CampaignDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CampaignDetail[]|null
     */
    public function getCampaignDetail()
    {
        return isset($this->CampaignDetail) ? $this->CampaignDetail : null;
    }
    /**
     * Set CampaignDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CampaignDetail[] $campaignDetail
     * @return \AcumaticaConfig\StructType\Campaigns
     */
    public function setCampaignDetail(array $campaignDetail = array())
    {
        foreach ($campaignDetail as $campaignsCampaignDetailItem) {
            // validation for constraint: itemType
            if (!$campaignsCampaignDetailItem instanceof \AcumaticaConfig\StructType\CampaignDetail) {
                throw new \InvalidArgumentException(sprintf('The CampaignDetail property can only contain items of \AcumaticaConfig\StructType\CampaignDetail, "%s" given', is_object($campaignsCampaignDetailItem) ? get_class($campaignsCampaignDetailItem) : gettype($campaignsCampaignDetailItem)), __LINE__);
            }
        }
        if (is_null($campaignDetail) || (is_array($campaignDetail) && empty($campaignDetail))) {
            unset($this->CampaignDetail);
        } else {
            $this->CampaignDetail = $campaignDetail;
        }
        return $this;
    }
    /**
     * Add item to CampaignDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CampaignDetail $item
     * @return \AcumaticaConfig\StructType\Campaigns
     */
    public function addToCampaignDetail(\AcumaticaConfig\StructType\CampaignDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CampaignDetail) {
            throw new \InvalidArgumentException(sprintf('The CampaignDetail property can only contain items of \AcumaticaConfig\StructType\CampaignDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CampaignDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Campaigns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
