<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessAccountOrder StructType
 * @subpackage Structs
 */
class BusinessAccountOrder extends Entity
{
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CustomerOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerOrder;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The OrderedQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OrderedQty;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OrderTotal;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderType;
    /**
     * The OrderVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OrderVolume;
    /**
     * The OrderWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OrderWeight;
    /**
     * The RequestedOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $RequestedOn;
    /**
     * The ScheduledShipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ScheduledShipment;
    /**
     * The ShippingZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingZone;
    /**
     * The ShipVia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for BusinessAccountOrder
     * @uses BusinessAccountOrder::setCurrencyID()
     * @uses BusinessAccountOrder::setCustomerOrder()
     * @uses BusinessAccountOrder::setDescription()
     * @uses BusinessAccountOrder::setOrderedQty()
     * @uses BusinessAccountOrder::setOrderNbr()
     * @uses BusinessAccountOrder::setOrderTotal()
     * @uses BusinessAccountOrder::setOrderType()
     * @uses BusinessAccountOrder::setOrderVolume()
     * @uses BusinessAccountOrder::setOrderWeight()
     * @uses BusinessAccountOrder::setRequestedOn()
     * @uses BusinessAccountOrder::setScheduledShipment()
     * @uses BusinessAccountOrder::setShippingZone()
     * @uses BusinessAccountOrder::setShipVia()
     * @uses BusinessAccountOrder::setStatus()
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @param \AcumaticaConfig\StructType\StringValue $customerOrder
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\DecimalValue $orderedQty
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @param \AcumaticaConfig\StructType\DecimalValue $orderTotal
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @param \AcumaticaConfig\StructType\DecimalValue $orderVolume
     * @param \AcumaticaConfig\StructType\DecimalValue $orderWeight
     * @param \AcumaticaConfig\StructType\DateTimeValue $requestedOn
     * @param \AcumaticaConfig\StructType\DateTimeValue $scheduledShipment
     * @param \AcumaticaConfig\StructType\StringValue $shippingZone
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @param \AcumaticaConfig\StructType\StringValue $status
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $currencyID = null, \AcumaticaConfig\StructType\StringValue $customerOrder = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\DecimalValue $orderedQty = null, \AcumaticaConfig\StructType\StringValue $orderNbr = null, \AcumaticaConfig\StructType\DecimalValue $orderTotal = null, \AcumaticaConfig\StructType\StringValue $orderType = null, \AcumaticaConfig\StructType\DecimalValue $orderVolume = null, \AcumaticaConfig\StructType\DecimalValue $orderWeight = null, \AcumaticaConfig\StructType\DateTimeValue $requestedOn = null, \AcumaticaConfig\StructType\DateTimeValue $scheduledShipment = null, \AcumaticaConfig\StructType\StringValue $shippingZone = null, \AcumaticaConfig\StructType\StringValue $shipVia = null, \AcumaticaConfig\StructType\StringValue $status = null)
    {
        $this
            ->setCurrencyID($currencyID)
            ->setCustomerOrder($customerOrder)
            ->setDescription($description)
            ->setOrderedQty($orderedQty)
            ->setOrderNbr($orderNbr)
            ->setOrderTotal($orderTotal)
            ->setOrderType($orderType)
            ->setOrderVolume($orderVolume)
            ->setOrderWeight($orderWeight)
            ->setRequestedOn($requestedOn)
            ->setScheduledShipment($scheduledShipment)
            ->setShippingZone($shippingZone)
            ->setShipVia($shipVia)
            ->setStatus($status);
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setCurrencyID(\AcumaticaConfig\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerOrder
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setCustomerOrder(\AcumaticaConfig\StructType\StringValue $customerOrder = null)
    {
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get OrderedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOrderedQty()
    {
        return isset($this->OrderedQty) ? $this->OrderedQty : null;
    }
    /**
     * Set OrderedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $orderedQty
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setOrderedQty(\AcumaticaConfig\StructType\DecimalValue $orderedQty = null)
    {
        if (is_null($orderedQty) || (is_array($orderedQty) && empty($orderedQty))) {
            unset($this->OrderedQty);
        } else {
            $this->OrderedQty = $orderedQty;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setOrderNbr(\AcumaticaConfig\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOrderTotal()
    {
        return isset($this->OrderTotal) ? $this->OrderTotal : null;
    }
    /**
     * Set OrderTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $orderTotal
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setOrderTotal(\AcumaticaConfig\StructType\DecimalValue $orderTotal = null)
    {
        if (is_null($orderTotal) || (is_array($orderTotal) && empty($orderTotal))) {
            unset($this->OrderTotal);
        } else {
            $this->OrderTotal = $orderTotal;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setOrderType(\AcumaticaConfig\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get OrderVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOrderVolume()
    {
        return isset($this->OrderVolume) ? $this->OrderVolume : null;
    }
    /**
     * Set OrderVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $orderVolume
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setOrderVolume(\AcumaticaConfig\StructType\DecimalValue $orderVolume = null)
    {
        if (is_null($orderVolume) || (is_array($orderVolume) && empty($orderVolume))) {
            unset($this->OrderVolume);
        } else {
            $this->OrderVolume = $orderVolume;
        }
        return $this;
    }
    /**
     * Get OrderWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOrderWeight()
    {
        return isset($this->OrderWeight) ? $this->OrderWeight : null;
    }
    /**
     * Set OrderWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $orderWeight
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setOrderWeight(\AcumaticaConfig\StructType\DecimalValue $orderWeight = null)
    {
        if (is_null($orderWeight) || (is_array($orderWeight) && empty($orderWeight))) {
            unset($this->OrderWeight);
        } else {
            $this->OrderWeight = $orderWeight;
        }
        return $this;
    }
    /**
     * Get RequestedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getRequestedOn()
    {
        return isset($this->RequestedOn) ? $this->RequestedOn : null;
    }
    /**
     * Set RequestedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $requestedOn
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setRequestedOn(\AcumaticaConfig\StructType\DateTimeValue $requestedOn = null)
    {
        if (is_null($requestedOn) || (is_array($requestedOn) && empty($requestedOn))) {
            unset($this->RequestedOn);
        } else {
            $this->RequestedOn = $requestedOn;
        }
        return $this;
    }
    /**
     * Get ScheduledShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getScheduledShipment()
    {
        return isset($this->ScheduledShipment) ? $this->ScheduledShipment : null;
    }
    /**
     * Set ScheduledShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $scheduledShipment
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setScheduledShipment(\AcumaticaConfig\StructType\DateTimeValue $scheduledShipment = null)
    {
        if (is_null($scheduledShipment) || (is_array($scheduledShipment) && empty($scheduledShipment))) {
            unset($this->ScheduledShipment);
        } else {
            $this->ScheduledShipment = $scheduledShipment;
        }
        return $this;
    }
    /**
     * Get ShippingZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingZone()
    {
        return isset($this->ShippingZone) ? $this->ShippingZone : null;
    }
    /**
     * Set ShippingZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingZone
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setShippingZone(\AcumaticaConfig\StructType\StringValue $shippingZone = null)
    {
        if (is_null($shippingZone) || (is_array($shippingZone) && empty($shippingZone))) {
            unset($this->ShippingZone);
        } else {
            $this->ShippingZone = $shippingZone;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setShipVia(\AcumaticaConfig\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
