<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attributes StructType
 * @subpackage Structs
 */
class Attributes extends AbstractStructBase
{
    /**
     * The AttributeDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\AttributeDetail[]
     */
    public $AttributeDetail;
    /**
     * The AttributeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\AttributeValue[]
     */
    public $AttributeValue;
    /**
     * The BusinessAccountClassAttributeDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail[]
     */
    public $BusinessAccountClassAttributeDetail;
    /**
     * The NonStockItemAttribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\NonStockItemAttribute[]
     */
    public $NonStockItemAttribute;
    /**
     * The ItemClassAtrribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ItemClassAtrribute[]
     */
    public $ItemClassAtrribute;
    /**
     * Constructor method for Attributes
     * @uses Attributes::setAttributeDetail()
     * @uses Attributes::setAttributeValue()
     * @uses Attributes::setBusinessAccountClassAttributeDetail()
     * @uses Attributes::setNonStockItemAttribute()
     * @uses Attributes::setItemClassAtrribute()
     * @param \AcumaticaConfig\StructType\AttributeDetail[] $attributeDetail
     * @param \AcumaticaConfig\StructType\AttributeValue[] $attributeValue
     * @param \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail[] $businessAccountClassAttributeDetail
     * @param \AcumaticaConfig\StructType\NonStockItemAttribute[] $nonStockItemAttribute
     * @param \AcumaticaConfig\StructType\ItemClassAtrribute[] $itemClassAtrribute
     */
    public function __construct(array $attributeDetail = array(), array $attributeValue = array(), array $businessAccountClassAttributeDetail = array(), array $nonStockItemAttribute = array(), array $itemClassAtrribute = array())
    {
        $this
            ->setAttributeDetail($attributeDetail)
            ->setAttributeValue($attributeValue)
            ->setBusinessAccountClassAttributeDetail($businessAccountClassAttributeDetail)
            ->setNonStockItemAttribute($nonStockItemAttribute)
            ->setItemClassAtrribute($itemClassAtrribute);
    }
    /**
     * Get AttributeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\AttributeDetail[]|null
     */
    public function getAttributeDetail()
    {
        return isset($this->AttributeDetail) ? $this->AttributeDetail : null;
    }
    /**
     * Set AttributeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AttributeDetail[] $attributeDetail
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function setAttributeDetail(array $attributeDetail = array())
    {
        foreach ($attributeDetail as $attributesAttributeDetailItem) {
            // validation for constraint: itemType
            if (!$attributesAttributeDetailItem instanceof \AcumaticaConfig\StructType\AttributeDetail) {
                throw new \InvalidArgumentException(sprintf('The AttributeDetail property can only contain items of \AcumaticaConfig\StructType\AttributeDetail, "%s" given', is_object($attributesAttributeDetailItem) ? get_class($attributesAttributeDetailItem) : gettype($attributesAttributeDetailItem)), __LINE__);
            }
        }
        if (is_null($attributeDetail) || (is_array($attributeDetail) && empty($attributeDetail))) {
            unset($this->AttributeDetail);
        } else {
            $this->AttributeDetail = $attributeDetail;
        }
        return $this;
    }
    /**
     * Add item to AttributeDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AttributeDetail $item
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function addToAttributeDetail(\AcumaticaConfig\StructType\AttributeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\AttributeDetail) {
            throw new \InvalidArgumentException(sprintf('The AttributeDetail property can only contain items of \AcumaticaConfig\StructType\AttributeDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AttributeDetail[] = $item;
        return $this;
    }
    /**
     * Get AttributeValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\AttributeValue[]|null
     */
    public function getAttributeValue()
    {
        return isset($this->AttributeValue) ? $this->AttributeValue : null;
    }
    /**
     * Set AttributeValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AttributeValue[] $attributeValue
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function setAttributeValue(array $attributeValue = array())
    {
        foreach ($attributeValue as $attributesAttributeValueItem) {
            // validation for constraint: itemType
            if (!$attributesAttributeValueItem instanceof \AcumaticaConfig\StructType\AttributeValue) {
                throw new \InvalidArgumentException(sprintf('The AttributeValue property can only contain items of \AcumaticaConfig\StructType\AttributeValue, "%s" given', is_object($attributesAttributeValueItem) ? get_class($attributesAttributeValueItem) : gettype($attributesAttributeValueItem)), __LINE__);
            }
        }
        if (is_null($attributeValue) || (is_array($attributeValue) && empty($attributeValue))) {
            unset($this->AttributeValue);
        } else {
            $this->AttributeValue = $attributeValue;
        }
        return $this;
    }
    /**
     * Add item to AttributeValue value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AttributeValue $item
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function addToAttributeValue(\AcumaticaConfig\StructType\AttributeValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\AttributeValue) {
            throw new \InvalidArgumentException(sprintf('The AttributeValue property can only contain items of \AcumaticaConfig\StructType\AttributeValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AttributeValue[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountClassAttributeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail[]|null
     */
    public function getBusinessAccountClassAttributeDetail()
    {
        return isset($this->BusinessAccountClassAttributeDetail) ? $this->BusinessAccountClassAttributeDetail : null;
    }
    /**
     * Set BusinessAccountClassAttributeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail[] $businessAccountClassAttributeDetail
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function setBusinessAccountClassAttributeDetail(array $businessAccountClassAttributeDetail = array())
    {
        foreach ($businessAccountClassAttributeDetail as $attributesBusinessAccountClassAttributeDetailItem) {
            // validation for constraint: itemType
            if (!$attributesBusinessAccountClassAttributeDetailItem instanceof \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountClassAttributeDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail, "%s" given', is_object($attributesBusinessAccountClassAttributeDetailItem) ? get_class($attributesBusinessAccountClassAttributeDetailItem) : gettype($attributesBusinessAccountClassAttributeDetailItem)), __LINE__);
            }
        }
        if (is_null($businessAccountClassAttributeDetail) || (is_array($businessAccountClassAttributeDetail) && empty($businessAccountClassAttributeDetail))) {
            unset($this->BusinessAccountClassAttributeDetail);
        } else {
            $this->BusinessAccountClassAttributeDetail = $businessAccountClassAttributeDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountClassAttributeDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail $item
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function addToBusinessAccountClassAttributeDetail(\AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountClassAttributeDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountClassAttributeDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountClassAttributeDetail[] = $item;
        return $this;
    }
    /**
     * Get NonStockItemAttribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\NonStockItemAttribute[]|null
     */
    public function getNonStockItemAttribute()
    {
        return isset($this->NonStockItemAttribute) ? $this->NonStockItemAttribute : null;
    }
    /**
     * Set NonStockItemAttribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\NonStockItemAttribute[] $nonStockItemAttribute
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function setNonStockItemAttribute(array $nonStockItemAttribute = array())
    {
        foreach ($nonStockItemAttribute as $attributesNonStockItemAttributeItem) {
            // validation for constraint: itemType
            if (!$attributesNonStockItemAttributeItem instanceof \AcumaticaConfig\StructType\NonStockItemAttribute) {
                throw new \InvalidArgumentException(sprintf('The NonStockItemAttribute property can only contain items of \AcumaticaConfig\StructType\NonStockItemAttribute, "%s" given', is_object($attributesNonStockItemAttributeItem) ? get_class($attributesNonStockItemAttributeItem) : gettype($attributesNonStockItemAttributeItem)), __LINE__);
            }
        }
        if (is_null($nonStockItemAttribute) || (is_array($nonStockItemAttribute) && empty($nonStockItemAttribute))) {
            unset($this->NonStockItemAttribute);
        } else {
            $this->NonStockItemAttribute = $nonStockItemAttribute;
        }
        return $this;
    }
    /**
     * Add item to NonStockItemAttribute value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\NonStockItemAttribute $item
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function addToNonStockItemAttribute(\AcumaticaConfig\StructType\NonStockItemAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\NonStockItemAttribute) {
            throw new \InvalidArgumentException(sprintf('The NonStockItemAttribute property can only contain items of \AcumaticaConfig\StructType\NonStockItemAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NonStockItemAttribute[] = $item;
        return $this;
    }
    /**
     * Get ItemClassAtrribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ItemClassAtrribute[]|null
     */
    public function getItemClassAtrribute()
    {
        return isset($this->ItemClassAtrribute) ? $this->ItemClassAtrribute : null;
    }
    /**
     * Set ItemClassAtrribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ItemClassAtrribute[] $itemClassAtrribute
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function setItemClassAtrribute(array $itemClassAtrribute = array())
    {
        foreach ($itemClassAtrribute as $attributesItemClassAtrributeItem) {
            // validation for constraint: itemType
            if (!$attributesItemClassAtrributeItem instanceof \AcumaticaConfig\StructType\ItemClassAtrribute) {
                throw new \InvalidArgumentException(sprintf('The ItemClassAtrribute property can only contain items of \AcumaticaConfig\StructType\ItemClassAtrribute, "%s" given', is_object($attributesItemClassAtrributeItem) ? get_class($attributesItemClassAtrributeItem) : gettype($attributesItemClassAtrributeItem)), __LINE__);
            }
        }
        if (is_null($itemClassAtrribute) || (is_array($itemClassAtrribute) && empty($itemClassAtrribute))) {
            unset($this->ItemClassAtrribute);
        } else {
            $this->ItemClassAtrribute = $itemClassAtrribute;
        }
        return $this;
    }
    /**
     * Add item to ItemClassAtrribute value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ItemClassAtrribute $item
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public function addToItemClassAtrribute(\AcumaticaConfig\StructType\ItemClassAtrribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ItemClassAtrribute) {
            throw new \InvalidArgumentException(sprintf('The ItemClassAtrribute property can only contain items of \AcumaticaConfig\StructType\ItemClassAtrribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemClassAtrribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Attributes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
