<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attendees StructType
 * @subpackage Structs
 */
class Attendees extends AbstractStructBase
{
    /**
     * The EventAttendee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\EventAttendee[]
     */
    public $EventAttendee;
    /**
     * Constructor method for Attendees
     * @uses Attendees::setEventAttendee()
     * @param \AcumaticaConfig\StructType\EventAttendee[] $eventAttendee
     */
    public function __construct(array $eventAttendee = array())
    {
        $this
            ->setEventAttendee($eventAttendee);
    }
    /**
     * Get EventAttendee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\EventAttendee[]|null
     */
    public function getEventAttendee()
    {
        return isset($this->EventAttendee) ? $this->EventAttendee : null;
    }
    /**
     * Set EventAttendee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\EventAttendee[] $eventAttendee
     * @return \AcumaticaConfig\StructType\Attendees
     */
    public function setEventAttendee(array $eventAttendee = array())
    {
        foreach ($eventAttendee as $attendeesEventAttendeeItem) {
            // validation for constraint: itemType
            if (!$attendeesEventAttendeeItem instanceof \AcumaticaConfig\StructType\EventAttendee) {
                throw new \InvalidArgumentException(sprintf('The EventAttendee property can only contain items of \AcumaticaConfig\StructType\EventAttendee, "%s" given', is_object($attendeesEventAttendeeItem) ? get_class($attendeesEventAttendeeItem) : gettype($attendeesEventAttendeeItem)), __LINE__);
            }
        }
        if (is_null($eventAttendee) || (is_array($eventAttendee) && empty($eventAttendee))) {
            unset($this->EventAttendee);
        } else {
            $this->EventAttendee = $eventAttendee;
        }
        return $this;
    }
    /**
     * Add item to EventAttendee value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\EventAttendee $item
     * @return \AcumaticaConfig\StructType\Attendees
     */
    public function addToEventAttendee(\AcumaticaConfig\StructType\EventAttendee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\EventAttendee) {
            throw new \InvalidArgumentException(sprintf('The EventAttendee property can only contain items of \AcumaticaConfig\StructType\EventAttendee, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EventAttendee[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Attendees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
