<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountLocation StructType
 * @subpackage Structs
 */
class AccountLocation extends Entity
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Active;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Address
     */
    public $Address;
    /**
     * The AddressSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $AddressSameAsMain;
    /**
     * The AddressValidated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $AddressValidated;
    /**
     * The ARAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ARAccount;
    /**
     * The ARSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ARSubaccount;
    /**
     * The BusinessAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $BusinessAccountID;
    /**
     * The Calendar
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Calendar;
    /**
     * The Cases
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Cases
     */
    public $Cases;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\AccountLocationContact
     */
    public $Contact;
    /**
     * The DefaultProject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultProject;
    /**
     * The DiscountAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountAccount;
    /**
     * The DiscountSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountSubaccount;
    /**
     * The EntityUsageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $EntityUsageType;
    /**
     * The FedExGroundCollect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $FedExGroundCollect;
    /**
     * The FOBPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The FreightAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FreightAccount;
    /**
     * The FreightSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FreightSubaccount;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Insurance;
    /**
     * The LeadTimeInDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $LeadTimeInDays;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LocationID;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LocationName;
    /**
     * The Opportunities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Opportunities
     */
    public $Opportunities;
    /**
     * The OrderPriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $OrderPriority;
    /**
     * The PriceClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PriceClass;
    /**
     * The ResidentialDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ResidentialDelivery;
    /**
     * The SalesAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The SameAsDefaultLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SameAsDefaultLocation;
    /**
     * The SaturdayDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SaturdayDelivery;
    /**
     * The ShippingBranch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingBranch;
    /**
     * The ShippingRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The ShippingTerms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShippingZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingZone;
    /**
     * The ShipVia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The TaxExemptionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxExemptionNumber;
    /**
     * The TaxRegistrationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxRegistrationID;
    /**
     * The TaxZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxZone;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for AccountLocation
     * @uses AccountLocation::setActive()
     * @uses AccountLocation::setAddress()
     * @uses AccountLocation::setAddressSameAsMain()
     * @uses AccountLocation::setAddressValidated()
     * @uses AccountLocation::setARAccount()
     * @uses AccountLocation::setARSubaccount()
     * @uses AccountLocation::setBusinessAccountID()
     * @uses AccountLocation::setCalendar()
     * @uses AccountLocation::setCases()
     * @uses AccountLocation::setContact()
     * @uses AccountLocation::setDefaultProject()
     * @uses AccountLocation::setDiscountAccount()
     * @uses AccountLocation::setDiscountSubaccount()
     * @uses AccountLocation::setEntityUsageType()
     * @uses AccountLocation::setFedExGroundCollect()
     * @uses AccountLocation::setFOBPoint()
     * @uses AccountLocation::setFreightAccount()
     * @uses AccountLocation::setFreightSubaccount()
     * @uses AccountLocation::setInsurance()
     * @uses AccountLocation::setLeadTimeInDays()
     * @uses AccountLocation::setLocationID()
     * @uses AccountLocation::setLocationName()
     * @uses AccountLocation::setOpportunities()
     * @uses AccountLocation::setOrderPriority()
     * @uses AccountLocation::setPriceClass()
     * @uses AccountLocation::setResidentialDelivery()
     * @uses AccountLocation::setSalesAccount()
     * @uses AccountLocation::setSalesSubaccount()
     * @uses AccountLocation::setSameAsDefaultLocation()
     * @uses AccountLocation::setSaturdayDelivery()
     * @uses AccountLocation::setShippingBranch()
     * @uses AccountLocation::setShippingRule()
     * @uses AccountLocation::setShippingTerms()
     * @uses AccountLocation::setShippingZone()
     * @uses AccountLocation::setShipVia()
     * @uses AccountLocation::setTaxExemptionNumber()
     * @uses AccountLocation::setTaxRegistrationID()
     * @uses AccountLocation::setTaxZone()
     * @uses AccountLocation::setWarehouse()
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @param \AcumaticaConfig\StructType\Address $address
     * @param \AcumaticaConfig\StructType\BooleanValue $addressSameAsMain
     * @param \AcumaticaConfig\StructType\BooleanValue $addressValidated
     * @param \AcumaticaConfig\StructType\StringValue $aRAccount
     * @param \AcumaticaConfig\StructType\StringValue $aRSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $businessAccountID
     * @param \AcumaticaConfig\StructType\StringValue $calendar
     * @param \AcumaticaConfig\StructType\Cases $cases
     * @param \AcumaticaConfig\StructType\AccountLocationContact $contact
     * @param \AcumaticaConfig\StructType\StringValue $defaultProject
     * @param \AcumaticaConfig\StructType\StringValue $discountAccount
     * @param \AcumaticaConfig\StructType\StringValue $discountSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $entityUsageType
     * @param \AcumaticaConfig\StructType\BooleanValue $fedExGroundCollect
     * @param \AcumaticaConfig\StructType\StringValue $fOBPoint
     * @param \AcumaticaConfig\StructType\StringValue $freightAccount
     * @param \AcumaticaConfig\StructType\StringValue $freightSubaccount
     * @param \AcumaticaConfig\StructType\BooleanValue $insurance
     * @param \AcumaticaConfig\StructType\ShortValue $leadTimeInDays
     * @param \AcumaticaConfig\StructType\StringValue $locationID
     * @param \AcumaticaConfig\StructType\StringValue $locationName
     * @param \AcumaticaConfig\StructType\Opportunities $opportunities
     * @param \AcumaticaConfig\StructType\ShortValue $orderPriority
     * @param \AcumaticaConfig\StructType\StringValue $priceClass
     * @param \AcumaticaConfig\StructType\BooleanValue $residentialDelivery
     * @param \AcumaticaConfig\StructType\StringValue $salesAccount
     * @param \AcumaticaConfig\StructType\StringValue $salesSubaccount
     * @param \AcumaticaConfig\StructType\BooleanValue $sameAsDefaultLocation
     * @param \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery
     * @param \AcumaticaConfig\StructType\StringValue $shippingBranch
     * @param \AcumaticaConfig\StructType\StringValue $shippingRule
     * @param \AcumaticaConfig\StructType\StringValue $shippingTerms
     * @param \AcumaticaConfig\StructType\StringValue $shippingZone
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @param \AcumaticaConfig\StructType\StringValue $taxExemptionNumber
     * @param \AcumaticaConfig\StructType\StringValue $taxRegistrationID
     * @param \AcumaticaConfig\StructType\StringValue $taxZone
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     */
    public function __construct(\AcumaticaConfig\StructType\BooleanValue $active = null, \AcumaticaConfig\StructType\Address $address = null, \AcumaticaConfig\StructType\BooleanValue $addressSameAsMain = null, \AcumaticaConfig\StructType\BooleanValue $addressValidated = null, \AcumaticaConfig\StructType\StringValue $aRAccount = null, \AcumaticaConfig\StructType\StringValue $aRSubaccount = null, \AcumaticaConfig\StructType\StringValue $businessAccountID = null, \AcumaticaConfig\StructType\StringValue $calendar = null, \AcumaticaConfig\StructType\Cases $cases = null, \AcumaticaConfig\StructType\AccountLocationContact $contact = null, \AcumaticaConfig\StructType\StringValue $defaultProject = null, \AcumaticaConfig\StructType\StringValue $discountAccount = null, \AcumaticaConfig\StructType\StringValue $discountSubaccount = null, \AcumaticaConfig\StructType\StringValue $entityUsageType = null, \AcumaticaConfig\StructType\BooleanValue $fedExGroundCollect = null, \AcumaticaConfig\StructType\StringValue $fOBPoint = null, \AcumaticaConfig\StructType\StringValue $freightAccount = null, \AcumaticaConfig\StructType\StringValue $freightSubaccount = null, \AcumaticaConfig\StructType\BooleanValue $insurance = null, \AcumaticaConfig\StructType\ShortValue $leadTimeInDays = null, \AcumaticaConfig\StructType\StringValue $locationID = null, \AcumaticaConfig\StructType\StringValue $locationName = null, \AcumaticaConfig\StructType\Opportunities $opportunities = null, \AcumaticaConfig\StructType\ShortValue $orderPriority = null, \AcumaticaConfig\StructType\StringValue $priceClass = null, \AcumaticaConfig\StructType\BooleanValue $residentialDelivery = null, \AcumaticaConfig\StructType\StringValue $salesAccount = null, \AcumaticaConfig\StructType\StringValue $salesSubaccount = null, \AcumaticaConfig\StructType\BooleanValue $sameAsDefaultLocation = null, \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery = null, \AcumaticaConfig\StructType\StringValue $shippingBranch = null, \AcumaticaConfig\StructType\StringValue $shippingRule = null, \AcumaticaConfig\StructType\StringValue $shippingTerms = null, \AcumaticaConfig\StructType\StringValue $shippingZone = null, \AcumaticaConfig\StructType\StringValue $shipVia = null, \AcumaticaConfig\StructType\StringValue $taxExemptionNumber = null, \AcumaticaConfig\StructType\StringValue $taxRegistrationID = null, \AcumaticaConfig\StructType\StringValue $taxZone = null, \AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        $this
            ->setActive($active)
            ->setAddress($address)
            ->setAddressSameAsMain($addressSameAsMain)
            ->setAddressValidated($addressValidated)
            ->setARAccount($aRAccount)
            ->setARSubaccount($aRSubaccount)
            ->setBusinessAccountID($businessAccountID)
            ->setCalendar($calendar)
            ->setCases($cases)
            ->setContact($contact)
            ->setDefaultProject($defaultProject)
            ->setDiscountAccount($discountAccount)
            ->setDiscountSubaccount($discountSubaccount)
            ->setEntityUsageType($entityUsageType)
            ->setFedExGroundCollect($fedExGroundCollect)
            ->setFOBPoint($fOBPoint)
            ->setFreightAccount($freightAccount)
            ->setFreightSubaccount($freightSubaccount)
            ->setInsurance($insurance)
            ->setLeadTimeInDays($leadTimeInDays)
            ->setLocationID($locationID)
            ->setLocationName($locationName)
            ->setOpportunities($opportunities)
            ->setOrderPriority($orderPriority)
            ->setPriceClass($priceClass)
            ->setResidentialDelivery($residentialDelivery)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setSameAsDefaultLocation($sameAsDefaultLocation)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setShippingBranch($shippingBranch)
            ->setShippingRule($shippingRule)
            ->setShippingTerms($shippingTerms)
            ->setShippingZone($shippingZone)
            ->setShipVia($shipVia)
            ->setTaxExemptionNumber($taxExemptionNumber)
            ->setTaxRegistrationID($taxRegistrationID)
            ->setTaxZone($taxZone)
            ->setWarehouse($warehouse);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setActive(\AcumaticaConfig\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Address $address
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setAddress(\AcumaticaConfig\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getAddressSameAsMain()
    {
        return isset($this->AddressSameAsMain) ? $this->AddressSameAsMain : null;
    }
    /**
     * Set AddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $addressSameAsMain
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setAddressSameAsMain(\AcumaticaConfig\StructType\BooleanValue $addressSameAsMain = null)
    {
        if (is_null($addressSameAsMain) || (is_array($addressSameAsMain) && empty($addressSameAsMain))) {
            unset($this->AddressSameAsMain);
        } else {
            $this->AddressSameAsMain = $addressSameAsMain;
        }
        return $this;
    }
    /**
     * Get AddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getAddressValidated()
    {
        return isset($this->AddressValidated) ? $this->AddressValidated : null;
    }
    /**
     * Set AddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $addressValidated
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setAddressValidated(\AcumaticaConfig\StructType\BooleanValue $addressValidated = null)
    {
        if (is_null($addressValidated) || (is_array($addressValidated) && empty($addressValidated))) {
            unset($this->AddressValidated);
        } else {
            $this->AddressValidated = $addressValidated;
        }
        return $this;
    }
    /**
     * Get ARAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getARAccount()
    {
        return isset($this->ARAccount) ? $this->ARAccount : null;
    }
    /**
     * Set ARAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $aRAccount
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setARAccount(\AcumaticaConfig\StructType\StringValue $aRAccount = null)
    {
        if (is_null($aRAccount) || (is_array($aRAccount) && empty($aRAccount))) {
            unset($this->ARAccount);
        } else {
            $this->ARAccount = $aRAccount;
        }
        return $this;
    }
    /**
     * Get ARSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getARSubaccount()
    {
        return isset($this->ARSubaccount) ? $this->ARSubaccount : null;
    }
    /**
     * Set ARSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $aRSubaccount
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setARSubaccount(\AcumaticaConfig\StructType\StringValue $aRSubaccount = null)
    {
        if (is_null($aRSubaccount) || (is_array($aRSubaccount) && empty($aRSubaccount))) {
            unset($this->ARSubaccount);
        } else {
            $this->ARSubaccount = $aRSubaccount;
        }
        return $this;
    }
    /**
     * Get BusinessAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBusinessAccountID()
    {
        return isset($this->BusinessAccountID) ? $this->BusinessAccountID : null;
    }
    /**
     * Set BusinessAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $businessAccountID
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setBusinessAccountID(\AcumaticaConfig\StructType\StringValue $businessAccountID = null)
    {
        if (is_null($businessAccountID) || (is_array($businessAccountID) && empty($businessAccountID))) {
            unset($this->BusinessAccountID);
        } else {
            $this->BusinessAccountID = $businessAccountID;
        }
        return $this;
    }
    /**
     * Get Calendar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCalendar()
    {
        return isset($this->Calendar) ? $this->Calendar : null;
    }
    /**
     * Set Calendar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $calendar
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setCalendar(\AcumaticaConfig\StructType\StringValue $calendar = null)
    {
        if (is_null($calendar) || (is_array($calendar) && empty($calendar))) {
            unset($this->Calendar);
        } else {
            $this->Calendar = $calendar;
        }
        return $this;
    }
    /**
     * Get Cases value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Cases|null
     */
    public function getCases()
    {
        return isset($this->Cases) ? $this->Cases : null;
    }
    /**
     * Set Cases value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Cases $cases
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setCases(\AcumaticaConfig\StructType\Cases $cases = null)
    {
        if (is_null($cases) || (is_array($cases) && empty($cases))) {
            unset($this->Cases);
        } else {
            $this->Cases = $cases;
        }
        return $this;
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\AccountLocationContact|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\AccountLocationContact $contact
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setContact(\AcumaticaConfig\StructType\AccountLocationContact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get DefaultProject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultProject()
    {
        return isset($this->DefaultProject) ? $this->DefaultProject : null;
    }
    /**
     * Set DefaultProject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultProject
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setDefaultProject(\AcumaticaConfig\StructType\StringValue $defaultProject = null)
    {
        if (is_null($defaultProject) || (is_array($defaultProject) && empty($defaultProject))) {
            unset($this->DefaultProject);
        } else {
            $this->DefaultProject = $defaultProject;
        }
        return $this;
    }
    /**
     * Get DiscountAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountAccount()
    {
        return isset($this->DiscountAccount) ? $this->DiscountAccount : null;
    }
    /**
     * Set DiscountAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountAccount
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setDiscountAccount(\AcumaticaConfig\StructType\StringValue $discountAccount = null)
    {
        if (is_null($discountAccount) || (is_array($discountAccount) && empty($discountAccount))) {
            unset($this->DiscountAccount);
        } else {
            $this->DiscountAccount = $discountAccount;
        }
        return $this;
    }
    /**
     * Get DiscountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountSubaccount()
    {
        return isset($this->DiscountSubaccount) ? $this->DiscountSubaccount : null;
    }
    /**
     * Set DiscountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountSubaccount
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setDiscountSubaccount(\AcumaticaConfig\StructType\StringValue $discountSubaccount = null)
    {
        if (is_null($discountSubaccount) || (is_array($discountSubaccount) && empty($discountSubaccount))) {
            unset($this->DiscountSubaccount);
        } else {
            $this->DiscountSubaccount = $discountSubaccount;
        }
        return $this;
    }
    /**
     * Get EntityUsageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getEntityUsageType()
    {
        return isset($this->EntityUsageType) ? $this->EntityUsageType : null;
    }
    /**
     * Set EntityUsageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $entityUsageType
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setEntityUsageType(\AcumaticaConfig\StructType\StringValue $entityUsageType = null)
    {
        if (is_null($entityUsageType) || (is_array($entityUsageType) && empty($entityUsageType))) {
            unset($this->EntityUsageType);
        } else {
            $this->EntityUsageType = $entityUsageType;
        }
        return $this;
    }
    /**
     * Get FedExGroundCollect value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getFedExGroundCollect()
    {
        return isset($this->FedExGroundCollect) ? $this->FedExGroundCollect : null;
    }
    /**
     * Set FedExGroundCollect value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $fedExGroundCollect
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setFedExGroundCollect(\AcumaticaConfig\StructType\BooleanValue $fedExGroundCollect = null)
    {
        if (is_null($fedExGroundCollect) || (is_array($fedExGroundCollect) && empty($fedExGroundCollect))) {
            unset($this->FedExGroundCollect);
        } else {
            $this->FedExGroundCollect = $fedExGroundCollect;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $fOBPoint
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setFOBPoint(\AcumaticaConfig\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get FreightAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFreightAccount()
    {
        return isset($this->FreightAccount) ? $this->FreightAccount : null;
    }
    /**
     * Set FreightAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $freightAccount
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setFreightAccount(\AcumaticaConfig\StructType\StringValue $freightAccount = null)
    {
        if (is_null($freightAccount) || (is_array($freightAccount) && empty($freightAccount))) {
            unset($this->FreightAccount);
        } else {
            $this->FreightAccount = $freightAccount;
        }
        return $this;
    }
    /**
     * Get FreightSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFreightSubaccount()
    {
        return isset($this->FreightSubaccount) ? $this->FreightSubaccount : null;
    }
    /**
     * Set FreightSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $freightSubaccount
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setFreightSubaccount(\AcumaticaConfig\StructType\StringValue $freightSubaccount = null)
    {
        if (is_null($freightSubaccount) || (is_array($freightSubaccount) && empty($freightSubaccount))) {
            unset($this->FreightSubaccount);
        } else {
            $this->FreightSubaccount = $freightSubaccount;
        }
        return $this;
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $insurance
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setInsurance(\AcumaticaConfig\StructType\BooleanValue $insurance = null)
    {
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Get LeadTimeInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getLeadTimeInDays()
    {
        return isset($this->LeadTimeInDays) ? $this->LeadTimeInDays : null;
    }
    /**
     * Set LeadTimeInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $leadTimeInDays
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setLeadTimeInDays(\AcumaticaConfig\StructType\ShortValue $leadTimeInDays = null)
    {
        if (is_null($leadTimeInDays) || (is_array($leadTimeInDays) && empty($leadTimeInDays))) {
            unset($this->LeadTimeInDays);
        } else {
            $this->LeadTimeInDays = $leadTimeInDays;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $locationID
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setLocationID(\AcumaticaConfig\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $locationName
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setLocationName(\AcumaticaConfig\StructType\StringValue $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get Opportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Opportunities|null
     */
    public function getOpportunities()
    {
        return isset($this->Opportunities) ? $this->Opportunities : null;
    }
    /**
     * Set Opportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Opportunities $opportunities
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setOpportunities(\AcumaticaConfig\StructType\Opportunities $opportunities = null)
    {
        if (is_null($opportunities) || (is_array($opportunities) && empty($opportunities))) {
            unset($this->Opportunities);
        } else {
            $this->Opportunities = $opportunities;
        }
        return $this;
    }
    /**
     * Get OrderPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getOrderPriority()
    {
        return isset($this->OrderPriority) ? $this->OrderPriority : null;
    }
    /**
     * Set OrderPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $orderPriority
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setOrderPriority(\AcumaticaConfig\StructType\ShortValue $orderPriority = null)
    {
        if (is_null($orderPriority) || (is_array($orderPriority) && empty($orderPriority))) {
            unset($this->OrderPriority);
        } else {
            $this->OrderPriority = $orderPriority;
        }
        return $this;
    }
    /**
     * Get PriceClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPriceClass()
    {
        return isset($this->PriceClass) ? $this->PriceClass : null;
    }
    /**
     * Set PriceClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $priceClass
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setPriceClass(\AcumaticaConfig\StructType\StringValue $priceClass = null)
    {
        if (is_null($priceClass) || (is_array($priceClass) && empty($priceClass))) {
            unset($this->PriceClass);
        } else {
            $this->PriceClass = $priceClass;
        }
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getResidentialDelivery()
    {
        return isset($this->ResidentialDelivery) ? $this->ResidentialDelivery : null;
    }
    /**
     * Set ResidentialDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $residentialDelivery
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setResidentialDelivery(\AcumaticaConfig\StructType\BooleanValue $residentialDelivery = null)
    {
        if (is_null($residentialDelivery) || (is_array($residentialDelivery) && empty($residentialDelivery))) {
            unset($this->ResidentialDelivery);
        } else {
            $this->ResidentialDelivery = $residentialDelivery;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesAccount
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setSalesAccount(\AcumaticaConfig\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesSubaccount
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setSalesSubaccount(\AcumaticaConfig\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get SameAsDefaultLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSameAsDefaultLocation()
    {
        return isset($this->SameAsDefaultLocation) ? $this->SameAsDefaultLocation : null;
    }
    /**
     * Set SameAsDefaultLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $sameAsDefaultLocation
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setSameAsDefaultLocation(\AcumaticaConfig\StructType\BooleanValue $sameAsDefaultLocation = null)
    {
        if (is_null($sameAsDefaultLocation) || (is_array($sameAsDefaultLocation) && empty($sameAsDefaultLocation))) {
            unset($this->SameAsDefaultLocation);
        } else {
            $this->SameAsDefaultLocation = $sameAsDefaultLocation;
        }
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSaturdayDelivery()
    {
        return isset($this->SaturdayDelivery) ? $this->SaturdayDelivery : null;
    }
    /**
     * Set SaturdayDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setSaturdayDelivery(\AcumaticaConfig\StructType\BooleanValue $saturdayDelivery = null)
    {
        if (is_null($saturdayDelivery) || (is_array($saturdayDelivery) && empty($saturdayDelivery))) {
            unset($this->SaturdayDelivery);
        } else {
            $this->SaturdayDelivery = $saturdayDelivery;
        }
        return $this;
    }
    /**
     * Get ShippingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingBranch()
    {
        return isset($this->ShippingBranch) ? $this->ShippingBranch : null;
    }
    /**
     * Set ShippingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingBranch
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setShippingBranch(\AcumaticaConfig\StructType\StringValue $shippingBranch = null)
    {
        if (is_null($shippingBranch) || (is_array($shippingBranch) && empty($shippingBranch))) {
            unset($this->ShippingBranch);
        } else {
            $this->ShippingBranch = $shippingBranch;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingRule
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setShippingRule(\AcumaticaConfig\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingTerms
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setShippingTerms(\AcumaticaConfig\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShippingZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingZone()
    {
        return isset($this->ShippingZone) ? $this->ShippingZone : null;
    }
    /**
     * Set ShippingZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingZone
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setShippingZone(\AcumaticaConfig\StructType\StringValue $shippingZone = null)
    {
        if (is_null($shippingZone) || (is_array($shippingZone) && empty($shippingZone))) {
            unset($this->ShippingZone);
        } else {
            $this->ShippingZone = $shippingZone;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setShipVia(\AcumaticaConfig\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get TaxExemptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxExemptionNumber()
    {
        return isset($this->TaxExemptionNumber) ? $this->TaxExemptionNumber : null;
    }
    /**
     * Set TaxExemptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxExemptionNumber
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setTaxExemptionNumber(\AcumaticaConfig\StructType\StringValue $taxExemptionNumber = null)
    {
        if (is_null($taxExemptionNumber) || (is_array($taxExemptionNumber) && empty($taxExemptionNumber))) {
            unset($this->TaxExemptionNumber);
        } else {
            $this->TaxExemptionNumber = $taxExemptionNumber;
        }
        return $this;
    }
    /**
     * Get TaxRegistrationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxRegistrationID()
    {
        return isset($this->TaxRegistrationID) ? $this->TaxRegistrationID : null;
    }
    /**
     * Set TaxRegistrationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxRegistrationID
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setTaxRegistrationID(\AcumaticaConfig\StructType\StringValue $taxRegistrationID = null)
    {
        if (is_null($taxRegistrationID) || (is_array($taxRegistrationID) && empty($taxRegistrationID))) {
            unset($this->TaxRegistrationID);
        } else {
            $this->TaxRegistrationID = $taxRegistrationID;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxZone
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setTaxZone(\AcumaticaConfig\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public function setWarehouse(\AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\AccountLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
