<?php

namespace AcumaticaConfig\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Put ServiceType
 * @subpackage Services
 */
class Put extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Put
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AcumaticaConfig\StructType\Put $parameters
     * @return \AcumaticaConfig\StructType\PutResponse|bool
     */
    public function Put(\AcumaticaConfig\StructType\Put $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Put($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PutFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AcumaticaConfig\StructType\PutFiles $parameters
     * @return \AcumaticaConfig\StructType\PutFilesResponse|bool
     */
    public function PutFiles(\AcumaticaConfig\StructType\PutFiles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PutFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AcumaticaConfig\StructType\PutFilesResponse|\AcumaticaConfig\StructType\PutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
