<?php

namespace AcumaticaConfig\EnumType;

/**
 * This class stands for GuidCondition EnumType
 * @subpackage Enumerations
 */
class GuidCondition
{
    /**
     * Constant for value 'Equal'
     * @return string 'Equal'
     */
    const VALUE_EQUAL = 'Equal';
    /**
     * Constant for value 'NotEqual'
     * @return string 'NotEqual'
     */
    const VALUE_NOT_EQUAL = 'NotEqual';
    /**
     * Constant for value 'IsNull'
     * @return string 'IsNull'
     */
    const VALUE_IS_NULL = 'IsNull';
    /**
     * Constant for value 'IsNotNull'
     * @return string 'IsNotNull'
     */
    const VALUE_IS_NOT_NULL = 'IsNotNull';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQUAL
     * @uses self::VALUE_NOT_EQUAL
     * @uses self::VALUE_IS_NULL
     * @uses self::VALUE_IS_NOT_NULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUAL,
            self::VALUE_NOT_EQUAL,
            self::VALUE_IS_NULL,
            self::VALUE_IS_NOT_NULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
