<?php

namespace AcumaticaConfig\EnumType;

/**
 * This class stands for DateTimeCondition EnumType
 * @subpackage Enumerations
 */
class DateTimeCondition
{
    /**
     * Constant for value 'Equal'
     * @return string 'Equal'
     */
    const VALUE_EQUAL = 'Equal';
    /**
     * Constant for value 'NotEqual'
     * @return string 'NotEqual'
     */
    const VALUE_NOT_EQUAL = 'NotEqual';
    /**
     * Constant for value 'IsBetween'
     * @return string 'IsBetween'
     */
    const VALUE_IS_BETWEEN = 'IsBetween';
    /**
     * Constant for value 'IsGreaterThan'
     * @return string 'IsGreaterThan'
     */
    const VALUE_IS_GREATER_THAN = 'IsGreaterThan';
    /**
     * Constant for value 'IsLessThan'
     * @return string 'IsLessThan'
     */
    const VALUE_IS_LESS_THAN = 'IsLessThan';
    /**
     * Constant for value 'IsGreaterThanOrEqualsTo'
     * @return string 'IsGreaterThanOrEqualsTo'
     */
    const VALUE_IS_GREATER_THAN_OR_EQUALS_TO = 'IsGreaterThanOrEqualsTo';
    /**
     * Constant for value 'IsLessThanOrEqualsTo'
     * @return string 'IsLessThanOrEqualsTo'
     */
    const VALUE_IS_LESS_THAN_OR_EQUALS_TO = 'IsLessThanOrEqualsTo';
    /**
     * Constant for value 'Today'
     * @return string 'Today'
     */
    const VALUE_TODAY = 'Today';
    /**
     * Constant for value 'Overdue'
     * @return string 'Overdue'
     */
    const VALUE_OVERDUE = 'Overdue';
    /**
     * Constant for value 'Tomorrow'
     * @return string 'Tomorrow'
     */
    const VALUE_TOMORROW = 'Tomorrow';
    /**
     * Constant for value 'ThisWeek'
     * @return string 'ThisWeek'
     */
    const VALUE_THIS_WEEK = 'ThisWeek';
    /**
     * Constant for value 'ThisMonth'
     * @return string 'ThisMonth'
     */
    const VALUE_THIS_MONTH = 'ThisMonth';
    /**
     * Constant for value 'IsNull'
     * @return string 'IsNull'
     */
    const VALUE_IS_NULL = 'IsNull';
    /**
     * Constant for value 'IsNotNull'
     * @return string 'IsNotNull'
     */
    const VALUE_IS_NOT_NULL = 'IsNotNull';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQUAL
     * @uses self::VALUE_NOT_EQUAL
     * @uses self::VALUE_IS_BETWEEN
     * @uses self::VALUE_IS_GREATER_THAN
     * @uses self::VALUE_IS_LESS_THAN
     * @uses self::VALUE_IS_GREATER_THAN_OR_EQUALS_TO
     * @uses self::VALUE_IS_LESS_THAN_OR_EQUALS_TO
     * @uses self::VALUE_TODAY
     * @uses self::VALUE_OVERDUE
     * @uses self::VALUE_TOMORROW
     * @uses self::VALUE_THIS_WEEK
     * @uses self::VALUE_THIS_MONTH
     * @uses self::VALUE_IS_NULL
     * @uses self::VALUE_IS_NOT_NULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUAL,
            self::VALUE_NOT_EQUAL,
            self::VALUE_IS_BETWEEN,
            self::VALUE_IS_GREATER_THAN,
            self::VALUE_IS_LESS_THAN,
            self::VALUE_IS_GREATER_THAN_OR_EQUALS_TO,
            self::VALUE_IS_LESS_THAN_OR_EQUALS_TO,
            self::VALUE_TODAY,
            self::VALUE_OVERDUE,
            self::VALUE_TOMORROW,
            self::VALUE_THIS_WEEK,
            self::VALUE_THIS_MONTH,
            self::VALUE_IS_NULL,
            self::VALUE_IS_NOT_NULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
