<?php

namespace AcumaticaConfig;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'GetList' => '\\AcumaticaConfig\\StructType\\GetList',
            'Entity' => '\\AcumaticaConfig\\StructType\\Entity',
            'LongValue' => '\\AcumaticaConfig\\StructType\\LongValue',
            'ArrayOfCustomField' => '\\AcumaticaConfig\\ArrayType\\ArrayOfCustomField',
            'CustomField' => '\\AcumaticaConfig\\StructType\\CustomField',
            'GetListResponse' => '\\AcumaticaConfig\\StructType\\GetListResponse',
            'ArrayOfEntity' => '\\AcumaticaConfig\\ArrayType\\ArrayOfEntity',
            'Get' => '\\AcumaticaConfig\\StructType\\Get',
            'GetResponse' => '\\AcumaticaConfig\\StructType\\GetResponse',
            'Put' => '\\AcumaticaConfig\\StructType\\Put',
            'PutResponse' => '\\AcumaticaConfig\\StructType\\PutResponse',
            'GetCustomFieldSchema' => '\\AcumaticaConfig\\StructType\\GetCustomFieldSchema',
            'GetCustomFieldSchemaResponse' => '\\AcumaticaConfig\\StructType\\GetCustomFieldSchemaResponse',
            'SanityCheck' => '\\AcumaticaConfig\\StructType\\SanityCheck',
            'SanityCheckResponse' => '\\AcumaticaConfig\\StructType\\SanityCheckResponse',
            'Login' => '\\AcumaticaConfig\\StructType\\Login',
            'LoginResponse' => '\\AcumaticaConfig\\StructType\\LoginResponse',
            'Logout' => '\\AcumaticaConfig\\StructType\\Logout',
            'LogoutResponse' => '\\AcumaticaConfig\\StructType\\LogoutResponse',
            'SetBusinessDate' => '\\AcumaticaConfig\\StructType\\SetBusinessDate',
            'SetBusinessDateResponse' => '\\AcumaticaConfig\\StructType\\SetBusinessDateResponse',
            'GetProcessStatus' => '\\AcumaticaConfig\\StructType\\GetProcessStatus',
            'InvokeResult' => '\\AcumaticaConfig\\StructType\\InvokeResult',
            'GetProcessStatusResponse' => '\\AcumaticaConfig\\StructType\\GetProcessStatusResponse',
            'ProcessResult' => '\\AcumaticaConfig\\StructType\\ProcessResult',
            'Delete' => '\\AcumaticaConfig\\StructType\\Delete',
            'DeleteResponse' => '\\AcumaticaConfig\\StructType\\DeleteResponse',
            'Invoke' => '\\AcumaticaConfig\\StructType\\Invoke',
            'Action' => '\\AcumaticaConfig\\StructType\\Action',
            'InvokeResponse' => '\\AcumaticaConfig\\StructType\\InvokeResponse',
            'GetFiles' => '\\AcumaticaConfig\\StructType\\GetFiles',
            'GetFilesResponse' => '\\AcumaticaConfig\\StructType\\GetFilesResponse',
            'ArrayOfFile' => '\\AcumaticaConfig\\ArrayType\\ArrayOfFile',
            'File' => '\\AcumaticaConfig\\StructType\\File',
            'PutFiles' => '\\AcumaticaConfig\\StructType\\PutFiles',
            'PutFilesResponse' => '\\AcumaticaConfig\\StructType\\PutFilesResponse',
            'StringSearch' => '\\AcumaticaConfig\\StructType\\StringSearch',
            'DecimalSearch' => '\\AcumaticaConfig\\StructType\\DecimalSearch',
            'DateTimeSearch' => '\\AcumaticaConfig\\StructType\\DateTimeSearch',
            'BooleanSearch' => '\\AcumaticaConfig\\StructType\\BooleanSearch',
            'IntSearch' => '\\AcumaticaConfig\\StructType\\IntSearch',
            'LongSearch' => '\\AcumaticaConfig\\StructType\\LongSearch',
            'ShortSearch' => '\\AcumaticaConfig\\StructType\\ShortSearch',
            'ByteSearch' => '\\AcumaticaConfig\\StructType\\ByteSearch',
            'DoubleSearch' => '\\AcumaticaConfig\\StructType\\DoubleSearch',
            'GuidSearch' => '\\AcumaticaConfig\\StructType\\GuidSearch',
            'StringValue' => '\\AcumaticaConfig\\StructType\\StringValue',
            'DecimalValue' => '\\AcumaticaConfig\\StructType\\DecimalValue',
            'DateTimeValue' => '\\AcumaticaConfig\\StructType\\DateTimeValue',
            'BooleanValue' => '\\AcumaticaConfig\\StructType\\BooleanValue',
            'IntValue' => '\\AcumaticaConfig\\StructType\\IntValue',
            'ShortValue' => '\\AcumaticaConfig\\StructType\\ShortValue',
            'ByteValue' => '\\AcumaticaConfig\\StructType\\ByteValue',
            'DoubleValue' => '\\AcumaticaConfig\\StructType\\DoubleValue',
            'GuidValue' => '\\AcumaticaConfig\\StructType\\GuidValue',
            'CustomStringField' => '\\AcumaticaConfig\\StructType\\CustomStringField',
            'StringSkip' => '\\AcumaticaConfig\\StructType\\StringSkip',
            'StringReturn' => '\\AcumaticaConfig\\StructType\\StringReturn',
            'CustomDecimalField' => '\\AcumaticaConfig\\StructType\\CustomDecimalField',
            'DecimalSkip' => '\\AcumaticaConfig\\StructType\\DecimalSkip',
            'DecimalReturn' => '\\AcumaticaConfig\\StructType\\DecimalReturn',
            'CustomDateTimeField' => '\\AcumaticaConfig\\StructType\\CustomDateTimeField',
            'DateTimeSkip' => '\\AcumaticaConfig\\StructType\\DateTimeSkip',
            'DateTimeReturn' => '\\AcumaticaConfig\\StructType\\DateTimeReturn',
            'CustomBooleanField' => '\\AcumaticaConfig\\StructType\\CustomBooleanField',
            'BooleanSkip' => '\\AcumaticaConfig\\StructType\\BooleanSkip',
            'BooleanReturn' => '\\AcumaticaConfig\\StructType\\BooleanReturn',
            'CustomIntField' => '\\AcumaticaConfig\\StructType\\CustomIntField',
            'IntSkip' => '\\AcumaticaConfig\\StructType\\IntSkip',
            'IntReturn' => '\\AcumaticaConfig\\StructType\\IntReturn',
            'CustomLongField' => '\\AcumaticaConfig\\StructType\\CustomLongField',
            'LongSkip' => '\\AcumaticaConfig\\StructType\\LongSkip',
            'LongReturn' => '\\AcumaticaConfig\\StructType\\LongReturn',
            'CustomShortField' => '\\AcumaticaConfig\\StructType\\CustomShortField',
            'ShortSkip' => '\\AcumaticaConfig\\StructType\\ShortSkip',
            'ShortReturn' => '\\AcumaticaConfig\\StructType\\ShortReturn',
            'CustomByteField' => '\\AcumaticaConfig\\StructType\\CustomByteField',
            'ByteSkip' => '\\AcumaticaConfig\\StructType\\ByteSkip',
            'ByteReturn' => '\\AcumaticaConfig\\StructType\\ByteReturn',
            'CustomDoubleField' => '\\AcumaticaConfig\\StructType\\CustomDoubleField',
            'DoubleSkip' => '\\AcumaticaConfig\\StructType\\DoubleSkip',
            'DoubleReturn' => '\\AcumaticaConfig\\StructType\\DoubleReturn',
            'CustomGuidField' => '\\AcumaticaConfig\\StructType\\CustomGuidField',
            'GuidSkip' => '\\AcumaticaConfig\\StructType\\GuidSkip',
            'GuidReturn' => '\\AcumaticaConfig\\StructType\\GuidReturn',
            'PurchaseReceiptDetail' => '\\AcumaticaConfig\\StructType\\PurchaseReceiptDetail',
            'Allocations' => '\\AcumaticaConfig\\StructType\\Allocations',
            'SalesOrderDetail' => '\\AcumaticaConfig\\StructType\\SalesOrderDetail',
            'CheckHistoryDetail' => '\\AcumaticaConfig\\StructType\\CheckHistoryDetail',
            'Salesperson' => '\\AcumaticaConfig\\StructType\\Salesperson',
            'Customer' => '\\AcumaticaConfig\\StructType\\Customer',
            'Attributes' => '\\AcumaticaConfig\\StructType\\Attributes',
            'Contacts' => '\\AcumaticaConfig\\StructType\\Contacts',
            'PaymentInstructions' => '\\AcumaticaConfig\\StructType\\PaymentInstructions',
            'Salespersons' => '\\AcumaticaConfig\\StructType\\Salespersons',
            'CarrierPluginParameter' => '\\AcumaticaConfig\\StructType\\CarrierPluginParameter',
            'SubItemStockItem' => '\\AcumaticaConfig\\StructType\\SubItemStockItem',
            'PhysicalInventoryCount' => '\\AcumaticaConfig\\StructType\\PhysicalInventoryCount',
            'Details' => '\\AcumaticaConfig\\StructType\\Details',
            'ShipmentPackage' => '\\AcumaticaConfig\\StructType\\ShipmentPackage',
            'DiscountBreakpointDetail' => '\\AcumaticaConfig\\StructType\\DiscountBreakpointDetail',
            'PurchaseOrderDetail' => '\\AcumaticaConfig\\StructType\\PurchaseOrderDetail',
            'TaskRelatedActivity' => '\\AcumaticaConfig\\StructType\\TaskRelatedActivity',
            'JournalVoucherDetail' => '\\AcumaticaConfig\\StructType\\JournalVoucherDetail',
            'APDocumentsToApply' => '\\AcumaticaConfig\\StructType\\APDocumentsToApply',
            'ARDocumentsToApply' => '\\AcumaticaConfig\\StructType\\ARDocumentsToApply',
            'PurchaseOrder' => '\\AcumaticaConfig\\StructType\\PurchaseOrder',
            'NonProductWithPrice' => '\\AcumaticaConfig\\StructType\\NonProductWithPrice',
            'NonProductResults' => '\\AcumaticaConfig\\StructType\\NonProductResults',
            'Email' => '\\AcumaticaConfig\\StructType\\Email',
            'InventoryResults' => '\\AcumaticaConfig\\StructType\\InventoryResults',
            'ProductWithPrice' => '\\AcumaticaConfig\\StructType\\ProductWithPrice',
            'ProductResults' => '\\AcumaticaConfig\\StructType\\ProductResults',
            'Members' => '\\AcumaticaConfig\\StructType\\Members',
            'SalesPricesWorksheetDetail' => '\\AcumaticaConfig\\StructType\\SalesPricesWorksheetDetail',
            'TransferOrderDetailAllocation' => '\\AcumaticaConfig\\StructType\\TransferOrderDetailAllocation',
            'JournalVoucherDetailAPDocumentToApply' => '\\AcumaticaConfig\\StructType\\JournalVoucherDetailAPDocumentToApply',
            'WarehouseLocation' => '\\AcumaticaConfig\\StructType\\WarehouseLocation',
            'ShippingTermDetail' => '\\AcumaticaConfig\\StructType\\ShippingTermDetail',
            'CrossSellDetails' => '\\AcumaticaConfig\\StructType\\CrossSellDetails',
            'AttributeDefinitionValue' => '\\AcumaticaConfig\\StructType\\AttributeDefinitionValue',
            'TaskTimeActivity' => '\\AcumaticaConfig\\StructType\\TaskTimeActivity',
            'SalesPricesInquiry' => '\\AcumaticaConfig\\StructType\\SalesPricesInquiry',
            'SalesPriceDetails' => '\\AcumaticaConfig\\StructType\\SalesPriceDetails',
            'InventoryAllocationRow' => '\\AcumaticaConfig\\StructType\\InventoryAllocationRow',
            'Event' => '\\AcumaticaConfig\\StructType\\Event',
            'Attendees' => '\\AcumaticaConfig\\StructType\\Attendees',
            'RelatedActivities' => '\\AcumaticaConfig\\StructType\\RelatedActivities',
            'SegmentConfiguration' => '\\AcumaticaConfig\\StructType\\SegmentConfiguration',
            'SegmentValues' => '\\AcumaticaConfig\\StructType\\SegmentValues',
            'CustomerCount' => '\\AcumaticaConfig\\StructType\\CustomerCount',
            'CustomerResult' => '\\AcumaticaConfig\\StructType\\CustomerResult',
            'TaxCategoryTaxDetail' => '\\AcumaticaConfig\\StructType\\TaxCategoryTaxDetail',
            'TaskRelatedTask' => '\\AcumaticaConfig\\StructType\\TaskRelatedTask',
            'UpSellsDetails' => '\\AcumaticaConfig\\StructType\\UpSellsDetails',
            'SalesPriceWorksheet' => '\\AcumaticaConfig\\StructType\\SalesPriceWorksheet',
            'SalesPrices' => '\\AcumaticaConfig\\StructType\\SalesPrices',
            'EmailProcessingRow' => '\\AcumaticaConfig\\StructType\\EmailProcessingRow',
            'PaymentDetail' => '\\AcumaticaConfig\\StructType\\PaymentDetail',
            'Employee' => '\\AcumaticaConfig\\StructType\\Employee',
            'EmployeeCost' => '\\AcumaticaConfig\\StructType\\EmployeeCost',
            'EmploymentHistory' => '\\AcumaticaConfig\\StructType\\EmploymentHistory',
            'ItemWarehouse' => '\\AcumaticaConfig\\StructType\\ItemWarehouse',
            'BillToSettings' => '\\AcumaticaConfig\\StructType\\BillToSettings',
            'DiscountItemPriceClassesDetail' => '\\AcumaticaConfig\\StructType\\DiscountItemPriceClassesDetail',
            'DiscountCode' => '\\AcumaticaConfig\\StructType\\DiscountCode',
            'FinancialPeriod' => '\\AcumaticaConfig\\StructType\\FinancialPeriod',
            'BoxStockItem' => '\\AcumaticaConfig\\StructType\\BoxStockItem',
            'CustomerContact' => '\\AcumaticaConfig\\StructType\\CustomerContact',
            'TrialBalanceDetail' => '\\AcumaticaConfig\\StructType\\TrialBalanceDetail',
            'ProductDetails' => '\\AcumaticaConfig\\StructType\\ProductDetails',
            'ShipViaFreightRate' => '\\AcumaticaConfig\\StructType\\ShipViaFreightRate',
            'OpportunityDiscount' => '\\AcumaticaConfig\\StructType\\OpportunityDiscount',
            'AttributeDefinition' => '\\AcumaticaConfig\\StructType\\AttributeDefinition',
            'Values' => '\\AcumaticaConfig\\StructType\\Values',
            'ShipmentDetailAllocation' => '\\AcumaticaConfig\\StructType\\ShipmentDetailAllocation',
            'BillApplicationDetail' => '\\AcumaticaConfig\\StructType\\BillApplicationDetail',
            'LotSerialClass' => '\\AcumaticaConfig\\StructType\\LotSerialClass',
            'Segments' => '\\AcumaticaConfig\\StructType\\Segments',
            'ReplenishmentParameterStockItem' => '\\AcumaticaConfig\\StructType\\ReplenishmentParameterStockItem',
            'LotSerialClassSegment' => '\\AcumaticaConfig\\StructType\\LotSerialClassSegment',
            'ShippingSettings' => '\\AcumaticaConfig\\StructType\\ShippingSettings',
            'ContactNotification' => '\\AcumaticaConfig\\StructType\\ContactNotification',
            'StockItem' => '\\AcumaticaConfig\\StructType\\StockItem',
            'Boxes' => '\\AcumaticaConfig\\StructType\\Boxes',
            'Categories' => '\\AcumaticaConfig\\StructType\\Categories',
            'CrossReferences' => '\\AcumaticaConfig\\StructType\\CrossReferences',
            'CrossSells' => '\\AcumaticaConfig\\StructType\\CrossSells',
            'ReplenishmentParameters' => '\\AcumaticaConfig\\StructType\\ReplenishmentParameters',
            'SubItems' => '\\AcumaticaConfig\\StructType\\SubItems',
            'UOMConversions' => '\\AcumaticaConfig\\StructType\\UOMConversions',
            'UpSells' => '\\AcumaticaConfig\\StructType\\UpSells',
            'VendorDetails' => '\\AcumaticaConfig\\StructType\\VendorDetails',
            'WarehouseDetails' => '\\AcumaticaConfig\\StructType\\WarehouseDetails',
            'SalesOrder' => '\\AcumaticaConfig\\StructType\\SalesOrder',
            'DiscountDetails' => '\\AcumaticaConfig\\StructType\\DiscountDetails',
            'Payments' => '\\AcumaticaConfig\\StructType\\Payments',
            'Shipments' => '\\AcumaticaConfig\\StructType\\Shipments',
            'TaxDetails' => '\\AcumaticaConfig\\StructType\\TaxDetails',
            'SalesInvoiceFreightDetail' => '\\AcumaticaConfig\\StructType\\SalesInvoiceFreightDetail',
            'CaseActivityDetail' => '\\AcumaticaConfig\\StructType\\CaseActivityDetail',
            'Commissions' => '\\AcumaticaConfig\\StructType\\Commissions',
            'SalesPersons' => '\\AcumaticaConfig\\StructType\\SalesPersons_1',
            'SalesPersonDetail' => '\\AcumaticaConfig\\StructType\\SalesPersonDetail',
            'ShipmentOrderDetail' => '\\AcumaticaConfig\\StructType\\ShipmentOrderDetail',
            'AccountLocation' => '\\AcumaticaConfig\\StructType\\AccountLocation',
            'Cases' => '\\AcumaticaConfig\\StructType\\Cases',
            'Opportunities' => '\\AcumaticaConfig\\StructType\\Opportunities',
            'SalesInvoiceDetail' => '\\AcumaticaConfig\\StructType\\SalesInvoiceDetail',
            'ProductCategories' => '\\AcumaticaConfig\\StructType\\ProductCategories',
            'EventRelatedActivity' => '\\AcumaticaConfig\\StructType\\EventRelatedActivity',
            'StatementCycle' => '\\AcumaticaConfig\\StructType\\StatementCycle',
            'RelationDetail' => '\\AcumaticaConfig\\StructType\\RelationDetail',
            'CustomerPriceClass' => '\\AcumaticaConfig\\StructType\\CustomerPriceClass',
            'CustomerClass' => '\\AcumaticaConfig\\StructType\\CustomerClass',
            'FinancialYear' => '\\AcumaticaConfig\\StructType\\FinancialYear',
            'DocContact' => '\\AcumaticaConfig\\StructType\\DocContact',
            'StockItemWarehouseDetail' => '\\AcumaticaConfig\\StructType\\StockItemWarehouseDetail',
            'SalesOrderShipment' => '\\AcumaticaConfig\\StructType\\SalesOrderShipment',
            'UnitsOfMeasure' => '\\AcumaticaConfig\\StructType\\UnitsOfMeasure',
            'VoucherEntryCode' => '\\AcumaticaConfig\\StructType\\VoucherEntryCode',
            'KitAssemblyStockComponent' => '\\AcumaticaConfig\\StructType\\KitAssemblyStockComponent',
            'AttributesDetail' => '\\AcumaticaConfig\\StructType\\AttributesDetail',
            'ProductByItemClass' => '\\AcumaticaConfig\\StructType\\ProductByItemClass',
            'Adjustment' => '\\AcumaticaConfig\\StructType\\Adjustment',
            'CustomerPaymentMethodDetail' => '\\AcumaticaConfig\\StructType\\CustomerPaymentMethodDetail',
            'CaseRelatedCase' => '\\AcumaticaConfig\\StructType\\CaseRelatedCase',
            'ChartOfAccounts' => '\\AcumaticaConfig\\StructType\\ChartOfAccounts',
            'ShippingBox' => '\\AcumaticaConfig\\StructType\\ShippingBox',
            'BillTaxDetail' => '\\AcumaticaConfig\\StructType\\BillTaxDetail',
            'NonStockItemSalesCategory' => '\\AcumaticaConfig\\StructType\\NonStockItemSalesCategory',
            'ReminderDetail' => '\\AcumaticaConfig\\StructType\\ReminderDetail',
            'CreditCardProcessingDetail' => '\\AcumaticaConfig\\StructType\\CreditCardProcessingDetail',
            'KitSpecification' => '\\AcumaticaConfig\\StructType\\KitSpecification',
            'NonStockComponents' => '\\AcumaticaConfig\\StructType\\NonStockComponents',
            'StockComponents' => '\\AcumaticaConfig\\StructType\\StockComponents',
            'Task' => '\\AcumaticaConfig\\StructType\\Task',
            'RelatedTasks' => '\\AcumaticaConfig\\StructType\\RelatedTasks',
            'JournalTransaction' => '\\AcumaticaConfig\\StructType\\JournalTransaction',
            'Address' => '\\AcumaticaConfig\\StructType\\Address',
            'InventoryReceipt' => '\\AcumaticaConfig\\StructType\\InventoryReceipt',
            'OpportunityProduct' => '\\AcumaticaConfig\\StructType\\OpportunityProduct',
            'ShippingInstructions' => '\\AcumaticaConfig\\StructType\\ShippingInstructions',
            'PurchaseSettings' => '\\AcumaticaConfig\\StructType\\PurchaseSettings',
            'FinancialSettings' => '\\AcumaticaConfig\\StructType\\FinancialSettings',
            'SalesOrderDetailAllocation' => '\\AcumaticaConfig\\StructType\\SalesOrderDetailAllocation',
            'OpportunityDetail' => '\\AcumaticaConfig\\StructType\\OpportunityDetail',
            'ActivityDetail' => '\\AcumaticaConfig\\StructType\\ActivityDetail',
            'ContactRoles' => '\\AcumaticaConfig\\StructType\\ContactRoles',
            'BasicConfiguration' => '\\AcumaticaConfig\\StructType\\BasicConfiguration',
            'VendorPriceWorksheet' => '\\AcumaticaConfig\\StructType\\VendorPriceWorksheet',
            'VendorSalesPrices' => '\\AcumaticaConfig\\StructType\\VendorSalesPrices',
            'EndPointVersion' => '\\AcumaticaConfig\\StructType\\EndPointVersion',
            'SalesInvoice' => '\\AcumaticaConfig\\StructType\\SalesInvoice',
            'FreightDetails' => '\\AcumaticaConfig\\StructType\\FreightDetails',
            'InterBranchAccountMappingTransactionInSourceBranchDetail' => '\\AcumaticaConfig\\StructType\\InterBranchAccountMappingTransactionInSourceBranchDetail',
            'KitStockComponent' => '\\AcumaticaConfig\\StructType\\KitStockComponent',
            'BusinessAccountOrder' => '\\AcumaticaConfig\\StructType\\BusinessAccountOrder',
            'NonStockItemAttribute' => '\\AcumaticaConfig\\StructType\\NonStockItemAttribute',
            'ItemsDetails' => '\\AcumaticaConfig\\StructType\\ItemsDetails',
            'KitAssemblyAllocation' => '\\AcumaticaConfig\\StructType\\KitAssemblyAllocation',
            'AttributeDetail' => '\\AcumaticaConfig\\StructType\\AttributeDetail',
            'JournalVoucher' => '\\AcumaticaConfig\\StructType\\JournalVoucher',
            'GLTransactions' => '\\AcumaticaConfig\\StructType\\GLTransactions',
            'BusinessAccountDefaultLocationSetting' => '\\AcumaticaConfig\\StructType\\BusinessAccountDefaultLocationSetting',
            'ShipmentDetail' => '\\AcumaticaConfig\\StructType\\ShipmentDetail',
            'InventoryList' => '\\AcumaticaConfig\\StructType\\InventoryList',
            'ProductInventoryByDate' => '\\AcumaticaConfig\\StructType\\ProductInventoryByDate',
            'Results' => '\\AcumaticaConfig\\StructType\\Results',
            'Totals' => '\\AcumaticaConfig\\StructType\\Totals',
            'KitAssemblyNonStockComponent' => '\\AcumaticaConfig\\StructType\\KitAssemblyNonStockComponent',
            'ItemPriceClassesDetails' => '\\AcumaticaConfig\\StructType\\ItemPriceClassesDetails',
            'ReportingGroup' => '\\AcumaticaConfig\\StructType\\ReportingGroup',
            'EmploymentHistoryRecord' => '\\AcumaticaConfig\\StructType\\EmploymentHistoryRecord',
            'EventAttendee' => '\\AcumaticaConfig\\StructType\\EventAttendee',
            'InventoryItemCrossReference' => '\\AcumaticaConfig\\StructType\\InventoryItemCrossReference',
            'CustomerSalesPerson' => '\\AcumaticaConfig\\StructType\\CustomerSalesPerson',
            'InventoryAllocationInquiry' => '\\AcumaticaConfig\\StructType\\InventoryAllocationInquiry',
            'CaseDetail' => '\\AcumaticaConfig\\StructType\\CaseDetail',
            'FOBPoint' => '\\AcumaticaConfig\\StructType\\FOBPoint',
            'ShippingTerm' => '\\AcumaticaConfig\\StructType\\ShippingTerm',
            'AccountDetailsRow' => '\\AcumaticaConfig\\StructType\\AccountDetailsRow',
            'CreditVerificationRules' => '\\AcumaticaConfig\\StructType\\CreditVerificationRules',
            'TaxScheduleDetail' => '\\AcumaticaConfig\\StructType\\TaxScheduleDetail',
            'ItemClassAtrribute' => '\\AcumaticaConfig\\StructType\\ItemClassAtrribute',
            'EmailProcessing' => '\\AcumaticaConfig\\StructType\\EmailProcessing',
            'Result' => '\\AcumaticaConfig\\StructType\\Result',
            'EmployeeCostRecord' => '\\AcumaticaConfig\\StructType\\EmployeeCostRecord',
            'Opportunity' => '\\AcumaticaConfig\\StructType\\Opportunity',
            'Activities' => '\\AcumaticaConfig\\StructType\\Activities',
            'Discounts' => '\\AcumaticaConfig\\StructType\\Discounts',
            'Products' => '\\AcumaticaConfig\\StructType\\Products',
            'Relations' => '\\AcumaticaConfig\\StructType\\Relations',
            'CategoryInfo' => '\\AcumaticaConfig\\StructType\\CategoryInfo',
            'TaxCategory' => '\\AcumaticaConfig\\StructType\\TaxCategory',
            'DroShipDetails' => '\\AcumaticaConfig\\StructType\\DroShipDetails',
            'BusinessAccountLocation' => '\\AcumaticaConfig\\StructType\\BusinessAccountLocation',
            'Lead' => '\\AcumaticaConfig\\StructType\\Lead',
            'Campaigns' => '\\AcumaticaConfig\\StructType\\Campaigns',
            'Duplicates' => '\\AcumaticaConfig\\StructType\\Duplicates',
            'MarketingLists' => '\\AcumaticaConfig\\StructType\\MarketingLists',
            'AttributeValue' => '\\AcumaticaConfig\\StructType\\AttributeValue',
            'ContractUsage' => '\\AcumaticaConfig\\StructType\\ContractUsage',
            'BilledTransactions' => '\\AcumaticaConfig\\StructType\\BilledTransactions',
            'UnbilledTransactions' => '\\AcumaticaConfig\\StructType\\UnbilledTransactions',
            'CustomerByEmail' => '\\AcumaticaConfig\\StructType\\CustomerByEmail',
            'CustomerDetails' => '\\AcumaticaConfig\\StructType\\CustomerDetails',
            'FinancialPeriodDetail' => '\\AcumaticaConfig\\StructType\\FinancialPeriodDetail',
            'OrdersCount' => '\\AcumaticaConfig\\StructType\\OrdersCount',
            'OrdersResult' => '\\AcumaticaConfig\\StructType\\OrdersResult',
            'AccountBySubaccountInquiry' => '\\AcumaticaConfig\\StructType\\AccountBySubaccountInquiry',
            'ContractUsageTransactionDetail' => '\\AcumaticaConfig\\StructType\\ContractUsageTransactionDetail',
            'PhysicalInventoryReviewDetail' => '\\AcumaticaConfig\\StructType\\PhysicalInventoryReviewDetail',
            'CategoryResult' => '\\AcumaticaConfig\\StructType\\CategoryResult',
            'StockItemVendorDetail' => '\\AcumaticaConfig\\StructType\\StockItemVendorDetail',
            'Invoice' => '\\AcumaticaConfig\\StructType\\Invoice',
            'ApplicationsCreditMemo' => '\\AcumaticaConfig\\StructType\\ApplicationsCreditMemo',
            'ApplicationsDefault' => '\\AcumaticaConfig\\StructType\\ApplicationsDefault',
            'CustomerTerms' => '\\AcumaticaConfig\\StructType\\CustomerTerms',
            'DiscountCustomerPriceClassesDetail' => '\\AcumaticaConfig\\StructType\\DiscountCustomerPriceClassesDetail',
            'BusinessAccountPaymentInstructionDetail' => '\\AcumaticaConfig\\StructType\\BusinessAccountPaymentInstructionDetail',
            'Account' => '\\AcumaticaConfig\\StructType\\Account',
            'Discount' => '\\AcumaticaConfig\\StructType\\Discount',
            'CustomerPriceClasses' => '\\AcumaticaConfig\\StructType\\CustomerPriceClasses',
            'Customers' => '\\AcumaticaConfig\\StructType\\Customers',
            'DiscountBreakpoints' => '\\AcumaticaConfig\\StructType\\DiscountBreakpoints',
            'ItemPriceClasses' => '\\AcumaticaConfig\\StructType\\ItemPriceClasses',
            'Items' => '\\AcumaticaConfig\\StructType\\Items',
            'Warehouses' => '\\AcumaticaConfig\\StructType\\Warehouses',
            'CategoryCount' => '\\AcumaticaConfig\\StructType\\CategoryCount',
            'Contact' => '\\AcumaticaConfig\\StructType\\Contact',
            'Notifications' => '\\AcumaticaConfig\\StructType\\Notifications',
            'CategoryImages' => '\\AcumaticaConfig\\StructType\\CategoryImages',
            'CategoryImageResults' => '\\AcumaticaConfig\\StructType\\CategoryImageResults',
            'ProductUpSells' => '\\AcumaticaConfig\\StructType\\ProductUpSells',
            'Payment' => '\\AcumaticaConfig\\StructType\\Payment',
            'ApplicationHistory' => '\\AcumaticaConfig\\StructType\\ApplicationHistory',
            'CreditCardProcessingInfo' => '\\AcumaticaConfig\\StructType\\CreditCardProcessingInfo',
            'DocumentsToApply' => '\\AcumaticaConfig\\StructType\\DocumentsToApply',
            'OrdersToApply' => '\\AcumaticaConfig\\StructType\\OrdersToApply',
            'CheckDetail' => '\\AcumaticaConfig\\StructType\\CheckDetail',
            'BusinessAccountClassAttributeDetail' => '\\AcumaticaConfig\\StructType\\BusinessAccountClassAttributeDetail',
            'InventoryItemUOMConversion' => '\\AcumaticaConfig\\StructType\\InventoryItemUOMConversion',
            'AccountByPeriodRow' => '\\AcumaticaConfig\\StructType\\AccountByPeriodRow',
            'DiscountCustomerDetail' => '\\AcumaticaConfig\\StructType\\DiscountCustomerDetail',
            'TimeZone' => '\\AcumaticaConfig\\StructType\\TimeZone',
            'Shipment' => '\\AcumaticaConfig\\StructType\\Shipment',
            'Orders' => '\\AcumaticaConfig\\StructType\\Orders',
            'Packages' => '\\AcumaticaConfig\\StructType\\Packages',
            'ShipmentCount' => '\\AcumaticaConfig\\StructType\\ShipmentCount',
            'ShipmentResults' => '\\AcumaticaConfig\\StructType\\ShipmentResults',
            'JournalVoucherDetailARDocumentToApply' => '\\AcumaticaConfig\\StructType\\JournalVoucherDetailARDocumentToApply',
            'JournalVoucherGLTransaction' => '\\AcumaticaConfig\\StructType\\JournalVoucherGLTransaction',
            'BusinessAccount' => '\\AcumaticaConfig\\StructType\\BusinessAccount',
            'Contracts' => '\\AcumaticaConfig\\StructType\\Contracts',
            'Locations' => '\\AcumaticaConfig\\StructType\\Locations',
            'EventTimeActivity' => '\\AcumaticaConfig\\StructType\\EventTimeActivity',
            'DiscountWarehouseDetail' => '\\AcumaticaConfig\\StructType\\DiscountWarehouseDetail',
            'CustomerStatementCycle' => '\\AcumaticaConfig\\StructType\\CustomerStatementCycle',
            'BillDetail' => '\\AcumaticaConfig\\StructType\\BillDetail',
            'ProductCrossSells' => '\\AcumaticaConfig\\StructType\\ProductCrossSells',
            'CampaignDetail' => '\\AcumaticaConfig\\StructType\\CampaignDetail',
            'KitAssemblyStockComponentAllocation' => '\\AcumaticaConfig\\StructType\\KitAssemblyStockComponentAllocation',
            'ProductInventory' => '\\AcumaticaConfig\\StructType\\ProductInventory',
            'AccountSummaryInquiry' => '\\AcumaticaConfig\\StructType\\AccountSummaryInquiry',
            'CashSale' => '\\AcumaticaConfig\\StructType\\CashSale',
            'AccountSummaryRow' => '\\AcumaticaConfig\\StructType\\AccountSummaryRow',
            'OpportunityTaxDetail' => '\\AcumaticaConfig\\StructType\\OpportunityTaxDetail',
            'TransferOrderDetail' => '\\AcumaticaConfig\\StructType\\TransferOrderDetail',
            'TaxZoneApplicableTaxDetail' => '\\AcumaticaConfig\\StructType\\TaxZoneApplicableTaxDetail',
            'PaymentMethod' => '\\AcumaticaConfig\\StructType\\PaymentMethod',
            'AllowedCashAccounts' => '\\AcumaticaConfig\\StructType\\AllowedCashAccounts',
            'ProcessingCenters' => '\\AcumaticaConfig\\StructType\\ProcessingCenters',
            'TrialBalance' => '\\AcumaticaConfig\\StructType\\TrialBalance',
            'ItemSalesCategoryMember' => '\\AcumaticaConfig\\StructType\\ItemSalesCategoryMember',
            'CustomersDeletedRecords' => '\\AcumaticaConfig\\StructType\\CustomersDeletedRecords',
            'CustomersDeletedResults' => '\\AcumaticaConfig\\StructType\\CustomersDeletedResults',
            'ProjectTransactionDetail' => '\\AcumaticaConfig\\StructType\\ProjectTransactionDetail',
            'PurchaseReceiptDetailAllocation' => '\\AcumaticaConfig\\StructType\\PurchaseReceiptDetailAllocation',
            'VendorClass' => '\\AcumaticaConfig\\StructType\\VendorClass',
            'Check' => '\\AcumaticaConfig\\StructType\\Check',
            'History' => '\\AcumaticaConfig\\StructType\\History',
            'ShipToSettings' => '\\AcumaticaConfig\\StructType\\ShipToSettings',
            'PaymentMethodProcessingCenterDetail' => '\\AcumaticaConfig\\StructType\\PaymentMethodProcessingCenterDetail',
            'ContactDuplicateDetail' => '\\AcumaticaConfig\\StructType\\ContactDuplicateDetail',
            'SalesPriceDetail' => '\\AcumaticaConfig\\StructType\\SalesPriceDetail',
            'BusinessAccountContract' => '\\AcumaticaConfig\\StructType\\BusinessAccountContract',
            'ShopForRates' => '\\AcumaticaConfig\\StructType\\ShopForRates',
            'FinancialYearPeriodDetail' => '\\AcumaticaConfig\\StructType\\FinancialYearPeriodDetail',
            'InvoiceApplicationsCreditMemo' => '\\AcumaticaConfig\\StructType\\InvoiceApplicationsCreditMemo',
            'AccountByPeriodInquiry' => '\\AcumaticaConfig\\StructType\\AccountByPeriodInquiry',
            'ShippingZones' => '\\AcumaticaConfig\\StructType\\ShippingZones',
            'KitAssembly' => '\\AcumaticaConfig\\StructType\\KitAssembly',
            'StockItemImagesByID' => '\\AcumaticaConfig\\StructType\\StockItemImagesByID',
            'StokItemImageResults' => '\\AcumaticaConfig\\StructType\\StokItemImageResults',
            'SalesOrdersDiscountDetails' => '\\AcumaticaConfig\\StructType\\SalesOrdersDiscountDetails',
            'PaymentApplicationHistoryDetail' => '\\AcumaticaConfig\\StructType\\PaymentApplicationHistoryDetail',
            'ProductsDeletedResults' => '\\AcumaticaConfig\\StructType\\ProductsDeletedResults',
            'AccountLocationContact' => '\\AcumaticaConfig\\StructType\\AccountLocationContact',
            'DuplicateDetail' => '\\AcumaticaConfig\\StructType\\DuplicateDetail',
            'VendorPriceWorksheetDetail' => '\\AcumaticaConfig\\StructType\\VendorPriceWorksheetDetail',
            'PaymentOrderDetail' => '\\AcumaticaConfig\\StructType\\PaymentOrderDetail',
            'ShipVia' => '\\AcumaticaConfig\\StructType\\ShipVia',
            'FreightRates' => '\\AcumaticaConfig\\StructType\\FreightRates',
            'TaxZone' => '\\AcumaticaConfig\\StructType\\TaxZone',
            'ApplicableTaxes' => '\\AcumaticaConfig\\StructType\\ApplicableTaxes',
            'ProjectTransaction' => '\\AcumaticaConfig\\StructType\\ProjectTransaction',
            'KitNonStockComponent' => '\\AcumaticaConfig\\StructType\\KitNonStockComponent',
            'TransferOrder' => '\\AcumaticaConfig\\StructType\\TransferOrder',
            'AccountDetailsInquiry' => '\\AcumaticaConfig\\StructType\\AccountDetailsInquiry',
            'Bill' => '\\AcumaticaConfig\\StructType\\Bill',
            'Applications' => '\\AcumaticaConfig\\StructType\\Applications',
            'InterBranchAccountMapping' => '\\AcumaticaConfig\\StructType\\InterBranchAccountMapping',
            'TransactionsInDestinationBranch' => '\\AcumaticaConfig\\StructType\\TransactionsInDestinationBranch',
            'TransactionsInSourceBranch' => '\\AcumaticaConfig\\StructType\\TransactionsInSourceBranch',
            'BusinessAccountCaseDetail' => '\\AcumaticaConfig\\StructType\\BusinessAccountCaseDetail',
            'OpportunityContact' => '\\AcumaticaConfig\\StructType\\OpportunityContact',
            'BusinessAccountMarketingListDetail' => '\\AcumaticaConfig\\StructType\\BusinessAccountMarketingListDetail',
            'CategoryStockItem' => '\\AcumaticaConfig\\StructType\\CategoryStockItem',
            'AccountBySubaccountRow' => '\\AcumaticaConfig\\StructType\\AccountBySubaccountRow',
            'DropShipmet' => '\\AcumaticaConfig\\StructType\\DropShipmet',
            'ContactUserInfo' => '\\AcumaticaConfig\\StructType\\ContactUserInfo',
            'Roles' => '\\AcumaticaConfig\\StructType\\Roles',
            'BusinessAccountOpportunityDetail' => '\\AcumaticaConfig\\StructType\\BusinessAccountOpportunityDetail',
            'ProductCount' => '\\AcumaticaConfig\\StructType\\ProductCount',
            'ProductResult' => '\\AcumaticaConfig\\StructType\\ProductResult',
            'Subaccount' => '\\AcumaticaConfig\\StructType\\Subaccount',
            'NonStockItem' => '\\AcumaticaConfig\\StructType\\NonStockItem',
            'SalesCategories' => '\\AcumaticaConfig\\StructType\\SalesCategories',
            'PhysicalInventoryCountDetail' => '\\AcumaticaConfig\\StructType\\PhysicalInventoryCountDetail',
            'Carrier' => '\\AcumaticaConfig\\StructType\\Carrier',
            'CustomerAccounts' => '\\AcumaticaConfig\\StructType\\CustomerAccounts',
            'PlugInParameters' => '\\AcumaticaConfig\\StructType\\PlugInParameters',
            'InventorySummaryInquiry' => '\\AcumaticaConfig\\StructType\\InventorySummaryInquiry',
            'NonStockItemVendorDetail' => '\\AcumaticaConfig\\StructType\\NonStockItemVendorDetail',
            'VendorPriceDetail' => '\\AcumaticaConfig\\StructType\\VendorPriceDetail',
            'Tax' => '\\AcumaticaConfig\\StructType\\Tax',
            'TaxSchedule' => '\\AcumaticaConfig\\StructType\\TaxSchedule',
            'Zones' => '\\AcumaticaConfig\\StructType\\Zones',
            'InterBranchAccountMappingTransactionInDestinationBranchDetail' => '\\AcumaticaConfig\\StructType\\InterBranchAccountMappingTransactionInDestinationBranchDetail',
            'CustomerPaymentMethod' => '\\AcumaticaConfig\\StructType\\CustomerPaymentMethod',
            'PaymentMethodAllowedCashAccountDetail' => '\\AcumaticaConfig\\StructType\\PaymentMethodAllowedCashAccountDetail',
            'TaxDetail' => '\\AcumaticaConfig\\StructType\\TaxDetail',
            'ReportingSettings' => '\\AcumaticaConfig\\StructType\\ReportingSettings',
            'ReportingGroups' => '\\AcumaticaConfig\\StructType\\ReportingGroups',
            'Vendor' => '\\AcumaticaConfig\\StructType\\Vendor',
            'PhysicalInventoryReview' => '\\AcumaticaConfig\\StructType\\PhysicalInventoryReview',
            'ItemClass' => '\\AcumaticaConfig\\StructType\\ItemClass',
            'CashSaleDetail' => '\\AcumaticaConfig\\StructType\\CashSaleDetail',
            'Currency' => '\\AcumaticaConfig\\StructType\\Currency',
            'AdjustmentDetail' => '\\AcumaticaConfig\\StructType\\AdjustmentDetail',
            'InvoiceTaxDetail' => '\\AcumaticaConfig\\StructType\\InvoiceTaxDetail',
            'ProductsDeletedRecords' => '\\AcumaticaConfig\\StructType\\ProductsDeletedRecords',
            'ItemSalesCategory' => '\\AcumaticaConfig\\StructType\\ItemSalesCategory',
            'BusinessAccountShippingContact' => '\\AcumaticaConfig\\StructType\\BusinessAccountShippingContact',
            'CustomerLocation' => '\\AcumaticaConfig\\StructType\\CustomerLocation',
            'InventorySummaryRow' => '\\AcumaticaConfig\\StructType\\InventorySummaryRow',
            'BusinessAccountActivityDetail' => '\\AcumaticaConfig\\StructType\\BusinessAccountActivityDetail',
            'EmailTimeActivity' => '\\AcumaticaConfig\\StructType\\EmailTimeActivity',
            'TaxZoneDetail' => '\\AcumaticaConfig\\StructType\\TaxZoneDetail',
            'BusinessAccountMainContact' => '\\AcumaticaConfig\\StructType\\BusinessAccountMainContact',
            'InvoiceApplicationsDefault' => '\\AcumaticaConfig\\StructType\\InvoiceApplicationsDefault',
            'DiscountItemDetail' => '\\AcumaticaConfig\\StructType\\DiscountItemDetail',
            'InvoiceDetail' => '\\AcumaticaConfig\\StructType\\InvoiceDetail',
            'Case' => '\\AcumaticaConfig\\StructType\\_Case',
            'RelatedCases' => '\\AcumaticaConfig\\StructType\\RelatedCases',
            'MarketingListDetail' => '\\AcumaticaConfig\\StructType\\MarketingListDetail',
            'Warehouse' => '\\AcumaticaConfig\\StructType\\Warehouse',
            'InventoryReceiptDetail' => '\\AcumaticaConfig\\StructType\\InventoryReceiptDetail',
            'InventoryReceiptDetailAllocation' => '\\AcumaticaConfig\\StructType\\InventoryReceiptDetailAllocation',
            'JournalTransactionDetail' => '\\AcumaticaConfig\\StructType\\JournalTransactionDetail',
            'VendorPricesInquiry' => '\\AcumaticaConfig\\StructType\\VendorPricesInquiry',
            'VendorPriceDetails' => '\\AcumaticaConfig\\StructType\\VendorPriceDetails',
            'PurchaseReceipt' => '\\AcumaticaConfig\\StructType\\PurchaseReceipt',
            'CarrierCustomerAccount' => '\\AcumaticaConfig\\StructType\\CarrierCustomerAccount',
            'BusinessAccountContact' => '\\AcumaticaConfig\\StructType\\BusinessAccountContact',
            'SendEmail' => '\\AcumaticaConfig\\StructType\\SendEmail',
            'CreateContactEmail' => '\\AcumaticaConfig\\StructType\\CreateContactEmail',
            'CreateEventEmail' => '\\AcumaticaConfig\\StructType\\CreateEventEmail',
            'CreateLeadEmail' => '\\AcumaticaConfig\\StructType\\CreateLeadEmail',
            'CreateOpportunityEmail' => '\\AcumaticaConfig\\StructType\\CreateOpportunityEmail',
            'CreateExpenseReceiptEmail' => '\\AcumaticaConfig\\StructType\\CreateExpenseReceiptEmail',
            'CreateCaseEmail' => '\\AcumaticaConfig\\StructType\\CreateCaseEmail',
            'CreateTaskEmail' => '\\AcumaticaConfig\\StructType\\CreateTaskEmail',
            'RestoreDeletedEmail' => '\\AcumaticaConfig\\StructType\\RestoreDeletedEmail',
            'RestoreArchivedEmail' => '\\AcumaticaConfig\\StructType\\RestoreArchivedEmail',
            'ProcessEmail' => '\\AcumaticaConfig\\StructType\\ProcessEmail',
            'SelectSourceEmail' => '\\AcumaticaConfig\\StructType\\SelectSourceEmail',
            'DownloadEmlFileEmail' => '\\AcumaticaConfig\\StructType\\DownloadEmlFileEmail',
            'CancelSendingEmail' => '\\AcumaticaConfig\\StructType\\CancelSendingEmail',
            'ArchiveEmail' => '\\AcumaticaConfig\\StructType\\ArchiveEmail',
            'SelectRelatedEntityEmail' => '\\AcumaticaConfig\\StructType\\SelectRelatedEntityEmail',
            'AcceptInvitationEvent' => '\\AcumaticaConfig\\StructType\\AcceptInvitationEvent',
            'CancelActivityEvent' => '\\AcumaticaConfig\\StructType\\CancelActivityEvent',
            'CompleteEvent' => '\\AcumaticaConfig\\StructType\\CompleteEvent',
            'CompleteAndFollowUpEvent' => '\\AcumaticaConfig\\StructType\\CompleteAndFollowUpEvent',
            'ExportCardEvent' => '\\AcumaticaConfig\\StructType\\ExportCardEvent',
            'RejectInvitationEvent' => '\\AcumaticaConfig\\StructType\\RejectInvitationEvent',
            'InviteAllEvent' => '\\AcumaticaConfig\\StructType\\InviteAllEvent',
            'InviteEvent' => '\\AcumaticaConfig\\StructType\\InviteEvent',
            'SelectRelatedEntityEvent' => '\\AcumaticaConfig\\StructType\\SelectRelatedEntityEvent',
            'ReleaseSalesPriceWorksheet' => '\\AcumaticaConfig\\StructType\\ReleaseSalesPriceWorksheet',
            'GeneratePeriods' => '\\AcumaticaConfig\\StructType\\GeneratePeriods',
            'UpdateStandardCostStockItem' => '\\AcumaticaConfig\\StructType\\UpdateStandardCostStockItem',
            'CancelSalesOrder' => '\\AcumaticaConfig\\StructType\\CancelSalesOrder',
            'ReopenSalesOrder' => '\\AcumaticaConfig\\StructType\\ReopenSalesOrder',
            'PrepareSalesInvoice' => '\\AcumaticaConfig\\StructType\\PrepareSalesInvoice',
            'ReleaseAdjustment' => '\\AcumaticaConfig\\StructType\\ReleaseAdjustment',
            'CompleteTask' => '\\AcumaticaConfig\\StructType\\CompleteTask',
            'CompleteAndFollowUpTask' => '\\AcumaticaConfig\\StructType\\CompleteAndFollowUpTask',
            'CancelActivityTask' => '\\AcumaticaConfig\\StructType\\CancelActivityTask',
            'SelectRelatedEntityTask' => '\\AcumaticaConfig\\StructType\\SelectRelatedEntityTask',
            'ReleaseJournalTransaction' => '\\AcumaticaConfig\\StructType\\ReleaseJournalTransaction',
            'ReleaseInventoryReceipt' => '\\AcumaticaConfig\\StructType\\ReleaseInventoryReceipt',
            'ReleaseVendorPriceWorksheet' => '\\AcumaticaConfig\\StructType\\ReleaseVendorPriceWorksheet',
            'ReleaseSalesInvoice' => '\\AcumaticaConfig\\StructType\\ReleaseSalesInvoice',
            'ReleaseJournalVoucher' => '\\AcumaticaConfig\\StructType\\ReleaseJournalVoucher',
            'ProcessEmailProcessing' => '\\AcumaticaConfig\\StructType\\ProcessEmailProcessing',
            'ProcessAllEmailProcessing' => '\\AcumaticaConfig\\StructType\\ProcessAllEmailProcessing',
            'CreateAccountFromOpportunity' => '\\AcumaticaConfig\\StructType\\CreateAccountFromOpportunity',
            'CreateContactFromOpportunity' => '\\AcumaticaConfig\\StructType\\CreateContactFromOpportunity',
            'CreateOpportunityInvoice' => '\\AcumaticaConfig\\StructType\\CreateOpportunityInvoice',
            'CreateOpportunitySalesOrder' => '\\AcumaticaConfig\\StructType\\CreateOpportunitySalesOrder',
            'CheckLeadForDuplicates' => '\\AcumaticaConfig\\StructType\\CheckLeadForDuplicates',
            'CloseLeadAsDuplicate' => '\\AcumaticaConfig\\StructType\\CloseLeadAsDuplicate',
            'ConvertLeadToBAccount' => '\\AcumaticaConfig\\StructType\\ConvertLeadToBAccount',
            'ConvertLeadToContact' => '\\AcumaticaConfig\\StructType\\ConvertLeadToContact',
            'ConvertLeadToOpportunity' => '\\AcumaticaConfig\\StructType\\ConvertLeadToOpportunity',
            'ValidateLeadAddress' => '\\AcumaticaConfig\\StructType\\ValidateLeadAddress',
            'MarkLeadAsValidated' => '\\AcumaticaConfig\\StructType\\MarkLeadAsValidated',
            'ReleaseInvoice' => '\\AcumaticaConfig\\StructType\\ReleaseInvoice',
            'ReverseInvoice' => '\\AcumaticaConfig\\StructType\\ReverseInvoice',
            'UpdateDiscounts' => '\\AcumaticaConfig\\StructType\\UpdateDiscounts',
            'CheckForContactDuplicates' => '\\AcumaticaConfig\\StructType\\CheckForContactDuplicates',
            'ConvertContactToBusinessAccount' => '\\AcumaticaConfig\\StructType\\ConvertContactToBusinessAccount',
            'CopyFromCompany' => '\\AcumaticaConfig\\StructType\\CopyFromCompany',
            'MarkContactAsValidated' => '\\AcumaticaConfig\\StructType\\MarkContactAsValidated',
            'ValidateContactAddress' => '\\AcumaticaConfig\\StructType\\ValidateContactAddress',
            'CloseContactAsDuplicate' => '\\AcumaticaConfig\\StructType\\CloseContactAsDuplicate',
            'CaptureCreditCardPayment' => '\\AcumaticaConfig\\StructType\\CaptureCreditCardPayment',
            'ReleasePayment' => '\\AcumaticaConfig\\StructType\\ReleasePayment',
            'VoidPayment' => '\\AcumaticaConfig\\StructType\\VoidPayment',
            'ConfirmShipment' => '\\AcumaticaConfig\\StructType\\ConfirmShipment',
            'CorrectShipment' => '\\AcumaticaConfig\\StructType\\CorrectShipment',
            'UpdateIN' => '\\AcumaticaConfig\\StructType\\UpdateIN',
            'ConvertBusinessAccountToCustomer' => '\\AcumaticaConfig\\StructType\\ConvertBusinessAccountToCustomer',
            'ConvertBusinessAccountToVendor' => '\\AcumaticaConfig\\StructType\\ConvertBusinessAccountToVendor',
            'MarkBusinessAccountAsValidated' => '\\AcumaticaConfig\\StructType\\MarkBusinessAccountAsValidated',
            'ValidateBusinessAccountAddresses' => '\\AcumaticaConfig\\StructType\\ValidateBusinessAccountAddresses',
            'ChangeBusinessAccountID' => '\\AcumaticaConfig\\StructType\\ChangeBusinessAccountID',
            'CheckForBusinessAccountDuplicates' => '\\AcumaticaConfig\\StructType\\CheckForBusinessAccountDuplicates',
            'ReleaseCashSale' => '\\AcumaticaConfig\\StructType\\ReleaseCashSale',
            'TrialBalanceProcess' => '\\AcumaticaConfig\\StructType\\TrialBalanceProcess',
            'TrialBalanceProcessAll' => '\\AcumaticaConfig\\StructType\\TrialBalanceProcessAll',
            'ReleaseTrialBalance' => '\\AcumaticaConfig\\StructType\\ReleaseTrialBalance',
            'ReleaseCheck' => '\\AcumaticaConfig\\StructType\\ReleaseCheck',
            'ReleaseKitAssembly' => '\\AcumaticaConfig\\StructType\\ReleaseKitAssembly',
            'ReleaseTransferOrder' => '\\AcumaticaConfig\\StructType\\ReleaseTransferOrder',
            'ReleaseBill' => '\\AcumaticaConfig\\StructType\\ReleaseBill',
            'ReverseBill' => '\\AcumaticaConfig\\StructType\\ReverseBill',
            'UpdateStandardCostNonStockItem' => '\\AcumaticaConfig\\StructType\\UpdateStandardCostNonStockItem',
            'CancelPhysicalInventory' => '\\AcumaticaConfig\\StructType\\CancelPhysicalInventory',
            'CompletePhysicalInventory' => '\\AcumaticaConfig\\StructType\\CompletePhysicalInventory',
            'FinishCountingPhysicalInventory' => '\\AcumaticaConfig\\StructType\\FinishCountingPhysicalInventory',
            'ReleaseCase' => '\\AcumaticaConfig\\StructType\\ReleaseCase',
            'TakeCase' => '\\AcumaticaConfig\\StructType\\TakeCase',
            'AssignCase' => '\\AcumaticaConfig\\StructType\\AssignCase',
            'ReleasePurchaseReceipt' => '\\AcumaticaConfig\\StructType\\ReleasePurchaseReceipt',
        );
    }
}
