<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Warehouses StructType
 * @subpackage Structs
 */
class Warehouses extends AbstractStructBase
{
    /**
     * The DiscountWarehouseDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DiscountWarehouseDetail[]
     */
    public $DiscountWarehouseDetail;
    /**
     * Constructor method for Warehouses
     * @uses Warehouses::setDiscountWarehouseDetail()
     * @param \AcumaticaConfig\StructType\DiscountWarehouseDetail[] $discountWarehouseDetail
     */
    public function __construct(array $discountWarehouseDetail = array())
    {
        $this
            ->setDiscountWarehouseDetail($discountWarehouseDetail);
    }
    /**
     * Get DiscountWarehouseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DiscountWarehouseDetail[]|null
     */
    public function getDiscountWarehouseDetail()
    {
        return isset($this->DiscountWarehouseDetail) ? $this->DiscountWarehouseDetail : null;
    }
    /**
     * Set DiscountWarehouseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\DiscountWarehouseDetail[] $discountWarehouseDetail
     * @return \AcumaticaConfig\StructType\Warehouses
     */
    public function setDiscountWarehouseDetail(array $discountWarehouseDetail = array())
    {
        foreach ($discountWarehouseDetail as $warehousesDiscountWarehouseDetailItem) {
            // validation for constraint: itemType
            if (!$warehousesDiscountWarehouseDetailItem instanceof \AcumaticaConfig\StructType\DiscountWarehouseDetail) {
                throw new \InvalidArgumentException(sprintf('The DiscountWarehouseDetail property can only contain items of \AcumaticaConfig\StructType\DiscountWarehouseDetail, "%s" given', is_object($warehousesDiscountWarehouseDetailItem) ? get_class($warehousesDiscountWarehouseDetailItem) : gettype($warehousesDiscountWarehouseDetailItem)), __LINE__);
            }
        }
        if (is_null($discountWarehouseDetail) || (is_array($discountWarehouseDetail) && empty($discountWarehouseDetail))) {
            unset($this->DiscountWarehouseDetail);
        } else {
            $this->DiscountWarehouseDetail = $discountWarehouseDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountWarehouseDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\DiscountWarehouseDetail $item
     * @return \AcumaticaConfig\StructType\Warehouses
     */
    public function addToDiscountWarehouseDetail(\AcumaticaConfig\StructType\DiscountWarehouseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\DiscountWarehouseDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountWarehouseDetail property can only contain items of \AcumaticaConfig\StructType\DiscountWarehouseDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DiscountWarehouseDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Warehouses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
