<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseLocation StructType
 * @subpackage Structs
 */
class WarehouseLocation extends Entity
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Active;
    /**
     * The AssemblyAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $AssemblyAllowed;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LocationID;
    /**
     * The PickPriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $PickPriority;
    /**
     * The ReceiptsAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ReceiptsAllowed;
    /**
     * The SalesAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SalesAllowed;
    /**
     * The TransfersAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $TransfersAllowed;
    /**
     * Constructor method for WarehouseLocation
     * @uses WarehouseLocation::setActive()
     * @uses WarehouseLocation::setAssemblyAllowed()
     * @uses WarehouseLocation::setDescription()
     * @uses WarehouseLocation::setLocationID()
     * @uses WarehouseLocation::setPickPriority()
     * @uses WarehouseLocation::setReceiptsAllowed()
     * @uses WarehouseLocation::setSalesAllowed()
     * @uses WarehouseLocation::setTransfersAllowed()
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @param \AcumaticaConfig\StructType\BooleanValue $assemblyAllowed
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $locationID
     * @param \AcumaticaConfig\StructType\ShortValue $pickPriority
     * @param \AcumaticaConfig\StructType\BooleanValue $receiptsAllowed
     * @param \AcumaticaConfig\StructType\BooleanValue $salesAllowed
     * @param \AcumaticaConfig\StructType\BooleanValue $transfersAllowed
     */
    public function __construct(\AcumaticaConfig\StructType\BooleanValue $active = null, \AcumaticaConfig\StructType\BooleanValue $assemblyAllowed = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $locationID = null, \AcumaticaConfig\StructType\ShortValue $pickPriority = null, \AcumaticaConfig\StructType\BooleanValue $receiptsAllowed = null, \AcumaticaConfig\StructType\BooleanValue $salesAllowed = null, \AcumaticaConfig\StructType\BooleanValue $transfersAllowed = null)
    {
        $this
            ->setActive($active)
            ->setAssemblyAllowed($assemblyAllowed)
            ->setDescription($description)
            ->setLocationID($locationID)
            ->setPickPriority($pickPriority)
            ->setReceiptsAllowed($receiptsAllowed)
            ->setSalesAllowed($salesAllowed)
            ->setTransfersAllowed($transfersAllowed);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public function setActive(\AcumaticaConfig\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get AssemblyAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getAssemblyAllowed()
    {
        return isset($this->AssemblyAllowed) ? $this->AssemblyAllowed : null;
    }
    /**
     * Set AssemblyAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $assemblyAllowed
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public function setAssemblyAllowed(\AcumaticaConfig\StructType\BooleanValue $assemblyAllowed = null)
    {
        if (is_null($assemblyAllowed) || (is_array($assemblyAllowed) && empty($assemblyAllowed))) {
            unset($this->AssemblyAllowed);
        } else {
            $this->AssemblyAllowed = $assemblyAllowed;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $locationID
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public function setLocationID(\AcumaticaConfig\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get PickPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getPickPriority()
    {
        return isset($this->PickPriority) ? $this->PickPriority : null;
    }
    /**
     * Set PickPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $pickPriority
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public function setPickPriority(\AcumaticaConfig\StructType\ShortValue $pickPriority = null)
    {
        if (is_null($pickPriority) || (is_array($pickPriority) && empty($pickPriority))) {
            unset($this->PickPriority);
        } else {
            $this->PickPriority = $pickPriority;
        }
        return $this;
    }
    /**
     * Get ReceiptsAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getReceiptsAllowed()
    {
        return isset($this->ReceiptsAllowed) ? $this->ReceiptsAllowed : null;
    }
    /**
     * Set ReceiptsAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $receiptsAllowed
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public function setReceiptsAllowed(\AcumaticaConfig\StructType\BooleanValue $receiptsAllowed = null)
    {
        if (is_null($receiptsAllowed) || (is_array($receiptsAllowed) && empty($receiptsAllowed))) {
            unset($this->ReceiptsAllowed);
        } else {
            $this->ReceiptsAllowed = $receiptsAllowed;
        }
        return $this;
    }
    /**
     * Get SalesAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSalesAllowed()
    {
        return isset($this->SalesAllowed) ? $this->SalesAllowed : null;
    }
    /**
     * Set SalesAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $salesAllowed
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public function setSalesAllowed(\AcumaticaConfig\StructType\BooleanValue $salesAllowed = null)
    {
        if (is_null($salesAllowed) || (is_array($salesAllowed) && empty($salesAllowed))) {
            unset($this->SalesAllowed);
        } else {
            $this->SalesAllowed = $salesAllowed;
        }
        return $this;
    }
    /**
     * Get TransfersAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getTransfersAllowed()
    {
        return isset($this->TransfersAllowed) ? $this->TransfersAllowed : null;
    }
    /**
     * Set TransfersAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $transfersAllowed
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public function setTransfersAllowed(\AcumaticaConfig\StructType\BooleanValue $transfersAllowed = null)
    {
        if (is_null($transfersAllowed) || (is_array($transfersAllowed) && empty($transfersAllowed))) {
            unset($this->TransfersAllowed);
        } else {
            $this->TransfersAllowed = $transfersAllowed;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\WarehouseLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
