<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseDetails StructType
 * @subpackage Structs
 */
class WarehouseDetails extends Entity
{
    /**
     * The StockItemWarehouseDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StockItemWarehouseDetail[]
     */
    public $StockItemWarehouseDetail;
    /**
     * The Default
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Default;
    /**
     * The QtyOnHand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $QtyOnHand;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Warehouse;
    /**
     * The WarehouseDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\WarehouseDetails[]
     */
    public $WarehouseDetails;
    /**
     * Constructor method for WarehouseDetails
     * @uses WarehouseDetails::setStockItemWarehouseDetail()
     * @uses WarehouseDetails::setDefault()
     * @uses WarehouseDetails::setQtyOnHand()
     * @uses WarehouseDetails::setWarehouse()
     * @uses WarehouseDetails::setWarehouseDetails()
     * @param \AcumaticaConfig\StructType\StockItemWarehouseDetail[] $stockItemWarehouseDetail
     * @param \AcumaticaConfig\StructType\BooleanValue $default
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyOnHand
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @param \AcumaticaConfig\StructType\WarehouseDetails[] $warehouseDetails
     */
    public function __construct(array $stockItemWarehouseDetail = array(), \AcumaticaConfig\StructType\BooleanValue $default = null, \AcumaticaConfig\StructType\DecimalValue $qtyOnHand = null, \AcumaticaConfig\StructType\StringValue $warehouse = null, array $warehouseDetails = array())
    {
        $this
            ->setStockItemWarehouseDetail($stockItemWarehouseDetail)
            ->setDefault($default)
            ->setQtyOnHand($qtyOnHand)
            ->setWarehouse($warehouse)
            ->setWarehouseDetails($warehouseDetails);
    }
    /**
     * Get StockItemWarehouseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StockItemWarehouseDetail[]|null
     */
    public function getStockItemWarehouseDetail()
    {
        return isset($this->StockItemWarehouseDetail) ? $this->StockItemWarehouseDetail : null;
    }
    /**
     * Set StockItemWarehouseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\StockItemWarehouseDetail[] $stockItemWarehouseDetail
     * @return \AcumaticaConfig\StructType\WarehouseDetails
     */
    public function setStockItemWarehouseDetail(array $stockItemWarehouseDetail = array())
    {
        foreach ($stockItemWarehouseDetail as $warehouseDetailsStockItemWarehouseDetailItem) {
            // validation for constraint: itemType
            if (!$warehouseDetailsStockItemWarehouseDetailItem instanceof \AcumaticaConfig\StructType\StockItemWarehouseDetail) {
                throw new \InvalidArgumentException(sprintf('The StockItemWarehouseDetail property can only contain items of \AcumaticaConfig\StructType\StockItemWarehouseDetail, "%s" given', is_object($warehouseDetailsStockItemWarehouseDetailItem) ? get_class($warehouseDetailsStockItemWarehouseDetailItem) : gettype($warehouseDetailsStockItemWarehouseDetailItem)), __LINE__);
            }
        }
        if (is_null($stockItemWarehouseDetail) || (is_array($stockItemWarehouseDetail) && empty($stockItemWarehouseDetail))) {
            unset($this->StockItemWarehouseDetail);
        } else {
            $this->StockItemWarehouseDetail = $stockItemWarehouseDetail;
        }
        return $this;
    }
    /**
     * Add item to StockItemWarehouseDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\StockItemWarehouseDetail $item
     * @return \AcumaticaConfig\StructType\WarehouseDetails
     */
    public function addToStockItemWarehouseDetail(\AcumaticaConfig\StructType\StockItemWarehouseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\StockItemWarehouseDetail) {
            throw new \InvalidArgumentException(sprintf('The StockItemWarehouseDetail property can only contain items of \AcumaticaConfig\StructType\StockItemWarehouseDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StockItemWarehouseDetail[] = $item;
        return $this;
    }
    /**
     * Get Default value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getDefault()
    {
        return isset($this->Default) ? $this->Default : null;
    }
    /**
     * Set Default value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $default
     * @return \AcumaticaConfig\StructType\WarehouseDetails
     */
    public function setDefault(\AcumaticaConfig\StructType\BooleanValue $default = null)
    {
        if (is_null($default) || (is_array($default) && empty($default))) {
            unset($this->Default);
        } else {
            $this->Default = $default;
        }
        return $this;
    }
    /**
     * Get QtyOnHand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQtyOnHand()
    {
        return isset($this->QtyOnHand) ? $this->QtyOnHand : null;
    }
    /**
     * Set QtyOnHand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyOnHand
     * @return \AcumaticaConfig\StructType\WarehouseDetails
     */
    public function setQtyOnHand(\AcumaticaConfig\StructType\DecimalValue $qtyOnHand = null)
    {
        if (is_null($qtyOnHand) || (is_array($qtyOnHand) && empty($qtyOnHand))) {
            unset($this->QtyOnHand);
        } else {
            $this->QtyOnHand = $qtyOnHand;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @return \AcumaticaConfig\StructType\WarehouseDetails
     */
    public function setWarehouse(\AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Get WarehouseDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\WarehouseDetails[]|null
     */
    public function getWarehouseDetails()
    {
        return isset($this->WarehouseDetails) ? $this->WarehouseDetails : null;
    }
    /**
     * Set WarehouseDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\WarehouseDetails[] $warehouseDetails
     * @return \AcumaticaConfig\StructType\WarehouseDetails
     */
    public function setWarehouseDetails(array $warehouseDetails = array())
    {
        foreach ($warehouseDetails as $warehouseDetailsWarehouseDetailsItem) {
            // validation for constraint: itemType
            if (!$warehouseDetailsWarehouseDetailsItem instanceof \AcumaticaConfig\StructType\WarehouseDetails) {
                throw new \InvalidArgumentException(sprintf('The WarehouseDetails property can only contain items of \AcumaticaConfig\StructType\WarehouseDetails, "%s" given', is_object($warehouseDetailsWarehouseDetailsItem) ? get_class($warehouseDetailsWarehouseDetailsItem) : gettype($warehouseDetailsWarehouseDetailsItem)), __LINE__);
            }
        }
        if (is_null($warehouseDetails) || (is_array($warehouseDetails) && empty($warehouseDetails))) {
            unset($this->WarehouseDetails);
        } else {
            $this->WarehouseDetails = $warehouseDetails;
        }
        return $this;
    }
    /**
     * Add item to WarehouseDetails value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\WarehouseDetails $item
     * @return \AcumaticaConfig\StructType\WarehouseDetails
     */
    public function addToWarehouseDetails(\AcumaticaConfig\StructType\WarehouseDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\WarehouseDetails) {
            throw new \InvalidArgumentException(sprintf('The WarehouseDetails property can only contain items of \AcumaticaConfig\StructType\WarehouseDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarehouseDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\WarehouseDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
