<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPricesInquiry StructType
 * @subpackage Structs
 */
class VendorPricesInquiry extends Entity
{
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ItemClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ProductManager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProductManager;
    /**
     * The ProductWorkgroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProductWorkgroup;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Vendor;
    /**
     * The VendorPriceDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\VendorPriceDetails
     */
    public $VendorPriceDetails;
    /**
     * Constructor method for VendorPricesInquiry
     * @uses VendorPricesInquiry::setInventoryID()
     * @uses VendorPricesInquiry::setItemClass()
     * @uses VendorPricesInquiry::setProductManager()
     * @uses VendorPricesInquiry::setProductWorkgroup()
     * @uses VendorPricesInquiry::setVendor()
     * @uses VendorPricesInquiry::setVendorPriceDetails()
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\StringValue $itemClass
     * @param \AcumaticaConfig\StructType\StringValue $productManager
     * @param \AcumaticaConfig\StructType\StringValue $productWorkgroup
     * @param \AcumaticaConfig\StructType\StringValue $vendor
     * @param \AcumaticaConfig\StructType\VendorPriceDetails $vendorPriceDetails
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\StringValue $itemClass = null, \AcumaticaConfig\StructType\StringValue $productManager = null, \AcumaticaConfig\StructType\StringValue $productWorkgroup = null, \AcumaticaConfig\StructType\StringValue $vendor = null, \AcumaticaConfig\StructType\VendorPriceDetails $vendorPriceDetails = null)
    {
        $this
            ->setInventoryID($inventoryID)
            ->setItemClass($itemClass)
            ->setProductManager($productManager)
            ->setProductWorkgroup($productWorkgroup)
            ->setVendor($vendor)
            ->setVendorPriceDetails($vendorPriceDetails);
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\VendorPricesInquiry
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $itemClass
     * @return \AcumaticaConfig\StructType\VendorPricesInquiry
     */
    public function setItemClass(\AcumaticaConfig\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ProductManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProductManager()
    {
        return isset($this->ProductManager) ? $this->ProductManager : null;
    }
    /**
     * Set ProductManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $productManager
     * @return \AcumaticaConfig\StructType\VendorPricesInquiry
     */
    public function setProductManager(\AcumaticaConfig\StructType\StringValue $productManager = null)
    {
        if (is_null($productManager) || (is_array($productManager) && empty($productManager))) {
            unset($this->ProductManager);
        } else {
            $this->ProductManager = $productManager;
        }
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProductWorkgroup()
    {
        return isset($this->ProductWorkgroup) ? $this->ProductWorkgroup : null;
    }
    /**
     * Set ProductWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $productWorkgroup
     * @return \AcumaticaConfig\StructType\VendorPricesInquiry
     */
    public function setProductWorkgroup(\AcumaticaConfig\StructType\StringValue $productWorkgroup = null)
    {
        if (is_null($productWorkgroup) || (is_array($productWorkgroup) && empty($productWorkgroup))) {
            unset($this->ProductWorkgroup);
        } else {
            $this->ProductWorkgroup = $productWorkgroup;
        }
        return $this;
    }
    /**
     * Get Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVendor()
    {
        return isset($this->Vendor) ? $this->Vendor : null;
    }
    /**
     * Set Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $vendor
     * @return \AcumaticaConfig\StructType\VendorPricesInquiry
     */
    public function setVendor(\AcumaticaConfig\StructType\StringValue $vendor = null)
    {
        if (is_null($vendor) || (is_array($vendor) && empty($vendor))) {
            unset($this->Vendor);
        } else {
            $this->Vendor = $vendor;
        }
        return $this;
    }
    /**
     * Get VendorPriceDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\VendorPriceDetails|null
     */
    public function getVendorPriceDetails()
    {
        return isset($this->VendorPriceDetails) ? $this->VendorPriceDetails : null;
    }
    /**
     * Set VendorPriceDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\VendorPriceDetails $vendorPriceDetails
     * @return \AcumaticaConfig\StructType\VendorPricesInquiry
     */
    public function setVendorPriceDetails(\AcumaticaConfig\StructType\VendorPriceDetails $vendorPriceDetails = null)
    {
        if (is_null($vendorPriceDetails) || (is_array($vendorPriceDetails) && empty($vendorPriceDetails))) {
            unset($this->VendorPriceDetails);
        } else {
            $this->VendorPriceDetails = $vendorPriceDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\VendorPricesInquiry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
