<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpSellsDetails StructType
 * @subpackage Structs
 */
class UpSellsDetails extends Entity
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The UpSellsDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\UpSellsDetails[]
     */
    public $UpSellsDetails;
    /**
     * Constructor method for UpSellsDetails
     * @uses UpSellsDetails::setDescription()
     * @uses UpSellsDetails::setInventoryID()
     * @uses UpSellsDetails::setUpSellsDetails()
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\UpSellsDetails[] $upSellsDetails
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, array $upSellsDetails = array())
    {
        $this
            ->setDescription($description)
            ->setInventoryID($inventoryID)
            ->setUpSellsDetails($upSellsDetails);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\UpSellsDetails
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\UpSellsDetails
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get UpSellsDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\UpSellsDetails[]|null
     */
    public function getUpSellsDetails()
    {
        return isset($this->UpSellsDetails) ? $this->UpSellsDetails : null;
    }
    /**
     * Set UpSellsDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\UpSellsDetails[] $upSellsDetails
     * @return \AcumaticaConfig\StructType\UpSellsDetails
     */
    public function setUpSellsDetails(array $upSellsDetails = array())
    {
        foreach ($upSellsDetails as $upSellsDetailsUpSellsDetailsItem) {
            // validation for constraint: itemType
            if (!$upSellsDetailsUpSellsDetailsItem instanceof \AcumaticaConfig\StructType\UpSellsDetails) {
                throw new \InvalidArgumentException(sprintf('The UpSellsDetails property can only contain items of \AcumaticaConfig\StructType\UpSellsDetails, "%s" given', is_object($upSellsDetailsUpSellsDetailsItem) ? get_class($upSellsDetailsUpSellsDetailsItem) : gettype($upSellsDetailsUpSellsDetailsItem)), __LINE__);
            }
        }
        if (is_null($upSellsDetails) || (is_array($upSellsDetails) && empty($upSellsDetails))) {
            unset($this->UpSellsDetails);
        } else {
            $this->UpSellsDetails = $upSellsDetails;
        }
        return $this;
    }
    /**
     * Add item to UpSellsDetails value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\UpSellsDetails $item
     * @return \AcumaticaConfig\StructType\UpSellsDetails
     */
    public function addToUpSellsDetails(\AcumaticaConfig\StructType\UpSellsDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\UpSellsDetails) {
            throw new \InvalidArgumentException(sprintf('The UpSellsDetails property can only contain items of \AcumaticaConfig\StructType\UpSellsDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UpSellsDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\UpSellsDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
