<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItem StructType
 * @subpackage Structs
 */
class StockItem extends Entity
{
    /**
     * The ABCCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ABCCode;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Active;
    /**
     * The AlternateSearchKeywords
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AlternateSearchKeywords;
    /**
     * The Attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Attributes
     */
    public $Attributes;
    /**
     * The AutoIncrementalValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AutoIncrementalValue;
    /**
     * The AverageCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $AverageCost;
    /**
     * The BaseInventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $BaseInventoryID;
    /**
     * The BaseUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $BaseUOM;
    /**
     * The BestSeller
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BestSeller;
    /**
     * The Boxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Boxes
     */
    public $Boxes;
    /**
     * The Categories
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Categories
     */
    public $Categories;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CategoryID;
    /**
     * The COGSAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $COGSAccount;
    /**
     * The COGSSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $COGSSubaccount;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Content;
    /**
     * The CrossReferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CrossReferences
     */
    public $CrossReferences;
    /**
     * The CrossSellID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CrossSellID;
    /**
     * The CrossSells
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CrossSells
     */
    public $CrossSells;
    /**
     * The CurrentStdCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CurrentStdCost;
    /**
     * The DefaultIssueLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultIssueLocationID;
    /**
     * The DefaultPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DefaultPrice;
    /**
     * The DefaultReceiptLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultReceiptLocationID;
    /**
     * The DefaultSubitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultSubitem;
    /**
     * The DefaultWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultWarehouseID;
    /**
     * The DeferralAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DeferralAccount;
    /**
     * The DeferralSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DeferralSubaccount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The DescriptionLong
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DescriptionLong;
    /**
     * The DescriptionShort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DescriptionShort;
    /**
     * The DimensionVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DimensionVolume;
    /**
     * The DimensionWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DimensionWeight;
    /**
     * The DiscountAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountAccount;
    /**
     * The DiscountSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountSubaccount;
    /**
     * The HomePage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $HomePage;
    /**
     * The ImageUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ImageUrl;
    /**
     * The InventoryAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryAccount;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The InventorySubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventorySubaccount;
    /**
     * The IsAKit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IsAKit;
    /**
     * The ItemClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ItemStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ItemStatus;
    /**
     * The ItemType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ItemType;
    /**
     * The LandedCostVarianceAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LandedCostVarianceAccount;
    /**
     * The LandedCostVarianceSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LandedCostVarianceSubaccount;
    /**
     * The LastCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $LastCost;
    /**
     * The LastModified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModified;
    /**
     * The LastStdCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $LastStdCost;
    /**
     * The LotSerialClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LotSerialClass;
    /**
     * The Markup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Markup;
    /**
     * The MaxCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MaxCost;
    /**
     * The MetaDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MetaDescription;
    /**
     * The MetaKeywords
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MetaKeywords;
    /**
     * The MetaTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MetaTitle;
    /**
     * The MinCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MinCost;
    /**
     * The MinMarkup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MinMarkup;
    /**
     * The MSRP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MSRP;
    /**
     * The PackagingOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PackagingOption;
    /**
     * The PackSeparately
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $PackSeparately;
    /**
     * The PendingStdCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $PendingStdCost;
    /**
     * The POAccrualAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $POAccrualAccount;
    /**
     * The POAccrualSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $POAccrualSubaccount;
    /**
     * The PostingClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PostingClass;
    /**
     * The PriceClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PriceClass;
    /**
     * The PriceManager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PriceManager;
    /**
     * The PriceWorkgroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PriceWorkgroup;
    /**
     * The ProductManager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProductManager;
    /**
     * The ProductWorkgroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProductWorkgroup;
    /**
     * The PurchasePriceVarianceAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PurchasePriceVarianceAccount;
    /**
     * The PurchasePriceVarianceSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PurchasePriceVarianceSubaccount;
    /**
     * The PurchaseUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PurchaseUOM;
    /**
     * The ReasonCodeSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReasonCodeSubaccount;
    /**
     * The ReplenishmentParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ReplenishmentParameters
     */
    public $ReplenishmentParameters;
    /**
     * The SalesAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The SalesUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesUOM;
    /**
     * The StandardCostRevaluationAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StandardCostRevaluationAccount;
    /**
     * The StandardCostRevaluationSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StandardCostRevaluationSubaccount;
    /**
     * The StandardCostVarianceAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StandardCostVarianceAccount;
    /**
     * The StandardCostVarianceSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StandardCostVarianceSubaccount;
    /**
     * The SubItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SubItems
     */
    public $SubItems;
    /**
     * The SubjectToCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SubjectToCommission;
    /**
     * The TaxCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The UOMConversions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\UOMConversions
     */
    public $UOMConversions;
    /**
     * The UpSellID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $UpSellID;
    /**
     * The UpSells
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\UpSells
     */
    public $UpSells;
    /**
     * The URLKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $URLKey;
    /**
     * The UseOnEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $UseOnEntry;
    /**
     * The ValuationMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ValuationMethod;
    /**
     * The VendorDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\VendorDetails
     */
    public $VendorDetails;
    /**
     * The Visibility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Visibility;
    /**
     * The Volume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Volume;
    /**
     * The VolumeUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $VolumeUOM;
    /**
     * The WarehouseDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\WarehouseDetails
     */
    public $WarehouseDetails;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Weight;
    /**
     * The WeightUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WeightUOM;
    /**
     * Constructor method for StockItem
     * @uses StockItem::setABCCode()
     * @uses StockItem::setActive()
     * @uses StockItem::setAlternateSearchKeywords()
     * @uses StockItem::setAttributes()
     * @uses StockItem::setAutoIncrementalValue()
     * @uses StockItem::setAverageCost()
     * @uses StockItem::setBaseInventoryID()
     * @uses StockItem::setBaseUOM()
     * @uses StockItem::setBestSeller()
     * @uses StockItem::setBoxes()
     * @uses StockItem::setCategories()
     * @uses StockItem::setCategoryID()
     * @uses StockItem::setCOGSAccount()
     * @uses StockItem::setCOGSSubaccount()
     * @uses StockItem::setContent()
     * @uses StockItem::setCrossReferences()
     * @uses StockItem::setCrossSellID()
     * @uses StockItem::setCrossSells()
     * @uses StockItem::setCurrentStdCost()
     * @uses StockItem::setDefaultIssueLocationID()
     * @uses StockItem::setDefaultPrice()
     * @uses StockItem::setDefaultReceiptLocationID()
     * @uses StockItem::setDefaultSubitem()
     * @uses StockItem::setDefaultWarehouseID()
     * @uses StockItem::setDeferralAccount()
     * @uses StockItem::setDeferralSubaccount()
     * @uses StockItem::setDescription()
     * @uses StockItem::setDescriptionLong()
     * @uses StockItem::setDescriptionShort()
     * @uses StockItem::setDimensionVolume()
     * @uses StockItem::setDimensionWeight()
     * @uses StockItem::setDiscountAccount()
     * @uses StockItem::setDiscountSubaccount()
     * @uses StockItem::setHomePage()
     * @uses StockItem::setImageUrl()
     * @uses StockItem::setInventoryAccount()
     * @uses StockItem::setInventoryID()
     * @uses StockItem::setInventorySubaccount()
     * @uses StockItem::setIsAKit()
     * @uses StockItem::setItemClass()
     * @uses StockItem::setItemStatus()
     * @uses StockItem::setItemType()
     * @uses StockItem::setLandedCostVarianceAccount()
     * @uses StockItem::setLandedCostVarianceSubaccount()
     * @uses StockItem::setLastCost()
     * @uses StockItem::setLastModified()
     * @uses StockItem::setLastStdCost()
     * @uses StockItem::setLotSerialClass()
     * @uses StockItem::setMarkup()
     * @uses StockItem::setMaxCost()
     * @uses StockItem::setMetaDescription()
     * @uses StockItem::setMetaKeywords()
     * @uses StockItem::setMetaTitle()
     * @uses StockItem::setMinCost()
     * @uses StockItem::setMinMarkup()
     * @uses StockItem::setMSRP()
     * @uses StockItem::setPackagingOption()
     * @uses StockItem::setPackSeparately()
     * @uses StockItem::setPendingStdCost()
     * @uses StockItem::setPOAccrualAccount()
     * @uses StockItem::setPOAccrualSubaccount()
     * @uses StockItem::setPostingClass()
     * @uses StockItem::setPriceClass()
     * @uses StockItem::setPriceManager()
     * @uses StockItem::setPriceWorkgroup()
     * @uses StockItem::setProductManager()
     * @uses StockItem::setProductWorkgroup()
     * @uses StockItem::setPurchasePriceVarianceAccount()
     * @uses StockItem::setPurchasePriceVarianceSubaccount()
     * @uses StockItem::setPurchaseUOM()
     * @uses StockItem::setReasonCodeSubaccount()
     * @uses StockItem::setReplenishmentParameters()
     * @uses StockItem::setSalesAccount()
     * @uses StockItem::setSalesSubaccount()
     * @uses StockItem::setSalesUOM()
     * @uses StockItem::setStandardCostRevaluationAccount()
     * @uses StockItem::setStandardCostRevaluationSubaccount()
     * @uses StockItem::setStandardCostVarianceAccount()
     * @uses StockItem::setStandardCostVarianceSubaccount()
     * @uses StockItem::setSubItems()
     * @uses StockItem::setSubjectToCommission()
     * @uses StockItem::setTaxCategory()
     * @uses StockItem::setUOMConversions()
     * @uses StockItem::setUpSellID()
     * @uses StockItem::setUpSells()
     * @uses StockItem::setURLKey()
     * @uses StockItem::setUseOnEntry()
     * @uses StockItem::setValuationMethod()
     * @uses StockItem::setVendorDetails()
     * @uses StockItem::setVisibility()
     * @uses StockItem::setVolume()
     * @uses StockItem::setVolumeUOM()
     * @uses StockItem::setWarehouseDetails()
     * @uses StockItem::setWeight()
     * @uses StockItem::setWeightUOM()
     * @param \AcumaticaConfig\StructType\StringValue $aBCCode
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @param \AcumaticaConfig\StructType\StringValue $alternateSearchKeywords
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @param \AcumaticaConfig\StructType\StringValue $autoIncrementalValue
     * @param \AcumaticaConfig\StructType\DecimalValue $averageCost
     * @param \AcumaticaConfig\StructType\IntValue $baseInventoryID
     * @param \AcumaticaConfig\StructType\StringValue $baseUOM
     * @param \AcumaticaConfig\StructType\BooleanValue $bestSeller
     * @param \AcumaticaConfig\StructType\Boxes $boxes
     * @param \AcumaticaConfig\StructType\Categories $categories
     * @param \AcumaticaConfig\StructType\StringValue $categoryID
     * @param \AcumaticaConfig\StructType\StringValue $cOGSAccount
     * @param \AcumaticaConfig\StructType\StringValue $cOGSSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $content
     * @param \AcumaticaConfig\StructType\CrossReferences $crossReferences
     * @param \AcumaticaConfig\StructType\StringValue $crossSellID
     * @param \AcumaticaConfig\StructType\CrossSells $crossSells
     * @param \AcumaticaConfig\StructType\DecimalValue $currentStdCost
     * @param \AcumaticaConfig\StructType\StringValue $defaultIssueLocationID
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @param \AcumaticaConfig\StructType\StringValue $defaultReceiptLocationID
     * @param \AcumaticaConfig\StructType\StringValue $defaultSubitem
     * @param \AcumaticaConfig\StructType\StringValue $defaultWarehouseID
     * @param \AcumaticaConfig\StructType\StringValue $deferralAccount
     * @param \AcumaticaConfig\StructType\StringValue $deferralSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $descriptionLong
     * @param \AcumaticaConfig\StructType\StringValue $descriptionShort
     * @param \AcumaticaConfig\StructType\DecimalValue $dimensionVolume
     * @param \AcumaticaConfig\StructType\DecimalValue $dimensionWeight
     * @param \AcumaticaConfig\StructType\StringValue $discountAccount
     * @param \AcumaticaConfig\StructType\StringValue $discountSubaccount
     * @param \AcumaticaConfig\StructType\BooleanValue $homePage
     * @param \AcumaticaConfig\StructType\StringValue $imageUrl
     * @param \AcumaticaConfig\StructType\StringValue $inventoryAccount
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\StringValue $inventorySubaccount
     * @param \AcumaticaConfig\StructType\BooleanValue $isAKit
     * @param \AcumaticaConfig\StructType\StringValue $itemClass
     * @param \AcumaticaConfig\StructType\StringValue $itemStatus
     * @param \AcumaticaConfig\StructType\StringValue $itemType
     * @param \AcumaticaConfig\StructType\StringValue $landedCostVarianceAccount
     * @param \AcumaticaConfig\StructType\StringValue $landedCostVarianceSubaccount
     * @param \AcumaticaConfig\StructType\DecimalValue $lastCost
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModified
     * @param \AcumaticaConfig\StructType\DecimalValue $lastStdCost
     * @param \AcumaticaConfig\StructType\StringValue $lotSerialClass
     * @param \AcumaticaConfig\StructType\DecimalValue $markup
     * @param \AcumaticaConfig\StructType\DecimalValue $maxCost
     * @param \AcumaticaConfig\StructType\StringValue $metaDescription
     * @param \AcumaticaConfig\StructType\StringValue $metaKeywords
     * @param \AcumaticaConfig\StructType\StringValue $metaTitle
     * @param \AcumaticaConfig\StructType\DecimalValue $minCost
     * @param \AcumaticaConfig\StructType\DecimalValue $minMarkup
     * @param \AcumaticaConfig\StructType\DecimalValue $mSRP
     * @param \AcumaticaConfig\StructType\StringValue $packagingOption
     * @param \AcumaticaConfig\StructType\BooleanValue $packSeparately
     * @param \AcumaticaConfig\StructType\DecimalValue $pendingStdCost
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualAccount
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $postingClass
     * @param \AcumaticaConfig\StructType\StringValue $priceClass
     * @param \AcumaticaConfig\StructType\StringValue $priceManager
     * @param \AcumaticaConfig\StructType\StringValue $priceWorkgroup
     * @param \AcumaticaConfig\StructType\StringValue $productManager
     * @param \AcumaticaConfig\StructType\StringValue $productWorkgroup
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $purchaseUOM
     * @param \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount
     * @param \AcumaticaConfig\StructType\ReplenishmentParameters $replenishmentParameters
     * @param \AcumaticaConfig\StructType\StringValue $salesAccount
     * @param \AcumaticaConfig\StructType\StringValue $salesSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $salesUOM
     * @param \AcumaticaConfig\StructType\StringValue $standardCostRevaluationAccount
     * @param \AcumaticaConfig\StructType\StringValue $standardCostRevaluationSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $standardCostVarianceAccount
     * @param \AcumaticaConfig\StructType\StringValue $standardCostVarianceSubaccount
     * @param \AcumaticaConfig\StructType\SubItems $subItems
     * @param \AcumaticaConfig\StructType\BooleanValue $subjectToCommission
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @param \AcumaticaConfig\StructType\UOMConversions $uOMConversions
     * @param \AcumaticaConfig\StructType\StringValue $upSellID
     * @param \AcumaticaConfig\StructType\UpSells $upSells
     * @param \AcumaticaConfig\StructType\StringValue $uRLKey
     * @param \AcumaticaConfig\StructType\BooleanValue $useOnEntry
     * @param \AcumaticaConfig\StructType\StringValue $valuationMethod
     * @param \AcumaticaConfig\StructType\VendorDetails $vendorDetails
     * @param \AcumaticaConfig\StructType\StringValue $visibility
     * @param \AcumaticaConfig\StructType\DecimalValue $volume
     * @param \AcumaticaConfig\StructType\StringValue $volumeUOM
     * @param \AcumaticaConfig\StructType\WarehouseDetails $warehouseDetails
     * @param \AcumaticaConfig\StructType\DecimalValue $weight
     * @param \AcumaticaConfig\StructType\StringValue $weightUOM
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $aBCCode = null, \AcumaticaConfig\StructType\BooleanValue $active = null, \AcumaticaConfig\StructType\StringValue $alternateSearchKeywords = null, \AcumaticaConfig\StructType\Attributes $attributes = null, \AcumaticaConfig\StructType\StringValue $autoIncrementalValue = null, \AcumaticaConfig\StructType\DecimalValue $averageCost = null, \AcumaticaConfig\StructType\IntValue $baseInventoryID = null, \AcumaticaConfig\StructType\StringValue $baseUOM = null, \AcumaticaConfig\StructType\BooleanValue $bestSeller = null, \AcumaticaConfig\StructType\Boxes $boxes = null, \AcumaticaConfig\StructType\Categories $categories = null, \AcumaticaConfig\StructType\StringValue $categoryID = null, \AcumaticaConfig\StructType\StringValue $cOGSAccount = null, \AcumaticaConfig\StructType\StringValue $cOGSSubaccount = null, \AcumaticaConfig\StructType\StringValue $content = null, \AcumaticaConfig\StructType\CrossReferences $crossReferences = null, \AcumaticaConfig\StructType\StringValue $crossSellID = null, \AcumaticaConfig\StructType\CrossSells $crossSells = null, \AcumaticaConfig\StructType\DecimalValue $currentStdCost = null, \AcumaticaConfig\StructType\StringValue $defaultIssueLocationID = null, \AcumaticaConfig\StructType\DecimalValue $defaultPrice = null, \AcumaticaConfig\StructType\StringValue $defaultReceiptLocationID = null, \AcumaticaConfig\StructType\StringValue $defaultSubitem = null, \AcumaticaConfig\StructType\StringValue $defaultWarehouseID = null, \AcumaticaConfig\StructType\StringValue $deferralAccount = null, \AcumaticaConfig\StructType\StringValue $deferralSubaccount = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $descriptionLong = null, \AcumaticaConfig\StructType\StringValue $descriptionShort = null, \AcumaticaConfig\StructType\DecimalValue $dimensionVolume = null, \AcumaticaConfig\StructType\DecimalValue $dimensionWeight = null, \AcumaticaConfig\StructType\StringValue $discountAccount = null, \AcumaticaConfig\StructType\StringValue $discountSubaccount = null, \AcumaticaConfig\StructType\BooleanValue $homePage = null, \AcumaticaConfig\StructType\StringValue $imageUrl = null, \AcumaticaConfig\StructType\StringValue $inventoryAccount = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\StringValue $inventorySubaccount = null, \AcumaticaConfig\StructType\BooleanValue $isAKit = null, \AcumaticaConfig\StructType\StringValue $itemClass = null, \AcumaticaConfig\StructType\StringValue $itemStatus = null, \AcumaticaConfig\StructType\StringValue $itemType = null, \AcumaticaConfig\StructType\StringValue $landedCostVarianceAccount = null, \AcumaticaConfig\StructType\StringValue $landedCostVarianceSubaccount = null, \AcumaticaConfig\StructType\DecimalValue $lastCost = null, \AcumaticaConfig\StructType\DateTimeValue $lastModified = null, \AcumaticaConfig\StructType\DecimalValue $lastStdCost = null, \AcumaticaConfig\StructType\StringValue $lotSerialClass = null, \AcumaticaConfig\StructType\DecimalValue $markup = null, \AcumaticaConfig\StructType\DecimalValue $maxCost = null, \AcumaticaConfig\StructType\StringValue $metaDescription = null, \AcumaticaConfig\StructType\StringValue $metaKeywords = null, \AcumaticaConfig\StructType\StringValue $metaTitle = null, \AcumaticaConfig\StructType\DecimalValue $minCost = null, \AcumaticaConfig\StructType\DecimalValue $minMarkup = null, \AcumaticaConfig\StructType\DecimalValue $mSRP = null, \AcumaticaConfig\StructType\StringValue $packagingOption = null, \AcumaticaConfig\StructType\BooleanValue $packSeparately = null, \AcumaticaConfig\StructType\DecimalValue $pendingStdCost = null, \AcumaticaConfig\StructType\StringValue $pOAccrualAccount = null, \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount = null, \AcumaticaConfig\StructType\StringValue $postingClass = null, \AcumaticaConfig\StructType\StringValue $priceClass = null, \AcumaticaConfig\StructType\StringValue $priceManager = null, \AcumaticaConfig\StructType\StringValue $priceWorkgroup = null, \AcumaticaConfig\StructType\StringValue $productManager = null, \AcumaticaConfig\StructType\StringValue $productWorkgroup = null, \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount = null, \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount = null, \AcumaticaConfig\StructType\StringValue $purchaseUOM = null, \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount = null, \AcumaticaConfig\StructType\ReplenishmentParameters $replenishmentParameters = null, \AcumaticaConfig\StructType\StringValue $salesAccount = null, \AcumaticaConfig\StructType\StringValue $salesSubaccount = null, \AcumaticaConfig\StructType\StringValue $salesUOM = null, \AcumaticaConfig\StructType\StringValue $standardCostRevaluationAccount = null, \AcumaticaConfig\StructType\StringValue $standardCostRevaluationSubaccount = null, \AcumaticaConfig\StructType\StringValue $standardCostVarianceAccount = null, \AcumaticaConfig\StructType\StringValue $standardCostVarianceSubaccount = null, \AcumaticaConfig\StructType\SubItems $subItems = null, \AcumaticaConfig\StructType\BooleanValue $subjectToCommission = null, \AcumaticaConfig\StructType\StringValue $taxCategory = null, \AcumaticaConfig\StructType\UOMConversions $uOMConversions = null, \AcumaticaConfig\StructType\StringValue $upSellID = null, \AcumaticaConfig\StructType\UpSells $upSells = null, \AcumaticaConfig\StructType\StringValue $uRLKey = null, \AcumaticaConfig\StructType\BooleanValue $useOnEntry = null, \AcumaticaConfig\StructType\StringValue $valuationMethod = null, \AcumaticaConfig\StructType\VendorDetails $vendorDetails = null, \AcumaticaConfig\StructType\StringValue $visibility = null, \AcumaticaConfig\StructType\DecimalValue $volume = null, \AcumaticaConfig\StructType\StringValue $volumeUOM = null, \AcumaticaConfig\StructType\WarehouseDetails $warehouseDetails = null, \AcumaticaConfig\StructType\DecimalValue $weight = null, \AcumaticaConfig\StructType\StringValue $weightUOM = null)
    {
        $this
            ->setABCCode($aBCCode)
            ->setActive($active)
            ->setAlternateSearchKeywords($alternateSearchKeywords)
            ->setAttributes($attributes)
            ->setAutoIncrementalValue($autoIncrementalValue)
            ->setAverageCost($averageCost)
            ->setBaseInventoryID($baseInventoryID)
            ->setBaseUOM($baseUOM)
            ->setBestSeller($bestSeller)
            ->setBoxes($boxes)
            ->setCategories($categories)
            ->setCategoryID($categoryID)
            ->setCOGSAccount($cOGSAccount)
            ->setCOGSSubaccount($cOGSSubaccount)
            ->setContent($content)
            ->setCrossReferences($crossReferences)
            ->setCrossSellID($crossSellID)
            ->setCrossSells($crossSells)
            ->setCurrentStdCost($currentStdCost)
            ->setDefaultIssueLocationID($defaultIssueLocationID)
            ->setDefaultPrice($defaultPrice)
            ->setDefaultReceiptLocationID($defaultReceiptLocationID)
            ->setDefaultSubitem($defaultSubitem)
            ->setDefaultWarehouseID($defaultWarehouseID)
            ->setDeferralAccount($deferralAccount)
            ->setDeferralSubaccount($deferralSubaccount)
            ->setDescription($description)
            ->setDescriptionLong($descriptionLong)
            ->setDescriptionShort($descriptionShort)
            ->setDimensionVolume($dimensionVolume)
            ->setDimensionWeight($dimensionWeight)
            ->setDiscountAccount($discountAccount)
            ->setDiscountSubaccount($discountSubaccount)
            ->setHomePage($homePage)
            ->setImageUrl($imageUrl)
            ->setInventoryAccount($inventoryAccount)
            ->setInventoryID($inventoryID)
            ->setInventorySubaccount($inventorySubaccount)
            ->setIsAKit($isAKit)
            ->setItemClass($itemClass)
            ->setItemStatus($itemStatus)
            ->setItemType($itemType)
            ->setLandedCostVarianceAccount($landedCostVarianceAccount)
            ->setLandedCostVarianceSubaccount($landedCostVarianceSubaccount)
            ->setLastCost($lastCost)
            ->setLastModified($lastModified)
            ->setLastStdCost($lastStdCost)
            ->setLotSerialClass($lotSerialClass)
            ->setMarkup($markup)
            ->setMaxCost($maxCost)
            ->setMetaDescription($metaDescription)
            ->setMetaKeywords($metaKeywords)
            ->setMetaTitle($metaTitle)
            ->setMinCost($minCost)
            ->setMinMarkup($minMarkup)
            ->setMSRP($mSRP)
            ->setPackagingOption($packagingOption)
            ->setPackSeparately($packSeparately)
            ->setPendingStdCost($pendingStdCost)
            ->setPOAccrualAccount($pOAccrualAccount)
            ->setPOAccrualSubaccount($pOAccrualSubaccount)
            ->setPostingClass($postingClass)
            ->setPriceClass($priceClass)
            ->setPriceManager($priceManager)
            ->setPriceWorkgroup($priceWorkgroup)
            ->setProductManager($productManager)
            ->setProductWorkgroup($productWorkgroup)
            ->setPurchasePriceVarianceAccount($purchasePriceVarianceAccount)
            ->setPurchasePriceVarianceSubaccount($purchasePriceVarianceSubaccount)
            ->setPurchaseUOM($purchaseUOM)
            ->setReasonCodeSubaccount($reasonCodeSubaccount)
            ->setReplenishmentParameters($replenishmentParameters)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setSalesUOM($salesUOM)
            ->setStandardCostRevaluationAccount($standardCostRevaluationAccount)
            ->setStandardCostRevaluationSubaccount($standardCostRevaluationSubaccount)
            ->setStandardCostVarianceAccount($standardCostVarianceAccount)
            ->setStandardCostVarianceSubaccount($standardCostVarianceSubaccount)
            ->setSubItems($subItems)
            ->setSubjectToCommission($subjectToCommission)
            ->setTaxCategory($taxCategory)
            ->setUOMConversions($uOMConversions)
            ->setUpSellID($upSellID)
            ->setUpSells($upSells)
            ->setURLKey($uRLKey)
            ->setUseOnEntry($useOnEntry)
            ->setValuationMethod($valuationMethod)
            ->setVendorDetails($vendorDetails)
            ->setVisibility($visibility)
            ->setVolume($volume)
            ->setVolumeUOM($volumeUOM)
            ->setWarehouseDetails($warehouseDetails)
            ->setWeight($weight)
            ->setWeightUOM($weightUOM);
    }
    /**
     * Get ABCCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getABCCode()
    {
        return isset($this->ABCCode) ? $this->ABCCode : null;
    }
    /**
     * Set ABCCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $aBCCode
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setABCCode(\AcumaticaConfig\StructType\StringValue $aBCCode = null)
    {
        if (is_null($aBCCode) || (is_array($aBCCode) && empty($aBCCode))) {
            unset($this->ABCCode);
        } else {
            $this->ABCCode = $aBCCode;
        }
        return $this;
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setActive(\AcumaticaConfig\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get AlternateSearchKeywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAlternateSearchKeywords()
    {
        return isset($this->AlternateSearchKeywords) ? $this->AlternateSearchKeywords : null;
    }
    /**
     * Set AlternateSearchKeywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $alternateSearchKeywords
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setAlternateSearchKeywords(\AcumaticaConfig\StructType\StringValue $alternateSearchKeywords = null)
    {
        if (is_null($alternateSearchKeywords) || (is_array($alternateSearchKeywords) && empty($alternateSearchKeywords))) {
            unset($this->AlternateSearchKeywords);
        } else {
            $this->AlternateSearchKeywords = $alternateSearchKeywords;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setAttributes(\AcumaticaConfig\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get AutoIncrementalValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAutoIncrementalValue()
    {
        return isset($this->AutoIncrementalValue) ? $this->AutoIncrementalValue : null;
    }
    /**
     * Set AutoIncrementalValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $autoIncrementalValue
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setAutoIncrementalValue(\AcumaticaConfig\StructType\StringValue $autoIncrementalValue = null)
    {
        if (is_null($autoIncrementalValue) || (is_array($autoIncrementalValue) && empty($autoIncrementalValue))) {
            unset($this->AutoIncrementalValue);
        } else {
            $this->AutoIncrementalValue = $autoIncrementalValue;
        }
        return $this;
    }
    /**
     * Get AverageCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getAverageCost()
    {
        return isset($this->AverageCost) ? $this->AverageCost : null;
    }
    /**
     * Set AverageCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $averageCost
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setAverageCost(\AcumaticaConfig\StructType\DecimalValue $averageCost = null)
    {
        if (is_null($averageCost) || (is_array($averageCost) && empty($averageCost))) {
            unset($this->AverageCost);
        } else {
            $this->AverageCost = $averageCost;
        }
        return $this;
    }
    /**
     * Get BaseInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getBaseInventoryID()
    {
        return isset($this->BaseInventoryID) ? $this->BaseInventoryID : null;
    }
    /**
     * Set BaseInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $baseInventoryID
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setBaseInventoryID(\AcumaticaConfig\StructType\IntValue $baseInventoryID = null)
    {
        if (is_null($baseInventoryID) || (is_array($baseInventoryID) && empty($baseInventoryID))) {
            unset($this->BaseInventoryID);
        } else {
            $this->BaseInventoryID = $baseInventoryID;
        }
        return $this;
    }
    /**
     * Get BaseUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBaseUOM()
    {
        return isset($this->BaseUOM) ? $this->BaseUOM : null;
    }
    /**
     * Set BaseUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $baseUOM
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setBaseUOM(\AcumaticaConfig\StructType\StringValue $baseUOM = null)
    {
        if (is_null($baseUOM) || (is_array($baseUOM) && empty($baseUOM))) {
            unset($this->BaseUOM);
        } else {
            $this->BaseUOM = $baseUOM;
        }
        return $this;
    }
    /**
     * Get BestSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBestSeller()
    {
        return isset($this->BestSeller) ? $this->BestSeller : null;
    }
    /**
     * Set BestSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $bestSeller
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setBestSeller(\AcumaticaConfig\StructType\BooleanValue $bestSeller = null)
    {
        if (is_null($bestSeller) || (is_array($bestSeller) && empty($bestSeller))) {
            unset($this->BestSeller);
        } else {
            $this->BestSeller = $bestSeller;
        }
        return $this;
    }
    /**
     * Get Boxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Boxes|null
     */
    public function getBoxes()
    {
        return isset($this->Boxes) ? $this->Boxes : null;
    }
    /**
     * Set Boxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Boxes $boxes
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setBoxes(\AcumaticaConfig\StructType\Boxes $boxes = null)
    {
        if (is_null($boxes) || (is_array($boxes) && empty($boxes))) {
            unset($this->Boxes);
        } else {
            $this->Boxes = $boxes;
        }
        return $this;
    }
    /**
     * Get Categories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Categories|null
     */
    public function getCategories()
    {
        return isset($this->Categories) ? $this->Categories : null;
    }
    /**
     * Set Categories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Categories $categories
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setCategories(\AcumaticaConfig\StructType\Categories $categories = null)
    {
        if (is_null($categories) || (is_array($categories) && empty($categories))) {
            unset($this->Categories);
        } else {
            $this->Categories = $categories;
        }
        return $this;
    }
    /**
     * Get CategoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCategoryID()
    {
        return isset($this->CategoryID) ? $this->CategoryID : null;
    }
    /**
     * Set CategoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $categoryID
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setCategoryID(\AcumaticaConfig\StructType\StringValue $categoryID = null)
    {
        if (is_null($categoryID) || (is_array($categoryID) && empty($categoryID))) {
            unset($this->CategoryID);
        } else {
            $this->CategoryID = $categoryID;
        }
        return $this;
    }
    /**
     * Get COGSAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCOGSAccount()
    {
        return isset($this->COGSAccount) ? $this->COGSAccount : null;
    }
    /**
     * Set COGSAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $cOGSAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setCOGSAccount(\AcumaticaConfig\StructType\StringValue $cOGSAccount = null)
    {
        if (is_null($cOGSAccount) || (is_array($cOGSAccount) && empty($cOGSAccount))) {
            unset($this->COGSAccount);
        } else {
            $this->COGSAccount = $cOGSAccount;
        }
        return $this;
    }
    /**
     * Get COGSSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCOGSSubaccount()
    {
        return isset($this->COGSSubaccount) ? $this->COGSSubaccount : null;
    }
    /**
     * Set COGSSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $cOGSSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setCOGSSubaccount(\AcumaticaConfig\StructType\StringValue $cOGSSubaccount = null)
    {
        if (is_null($cOGSSubaccount) || (is_array($cOGSSubaccount) && empty($cOGSSubaccount))) {
            unset($this->COGSSubaccount);
        } else {
            $this->COGSSubaccount = $cOGSSubaccount;
        }
        return $this;
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $content
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setContent(\AcumaticaConfig\StructType\StringValue $content = null)
    {
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Get CrossReferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CrossReferences|null
     */
    public function getCrossReferences()
    {
        return isset($this->CrossReferences) ? $this->CrossReferences : null;
    }
    /**
     * Set CrossReferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\CrossReferences $crossReferences
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setCrossReferences(\AcumaticaConfig\StructType\CrossReferences $crossReferences = null)
    {
        if (is_null($crossReferences) || (is_array($crossReferences) && empty($crossReferences))) {
            unset($this->CrossReferences);
        } else {
            $this->CrossReferences = $crossReferences;
        }
        return $this;
    }
    /**
     * Get CrossSellID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCrossSellID()
    {
        return isset($this->CrossSellID) ? $this->CrossSellID : null;
    }
    /**
     * Set CrossSellID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $crossSellID
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setCrossSellID(\AcumaticaConfig\StructType\StringValue $crossSellID = null)
    {
        if (is_null($crossSellID) || (is_array($crossSellID) && empty($crossSellID))) {
            unset($this->CrossSellID);
        } else {
            $this->CrossSellID = $crossSellID;
        }
        return $this;
    }
    /**
     * Get CrossSells value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CrossSells|null
     */
    public function getCrossSells()
    {
        return isset($this->CrossSells) ? $this->CrossSells : null;
    }
    /**
     * Set CrossSells value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\CrossSells $crossSells
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setCrossSells(\AcumaticaConfig\StructType\CrossSells $crossSells = null)
    {
        if (is_null($crossSells) || (is_array($crossSells) && empty($crossSells))) {
            unset($this->CrossSells);
        } else {
            $this->CrossSells = $crossSells;
        }
        return $this;
    }
    /**
     * Get CurrentStdCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCurrentStdCost()
    {
        return isset($this->CurrentStdCost) ? $this->CurrentStdCost : null;
    }
    /**
     * Set CurrentStdCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $currentStdCost
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setCurrentStdCost(\AcumaticaConfig\StructType\DecimalValue $currentStdCost = null)
    {
        if (is_null($currentStdCost) || (is_array($currentStdCost) && empty($currentStdCost))) {
            unset($this->CurrentStdCost);
        } else {
            $this->CurrentStdCost = $currentStdCost;
        }
        return $this;
    }
    /**
     * Get DefaultIssueLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultIssueLocationID()
    {
        return isset($this->DefaultIssueLocationID) ? $this->DefaultIssueLocationID : null;
    }
    /**
     * Set DefaultIssueLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultIssueLocationID
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDefaultIssueLocationID(\AcumaticaConfig\StructType\StringValue $defaultIssueLocationID = null)
    {
        if (is_null($defaultIssueLocationID) || (is_array($defaultIssueLocationID) && empty($defaultIssueLocationID))) {
            unset($this->DefaultIssueLocationID);
        } else {
            $this->DefaultIssueLocationID = $defaultIssueLocationID;
        }
        return $this;
    }
    /**
     * Get DefaultPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDefaultPrice()
    {
        return isset($this->DefaultPrice) ? $this->DefaultPrice : null;
    }
    /**
     * Set DefaultPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDefaultPrice(\AcumaticaConfig\StructType\DecimalValue $defaultPrice = null)
    {
        if (is_null($defaultPrice) || (is_array($defaultPrice) && empty($defaultPrice))) {
            unset($this->DefaultPrice);
        } else {
            $this->DefaultPrice = $defaultPrice;
        }
        return $this;
    }
    /**
     * Get DefaultReceiptLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultReceiptLocationID()
    {
        return isset($this->DefaultReceiptLocationID) ? $this->DefaultReceiptLocationID : null;
    }
    /**
     * Set DefaultReceiptLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultReceiptLocationID
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDefaultReceiptLocationID(\AcumaticaConfig\StructType\StringValue $defaultReceiptLocationID = null)
    {
        if (is_null($defaultReceiptLocationID) || (is_array($defaultReceiptLocationID) && empty($defaultReceiptLocationID))) {
            unset($this->DefaultReceiptLocationID);
        } else {
            $this->DefaultReceiptLocationID = $defaultReceiptLocationID;
        }
        return $this;
    }
    /**
     * Get DefaultSubitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultSubitem()
    {
        return isset($this->DefaultSubitem) ? $this->DefaultSubitem : null;
    }
    /**
     * Set DefaultSubitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultSubitem
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDefaultSubitem(\AcumaticaConfig\StructType\StringValue $defaultSubitem = null)
    {
        if (is_null($defaultSubitem) || (is_array($defaultSubitem) && empty($defaultSubitem))) {
            unset($this->DefaultSubitem);
        } else {
            $this->DefaultSubitem = $defaultSubitem;
        }
        return $this;
    }
    /**
     * Get DefaultWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultWarehouseID()
    {
        return isset($this->DefaultWarehouseID) ? $this->DefaultWarehouseID : null;
    }
    /**
     * Set DefaultWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultWarehouseID
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDefaultWarehouseID(\AcumaticaConfig\StructType\StringValue $defaultWarehouseID = null)
    {
        if (is_null($defaultWarehouseID) || (is_array($defaultWarehouseID) && empty($defaultWarehouseID))) {
            unset($this->DefaultWarehouseID);
        } else {
            $this->DefaultWarehouseID = $defaultWarehouseID;
        }
        return $this;
    }
    /**
     * Get DeferralAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDeferralAccount()
    {
        return isset($this->DeferralAccount) ? $this->DeferralAccount : null;
    }
    /**
     * Set DeferralAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $deferralAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDeferralAccount(\AcumaticaConfig\StructType\StringValue $deferralAccount = null)
    {
        if (is_null($deferralAccount) || (is_array($deferralAccount) && empty($deferralAccount))) {
            unset($this->DeferralAccount);
        } else {
            $this->DeferralAccount = $deferralAccount;
        }
        return $this;
    }
    /**
     * Get DeferralSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDeferralSubaccount()
    {
        return isset($this->DeferralSubaccount) ? $this->DeferralSubaccount : null;
    }
    /**
     * Set DeferralSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $deferralSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDeferralSubaccount(\AcumaticaConfig\StructType\StringValue $deferralSubaccount = null)
    {
        if (is_null($deferralSubaccount) || (is_array($deferralSubaccount) && empty($deferralSubaccount))) {
            unset($this->DeferralSubaccount);
        } else {
            $this->DeferralSubaccount = $deferralSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DescriptionLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescriptionLong()
    {
        return isset($this->DescriptionLong) ? $this->DescriptionLong : null;
    }
    /**
     * Set DescriptionLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $descriptionLong
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDescriptionLong(\AcumaticaConfig\StructType\StringValue $descriptionLong = null)
    {
        if (is_null($descriptionLong) || (is_array($descriptionLong) && empty($descriptionLong))) {
            unset($this->DescriptionLong);
        } else {
            $this->DescriptionLong = $descriptionLong;
        }
        return $this;
    }
    /**
     * Get DescriptionShort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescriptionShort()
    {
        return isset($this->DescriptionShort) ? $this->DescriptionShort : null;
    }
    /**
     * Set DescriptionShort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $descriptionShort
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDescriptionShort(\AcumaticaConfig\StructType\StringValue $descriptionShort = null)
    {
        if (is_null($descriptionShort) || (is_array($descriptionShort) && empty($descriptionShort))) {
            unset($this->DescriptionShort);
        } else {
            $this->DescriptionShort = $descriptionShort;
        }
        return $this;
    }
    /**
     * Get DimensionVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDimensionVolume()
    {
        return isset($this->DimensionVolume) ? $this->DimensionVolume : null;
    }
    /**
     * Set DimensionVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $dimensionVolume
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDimensionVolume(\AcumaticaConfig\StructType\DecimalValue $dimensionVolume = null)
    {
        if (is_null($dimensionVolume) || (is_array($dimensionVolume) && empty($dimensionVolume))) {
            unset($this->DimensionVolume);
        } else {
            $this->DimensionVolume = $dimensionVolume;
        }
        return $this;
    }
    /**
     * Get DimensionWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDimensionWeight()
    {
        return isset($this->DimensionWeight) ? $this->DimensionWeight : null;
    }
    /**
     * Set DimensionWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $dimensionWeight
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDimensionWeight(\AcumaticaConfig\StructType\DecimalValue $dimensionWeight = null)
    {
        if (is_null($dimensionWeight) || (is_array($dimensionWeight) && empty($dimensionWeight))) {
            unset($this->DimensionWeight);
        } else {
            $this->DimensionWeight = $dimensionWeight;
        }
        return $this;
    }
    /**
     * Get DiscountAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountAccount()
    {
        return isset($this->DiscountAccount) ? $this->DiscountAccount : null;
    }
    /**
     * Set DiscountAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDiscountAccount(\AcumaticaConfig\StructType\StringValue $discountAccount = null)
    {
        if (is_null($discountAccount) || (is_array($discountAccount) && empty($discountAccount))) {
            unset($this->DiscountAccount);
        } else {
            $this->DiscountAccount = $discountAccount;
        }
        return $this;
    }
    /**
     * Get DiscountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountSubaccount()
    {
        return isset($this->DiscountSubaccount) ? $this->DiscountSubaccount : null;
    }
    /**
     * Set DiscountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setDiscountSubaccount(\AcumaticaConfig\StructType\StringValue $discountSubaccount = null)
    {
        if (is_null($discountSubaccount) || (is_array($discountSubaccount) && empty($discountSubaccount))) {
            unset($this->DiscountSubaccount);
        } else {
            $this->DiscountSubaccount = $discountSubaccount;
        }
        return $this;
    }
    /**
     * Get HomePage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getHomePage()
    {
        return isset($this->HomePage) ? $this->HomePage : null;
    }
    /**
     * Set HomePage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $homePage
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setHomePage(\AcumaticaConfig\StructType\BooleanValue $homePage = null)
    {
        if (is_null($homePage) || (is_array($homePage) && empty($homePage))) {
            unset($this->HomePage);
        } else {
            $this->HomePage = $homePage;
        }
        return $this;
    }
    /**
     * Get ImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getImageUrl()
    {
        return isset($this->ImageUrl) ? $this->ImageUrl : null;
    }
    /**
     * Set ImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $imageUrl
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setImageUrl(\AcumaticaConfig\StructType\StringValue $imageUrl = null)
    {
        if (is_null($imageUrl) || (is_array($imageUrl) && empty($imageUrl))) {
            unset($this->ImageUrl);
        } else {
            $this->ImageUrl = $imageUrl;
        }
        return $this;
    }
    /**
     * Get InventoryAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryAccount()
    {
        return isset($this->InventoryAccount) ? $this->InventoryAccount : null;
    }
    /**
     * Set InventoryAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setInventoryAccount(\AcumaticaConfig\StructType\StringValue $inventoryAccount = null)
    {
        if (is_null($inventoryAccount) || (is_array($inventoryAccount) && empty($inventoryAccount))) {
            unset($this->InventoryAccount);
        } else {
            $this->InventoryAccount = $inventoryAccount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get InventorySubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventorySubaccount()
    {
        return isset($this->InventorySubaccount) ? $this->InventorySubaccount : null;
    }
    /**
     * Set InventorySubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventorySubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setInventorySubaccount(\AcumaticaConfig\StructType\StringValue $inventorySubaccount = null)
    {
        if (is_null($inventorySubaccount) || (is_array($inventorySubaccount) && empty($inventorySubaccount))) {
            unset($this->InventorySubaccount);
        } else {
            $this->InventorySubaccount = $inventorySubaccount;
        }
        return $this;
    }
    /**
     * Get IsAKit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIsAKit()
    {
        return isset($this->IsAKit) ? $this->IsAKit : null;
    }
    /**
     * Set IsAKit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $isAKit
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setIsAKit(\AcumaticaConfig\StructType\BooleanValue $isAKit = null)
    {
        if (is_null($isAKit) || (is_array($isAKit) && empty($isAKit))) {
            unset($this->IsAKit);
        } else {
            $this->IsAKit = $isAKit;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $itemClass
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setItemClass(\AcumaticaConfig\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ItemStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getItemStatus()
    {
        return isset($this->ItemStatus) ? $this->ItemStatus : null;
    }
    /**
     * Set ItemStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $itemStatus
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setItemStatus(\AcumaticaConfig\StructType\StringValue $itemStatus = null)
    {
        if (is_null($itemStatus) || (is_array($itemStatus) && empty($itemStatus))) {
            unset($this->ItemStatus);
        } else {
            $this->ItemStatus = $itemStatus;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $itemType
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setItemType(\AcumaticaConfig\StructType\StringValue $itemType = null)
    {
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LandedCostVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLandedCostVarianceAccount()
    {
        return isset($this->LandedCostVarianceAccount) ? $this->LandedCostVarianceAccount : null;
    }
    /**
     * Set LandedCostVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $landedCostVarianceAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setLandedCostVarianceAccount(\AcumaticaConfig\StructType\StringValue $landedCostVarianceAccount = null)
    {
        if (is_null($landedCostVarianceAccount) || (is_array($landedCostVarianceAccount) && empty($landedCostVarianceAccount))) {
            unset($this->LandedCostVarianceAccount);
        } else {
            $this->LandedCostVarianceAccount = $landedCostVarianceAccount;
        }
        return $this;
    }
    /**
     * Get LandedCostVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLandedCostVarianceSubaccount()
    {
        return isset($this->LandedCostVarianceSubaccount) ? $this->LandedCostVarianceSubaccount : null;
    }
    /**
     * Set LandedCostVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $landedCostVarianceSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setLandedCostVarianceSubaccount(\AcumaticaConfig\StructType\StringValue $landedCostVarianceSubaccount = null)
    {
        if (is_null($landedCostVarianceSubaccount) || (is_array($landedCostVarianceSubaccount) && empty($landedCostVarianceSubaccount))) {
            unset($this->LandedCostVarianceSubaccount);
        } else {
            $this->LandedCostVarianceSubaccount = $landedCostVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get LastCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getLastCost()
    {
        return isset($this->LastCost) ? $this->LastCost : null;
    }
    /**
     * Set LastCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $lastCost
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setLastCost(\AcumaticaConfig\StructType\DecimalValue $lastCost = null)
    {
        if (is_null($lastCost) || (is_array($lastCost) && empty($lastCost))) {
            unset($this->LastCost);
        } else {
            $this->LastCost = $lastCost;
        }
        return $this;
    }
    /**
     * Get LastModified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModified()
    {
        return isset($this->LastModified) ? $this->LastModified : null;
    }
    /**
     * Set LastModified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModified
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setLastModified(\AcumaticaConfig\StructType\DateTimeValue $lastModified = null)
    {
        if (is_null($lastModified) || (is_array($lastModified) && empty($lastModified))) {
            unset($this->LastModified);
        } else {
            $this->LastModified = $lastModified;
        }
        return $this;
    }
    /**
     * Get LastStdCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getLastStdCost()
    {
        return isset($this->LastStdCost) ? $this->LastStdCost : null;
    }
    /**
     * Set LastStdCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $lastStdCost
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setLastStdCost(\AcumaticaConfig\StructType\DecimalValue $lastStdCost = null)
    {
        if (is_null($lastStdCost) || (is_array($lastStdCost) && empty($lastStdCost))) {
            unset($this->LastStdCost);
        } else {
            $this->LastStdCost = $lastStdCost;
        }
        return $this;
    }
    /**
     * Get LotSerialClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLotSerialClass()
    {
        return isset($this->LotSerialClass) ? $this->LotSerialClass : null;
    }
    /**
     * Set LotSerialClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $lotSerialClass
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setLotSerialClass(\AcumaticaConfig\StructType\StringValue $lotSerialClass = null)
    {
        if (is_null($lotSerialClass) || (is_array($lotSerialClass) && empty($lotSerialClass))) {
            unset($this->LotSerialClass);
        } else {
            $this->LotSerialClass = $lotSerialClass;
        }
        return $this;
    }
    /**
     * Get Markup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMarkup()
    {
        return isset($this->Markup) ? $this->Markup : null;
    }
    /**
     * Set Markup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $markup
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setMarkup(\AcumaticaConfig\StructType\DecimalValue $markup = null)
    {
        if (is_null($markup) || (is_array($markup) && empty($markup))) {
            unset($this->Markup);
        } else {
            $this->Markup = $markup;
        }
        return $this;
    }
    /**
     * Get MaxCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMaxCost()
    {
        return isset($this->MaxCost) ? $this->MaxCost : null;
    }
    /**
     * Set MaxCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $maxCost
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setMaxCost(\AcumaticaConfig\StructType\DecimalValue $maxCost = null)
    {
        if (is_null($maxCost) || (is_array($maxCost) && empty($maxCost))) {
            unset($this->MaxCost);
        } else {
            $this->MaxCost = $maxCost;
        }
        return $this;
    }
    /**
     * Get MetaDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMetaDescription()
    {
        return isset($this->MetaDescription) ? $this->MetaDescription : null;
    }
    /**
     * Set MetaDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $metaDescription
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setMetaDescription(\AcumaticaConfig\StructType\StringValue $metaDescription = null)
    {
        if (is_null($metaDescription) || (is_array($metaDescription) && empty($metaDescription))) {
            unset($this->MetaDescription);
        } else {
            $this->MetaDescription = $metaDescription;
        }
        return $this;
    }
    /**
     * Get MetaKeywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMetaKeywords()
    {
        return isset($this->MetaKeywords) ? $this->MetaKeywords : null;
    }
    /**
     * Set MetaKeywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $metaKeywords
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setMetaKeywords(\AcumaticaConfig\StructType\StringValue $metaKeywords = null)
    {
        if (is_null($metaKeywords) || (is_array($metaKeywords) && empty($metaKeywords))) {
            unset($this->MetaKeywords);
        } else {
            $this->MetaKeywords = $metaKeywords;
        }
        return $this;
    }
    /**
     * Get MetaTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMetaTitle()
    {
        return isset($this->MetaTitle) ? $this->MetaTitle : null;
    }
    /**
     * Set MetaTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $metaTitle
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setMetaTitle(\AcumaticaConfig\StructType\StringValue $metaTitle = null)
    {
        if (is_null($metaTitle) || (is_array($metaTitle) && empty($metaTitle))) {
            unset($this->MetaTitle);
        } else {
            $this->MetaTitle = $metaTitle;
        }
        return $this;
    }
    /**
     * Get MinCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMinCost()
    {
        return isset($this->MinCost) ? $this->MinCost : null;
    }
    /**
     * Set MinCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $minCost
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setMinCost(\AcumaticaConfig\StructType\DecimalValue $minCost = null)
    {
        if (is_null($minCost) || (is_array($minCost) && empty($minCost))) {
            unset($this->MinCost);
        } else {
            $this->MinCost = $minCost;
        }
        return $this;
    }
    /**
     * Get MinMarkup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMinMarkup()
    {
        return isset($this->MinMarkup) ? $this->MinMarkup : null;
    }
    /**
     * Set MinMarkup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $minMarkup
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setMinMarkup(\AcumaticaConfig\StructType\DecimalValue $minMarkup = null)
    {
        if (is_null($minMarkup) || (is_array($minMarkup) && empty($minMarkup))) {
            unset($this->MinMarkup);
        } else {
            $this->MinMarkup = $minMarkup;
        }
        return $this;
    }
    /**
     * Get MSRP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMSRP()
    {
        return isset($this->MSRP) ? $this->MSRP : null;
    }
    /**
     * Set MSRP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $mSRP
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setMSRP(\AcumaticaConfig\StructType\DecimalValue $mSRP = null)
    {
        if (is_null($mSRP) || (is_array($mSRP) && empty($mSRP))) {
            unset($this->MSRP);
        } else {
            $this->MSRP = $mSRP;
        }
        return $this;
    }
    /**
     * Get PackagingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPackagingOption()
    {
        return isset($this->PackagingOption) ? $this->PackagingOption : null;
    }
    /**
     * Set PackagingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $packagingOption
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPackagingOption(\AcumaticaConfig\StructType\StringValue $packagingOption = null)
    {
        if (is_null($packagingOption) || (is_array($packagingOption) && empty($packagingOption))) {
            unset($this->PackagingOption);
        } else {
            $this->PackagingOption = $packagingOption;
        }
        return $this;
    }
    /**
     * Get PackSeparately value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getPackSeparately()
    {
        return isset($this->PackSeparately) ? $this->PackSeparately : null;
    }
    /**
     * Set PackSeparately value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $packSeparately
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPackSeparately(\AcumaticaConfig\StructType\BooleanValue $packSeparately = null)
    {
        if (is_null($packSeparately) || (is_array($packSeparately) && empty($packSeparately))) {
            unset($this->PackSeparately);
        } else {
            $this->PackSeparately = $packSeparately;
        }
        return $this;
    }
    /**
     * Get PendingStdCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getPendingStdCost()
    {
        return isset($this->PendingStdCost) ? $this->PendingStdCost : null;
    }
    /**
     * Set PendingStdCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $pendingStdCost
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPendingStdCost(\AcumaticaConfig\StructType\DecimalValue $pendingStdCost = null)
    {
        if (is_null($pendingStdCost) || (is_array($pendingStdCost) && empty($pendingStdCost))) {
            unset($this->PendingStdCost);
        } else {
            $this->PendingStdCost = $pendingStdCost;
        }
        return $this;
    }
    /**
     * Get POAccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPOAccrualAccount()
    {
        return isset($this->POAccrualAccount) ? $this->POAccrualAccount : null;
    }
    /**
     * Set POAccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPOAccrualAccount(\AcumaticaConfig\StructType\StringValue $pOAccrualAccount = null)
    {
        if (is_null($pOAccrualAccount) || (is_array($pOAccrualAccount) && empty($pOAccrualAccount))) {
            unset($this->POAccrualAccount);
        } else {
            $this->POAccrualAccount = $pOAccrualAccount;
        }
        return $this;
    }
    /**
     * Get POAccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPOAccrualSubaccount()
    {
        return isset($this->POAccrualSubaccount) ? $this->POAccrualSubaccount : null;
    }
    /**
     * Set POAccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPOAccrualSubaccount(\AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount = null)
    {
        if (is_null($pOAccrualSubaccount) || (is_array($pOAccrualSubaccount) && empty($pOAccrualSubaccount))) {
            unset($this->POAccrualSubaccount);
        } else {
            $this->POAccrualSubaccount = $pOAccrualSubaccount;
        }
        return $this;
    }
    /**
     * Get PostingClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPostingClass()
    {
        return isset($this->PostingClass) ? $this->PostingClass : null;
    }
    /**
     * Set PostingClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $postingClass
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPostingClass(\AcumaticaConfig\StructType\StringValue $postingClass = null)
    {
        if (is_null($postingClass) || (is_array($postingClass) && empty($postingClass))) {
            unset($this->PostingClass);
        } else {
            $this->PostingClass = $postingClass;
        }
        return $this;
    }
    /**
     * Get PriceClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPriceClass()
    {
        return isset($this->PriceClass) ? $this->PriceClass : null;
    }
    /**
     * Set PriceClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $priceClass
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPriceClass(\AcumaticaConfig\StructType\StringValue $priceClass = null)
    {
        if (is_null($priceClass) || (is_array($priceClass) && empty($priceClass))) {
            unset($this->PriceClass);
        } else {
            $this->PriceClass = $priceClass;
        }
        return $this;
    }
    /**
     * Get PriceManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPriceManager()
    {
        return isset($this->PriceManager) ? $this->PriceManager : null;
    }
    /**
     * Set PriceManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $priceManager
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPriceManager(\AcumaticaConfig\StructType\StringValue $priceManager = null)
    {
        if (is_null($priceManager) || (is_array($priceManager) && empty($priceManager))) {
            unset($this->PriceManager);
        } else {
            $this->PriceManager = $priceManager;
        }
        return $this;
    }
    /**
     * Get PriceWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPriceWorkgroup()
    {
        return isset($this->PriceWorkgroup) ? $this->PriceWorkgroup : null;
    }
    /**
     * Set PriceWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $priceWorkgroup
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPriceWorkgroup(\AcumaticaConfig\StructType\StringValue $priceWorkgroup = null)
    {
        if (is_null($priceWorkgroup) || (is_array($priceWorkgroup) && empty($priceWorkgroup))) {
            unset($this->PriceWorkgroup);
        } else {
            $this->PriceWorkgroup = $priceWorkgroup;
        }
        return $this;
    }
    /**
     * Get ProductManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProductManager()
    {
        return isset($this->ProductManager) ? $this->ProductManager : null;
    }
    /**
     * Set ProductManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $productManager
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setProductManager(\AcumaticaConfig\StructType\StringValue $productManager = null)
    {
        if (is_null($productManager) || (is_array($productManager) && empty($productManager))) {
            unset($this->ProductManager);
        } else {
            $this->ProductManager = $productManager;
        }
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProductWorkgroup()
    {
        return isset($this->ProductWorkgroup) ? $this->ProductWorkgroup : null;
    }
    /**
     * Set ProductWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $productWorkgroup
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setProductWorkgroup(\AcumaticaConfig\StructType\StringValue $productWorkgroup = null)
    {
        if (is_null($productWorkgroup) || (is_array($productWorkgroup) && empty($productWorkgroup))) {
            unset($this->ProductWorkgroup);
        } else {
            $this->ProductWorkgroup = $productWorkgroup;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPurchasePriceVarianceAccount()
    {
        return isset($this->PurchasePriceVarianceAccount) ? $this->PurchasePriceVarianceAccount : null;
    }
    /**
     * Set PurchasePriceVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPurchasePriceVarianceAccount(\AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount = null)
    {
        if (is_null($purchasePriceVarianceAccount) || (is_array($purchasePriceVarianceAccount) && empty($purchasePriceVarianceAccount))) {
            unset($this->PurchasePriceVarianceAccount);
        } else {
            $this->PurchasePriceVarianceAccount = $purchasePriceVarianceAccount;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPurchasePriceVarianceSubaccount()
    {
        return isset($this->PurchasePriceVarianceSubaccount) ? $this->PurchasePriceVarianceSubaccount : null;
    }
    /**
     * Set PurchasePriceVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPurchasePriceVarianceSubaccount(\AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount = null)
    {
        if (is_null($purchasePriceVarianceSubaccount) || (is_array($purchasePriceVarianceSubaccount) && empty($purchasePriceVarianceSubaccount))) {
            unset($this->PurchasePriceVarianceSubaccount);
        } else {
            $this->PurchasePriceVarianceSubaccount = $purchasePriceVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get PurchaseUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPurchaseUOM()
    {
        return isset($this->PurchaseUOM) ? $this->PurchaseUOM : null;
    }
    /**
     * Set PurchaseUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $purchaseUOM
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setPurchaseUOM(\AcumaticaConfig\StructType\StringValue $purchaseUOM = null)
    {
        if (is_null($purchaseUOM) || (is_array($purchaseUOM) && empty($purchaseUOM))) {
            unset($this->PurchaseUOM);
        } else {
            $this->PurchaseUOM = $purchaseUOM;
        }
        return $this;
    }
    /**
     * Get ReasonCodeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReasonCodeSubaccount()
    {
        return isset($this->ReasonCodeSubaccount) ? $this->ReasonCodeSubaccount : null;
    }
    /**
     * Set ReasonCodeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setReasonCodeSubaccount(\AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount = null)
    {
        if (is_null($reasonCodeSubaccount) || (is_array($reasonCodeSubaccount) && empty($reasonCodeSubaccount))) {
            unset($this->ReasonCodeSubaccount);
        } else {
            $this->ReasonCodeSubaccount = $reasonCodeSubaccount;
        }
        return $this;
    }
    /**
     * Get ReplenishmentParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ReplenishmentParameters|null
     */
    public function getReplenishmentParameters()
    {
        return isset($this->ReplenishmentParameters) ? $this->ReplenishmentParameters : null;
    }
    /**
     * Set ReplenishmentParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ReplenishmentParameters $replenishmentParameters
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setReplenishmentParameters(\AcumaticaConfig\StructType\ReplenishmentParameters $replenishmentParameters = null)
    {
        if (is_null($replenishmentParameters) || (is_array($replenishmentParameters) && empty($replenishmentParameters))) {
            unset($this->ReplenishmentParameters);
        } else {
            $this->ReplenishmentParameters = $replenishmentParameters;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setSalesAccount(\AcumaticaConfig\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setSalesSubaccount(\AcumaticaConfig\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get SalesUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesUOM()
    {
        return isset($this->SalesUOM) ? $this->SalesUOM : null;
    }
    /**
     * Set SalesUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesUOM
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setSalesUOM(\AcumaticaConfig\StructType\StringValue $salesUOM = null)
    {
        if (is_null($salesUOM) || (is_array($salesUOM) && empty($salesUOM))) {
            unset($this->SalesUOM);
        } else {
            $this->SalesUOM = $salesUOM;
        }
        return $this;
    }
    /**
     * Get StandardCostRevaluationAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStandardCostRevaluationAccount()
    {
        return isset($this->StandardCostRevaluationAccount) ? $this->StandardCostRevaluationAccount : null;
    }
    /**
     * Set StandardCostRevaluationAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $standardCostRevaluationAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setStandardCostRevaluationAccount(\AcumaticaConfig\StructType\StringValue $standardCostRevaluationAccount = null)
    {
        if (is_null($standardCostRevaluationAccount) || (is_array($standardCostRevaluationAccount) && empty($standardCostRevaluationAccount))) {
            unset($this->StandardCostRevaluationAccount);
        } else {
            $this->StandardCostRevaluationAccount = $standardCostRevaluationAccount;
        }
        return $this;
    }
    /**
     * Get StandardCostRevaluationSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStandardCostRevaluationSubaccount()
    {
        return isset($this->StandardCostRevaluationSubaccount) ? $this->StandardCostRevaluationSubaccount : null;
    }
    /**
     * Set StandardCostRevaluationSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $standardCostRevaluationSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setStandardCostRevaluationSubaccount(\AcumaticaConfig\StructType\StringValue $standardCostRevaluationSubaccount = null)
    {
        if (is_null($standardCostRevaluationSubaccount) || (is_array($standardCostRevaluationSubaccount) && empty($standardCostRevaluationSubaccount))) {
            unset($this->StandardCostRevaluationSubaccount);
        } else {
            $this->StandardCostRevaluationSubaccount = $standardCostRevaluationSubaccount;
        }
        return $this;
    }
    /**
     * Get StandardCostVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStandardCostVarianceAccount()
    {
        return isset($this->StandardCostVarianceAccount) ? $this->StandardCostVarianceAccount : null;
    }
    /**
     * Set StandardCostVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $standardCostVarianceAccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setStandardCostVarianceAccount(\AcumaticaConfig\StructType\StringValue $standardCostVarianceAccount = null)
    {
        if (is_null($standardCostVarianceAccount) || (is_array($standardCostVarianceAccount) && empty($standardCostVarianceAccount))) {
            unset($this->StandardCostVarianceAccount);
        } else {
            $this->StandardCostVarianceAccount = $standardCostVarianceAccount;
        }
        return $this;
    }
    /**
     * Get StandardCostVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStandardCostVarianceSubaccount()
    {
        return isset($this->StandardCostVarianceSubaccount) ? $this->StandardCostVarianceSubaccount : null;
    }
    /**
     * Set StandardCostVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $standardCostVarianceSubaccount
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setStandardCostVarianceSubaccount(\AcumaticaConfig\StructType\StringValue $standardCostVarianceSubaccount = null)
    {
        if (is_null($standardCostVarianceSubaccount) || (is_array($standardCostVarianceSubaccount) && empty($standardCostVarianceSubaccount))) {
            unset($this->StandardCostVarianceSubaccount);
        } else {
            $this->StandardCostVarianceSubaccount = $standardCostVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get SubItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SubItems|null
     */
    public function getSubItems()
    {
        return isset($this->SubItems) ? $this->SubItems : null;
    }
    /**
     * Set SubItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\SubItems $subItems
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setSubItems(\AcumaticaConfig\StructType\SubItems $subItems = null)
    {
        if (is_null($subItems) || (is_array($subItems) && empty($subItems))) {
            unset($this->SubItems);
        } else {
            $this->SubItems = $subItems;
        }
        return $this;
    }
    /**
     * Get SubjectToCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSubjectToCommission()
    {
        return isset($this->SubjectToCommission) ? $this->SubjectToCommission : null;
    }
    /**
     * Set SubjectToCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $subjectToCommission
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setSubjectToCommission(\AcumaticaConfig\StructType\BooleanValue $subjectToCommission = null)
    {
        if (is_null($subjectToCommission) || (is_array($subjectToCommission) && empty($subjectToCommission))) {
            unset($this->SubjectToCommission);
        } else {
            $this->SubjectToCommission = $subjectToCommission;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setTaxCategory(\AcumaticaConfig\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get UOMConversions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\UOMConversions|null
     */
    public function getUOMConversions()
    {
        return isset($this->UOMConversions) ? $this->UOMConversions : null;
    }
    /**
     * Set UOMConversions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\UOMConversions $uOMConversions
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setUOMConversions(\AcumaticaConfig\StructType\UOMConversions $uOMConversions = null)
    {
        if (is_null($uOMConversions) || (is_array($uOMConversions) && empty($uOMConversions))) {
            unset($this->UOMConversions);
        } else {
            $this->UOMConversions = $uOMConversions;
        }
        return $this;
    }
    /**
     * Get UpSellID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getUpSellID()
    {
        return isset($this->UpSellID) ? $this->UpSellID : null;
    }
    /**
     * Set UpSellID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $upSellID
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setUpSellID(\AcumaticaConfig\StructType\StringValue $upSellID = null)
    {
        if (is_null($upSellID) || (is_array($upSellID) && empty($upSellID))) {
            unset($this->UpSellID);
        } else {
            $this->UpSellID = $upSellID;
        }
        return $this;
    }
    /**
     * Get UpSells value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\UpSells|null
     */
    public function getUpSells()
    {
        return isset($this->UpSells) ? $this->UpSells : null;
    }
    /**
     * Set UpSells value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\UpSells $upSells
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setUpSells(\AcumaticaConfig\StructType\UpSells $upSells = null)
    {
        if (is_null($upSells) || (is_array($upSells) && empty($upSells))) {
            unset($this->UpSells);
        } else {
            $this->UpSells = $upSells;
        }
        return $this;
    }
    /**
     * Get URLKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getURLKey()
    {
        return isset($this->URLKey) ? $this->URLKey : null;
    }
    /**
     * Set URLKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $uRLKey
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setURLKey(\AcumaticaConfig\StructType\StringValue $uRLKey = null)
    {
        if (is_null($uRLKey) || (is_array($uRLKey) && empty($uRLKey))) {
            unset($this->URLKey);
        } else {
            $this->URLKey = $uRLKey;
        }
        return $this;
    }
    /**
     * Get UseOnEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getUseOnEntry()
    {
        return isset($this->UseOnEntry) ? $this->UseOnEntry : null;
    }
    /**
     * Set UseOnEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $useOnEntry
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setUseOnEntry(\AcumaticaConfig\StructType\BooleanValue $useOnEntry = null)
    {
        if (is_null($useOnEntry) || (is_array($useOnEntry) && empty($useOnEntry))) {
            unset($this->UseOnEntry);
        } else {
            $this->UseOnEntry = $useOnEntry;
        }
        return $this;
    }
    /**
     * Get ValuationMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getValuationMethod()
    {
        return isset($this->ValuationMethod) ? $this->ValuationMethod : null;
    }
    /**
     * Set ValuationMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $valuationMethod
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setValuationMethod(\AcumaticaConfig\StructType\StringValue $valuationMethod = null)
    {
        if (is_null($valuationMethod) || (is_array($valuationMethod) && empty($valuationMethod))) {
            unset($this->ValuationMethod);
        } else {
            $this->ValuationMethod = $valuationMethod;
        }
        return $this;
    }
    /**
     * Get VendorDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\VendorDetails|null
     */
    public function getVendorDetails()
    {
        return isset($this->VendorDetails) ? $this->VendorDetails : null;
    }
    /**
     * Set VendorDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\VendorDetails $vendorDetails
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setVendorDetails(\AcumaticaConfig\StructType\VendorDetails $vendorDetails = null)
    {
        if (is_null($vendorDetails) || (is_array($vendorDetails) && empty($vendorDetails))) {
            unset($this->VendorDetails);
        } else {
            $this->VendorDetails = $vendorDetails;
        }
        return $this;
    }
    /**
     * Get Visibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVisibility()
    {
        return isset($this->Visibility) ? $this->Visibility : null;
    }
    /**
     * Set Visibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $visibility
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setVisibility(\AcumaticaConfig\StructType\StringValue $visibility = null)
    {
        if (is_null($visibility) || (is_array($visibility) && empty($visibility))) {
            unset($this->Visibility);
        } else {
            $this->Visibility = $visibility;
        }
        return $this;
    }
    /**
     * Get Volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getVolume()
    {
        return isset($this->Volume) ? $this->Volume : null;
    }
    /**
     * Set Volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $volume
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setVolume(\AcumaticaConfig\StructType\DecimalValue $volume = null)
    {
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->Volume);
        } else {
            $this->Volume = $volume;
        }
        return $this;
    }
    /**
     * Get VolumeUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVolumeUOM()
    {
        return isset($this->VolumeUOM) ? $this->VolumeUOM : null;
    }
    /**
     * Set VolumeUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $volumeUOM
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setVolumeUOM(\AcumaticaConfig\StructType\StringValue $volumeUOM = null)
    {
        if (is_null($volumeUOM) || (is_array($volumeUOM) && empty($volumeUOM))) {
            unset($this->VolumeUOM);
        } else {
            $this->VolumeUOM = $volumeUOM;
        }
        return $this;
    }
    /**
     * Get WarehouseDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\WarehouseDetails|null
     */
    public function getWarehouseDetails()
    {
        return isset($this->WarehouseDetails) ? $this->WarehouseDetails : null;
    }
    /**
     * Set WarehouseDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\WarehouseDetails $warehouseDetails
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setWarehouseDetails(\AcumaticaConfig\StructType\WarehouseDetails $warehouseDetails = null)
    {
        if (is_null($warehouseDetails) || (is_array($warehouseDetails) && empty($warehouseDetails))) {
            unset($this->WarehouseDetails);
        } else {
            $this->WarehouseDetails = $warehouseDetails;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $weight
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setWeight(\AcumaticaConfig\StructType\DecimalValue $weight = null)
    {
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
    /**
     * Get WeightUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWeightUOM()
    {
        return isset($this->WeightUOM) ? $this->WeightUOM : null;
    }
    /**
     * Set WeightUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $weightUOM
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public function setWeightUOM(\AcumaticaConfig\StructType\StringValue $weightUOM = null)
    {
        if (is_null($weightUOM) || (is_array($weightUOM) && empty($weightUOM))) {
            unset($this->WeightUOM);
        } else {
            $this->WeightUOM = $weightUOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\StockItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
