<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockComponents StructType
 * @subpackage Structs
 */
class StockComponents extends AbstractStructBase
{
    /**
     * The KitStockComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\KitStockComponent[]
     */
    public $KitStockComponent;
    /**
     * The KitAssemblyStockComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\KitAssemblyStockComponent[]
     */
    public $KitAssemblyStockComponent;
    /**
     * Constructor method for StockComponents
     * @uses StockComponents::setKitStockComponent()
     * @uses StockComponents::setKitAssemblyStockComponent()
     * @param \AcumaticaConfig\StructType\KitStockComponent[] $kitStockComponent
     * @param \AcumaticaConfig\StructType\KitAssemblyStockComponent[] $kitAssemblyStockComponent
     */
    public function __construct(array $kitStockComponent = array(), array $kitAssemblyStockComponent = array())
    {
        $this
            ->setKitStockComponent($kitStockComponent)
            ->setKitAssemblyStockComponent($kitAssemblyStockComponent);
    }
    /**
     * Get KitStockComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\KitStockComponent[]|null
     */
    public function getKitStockComponent()
    {
        return isset($this->KitStockComponent) ? $this->KitStockComponent : null;
    }
    /**
     * Set KitStockComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\KitStockComponent[] $kitStockComponent
     * @return \AcumaticaConfig\StructType\StockComponents
     */
    public function setKitStockComponent(array $kitStockComponent = array())
    {
        foreach ($kitStockComponent as $stockComponentsKitStockComponentItem) {
            // validation for constraint: itemType
            if (!$stockComponentsKitStockComponentItem instanceof \AcumaticaConfig\StructType\KitStockComponent) {
                throw new \InvalidArgumentException(sprintf('The KitStockComponent property can only contain items of \AcumaticaConfig\StructType\KitStockComponent, "%s" given', is_object($stockComponentsKitStockComponentItem) ? get_class($stockComponentsKitStockComponentItem) : gettype($stockComponentsKitStockComponentItem)), __LINE__);
            }
        }
        if (is_null($kitStockComponent) || (is_array($kitStockComponent) && empty($kitStockComponent))) {
            unset($this->KitStockComponent);
        } else {
            $this->KitStockComponent = $kitStockComponent;
        }
        return $this;
    }
    /**
     * Add item to KitStockComponent value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\KitStockComponent $item
     * @return \AcumaticaConfig\StructType\StockComponents
     */
    public function addToKitStockComponent(\AcumaticaConfig\StructType\KitStockComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\KitStockComponent) {
            throw new \InvalidArgumentException(sprintf('The KitStockComponent property can only contain items of \AcumaticaConfig\StructType\KitStockComponent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitStockComponent[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyStockComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\KitAssemblyStockComponent[]|null
     */
    public function getKitAssemblyStockComponent()
    {
        return isset($this->KitAssemblyStockComponent) ? $this->KitAssemblyStockComponent : null;
    }
    /**
     * Set KitAssemblyStockComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\KitAssemblyStockComponent[] $kitAssemblyStockComponent
     * @return \AcumaticaConfig\StructType\StockComponents
     */
    public function setKitAssemblyStockComponent(array $kitAssemblyStockComponent = array())
    {
        foreach ($kitAssemblyStockComponent as $stockComponentsKitAssemblyStockComponentItem) {
            // validation for constraint: itemType
            if (!$stockComponentsKitAssemblyStockComponentItem instanceof \AcumaticaConfig\StructType\KitAssemblyStockComponent) {
                throw new \InvalidArgumentException(sprintf('The KitAssemblyStockComponent property can only contain items of \AcumaticaConfig\StructType\KitAssemblyStockComponent, "%s" given', is_object($stockComponentsKitAssemblyStockComponentItem) ? get_class($stockComponentsKitAssemblyStockComponentItem) : gettype($stockComponentsKitAssemblyStockComponentItem)), __LINE__);
            }
        }
        if (is_null($kitAssemblyStockComponent) || (is_array($kitAssemblyStockComponent) && empty($kitAssemblyStockComponent))) {
            unset($this->KitAssemblyStockComponent);
        } else {
            $this->KitAssemblyStockComponent = $kitAssemblyStockComponent;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyStockComponent value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\KitAssemblyStockComponent $item
     * @return \AcumaticaConfig\StructType\StockComponents
     */
    public function addToKitAssemblyStockComponent(\AcumaticaConfig\StructType\KitAssemblyStockComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\KitAssemblyStockComponent) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyStockComponent property can only contain items of \AcumaticaConfig\StructType\KitAssemblyStockComponent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitAssemblyStockComponent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\StockComponents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
