<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingSettings StructType
 * @subpackage Structs
 */
class ShippingSettings extends Entity
{
    /**
     * The CancelByDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $CancelByDate;
    /**
     * The Canceled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Canceled;
    /**
     * The FOBPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The GroundCollect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $GroundCollect;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Insurance;
    /**
     * The PreferredWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PreferredWarehouseID;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $Priority;
    /**
     * The ResidentialDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ResidentialDelivery;
    /**
     * The SaturdayDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SaturdayDelivery;
    /**
     * The ScheduledShipmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ScheduledShipmentDate;
    /**
     * The ShippingRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The ShippingTerms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShippingZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingZone;
    /**
     * The ShipSeparately
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipSeparately;
    /**
     * The ShipVia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The ShopForRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShopForRates
     */
    public $ShopForRates;
    /**
     * The UseCustomersAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $UseCustomersAccount;
    /**
     * Constructor method for ShippingSettings
     * @uses ShippingSettings::setCancelByDate()
     * @uses ShippingSettings::setCanceled()
     * @uses ShippingSettings::setFOBPoint()
     * @uses ShippingSettings::setGroundCollect()
     * @uses ShippingSettings::setInsurance()
     * @uses ShippingSettings::setPreferredWarehouseID()
     * @uses ShippingSettings::setPriority()
     * @uses ShippingSettings::setResidentialDelivery()
     * @uses ShippingSettings::setSaturdayDelivery()
     * @uses ShippingSettings::setScheduledShipmentDate()
     * @uses ShippingSettings::setShippingRule()
     * @uses ShippingSettings::setShippingTerms()
     * @uses ShippingSettings::setShippingZone()
     * @uses ShippingSettings::setShipSeparately()
     * @uses ShippingSettings::setShipVia()
     * @uses ShippingSettings::setShopForRates()
     * @uses ShippingSettings::setUseCustomersAccount()
     * @param \AcumaticaConfig\StructType\DateTimeValue $cancelByDate
     * @param \AcumaticaConfig\StructType\BooleanValue $canceled
     * @param \AcumaticaConfig\StructType\StringValue $fOBPoint
     * @param \AcumaticaConfig\StructType\BooleanValue $groundCollect
     * @param \AcumaticaConfig\StructType\BooleanValue $insurance
     * @param \AcumaticaConfig\StructType\StringValue $preferredWarehouseID
     * @param \AcumaticaConfig\StructType\ShortValue $priority
     * @param \AcumaticaConfig\StructType\BooleanValue $residentialDelivery
     * @param \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery
     * @param \AcumaticaConfig\StructType\DateTimeValue $scheduledShipmentDate
     * @param \AcumaticaConfig\StructType\StringValue $shippingRule
     * @param \AcumaticaConfig\StructType\StringValue $shippingTerms
     * @param \AcumaticaConfig\StructType\StringValue $shippingZone
     * @param \AcumaticaConfig\StructType\BooleanValue $shipSeparately
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @param \AcumaticaConfig\StructType\ShopForRates $shopForRates
     * @param \AcumaticaConfig\StructType\BooleanValue $useCustomersAccount
     */
    public function __construct(\AcumaticaConfig\StructType\DateTimeValue $cancelByDate = null, \AcumaticaConfig\StructType\BooleanValue $canceled = null, \AcumaticaConfig\StructType\StringValue $fOBPoint = null, \AcumaticaConfig\StructType\BooleanValue $groundCollect = null, \AcumaticaConfig\StructType\BooleanValue $insurance = null, \AcumaticaConfig\StructType\StringValue $preferredWarehouseID = null, \AcumaticaConfig\StructType\ShortValue $priority = null, \AcumaticaConfig\StructType\BooleanValue $residentialDelivery = null, \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery = null, \AcumaticaConfig\StructType\DateTimeValue $scheduledShipmentDate = null, \AcumaticaConfig\StructType\StringValue $shippingRule = null, \AcumaticaConfig\StructType\StringValue $shippingTerms = null, \AcumaticaConfig\StructType\StringValue $shippingZone = null, \AcumaticaConfig\StructType\BooleanValue $shipSeparately = null, \AcumaticaConfig\StructType\StringValue $shipVia = null, \AcumaticaConfig\StructType\ShopForRates $shopForRates = null, \AcumaticaConfig\StructType\BooleanValue $useCustomersAccount = null)
    {
        $this
            ->setCancelByDate($cancelByDate)
            ->setCanceled($canceled)
            ->setFOBPoint($fOBPoint)
            ->setGroundCollect($groundCollect)
            ->setInsurance($insurance)
            ->setPreferredWarehouseID($preferredWarehouseID)
            ->setPriority($priority)
            ->setResidentialDelivery($residentialDelivery)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setScheduledShipmentDate($scheduledShipmentDate)
            ->setShippingRule($shippingRule)
            ->setShippingTerms($shippingTerms)
            ->setShippingZone($shippingZone)
            ->setShipSeparately($shipSeparately)
            ->setShipVia($shipVia)
            ->setShopForRates($shopForRates)
            ->setUseCustomersAccount($useCustomersAccount);
    }
    /**
     * Get CancelByDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getCancelByDate()
    {
        return isset($this->CancelByDate) ? $this->CancelByDate : null;
    }
    /**
     * Set CancelByDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $cancelByDate
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setCancelByDate(\AcumaticaConfig\StructType\DateTimeValue $cancelByDate = null)
    {
        if (is_null($cancelByDate) || (is_array($cancelByDate) && empty($cancelByDate))) {
            unset($this->CancelByDate);
        } else {
            $this->CancelByDate = $cancelByDate;
        }
        return $this;
    }
    /**
     * Get Canceled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getCanceled()
    {
        return isset($this->Canceled) ? $this->Canceled : null;
    }
    /**
     * Set Canceled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $canceled
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setCanceled(\AcumaticaConfig\StructType\BooleanValue $canceled = null)
    {
        if (is_null($canceled) || (is_array($canceled) && empty($canceled))) {
            unset($this->Canceled);
        } else {
            $this->Canceled = $canceled;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $fOBPoint
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setFOBPoint(\AcumaticaConfig\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get GroundCollect value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getGroundCollect()
    {
        return isset($this->GroundCollect) ? $this->GroundCollect : null;
    }
    /**
     * Set GroundCollect value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $groundCollect
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setGroundCollect(\AcumaticaConfig\StructType\BooleanValue $groundCollect = null)
    {
        if (is_null($groundCollect) || (is_array($groundCollect) && empty($groundCollect))) {
            unset($this->GroundCollect);
        } else {
            $this->GroundCollect = $groundCollect;
        }
        return $this;
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $insurance
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setInsurance(\AcumaticaConfig\StructType\BooleanValue $insurance = null)
    {
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Get PreferredWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPreferredWarehouseID()
    {
        return isset($this->PreferredWarehouseID) ? $this->PreferredWarehouseID : null;
    }
    /**
     * Set PreferredWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $preferredWarehouseID
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setPreferredWarehouseID(\AcumaticaConfig\StructType\StringValue $preferredWarehouseID = null)
    {
        if (is_null($preferredWarehouseID) || (is_array($preferredWarehouseID) && empty($preferredWarehouseID))) {
            unset($this->PreferredWarehouseID);
        } else {
            $this->PreferredWarehouseID = $preferredWarehouseID;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $priority
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setPriority(\AcumaticaConfig\StructType\ShortValue $priority = null)
    {
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getResidentialDelivery()
    {
        return isset($this->ResidentialDelivery) ? $this->ResidentialDelivery : null;
    }
    /**
     * Set ResidentialDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $residentialDelivery
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setResidentialDelivery(\AcumaticaConfig\StructType\BooleanValue $residentialDelivery = null)
    {
        if (is_null($residentialDelivery) || (is_array($residentialDelivery) && empty($residentialDelivery))) {
            unset($this->ResidentialDelivery);
        } else {
            $this->ResidentialDelivery = $residentialDelivery;
        }
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSaturdayDelivery()
    {
        return isset($this->SaturdayDelivery) ? $this->SaturdayDelivery : null;
    }
    /**
     * Set SaturdayDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setSaturdayDelivery(\AcumaticaConfig\StructType\BooleanValue $saturdayDelivery = null)
    {
        if (is_null($saturdayDelivery) || (is_array($saturdayDelivery) && empty($saturdayDelivery))) {
            unset($this->SaturdayDelivery);
        } else {
            $this->SaturdayDelivery = $saturdayDelivery;
        }
        return $this;
    }
    /**
     * Get ScheduledShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getScheduledShipmentDate()
    {
        return isset($this->ScheduledShipmentDate) ? $this->ScheduledShipmentDate : null;
    }
    /**
     * Set ScheduledShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $scheduledShipmentDate
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setScheduledShipmentDate(\AcumaticaConfig\StructType\DateTimeValue $scheduledShipmentDate = null)
    {
        if (is_null($scheduledShipmentDate) || (is_array($scheduledShipmentDate) && empty($scheduledShipmentDate))) {
            unset($this->ScheduledShipmentDate);
        } else {
            $this->ScheduledShipmentDate = $scheduledShipmentDate;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingRule
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setShippingRule(\AcumaticaConfig\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingTerms
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setShippingTerms(\AcumaticaConfig\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShippingZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingZone()
    {
        return isset($this->ShippingZone) ? $this->ShippingZone : null;
    }
    /**
     * Set ShippingZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingZone
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setShippingZone(\AcumaticaConfig\StructType\StringValue $shippingZone = null)
    {
        if (is_null($shippingZone) || (is_array($shippingZone) && empty($shippingZone))) {
            unset($this->ShippingZone);
        } else {
            $this->ShippingZone = $shippingZone;
        }
        return $this;
    }
    /**
     * Get ShipSeparately value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipSeparately()
    {
        return isset($this->ShipSeparately) ? $this->ShipSeparately : null;
    }
    /**
     * Set ShipSeparately value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipSeparately
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setShipSeparately(\AcumaticaConfig\StructType\BooleanValue $shipSeparately = null)
    {
        if (is_null($shipSeparately) || (is_array($shipSeparately) && empty($shipSeparately))) {
            unset($this->ShipSeparately);
        } else {
            $this->ShipSeparately = $shipSeparately;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setShipVia(\AcumaticaConfig\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get ShopForRates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShopForRates|null
     */
    public function getShopForRates()
    {
        return isset($this->ShopForRates) ? $this->ShopForRates : null;
    }
    /**
     * Set ShopForRates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShopForRates $shopForRates
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setShopForRates(\AcumaticaConfig\StructType\ShopForRates $shopForRates = null)
    {
        if (is_null($shopForRates) || (is_array($shopForRates) && empty($shopForRates))) {
            unset($this->ShopForRates);
        } else {
            $this->ShopForRates = $shopForRates;
        }
        return $this;
    }
    /**
     * Get UseCustomersAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getUseCustomersAccount()
    {
        return isset($this->UseCustomersAccount) ? $this->UseCustomersAccount : null;
    }
    /**
     * Set UseCustomersAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $useCustomersAccount
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public function setUseCustomersAccount(\AcumaticaConfig\StructType\BooleanValue $useCustomersAccount = null)
    {
        if (is_null($useCustomersAccount) || (is_array($useCustomersAccount) && empty($useCustomersAccount))) {
            unset($this->UseCustomersAccount);
        } else {
            $this->UseCustomersAccount = $useCustomersAccount;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ShippingSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
