<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingInstructions StructType
 * @subpackage Structs
 */
class ShippingInstructions extends Entity
{
    /**
     * The ShippingDestinationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingDestinationType;
    /**
     * The ShippingLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingLocation;
    /**
     * The ShipTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipTo;
    /**
     * The ShipToAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Address
     */
    public $ShipToAddress;
    /**
     * The ShipToAddressOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipToAddressOverride;
    /**
     * The ShipToAddressValidated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipToAddressValidated;
    /**
     * The ShipToContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DocContact
     */
    public $ShipToContact;
    /**
     * The ShipToContactOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipToContactOverride;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for ShippingInstructions
     * @uses ShippingInstructions::setShippingDestinationType()
     * @uses ShippingInstructions::setShippingLocation()
     * @uses ShippingInstructions::setShipTo()
     * @uses ShippingInstructions::setShipToAddress()
     * @uses ShippingInstructions::setShipToAddressOverride()
     * @uses ShippingInstructions::setShipToAddressValidated()
     * @uses ShippingInstructions::setShipToContact()
     * @uses ShippingInstructions::setShipToContactOverride()
     * @uses ShippingInstructions::setWarehouse()
     * @param \AcumaticaConfig\StructType\StringValue $shippingDestinationType
     * @param \AcumaticaConfig\StructType\StringValue $shippingLocation
     * @param \AcumaticaConfig\StructType\StringValue $shipTo
     * @param \AcumaticaConfig\StructType\Address $shipToAddress
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressValidated
     * @param \AcumaticaConfig\StructType\DocContact $shipToContact
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $shippingDestinationType = null, \AcumaticaConfig\StructType\StringValue $shippingLocation = null, \AcumaticaConfig\StructType\StringValue $shipTo = null, \AcumaticaConfig\StructType\Address $shipToAddress = null, \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride = null, \AcumaticaConfig\StructType\BooleanValue $shipToAddressValidated = null, \AcumaticaConfig\StructType\DocContact $shipToContact = null, \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride = null, \AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        $this
            ->setShippingDestinationType($shippingDestinationType)
            ->setShippingLocation($shippingLocation)
            ->setShipTo($shipTo)
            ->setShipToAddress($shipToAddress)
            ->setShipToAddressOverride($shipToAddressOverride)
            ->setShipToAddressValidated($shipToAddressValidated)
            ->setShipToContact($shipToContact)
            ->setShipToContactOverride($shipToContactOverride)
            ->setWarehouse($warehouse);
    }
    /**
     * Get ShippingDestinationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingDestinationType()
    {
        return isset($this->ShippingDestinationType) ? $this->ShippingDestinationType : null;
    }
    /**
     * Set ShippingDestinationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingDestinationType
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setShippingDestinationType(\AcumaticaConfig\StructType\StringValue $shippingDestinationType = null)
    {
        if (is_null($shippingDestinationType) || (is_array($shippingDestinationType) && empty($shippingDestinationType))) {
            unset($this->ShippingDestinationType);
        } else {
            $this->ShippingDestinationType = $shippingDestinationType;
        }
        return $this;
    }
    /**
     * Get ShippingLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingLocation()
    {
        return isset($this->ShippingLocation) ? $this->ShippingLocation : null;
    }
    /**
     * Set ShippingLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingLocation
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setShippingLocation(\AcumaticaConfig\StructType\StringValue $shippingLocation = null)
    {
        if (is_null($shippingLocation) || (is_array($shippingLocation) && empty($shippingLocation))) {
            unset($this->ShippingLocation);
        } else {
            $this->ShippingLocation = $shippingLocation;
        }
        return $this;
    }
    /**
     * Get ShipTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipTo()
    {
        return isset($this->ShipTo) ? $this->ShipTo : null;
    }
    /**
     * Set ShipTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipTo
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setShipTo(\AcumaticaConfig\StructType\StringValue $shipTo = null)
    {
        if (is_null($shipTo) || (is_array($shipTo) && empty($shipTo))) {
            unset($this->ShipTo);
        } else {
            $this->ShipTo = $shipTo;
        }
        return $this;
    }
    /**
     * Get ShipToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Address|null
     */
    public function getShipToAddress()
    {
        return isset($this->ShipToAddress) ? $this->ShipToAddress : null;
    }
    /**
     * Set ShipToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Address $shipToAddress
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setShipToAddress(\AcumaticaConfig\StructType\Address $shipToAddress = null)
    {
        if (is_null($shipToAddress) || (is_array($shipToAddress) && empty($shipToAddress))) {
            unset($this->ShipToAddress);
        } else {
            $this->ShipToAddress = $shipToAddress;
        }
        return $this;
    }
    /**
     * Get ShipToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipToAddressOverride()
    {
        return isset($this->ShipToAddressOverride) ? $this->ShipToAddressOverride : null;
    }
    /**
     * Set ShipToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setShipToAddressOverride(\AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride = null)
    {
        if (is_null($shipToAddressOverride) || (is_array($shipToAddressOverride) && empty($shipToAddressOverride))) {
            unset($this->ShipToAddressOverride);
        } else {
            $this->ShipToAddressOverride = $shipToAddressOverride;
        }
        return $this;
    }
    /**
     * Get ShipToAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipToAddressValidated()
    {
        return isset($this->ShipToAddressValidated) ? $this->ShipToAddressValidated : null;
    }
    /**
     * Set ShipToAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressValidated
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setShipToAddressValidated(\AcumaticaConfig\StructType\BooleanValue $shipToAddressValidated = null)
    {
        if (is_null($shipToAddressValidated) || (is_array($shipToAddressValidated) && empty($shipToAddressValidated))) {
            unset($this->ShipToAddressValidated);
        } else {
            $this->ShipToAddressValidated = $shipToAddressValidated;
        }
        return $this;
    }
    /**
     * Get ShipToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DocContact|null
     */
    public function getShipToContact()
    {
        return isset($this->ShipToContact) ? $this->ShipToContact : null;
    }
    /**
     * Set ShipToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DocContact $shipToContact
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setShipToContact(\AcumaticaConfig\StructType\DocContact $shipToContact = null)
    {
        if (is_null($shipToContact) || (is_array($shipToContact) && empty($shipToContact))) {
            unset($this->ShipToContact);
        } else {
            $this->ShipToContact = $shipToContact;
        }
        return $this;
    }
    /**
     * Get ShipToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipToContactOverride()
    {
        return isset($this->ShipToContactOverride) ? $this->ShipToContactOverride : null;
    }
    /**
     * Set ShipToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setShipToContactOverride(\AcumaticaConfig\StructType\BooleanValue $shipToContactOverride = null)
    {
        if (is_null($shipToContactOverride) || (is_array($shipToContactOverride) && empty($shipToContactOverride))) {
            unset($this->ShipToContactOverride);
        } else {
            $this->ShipToContactOverride = $shipToContactOverride;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public function setWarehouse(\AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ShippingInstructions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
