<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipments StructType
 * @subpackage Structs
 */
class Shipments extends AbstractStructBase
{
    /**
     * The SalesOrderShipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SalesOrderShipment[]
     */
    public $SalesOrderShipment;
    /**
     * Constructor method for Shipments
     * @uses Shipments::setSalesOrderShipment()
     * @param \AcumaticaConfig\StructType\SalesOrderShipment[] $salesOrderShipment
     */
    public function __construct(array $salesOrderShipment = array())
    {
        $this
            ->setSalesOrderShipment($salesOrderShipment);
    }
    /**
     * Get SalesOrderShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SalesOrderShipment[]|null
     */
    public function getSalesOrderShipment()
    {
        return isset($this->SalesOrderShipment) ? $this->SalesOrderShipment : null;
    }
    /**
     * Set SalesOrderShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesOrderShipment[] $salesOrderShipment
     * @return \AcumaticaConfig\StructType\Shipments
     */
    public function setSalesOrderShipment(array $salesOrderShipment = array())
    {
        foreach ($salesOrderShipment as $shipmentsSalesOrderShipmentItem) {
            // validation for constraint: itemType
            if (!$shipmentsSalesOrderShipmentItem instanceof \AcumaticaConfig\StructType\SalesOrderShipment) {
                throw new \InvalidArgumentException(sprintf('The SalesOrderShipment property can only contain items of \AcumaticaConfig\StructType\SalesOrderShipment, "%s" given', is_object($shipmentsSalesOrderShipmentItem) ? get_class($shipmentsSalesOrderShipmentItem) : gettype($shipmentsSalesOrderShipmentItem)), __LINE__);
            }
        }
        if (is_null($salesOrderShipment) || (is_array($salesOrderShipment) && empty($salesOrderShipment))) {
            unset($this->SalesOrderShipment);
        } else {
            $this->SalesOrderShipment = $salesOrderShipment;
        }
        return $this;
    }
    /**
     * Add item to SalesOrderShipment value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesOrderShipment $item
     * @return \AcumaticaConfig\StructType\Shipments
     */
    public function addToSalesOrderShipment(\AcumaticaConfig\StructType\SalesOrderShipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\SalesOrderShipment) {
            throw new \InvalidArgumentException(sprintf('The SalesOrderShipment property can only contain items of \AcumaticaConfig\StructType\SalesOrderShipment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesOrderShipment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Shipments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
