<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentResults StructType
 * @subpackage Structs
 */
class ShipmentResults extends Entity
{
    /**
     * The ShipmentResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShipmentResults[]
     */
    public $ShipmentResults;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $Count;
    /**
     * The ShipmentNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for ShipmentResults
     * @uses ShipmentResults::setShipmentResults()
     * @uses ShipmentResults::setCount()
     * @uses ShipmentResults::setShipmentNbr()
     * @uses ShipmentResults::setType()
     * @param \AcumaticaConfig\StructType\ShipmentResults[] $shipmentResults
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @param \AcumaticaConfig\StructType\StringValue $shipmentNbr
     * @param \AcumaticaConfig\StructType\StringValue $type
     */
    public function __construct(array $shipmentResults = array(), \AcumaticaConfig\StructType\IntValue $count = null, \AcumaticaConfig\StructType\StringValue $shipmentNbr = null, \AcumaticaConfig\StructType\StringValue $type = null)
    {
        $this
            ->setShipmentResults($shipmentResults)
            ->setCount($count)
            ->setShipmentNbr($shipmentNbr)
            ->setType($type);
    }
    /**
     * Get ShipmentResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShipmentResults[]|null
     */
    public function getShipmentResults()
    {
        return isset($this->ShipmentResults) ? $this->ShipmentResults : null;
    }
    /**
     * Set ShipmentResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentResults[] $shipmentResults
     * @return \AcumaticaConfig\StructType\ShipmentResults
     */
    public function setShipmentResults(array $shipmentResults = array())
    {
        foreach ($shipmentResults as $shipmentResultsShipmentResultsItem) {
            // validation for constraint: itemType
            if (!$shipmentResultsShipmentResultsItem instanceof \AcumaticaConfig\StructType\ShipmentResults) {
                throw new \InvalidArgumentException(sprintf('The ShipmentResults property can only contain items of \AcumaticaConfig\StructType\ShipmentResults, "%s" given', is_object($shipmentResultsShipmentResultsItem) ? get_class($shipmentResultsShipmentResultsItem) : gettype($shipmentResultsShipmentResultsItem)), __LINE__);
            }
        }
        if (is_null($shipmentResults) || (is_array($shipmentResults) && empty($shipmentResults))) {
            unset($this->ShipmentResults);
        } else {
            $this->ShipmentResults = $shipmentResults;
        }
        return $this;
    }
    /**
     * Add item to ShipmentResults value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentResults $item
     * @return \AcumaticaConfig\StructType\ShipmentResults
     */
    public function addToShipmentResults(\AcumaticaConfig\StructType\ShipmentResults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ShipmentResults) {
            throw new \InvalidArgumentException(sprintf('The ShipmentResults property can only contain items of \AcumaticaConfig\StructType\ShipmentResults, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentResults[] = $item;
        return $this;
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @return \AcumaticaConfig\StructType\ShipmentResults
     */
    public function setCount(\AcumaticaConfig\StructType\IntValue $count = null)
    {
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipmentNbr
     * @return \AcumaticaConfig\StructType\ShipmentResults
     */
    public function setShipmentNbr(\AcumaticaConfig\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @return \AcumaticaConfig\StructType\ShipmentResults
     */
    public function setType(\AcumaticaConfig\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ShipmentResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
