<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentCount StructType
 * @subpackage Structs
 */
class ShipmentCount extends Entity
{
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $FromDate;
    /**
     * The ShipmentResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShipmentResults
     */
    public $ShipmentResults;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ToDate;
    /**
     * Constructor method for ShipmentCount
     * @uses ShipmentCount::setFromDate()
     * @uses ShipmentCount::setShipmentResults()
     * @uses ShipmentCount::setToDate()
     * @param \AcumaticaConfig\StructType\DateTimeValue $fromDate
     * @param \AcumaticaConfig\StructType\ShipmentResults $shipmentResults
     * @param \AcumaticaConfig\StructType\DateTimeValue $toDate
     */
    public function __construct(\AcumaticaConfig\StructType\DateTimeValue $fromDate = null, \AcumaticaConfig\StructType\ShipmentResults $shipmentResults = null, \AcumaticaConfig\StructType\DateTimeValue $toDate = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setShipmentResults($shipmentResults)
            ->setToDate($toDate);
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $fromDate
     * @return \AcumaticaConfig\StructType\ShipmentCount
     */
    public function setFromDate(\AcumaticaConfig\StructType\DateTimeValue $fromDate = null)
    {
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get ShipmentResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShipmentResults|null
     */
    public function getShipmentResults()
    {
        return isset($this->ShipmentResults) ? $this->ShipmentResults : null;
    }
    /**
     * Set ShipmentResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShipmentResults $shipmentResults
     * @return \AcumaticaConfig\StructType\ShipmentCount
     */
    public function setShipmentResults(\AcumaticaConfig\StructType\ShipmentResults $shipmentResults = null)
    {
        if (is_null($shipmentResults) || (is_array($shipmentResults) && empty($shipmentResults))) {
            unset($this->ShipmentResults);
        } else {
            $this->ShipmentResults = $shipmentResults;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $toDate
     * @return \AcumaticaConfig\StructType\ShipmentCount
     */
    public function setToDate(\AcumaticaConfig\StructType\DateTimeValue $toDate = null)
    {
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ShipmentCount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
