<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderDetailAllocation StructType
 * @subpackage Structs
 */
class SalesOrderDetailAllocation extends Entity
{
    /**
     * The Allocated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Allocated;
    /**
     * The AllocWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AllocWarehouseID;
    /**
     * The Completed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Completed;
    /**
     * The ExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LocationID;
    /**
     * The LotSerialNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderType;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The QtyOnShipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $QtyOnShipments;
    /**
     * The QtyReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $QtyReceived;
    /**
     * The RelatedDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $RelatedDocument;
    /**
     * The ShipOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ShipOn;
    /**
     * The SplitLineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $SplitLineNbr;
    /**
     * The Subitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Subitem;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for SalesOrderDetailAllocation
     * @uses SalesOrderDetailAllocation::setAllocated()
     * @uses SalesOrderDetailAllocation::setAllocWarehouseID()
     * @uses SalesOrderDetailAllocation::setCompleted()
     * @uses SalesOrderDetailAllocation::setExpirationDate()
     * @uses SalesOrderDetailAllocation::setInventoryID()
     * @uses SalesOrderDetailAllocation::setLineNbr()
     * @uses SalesOrderDetailAllocation::setLocationID()
     * @uses SalesOrderDetailAllocation::setLotSerialNbr()
     * @uses SalesOrderDetailAllocation::setOrderNbr()
     * @uses SalesOrderDetailAllocation::setOrderType()
     * @uses SalesOrderDetailAllocation::setQty()
     * @uses SalesOrderDetailAllocation::setQtyOnShipments()
     * @uses SalesOrderDetailAllocation::setQtyReceived()
     * @uses SalesOrderDetailAllocation::setRelatedDocument()
     * @uses SalesOrderDetailAllocation::setShipOn()
     * @uses SalesOrderDetailAllocation::setSplitLineNbr()
     * @uses SalesOrderDetailAllocation::setSubitem()
     * @uses SalesOrderDetailAllocation::setUOM()
     * @param \AcumaticaConfig\StructType\BooleanValue $allocated
     * @param \AcumaticaConfig\StructType\StringValue $allocWarehouseID
     * @param \AcumaticaConfig\StructType\BooleanValue $completed
     * @param \AcumaticaConfig\StructType\DateTimeValue $expirationDate
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\IntValue $lineNbr
     * @param \AcumaticaConfig\StructType\StringValue $locationID
     * @param \AcumaticaConfig\StructType\StringValue $lotSerialNbr
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @param \AcumaticaConfig\StructType\DecimalValue $qty
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyOnShipments
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyReceived
     * @param \AcumaticaConfig\StructType\StringValue $relatedDocument
     * @param \AcumaticaConfig\StructType\DateTimeValue $shipOn
     * @param \AcumaticaConfig\StructType\IntValue $splitLineNbr
     * @param \AcumaticaConfig\StructType\StringValue $subitem
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     */
    public function __construct(\AcumaticaConfig\StructType\BooleanValue $allocated = null, \AcumaticaConfig\StructType\StringValue $allocWarehouseID = null, \AcumaticaConfig\StructType\BooleanValue $completed = null, \AcumaticaConfig\StructType\DateTimeValue $expirationDate = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\IntValue $lineNbr = null, \AcumaticaConfig\StructType\StringValue $locationID = null, \AcumaticaConfig\StructType\StringValue $lotSerialNbr = null, \AcumaticaConfig\StructType\StringValue $orderNbr = null, \AcumaticaConfig\StructType\StringValue $orderType = null, \AcumaticaConfig\StructType\DecimalValue $qty = null, \AcumaticaConfig\StructType\DecimalValue $qtyOnShipments = null, \AcumaticaConfig\StructType\DecimalValue $qtyReceived = null, \AcumaticaConfig\StructType\StringValue $relatedDocument = null, \AcumaticaConfig\StructType\DateTimeValue $shipOn = null, \AcumaticaConfig\StructType\IntValue $splitLineNbr = null, \AcumaticaConfig\StructType\StringValue $subitem = null, \AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        $this
            ->setAllocated($allocated)
            ->setAllocWarehouseID($allocWarehouseID)
            ->setCompleted($completed)
            ->setExpirationDate($expirationDate)
            ->setInventoryID($inventoryID)
            ->setLineNbr($lineNbr)
            ->setLocationID($locationID)
            ->setLotSerialNbr($lotSerialNbr)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType)
            ->setQty($qty)
            ->setQtyOnShipments($qtyOnShipments)
            ->setQtyReceived($qtyReceived)
            ->setRelatedDocument($relatedDocument)
            ->setShipOn($shipOn)
            ->setSplitLineNbr($splitLineNbr)
            ->setSubitem($subitem)
            ->setUOM($uOM);
    }
    /**
     * Get Allocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getAllocated()
    {
        return isset($this->Allocated) ? $this->Allocated : null;
    }
    /**
     * Set Allocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $allocated
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setAllocated(\AcumaticaConfig\StructType\BooleanValue $allocated = null)
    {
        if (is_null($allocated) || (is_array($allocated) && empty($allocated))) {
            unset($this->Allocated);
        } else {
            $this->Allocated = $allocated;
        }
        return $this;
    }
    /**
     * Get AllocWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAllocWarehouseID()
    {
        return isset($this->AllocWarehouseID) ? $this->AllocWarehouseID : null;
    }
    /**
     * Set AllocWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $allocWarehouseID
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setAllocWarehouseID(\AcumaticaConfig\StructType\StringValue $allocWarehouseID = null)
    {
        if (is_null($allocWarehouseID) || (is_array($allocWarehouseID) && empty($allocWarehouseID))) {
            unset($this->AllocWarehouseID);
        } else {
            $this->AllocWarehouseID = $allocWarehouseID;
        }
        return $this;
    }
    /**
     * Get Completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getCompleted()
    {
        return isset($this->Completed) ? $this->Completed : null;
    }
    /**
     * Set Completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $completed
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setCompleted(\AcumaticaConfig\StructType\BooleanValue $completed = null)
    {
        if (is_null($completed) || (is_array($completed) && empty($completed))) {
            unset($this->Completed);
        } else {
            $this->Completed = $completed;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $expirationDate
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setExpirationDate(\AcumaticaConfig\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $lineNbr
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setLineNbr(\AcumaticaConfig\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $locationID
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setLocationID(\AcumaticaConfig\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $lotSerialNbr
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setLotSerialNbr(\AcumaticaConfig\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setOrderNbr(\AcumaticaConfig\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setOrderType(\AcumaticaConfig\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qty
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setQty(\AcumaticaConfig\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQtyOnShipments()
    {
        return isset($this->QtyOnShipments) ? $this->QtyOnShipments : null;
    }
    /**
     * Set QtyOnShipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyOnShipments
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setQtyOnShipments(\AcumaticaConfig\StructType\DecimalValue $qtyOnShipments = null)
    {
        if (is_null($qtyOnShipments) || (is_array($qtyOnShipments) && empty($qtyOnShipments))) {
            unset($this->QtyOnShipments);
        } else {
            $this->QtyOnShipments = $qtyOnShipments;
        }
        return $this;
    }
    /**
     * Get QtyReceived value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQtyReceived()
    {
        return isset($this->QtyReceived) ? $this->QtyReceived : null;
    }
    /**
     * Set QtyReceived value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyReceived
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setQtyReceived(\AcumaticaConfig\StructType\DecimalValue $qtyReceived = null)
    {
        if (is_null($qtyReceived) || (is_array($qtyReceived) && empty($qtyReceived))) {
            unset($this->QtyReceived);
        } else {
            $this->QtyReceived = $qtyReceived;
        }
        return $this;
    }
    /**
     * Get RelatedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getRelatedDocument()
    {
        return isset($this->RelatedDocument) ? $this->RelatedDocument : null;
    }
    /**
     * Set RelatedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $relatedDocument
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setRelatedDocument(\AcumaticaConfig\StructType\StringValue $relatedDocument = null)
    {
        if (is_null($relatedDocument) || (is_array($relatedDocument) && empty($relatedDocument))) {
            unset($this->RelatedDocument);
        } else {
            $this->RelatedDocument = $relatedDocument;
        }
        return $this;
    }
    /**
     * Get ShipOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getShipOn()
    {
        return isset($this->ShipOn) ? $this->ShipOn : null;
    }
    /**
     * Set ShipOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $shipOn
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setShipOn(\AcumaticaConfig\StructType\DateTimeValue $shipOn = null)
    {
        if (is_null($shipOn) || (is_array($shipOn) && empty($shipOn))) {
            unset($this->ShipOn);
        } else {
            $this->ShipOn = $shipOn;
        }
        return $this;
    }
    /**
     * Get SplitLineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getSplitLineNbr()
    {
        return isset($this->SplitLineNbr) ? $this->SplitLineNbr : null;
    }
    /**
     * Set SplitLineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $splitLineNbr
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setSplitLineNbr(\AcumaticaConfig\StructType\IntValue $splitLineNbr = null)
    {
        if (is_null($splitLineNbr) || (is_array($splitLineNbr) && empty($splitLineNbr))) {
            unset($this->SplitLineNbr);
        } else {
            $this->SplitLineNbr = $splitLineNbr;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $subitem
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setSubitem(\AcumaticaConfig\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public function setUOM(\AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
