<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrder StructType
 * @subpackage Structs
 */
class SalesOrder extends Entity
{
    /**
     * The Approved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Approved;
    /**
     * The BaseCurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $BaseCurrencyID;
    /**
     * The BillToAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Address
     */
    public $BillToAddress;
    /**
     * The BillToAddressOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BillToAddressOverride;
    /**
     * The BillToAddressValidated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BillToAddressValidated;
    /**
     * The BillToContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DocContact
     */
    public $BillToContact;
    /**
     * The BillToContactOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BillToContactOverride;
    /**
     * The CashAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CashAccount;
    /**
     * The Commissions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Commissions
     */
    public $Commissions;
    /**
     * The ControlTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ControlTotal;
    /**
     * The CreditHold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $CreditHold;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CurrencyRate;
    /**
     * The CurrencyRateTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyRateTypeID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerOrder;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The DestinationWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DestinationWarehouseID;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Details
     */
    public $Details;
    /**
     * The DiscountDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DiscountDetails
     */
    public $DiscountDetails;
    /**
     * The DiscountTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DiscountTotal;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $EffectiveDate;
    /**
     * The ExternalRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ExternalRef;
    /**
     * The FinancialSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\FinancialSettings
     */
    public $FinancialSettings;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The IsTaxValid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IsTaxValid;
    /**
     * The LastModified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModified;
    /**
     * The LineTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $LineTotal;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LocationID;
    /**
     * The MiscTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MiscTotal;
    /**
     * The NewCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $NewCard;
    /**
     * The OrderedQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OrderedQty;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OrderTotal;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderType;
    /**
     * The PaymentCardIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PaymentCardIdentifier;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The Payments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Payments
     */
    public $Payments;
    /**
     * The PreAuthorizationNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PreAuthorizationNbr;
    /**
     * The PreAuthorizedAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $PreAuthorizedAmount;
    /**
     * The PreferredWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PreferredWarehouseID;
    /**
     * The ProcCenterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProcCenterID;
    /**
     * The Project
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Project;
    /**
     * The ReciprocalRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ReciprocalRate;
    /**
     * The RequestedOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $RequestedOn;
    /**
     * The Shipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Shipments
     */
    public $Shipments;
    /**
     * The ShippingSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShippingSettings
     */
    public $ShippingSettings;
    /**
     * The ShipToAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Address
     */
    public $ShipToAddress;
    /**
     * The ShipToAddressOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipToAddressOverride;
    /**
     * The ShipToAddressValidated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipToAddressValidated;
    /**
     * The ShipToContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DocContact
     */
    public $ShipToContact;
    /**
     * The ShipToContactOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipToContactOverride;
    /**
     * The ShipVia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TaxDetails
     */
    public $TaxDetails;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * The Totals
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Totals
     */
    public $Totals;
    /**
     * The VATExemptTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $VATExemptTotal;
    /**
     * The VATTaxableTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $VATTaxableTotal;
    /**
     * Constructor method for SalesOrder
     * @uses SalesOrder::setApproved()
     * @uses SalesOrder::setBaseCurrencyID()
     * @uses SalesOrder::setBillToAddress()
     * @uses SalesOrder::setBillToAddressOverride()
     * @uses SalesOrder::setBillToAddressValidated()
     * @uses SalesOrder::setBillToContact()
     * @uses SalesOrder::setBillToContactOverride()
     * @uses SalesOrder::setCashAccount()
     * @uses SalesOrder::setCommissions()
     * @uses SalesOrder::setControlTotal()
     * @uses SalesOrder::setCreditHold()
     * @uses SalesOrder::setCurrencyID()
     * @uses SalesOrder::setCurrencyRate()
     * @uses SalesOrder::setCurrencyRateTypeID()
     * @uses SalesOrder::setCustomerID()
     * @uses SalesOrder::setCustomerOrder()
     * @uses SalesOrder::setDate()
     * @uses SalesOrder::setDescription()
     * @uses SalesOrder::setDestinationWarehouseID()
     * @uses SalesOrder::setDetails()
     * @uses SalesOrder::setDiscountDetails()
     * @uses SalesOrder::setDiscountTotal()
     * @uses SalesOrder::setEffectiveDate()
     * @uses SalesOrder::setExternalRef()
     * @uses SalesOrder::setFinancialSettings()
     * @uses SalesOrder::setHold()
     * @uses SalesOrder::setIsTaxValid()
     * @uses SalesOrder::setLastModified()
     * @uses SalesOrder::setLineTotal()
     * @uses SalesOrder::setLocationID()
     * @uses SalesOrder::setMiscTotal()
     * @uses SalesOrder::setNewCard()
     * @uses SalesOrder::setOrderedQty()
     * @uses SalesOrder::setOrderNbr()
     * @uses SalesOrder::setOrderTotal()
     * @uses SalesOrder::setOrderType()
     * @uses SalesOrder::setPaymentCardIdentifier()
     * @uses SalesOrder::setPaymentMethod()
     * @uses SalesOrder::setPaymentRef()
     * @uses SalesOrder::setPayments()
     * @uses SalesOrder::setPreAuthorizationNbr()
     * @uses SalesOrder::setPreAuthorizedAmount()
     * @uses SalesOrder::setPreferredWarehouseID()
     * @uses SalesOrder::setProcCenterID()
     * @uses SalesOrder::setProject()
     * @uses SalesOrder::setReciprocalRate()
     * @uses SalesOrder::setRequestedOn()
     * @uses SalesOrder::setShipments()
     * @uses SalesOrder::setShippingSettings()
     * @uses SalesOrder::setShipToAddress()
     * @uses SalesOrder::setShipToAddressOverride()
     * @uses SalesOrder::setShipToAddressValidated()
     * @uses SalesOrder::setShipToContact()
     * @uses SalesOrder::setShipToContactOverride()
     * @uses SalesOrder::setShipVia()
     * @uses SalesOrder::setStatus()
     * @uses SalesOrder::setTaxDetails()
     * @uses SalesOrder::setTaxTotal()
     * @uses SalesOrder::setTotals()
     * @uses SalesOrder::setVATExemptTotal()
     * @uses SalesOrder::setVATTaxableTotal()
     * @param \AcumaticaConfig\StructType\BooleanValue $approved
     * @param \AcumaticaConfig\StructType\StringValue $baseCurrencyID
     * @param \AcumaticaConfig\StructType\Address $billToAddress
     * @param \AcumaticaConfig\StructType\BooleanValue $billToAddressOverride
     * @param \AcumaticaConfig\StructType\BooleanValue $billToAddressValidated
     * @param \AcumaticaConfig\StructType\DocContact $billToContact
     * @param \AcumaticaConfig\StructType\BooleanValue $billToContactOverride
     * @param \AcumaticaConfig\StructType\StringValue $cashAccount
     * @param \AcumaticaConfig\StructType\Commissions $commissions
     * @param \AcumaticaConfig\StructType\DecimalValue $controlTotal
     * @param \AcumaticaConfig\StructType\BooleanValue $creditHold
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyRate
     * @param \AcumaticaConfig\StructType\StringValue $currencyRateTypeID
     * @param \AcumaticaConfig\StructType\StringValue $customerID
     * @param \AcumaticaConfig\StructType\StringValue $customerOrder
     * @param \AcumaticaConfig\StructType\DateTimeValue $date
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $destinationWarehouseID
     * @param \AcumaticaConfig\StructType\Details $details
     * @param \AcumaticaConfig\StructType\DiscountDetails $discountDetails
     * @param \AcumaticaConfig\StructType\DecimalValue $discountTotal
     * @param \AcumaticaConfig\StructType\DateTimeValue $effectiveDate
     * @param \AcumaticaConfig\StructType\StringValue $externalRef
     * @param \AcumaticaConfig\StructType\FinancialSettings $financialSettings
     * @param \AcumaticaConfig\StructType\BooleanValue $hold
     * @param \AcumaticaConfig\StructType\BooleanValue $isTaxValid
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModified
     * @param \AcumaticaConfig\StructType\DecimalValue $lineTotal
     * @param \AcumaticaConfig\StructType\StringValue $locationID
     * @param \AcumaticaConfig\StructType\DecimalValue $miscTotal
     * @param \AcumaticaConfig\StructType\BooleanValue $newCard
     * @param \AcumaticaConfig\StructType\DecimalValue $orderedQty
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @param \AcumaticaConfig\StructType\DecimalValue $orderTotal
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @param \AcumaticaConfig\StructType\StringValue $paymentCardIdentifier
     * @param \AcumaticaConfig\StructType\StringValue $paymentMethod
     * @param \AcumaticaConfig\StructType\StringValue $paymentRef
     * @param \AcumaticaConfig\StructType\Payments $payments
     * @param \AcumaticaConfig\StructType\StringValue $preAuthorizationNbr
     * @param \AcumaticaConfig\StructType\DecimalValue $preAuthorizedAmount
     * @param \AcumaticaConfig\StructType\StringValue $preferredWarehouseID
     * @param \AcumaticaConfig\StructType\StringValue $procCenterID
     * @param \AcumaticaConfig\StructType\StringValue $project
     * @param \AcumaticaConfig\StructType\DecimalValue $reciprocalRate
     * @param \AcumaticaConfig\StructType\DateTimeValue $requestedOn
     * @param \AcumaticaConfig\StructType\Shipments $shipments
     * @param \AcumaticaConfig\StructType\ShippingSettings $shippingSettings
     * @param \AcumaticaConfig\StructType\Address $shipToAddress
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressValidated
     * @param \AcumaticaConfig\StructType\DocContact $shipToContact
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\TaxDetails $taxDetails
     * @param \AcumaticaConfig\StructType\DecimalValue $taxTotal
     * @param \AcumaticaConfig\StructType\Totals $totals
     * @param \AcumaticaConfig\StructType\DecimalValue $vATExemptTotal
     * @param \AcumaticaConfig\StructType\DecimalValue $vATTaxableTotal
     */
    public function __construct(\AcumaticaConfig\StructType\BooleanValue $approved = null, \AcumaticaConfig\StructType\StringValue $baseCurrencyID = null, \AcumaticaConfig\StructType\Address $billToAddress = null, \AcumaticaConfig\StructType\BooleanValue $billToAddressOverride = null, \AcumaticaConfig\StructType\BooleanValue $billToAddressValidated = null, \AcumaticaConfig\StructType\DocContact $billToContact = null, \AcumaticaConfig\StructType\BooleanValue $billToContactOverride = null, \AcumaticaConfig\StructType\StringValue $cashAccount = null, \AcumaticaConfig\StructType\Commissions $commissions = null, \AcumaticaConfig\StructType\DecimalValue $controlTotal = null, \AcumaticaConfig\StructType\BooleanValue $creditHold = null, \AcumaticaConfig\StructType\StringValue $currencyID = null, \AcumaticaConfig\StructType\DecimalValue $currencyRate = null, \AcumaticaConfig\StructType\StringValue $currencyRateTypeID = null, \AcumaticaConfig\StructType\StringValue $customerID = null, \AcumaticaConfig\StructType\StringValue $customerOrder = null, \AcumaticaConfig\StructType\DateTimeValue $date = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $destinationWarehouseID = null, \AcumaticaConfig\StructType\Details $details = null, \AcumaticaConfig\StructType\DiscountDetails $discountDetails = null, \AcumaticaConfig\StructType\DecimalValue $discountTotal = null, \AcumaticaConfig\StructType\DateTimeValue $effectiveDate = null, \AcumaticaConfig\StructType\StringValue $externalRef = null, \AcumaticaConfig\StructType\FinancialSettings $financialSettings = null, \AcumaticaConfig\StructType\BooleanValue $hold = null, \AcumaticaConfig\StructType\BooleanValue $isTaxValid = null, \AcumaticaConfig\StructType\DateTimeValue $lastModified = null, \AcumaticaConfig\StructType\DecimalValue $lineTotal = null, \AcumaticaConfig\StructType\StringValue $locationID = null, \AcumaticaConfig\StructType\DecimalValue $miscTotal = null, \AcumaticaConfig\StructType\BooleanValue $newCard = null, \AcumaticaConfig\StructType\DecimalValue $orderedQty = null, \AcumaticaConfig\StructType\StringValue $orderNbr = null, \AcumaticaConfig\StructType\DecimalValue $orderTotal = null, \AcumaticaConfig\StructType\StringValue $orderType = null, \AcumaticaConfig\StructType\StringValue $paymentCardIdentifier = null, \AcumaticaConfig\StructType\StringValue $paymentMethod = null, \AcumaticaConfig\StructType\StringValue $paymentRef = null, \AcumaticaConfig\StructType\Payments $payments = null, \AcumaticaConfig\StructType\StringValue $preAuthorizationNbr = null, \AcumaticaConfig\StructType\DecimalValue $preAuthorizedAmount = null, \AcumaticaConfig\StructType\StringValue $preferredWarehouseID = null, \AcumaticaConfig\StructType\StringValue $procCenterID = null, \AcumaticaConfig\StructType\StringValue $project = null, \AcumaticaConfig\StructType\DecimalValue $reciprocalRate = null, \AcumaticaConfig\StructType\DateTimeValue $requestedOn = null, \AcumaticaConfig\StructType\Shipments $shipments = null, \AcumaticaConfig\StructType\ShippingSettings $shippingSettings = null, \AcumaticaConfig\StructType\Address $shipToAddress = null, \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride = null, \AcumaticaConfig\StructType\BooleanValue $shipToAddressValidated = null, \AcumaticaConfig\StructType\DocContact $shipToContact = null, \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride = null, \AcumaticaConfig\StructType\StringValue $shipVia = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\TaxDetails $taxDetails = null, \AcumaticaConfig\StructType\DecimalValue $taxTotal = null, \AcumaticaConfig\StructType\Totals $totals = null, \AcumaticaConfig\StructType\DecimalValue $vATExemptTotal = null, \AcumaticaConfig\StructType\DecimalValue $vATTaxableTotal = null)
    {
        $this
            ->setApproved($approved)
            ->setBaseCurrencyID($baseCurrencyID)
            ->setBillToAddress($billToAddress)
            ->setBillToAddressOverride($billToAddressOverride)
            ->setBillToAddressValidated($billToAddressValidated)
            ->setBillToContact($billToContact)
            ->setBillToContactOverride($billToContactOverride)
            ->setCashAccount($cashAccount)
            ->setCommissions($commissions)
            ->setControlTotal($controlTotal)
            ->setCreditHold($creditHold)
            ->setCurrencyID($currencyID)
            ->setCurrencyRate($currencyRate)
            ->setCurrencyRateTypeID($currencyRateTypeID)
            ->setCustomerID($customerID)
            ->setCustomerOrder($customerOrder)
            ->setDate($date)
            ->setDescription($description)
            ->setDestinationWarehouseID($destinationWarehouseID)
            ->setDetails($details)
            ->setDiscountDetails($discountDetails)
            ->setDiscountTotal($discountTotal)
            ->setEffectiveDate($effectiveDate)
            ->setExternalRef($externalRef)
            ->setFinancialSettings($financialSettings)
            ->setHold($hold)
            ->setIsTaxValid($isTaxValid)
            ->setLastModified($lastModified)
            ->setLineTotal($lineTotal)
            ->setLocationID($locationID)
            ->setMiscTotal($miscTotal)
            ->setNewCard($newCard)
            ->setOrderedQty($orderedQty)
            ->setOrderNbr($orderNbr)
            ->setOrderTotal($orderTotal)
            ->setOrderType($orderType)
            ->setPaymentCardIdentifier($paymentCardIdentifier)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentRef($paymentRef)
            ->setPayments($payments)
            ->setPreAuthorizationNbr($preAuthorizationNbr)
            ->setPreAuthorizedAmount($preAuthorizedAmount)
            ->setPreferredWarehouseID($preferredWarehouseID)
            ->setProcCenterID($procCenterID)
            ->setProject($project)
            ->setReciprocalRate($reciprocalRate)
            ->setRequestedOn($requestedOn)
            ->setShipments($shipments)
            ->setShippingSettings($shippingSettings)
            ->setShipToAddress($shipToAddress)
            ->setShipToAddressOverride($shipToAddressOverride)
            ->setShipToAddressValidated($shipToAddressValidated)
            ->setShipToContact($shipToContact)
            ->setShipToContactOverride($shipToContactOverride)
            ->setShipVia($shipVia)
            ->setStatus($status)
            ->setTaxDetails($taxDetails)
            ->setTaxTotal($taxTotal)
            ->setTotals($totals)
            ->setVATExemptTotal($vATExemptTotal)
            ->setVATTaxableTotal($vATTaxableTotal);
    }
    /**
     * Get Approved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getApproved()
    {
        return isset($this->Approved) ? $this->Approved : null;
    }
    /**
     * Set Approved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $approved
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setApproved(\AcumaticaConfig\StructType\BooleanValue $approved = null)
    {
        if (is_null($approved) || (is_array($approved) && empty($approved))) {
            unset($this->Approved);
        } else {
            $this->Approved = $approved;
        }
        return $this;
    }
    /**
     * Get BaseCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBaseCurrencyID()
    {
        return isset($this->BaseCurrencyID) ? $this->BaseCurrencyID : null;
    }
    /**
     * Set BaseCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $baseCurrencyID
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setBaseCurrencyID(\AcumaticaConfig\StructType\StringValue $baseCurrencyID = null)
    {
        if (is_null($baseCurrencyID) || (is_array($baseCurrencyID) && empty($baseCurrencyID))) {
            unset($this->BaseCurrencyID);
        } else {
            $this->BaseCurrencyID = $baseCurrencyID;
        }
        return $this;
    }
    /**
     * Get BillToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Address|null
     */
    public function getBillToAddress()
    {
        return isset($this->BillToAddress) ? $this->BillToAddress : null;
    }
    /**
     * Set BillToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Address $billToAddress
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setBillToAddress(\AcumaticaConfig\StructType\Address $billToAddress = null)
    {
        if (is_null($billToAddress) || (is_array($billToAddress) && empty($billToAddress))) {
            unset($this->BillToAddress);
        } else {
            $this->BillToAddress = $billToAddress;
        }
        return $this;
    }
    /**
     * Get BillToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBillToAddressOverride()
    {
        return isset($this->BillToAddressOverride) ? $this->BillToAddressOverride : null;
    }
    /**
     * Set BillToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $billToAddressOverride
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setBillToAddressOverride(\AcumaticaConfig\StructType\BooleanValue $billToAddressOverride = null)
    {
        if (is_null($billToAddressOverride) || (is_array($billToAddressOverride) && empty($billToAddressOverride))) {
            unset($this->BillToAddressOverride);
        } else {
            $this->BillToAddressOverride = $billToAddressOverride;
        }
        return $this;
    }
    /**
     * Get BillToAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBillToAddressValidated()
    {
        return isset($this->BillToAddressValidated) ? $this->BillToAddressValidated : null;
    }
    /**
     * Set BillToAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $billToAddressValidated
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setBillToAddressValidated(\AcumaticaConfig\StructType\BooleanValue $billToAddressValidated = null)
    {
        if (is_null($billToAddressValidated) || (is_array($billToAddressValidated) && empty($billToAddressValidated))) {
            unset($this->BillToAddressValidated);
        } else {
            $this->BillToAddressValidated = $billToAddressValidated;
        }
        return $this;
    }
    /**
     * Get BillToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DocContact|null
     */
    public function getBillToContact()
    {
        return isset($this->BillToContact) ? $this->BillToContact : null;
    }
    /**
     * Set BillToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DocContact $billToContact
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setBillToContact(\AcumaticaConfig\StructType\DocContact $billToContact = null)
    {
        if (is_null($billToContact) || (is_array($billToContact) && empty($billToContact))) {
            unset($this->BillToContact);
        } else {
            $this->BillToContact = $billToContact;
        }
        return $this;
    }
    /**
     * Get BillToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBillToContactOverride()
    {
        return isset($this->BillToContactOverride) ? $this->BillToContactOverride : null;
    }
    /**
     * Set BillToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $billToContactOverride
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setBillToContactOverride(\AcumaticaConfig\StructType\BooleanValue $billToContactOverride = null)
    {
        if (is_null($billToContactOverride) || (is_array($billToContactOverride) && empty($billToContactOverride))) {
            unset($this->BillToContactOverride);
        } else {
            $this->BillToContactOverride = $billToContactOverride;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $cashAccount
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setCashAccount(\AcumaticaConfig\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get Commissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Commissions|null
     */
    public function getCommissions()
    {
        return isset($this->Commissions) ? $this->Commissions : null;
    }
    /**
     * Set Commissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Commissions $commissions
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setCommissions(\AcumaticaConfig\StructType\Commissions $commissions = null)
    {
        if (is_null($commissions) || (is_array($commissions) && empty($commissions))) {
            unset($this->Commissions);
        } else {
            $this->Commissions = $commissions;
        }
        return $this;
    }
    /**
     * Get ControlTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getControlTotal()
    {
        return isset($this->ControlTotal) ? $this->ControlTotal : null;
    }
    /**
     * Set ControlTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $controlTotal
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setControlTotal(\AcumaticaConfig\StructType\DecimalValue $controlTotal = null)
    {
        if (is_null($controlTotal) || (is_array($controlTotal) && empty($controlTotal))) {
            unset($this->ControlTotal);
        } else {
            $this->ControlTotal = $controlTotal;
        }
        return $this;
    }
    /**
     * Get CreditHold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getCreditHold()
    {
        return isset($this->CreditHold) ? $this->CreditHold : null;
    }
    /**
     * Set CreditHold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $creditHold
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setCreditHold(\AcumaticaConfig\StructType\BooleanValue $creditHold = null)
    {
        if (is_null($creditHold) || (is_array($creditHold) && empty($creditHold))) {
            unset($this->CreditHold);
        } else {
            $this->CreditHold = $creditHold;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setCurrencyID(\AcumaticaConfig\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyRate
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setCurrencyRate(\AcumaticaConfig\StructType\DecimalValue $currencyRate = null)
    {
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get CurrencyRateTypeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyRateTypeID()
    {
        return isset($this->CurrencyRateTypeID) ? $this->CurrencyRateTypeID : null;
    }
    /**
     * Set CurrencyRateTypeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyRateTypeID
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setCurrencyRateTypeID(\AcumaticaConfig\StructType\StringValue $currencyRateTypeID = null)
    {
        if (is_null($currencyRateTypeID) || (is_array($currencyRateTypeID) && empty($currencyRateTypeID))) {
            unset($this->CurrencyRateTypeID);
        } else {
            $this->CurrencyRateTypeID = $currencyRateTypeID;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerID
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setCustomerID(\AcumaticaConfig\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerOrder
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setCustomerOrder(\AcumaticaConfig\StructType\StringValue $customerOrder = null)
    {
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $date
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setDate(\AcumaticaConfig\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DestinationWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDestinationWarehouseID()
    {
        return isset($this->DestinationWarehouseID) ? $this->DestinationWarehouseID : null;
    }
    /**
     * Set DestinationWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $destinationWarehouseID
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setDestinationWarehouseID(\AcumaticaConfig\StructType\StringValue $destinationWarehouseID = null)
    {
        if (is_null($destinationWarehouseID) || (is_array($destinationWarehouseID) && empty($destinationWarehouseID))) {
            unset($this->DestinationWarehouseID);
        } else {
            $this->DestinationWarehouseID = $destinationWarehouseID;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Details $details
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setDetails(\AcumaticaConfig\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get DiscountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DiscountDetails|null
     */
    public function getDiscountDetails()
    {
        return isset($this->DiscountDetails) ? $this->DiscountDetails : null;
    }
    /**
     * Set DiscountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DiscountDetails $discountDetails
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setDiscountDetails(\AcumaticaConfig\StructType\DiscountDetails $discountDetails = null)
    {
        if (is_null($discountDetails) || (is_array($discountDetails) && empty($discountDetails))) {
            unset($this->DiscountDetails);
        } else {
            $this->DiscountDetails = $discountDetails;
        }
        return $this;
    }
    /**
     * Get DiscountTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDiscountTotal()
    {
        return isset($this->DiscountTotal) ? $this->DiscountTotal : null;
    }
    /**
     * Set DiscountTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $discountTotal
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setDiscountTotal(\AcumaticaConfig\StructType\DecimalValue $discountTotal = null)
    {
        if (is_null($discountTotal) || (is_array($discountTotal) && empty($discountTotal))) {
            unset($this->DiscountTotal);
        } else {
            $this->DiscountTotal = $discountTotal;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getEffectiveDate()
    {
        return isset($this->EffectiveDate) ? $this->EffectiveDate : null;
    }
    /**
     * Set EffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $effectiveDate
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setEffectiveDate(\AcumaticaConfig\StructType\DateTimeValue $effectiveDate = null)
    {
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->EffectiveDate);
        } else {
            $this->EffectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get ExternalRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getExternalRef()
    {
        return isset($this->ExternalRef) ? $this->ExternalRef : null;
    }
    /**
     * Set ExternalRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $externalRef
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setExternalRef(\AcumaticaConfig\StructType\StringValue $externalRef = null)
    {
        if (is_null($externalRef) || (is_array($externalRef) && empty($externalRef))) {
            unset($this->ExternalRef);
        } else {
            $this->ExternalRef = $externalRef;
        }
        return $this;
    }
    /**
     * Get FinancialSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\FinancialSettings|null
     */
    public function getFinancialSettings()
    {
        return isset($this->FinancialSettings) ? $this->FinancialSettings : null;
    }
    /**
     * Set FinancialSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\FinancialSettings $financialSettings
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setFinancialSettings(\AcumaticaConfig\StructType\FinancialSettings $financialSettings = null)
    {
        if (is_null($financialSettings) || (is_array($financialSettings) && empty($financialSettings))) {
            unset($this->FinancialSettings);
        } else {
            $this->FinancialSettings = $financialSettings;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $hold
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setHold(\AcumaticaConfig\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get IsTaxValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIsTaxValid()
    {
        return isset($this->IsTaxValid) ? $this->IsTaxValid : null;
    }
    /**
     * Set IsTaxValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $isTaxValid
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setIsTaxValid(\AcumaticaConfig\StructType\BooleanValue $isTaxValid = null)
    {
        if (is_null($isTaxValid) || (is_array($isTaxValid) && empty($isTaxValid))) {
            unset($this->IsTaxValid);
        } else {
            $this->IsTaxValid = $isTaxValid;
        }
        return $this;
    }
    /**
     * Get LastModified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModified()
    {
        return isset($this->LastModified) ? $this->LastModified : null;
    }
    /**
     * Set LastModified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModified
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setLastModified(\AcumaticaConfig\StructType\DateTimeValue $lastModified = null)
    {
        if (is_null($lastModified) || (is_array($lastModified) && empty($lastModified))) {
            unset($this->LastModified);
        } else {
            $this->LastModified = $lastModified;
        }
        return $this;
    }
    /**
     * Get LineTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getLineTotal()
    {
        return isset($this->LineTotal) ? $this->LineTotal : null;
    }
    /**
     * Set LineTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $lineTotal
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setLineTotal(\AcumaticaConfig\StructType\DecimalValue $lineTotal = null)
    {
        if (is_null($lineTotal) || (is_array($lineTotal) && empty($lineTotal))) {
            unset($this->LineTotal);
        } else {
            $this->LineTotal = $lineTotal;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $locationID
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setLocationID(\AcumaticaConfig\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get MiscTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMiscTotal()
    {
        return isset($this->MiscTotal) ? $this->MiscTotal : null;
    }
    /**
     * Set MiscTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $miscTotal
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setMiscTotal(\AcumaticaConfig\StructType\DecimalValue $miscTotal = null)
    {
        if (is_null($miscTotal) || (is_array($miscTotal) && empty($miscTotal))) {
            unset($this->MiscTotal);
        } else {
            $this->MiscTotal = $miscTotal;
        }
        return $this;
    }
    /**
     * Get NewCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getNewCard()
    {
        return isset($this->NewCard) ? $this->NewCard : null;
    }
    /**
     * Set NewCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $newCard
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setNewCard(\AcumaticaConfig\StructType\BooleanValue $newCard = null)
    {
        if (is_null($newCard) || (is_array($newCard) && empty($newCard))) {
            unset($this->NewCard);
        } else {
            $this->NewCard = $newCard;
        }
        return $this;
    }
    /**
     * Get OrderedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOrderedQty()
    {
        return isset($this->OrderedQty) ? $this->OrderedQty : null;
    }
    /**
     * Set OrderedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $orderedQty
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setOrderedQty(\AcumaticaConfig\StructType\DecimalValue $orderedQty = null)
    {
        if (is_null($orderedQty) || (is_array($orderedQty) && empty($orderedQty))) {
            unset($this->OrderedQty);
        } else {
            $this->OrderedQty = $orderedQty;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setOrderNbr(\AcumaticaConfig\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOrderTotal()
    {
        return isset($this->OrderTotal) ? $this->OrderTotal : null;
    }
    /**
     * Set OrderTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $orderTotal
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setOrderTotal(\AcumaticaConfig\StructType\DecimalValue $orderTotal = null)
    {
        if (is_null($orderTotal) || (is_array($orderTotal) && empty($orderTotal))) {
            unset($this->OrderTotal);
        } else {
            $this->OrderTotal = $orderTotal;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setOrderType(\AcumaticaConfig\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get PaymentCardIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPaymentCardIdentifier()
    {
        return isset($this->PaymentCardIdentifier) ? $this->PaymentCardIdentifier : null;
    }
    /**
     * Set PaymentCardIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $paymentCardIdentifier
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setPaymentCardIdentifier(\AcumaticaConfig\StructType\StringValue $paymentCardIdentifier = null)
    {
        if (is_null($paymentCardIdentifier) || (is_array($paymentCardIdentifier) && empty($paymentCardIdentifier))) {
            unset($this->PaymentCardIdentifier);
        } else {
            $this->PaymentCardIdentifier = $paymentCardIdentifier;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $paymentMethod
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setPaymentMethod(\AcumaticaConfig\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $paymentRef
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setPaymentRef(\AcumaticaConfig\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get Payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Payments|null
     */
    public function getPayments()
    {
        return isset($this->Payments) ? $this->Payments : null;
    }
    /**
     * Set Payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Payments $payments
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setPayments(\AcumaticaConfig\StructType\Payments $payments = null)
    {
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->Payments);
        } else {
            $this->Payments = $payments;
        }
        return $this;
    }
    /**
     * Get PreAuthorizationNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPreAuthorizationNbr()
    {
        return isset($this->PreAuthorizationNbr) ? $this->PreAuthorizationNbr : null;
    }
    /**
     * Set PreAuthorizationNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $preAuthorizationNbr
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setPreAuthorizationNbr(\AcumaticaConfig\StructType\StringValue $preAuthorizationNbr = null)
    {
        if (is_null($preAuthorizationNbr) || (is_array($preAuthorizationNbr) && empty($preAuthorizationNbr))) {
            unset($this->PreAuthorizationNbr);
        } else {
            $this->PreAuthorizationNbr = $preAuthorizationNbr;
        }
        return $this;
    }
    /**
     * Get PreAuthorizedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getPreAuthorizedAmount()
    {
        return isset($this->PreAuthorizedAmount) ? $this->PreAuthorizedAmount : null;
    }
    /**
     * Set PreAuthorizedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $preAuthorizedAmount
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setPreAuthorizedAmount(\AcumaticaConfig\StructType\DecimalValue $preAuthorizedAmount = null)
    {
        if (is_null($preAuthorizedAmount) || (is_array($preAuthorizedAmount) && empty($preAuthorizedAmount))) {
            unset($this->PreAuthorizedAmount);
        } else {
            $this->PreAuthorizedAmount = $preAuthorizedAmount;
        }
        return $this;
    }
    /**
     * Get PreferredWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPreferredWarehouseID()
    {
        return isset($this->PreferredWarehouseID) ? $this->PreferredWarehouseID : null;
    }
    /**
     * Set PreferredWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $preferredWarehouseID
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setPreferredWarehouseID(\AcumaticaConfig\StructType\StringValue $preferredWarehouseID = null)
    {
        if (is_null($preferredWarehouseID) || (is_array($preferredWarehouseID) && empty($preferredWarehouseID))) {
            unset($this->PreferredWarehouseID);
        } else {
            $this->PreferredWarehouseID = $preferredWarehouseID;
        }
        return $this;
    }
    /**
     * Get ProcCenterID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProcCenterID()
    {
        return isset($this->ProcCenterID) ? $this->ProcCenterID : null;
    }
    /**
     * Set ProcCenterID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $procCenterID
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setProcCenterID(\AcumaticaConfig\StructType\StringValue $procCenterID = null)
    {
        if (is_null($procCenterID) || (is_array($procCenterID) && empty($procCenterID))) {
            unset($this->ProcCenterID);
        } else {
            $this->ProcCenterID = $procCenterID;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $project
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setProject(\AcumaticaConfig\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ReciprocalRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getReciprocalRate()
    {
        return isset($this->ReciprocalRate) ? $this->ReciprocalRate : null;
    }
    /**
     * Set ReciprocalRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $reciprocalRate
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setReciprocalRate(\AcumaticaConfig\StructType\DecimalValue $reciprocalRate = null)
    {
        if (is_null($reciprocalRate) || (is_array($reciprocalRate) && empty($reciprocalRate))) {
            unset($this->ReciprocalRate);
        } else {
            $this->ReciprocalRate = $reciprocalRate;
        }
        return $this;
    }
    /**
     * Get RequestedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getRequestedOn()
    {
        return isset($this->RequestedOn) ? $this->RequestedOn : null;
    }
    /**
     * Set RequestedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $requestedOn
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setRequestedOn(\AcumaticaConfig\StructType\DateTimeValue $requestedOn = null)
    {
        if (is_null($requestedOn) || (is_array($requestedOn) && empty($requestedOn))) {
            unset($this->RequestedOn);
        } else {
            $this->RequestedOn = $requestedOn;
        }
        return $this;
    }
    /**
     * Get Shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Shipments|null
     */
    public function getShipments()
    {
        return isset($this->Shipments) ? $this->Shipments : null;
    }
    /**
     * Set Shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Shipments $shipments
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setShipments(\AcumaticaConfig\StructType\Shipments $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->Shipments);
        } else {
            $this->Shipments = $shipments;
        }
        return $this;
    }
    /**
     * Get ShippingSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShippingSettings|null
     */
    public function getShippingSettings()
    {
        return isset($this->ShippingSettings) ? $this->ShippingSettings : null;
    }
    /**
     * Set ShippingSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShippingSettings $shippingSettings
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setShippingSettings(\AcumaticaConfig\StructType\ShippingSettings $shippingSettings = null)
    {
        if (is_null($shippingSettings) || (is_array($shippingSettings) && empty($shippingSettings))) {
            unset($this->ShippingSettings);
        } else {
            $this->ShippingSettings = $shippingSettings;
        }
        return $this;
    }
    /**
     * Get ShipToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Address|null
     */
    public function getShipToAddress()
    {
        return isset($this->ShipToAddress) ? $this->ShipToAddress : null;
    }
    /**
     * Set ShipToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Address $shipToAddress
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setShipToAddress(\AcumaticaConfig\StructType\Address $shipToAddress = null)
    {
        if (is_null($shipToAddress) || (is_array($shipToAddress) && empty($shipToAddress))) {
            unset($this->ShipToAddress);
        } else {
            $this->ShipToAddress = $shipToAddress;
        }
        return $this;
    }
    /**
     * Get ShipToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipToAddressOverride()
    {
        return isset($this->ShipToAddressOverride) ? $this->ShipToAddressOverride : null;
    }
    /**
     * Set ShipToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setShipToAddressOverride(\AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride = null)
    {
        if (is_null($shipToAddressOverride) || (is_array($shipToAddressOverride) && empty($shipToAddressOverride))) {
            unset($this->ShipToAddressOverride);
        } else {
            $this->ShipToAddressOverride = $shipToAddressOverride;
        }
        return $this;
    }
    /**
     * Get ShipToAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipToAddressValidated()
    {
        return isset($this->ShipToAddressValidated) ? $this->ShipToAddressValidated : null;
    }
    /**
     * Set ShipToAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressValidated
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setShipToAddressValidated(\AcumaticaConfig\StructType\BooleanValue $shipToAddressValidated = null)
    {
        if (is_null($shipToAddressValidated) || (is_array($shipToAddressValidated) && empty($shipToAddressValidated))) {
            unset($this->ShipToAddressValidated);
        } else {
            $this->ShipToAddressValidated = $shipToAddressValidated;
        }
        return $this;
    }
    /**
     * Get ShipToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DocContact|null
     */
    public function getShipToContact()
    {
        return isset($this->ShipToContact) ? $this->ShipToContact : null;
    }
    /**
     * Set ShipToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DocContact $shipToContact
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setShipToContact(\AcumaticaConfig\StructType\DocContact $shipToContact = null)
    {
        if (is_null($shipToContact) || (is_array($shipToContact) && empty($shipToContact))) {
            unset($this->ShipToContact);
        } else {
            $this->ShipToContact = $shipToContact;
        }
        return $this;
    }
    /**
     * Get ShipToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipToContactOverride()
    {
        return isset($this->ShipToContactOverride) ? $this->ShipToContactOverride : null;
    }
    /**
     * Set ShipToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setShipToContactOverride(\AcumaticaConfig\StructType\BooleanValue $shipToContactOverride = null)
    {
        if (is_null($shipToContactOverride) || (is_array($shipToContactOverride) && empty($shipToContactOverride))) {
            unset($this->ShipToContactOverride);
        } else {
            $this->ShipToContactOverride = $shipToContactOverride;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setShipVia(\AcumaticaConfig\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TaxDetails|null
     */
    public function getTaxDetails()
    {
        return isset($this->TaxDetails) ? $this->TaxDetails : null;
    }
    /**
     * Set TaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\TaxDetails $taxDetails
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setTaxDetails(\AcumaticaConfig\StructType\TaxDetails $taxDetails = null)
    {
        if (is_null($taxDetails) || (is_array($taxDetails) && empty($taxDetails))) {
            unset($this->TaxDetails);
        } else {
            $this->TaxDetails = $taxDetails;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $taxTotal
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setTaxTotal(\AcumaticaConfig\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Totals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Totals $totals
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setTotals(\AcumaticaConfig\StructType\Totals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
    /**
     * Get VATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getVATExemptTotal()
    {
        return isset($this->VATExemptTotal) ? $this->VATExemptTotal : null;
    }
    /**
     * Set VATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $vATExemptTotal
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setVATExemptTotal(\AcumaticaConfig\StructType\DecimalValue $vATExemptTotal = null)
    {
        if (is_null($vATExemptTotal) || (is_array($vATExemptTotal) && empty($vATExemptTotal))) {
            unset($this->VATExemptTotal);
        } else {
            $this->VATExemptTotal = $vATExemptTotal;
        }
        return $this;
    }
    /**
     * Get VATTaxableTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getVATTaxableTotal()
    {
        return isset($this->VATTaxableTotal) ? $this->VATTaxableTotal : null;
    }
    /**
     * Set VATTaxableTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $vATTaxableTotal
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public function setVATTaxableTotal(\AcumaticaConfig\StructType\DecimalValue $vATTaxableTotal = null)
    {
        if (is_null($vATTaxableTotal) || (is_array($vATTaxableTotal) && empty($vATTaxableTotal))) {
            unset($this->VATTaxableTotal);
        } else {
            $this->VATTaxableTotal = $vATTaxableTotal;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SalesOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
