<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesCategories StructType
 * @subpackage Structs
 */
class SalesCategories extends AbstractStructBase
{
    /**
     * The NonStockItemSalesCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\NonStockItemSalesCategory[]
     */
    public $NonStockItemSalesCategory;
    /**
     * Constructor method for SalesCategories
     * @uses SalesCategories::setNonStockItemSalesCategory()
     * @param \AcumaticaConfig\StructType\NonStockItemSalesCategory[] $nonStockItemSalesCategory
     */
    public function __construct(array $nonStockItemSalesCategory = array())
    {
        $this
            ->setNonStockItemSalesCategory($nonStockItemSalesCategory);
    }
    /**
     * Get NonStockItemSalesCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\NonStockItemSalesCategory[]|null
     */
    public function getNonStockItemSalesCategory()
    {
        return isset($this->NonStockItemSalesCategory) ? $this->NonStockItemSalesCategory : null;
    }
    /**
     * Set NonStockItemSalesCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\NonStockItemSalesCategory[] $nonStockItemSalesCategory
     * @return \AcumaticaConfig\StructType\SalesCategories
     */
    public function setNonStockItemSalesCategory(array $nonStockItemSalesCategory = array())
    {
        foreach ($nonStockItemSalesCategory as $salesCategoriesNonStockItemSalesCategoryItem) {
            // validation for constraint: itemType
            if (!$salesCategoriesNonStockItemSalesCategoryItem instanceof \AcumaticaConfig\StructType\NonStockItemSalesCategory) {
                throw new \InvalidArgumentException(sprintf('The NonStockItemSalesCategory property can only contain items of \AcumaticaConfig\StructType\NonStockItemSalesCategory, "%s" given', is_object($salesCategoriesNonStockItemSalesCategoryItem) ? get_class($salesCategoriesNonStockItemSalesCategoryItem) : gettype($salesCategoriesNonStockItemSalesCategoryItem)), __LINE__);
            }
        }
        if (is_null($nonStockItemSalesCategory) || (is_array($nonStockItemSalesCategory) && empty($nonStockItemSalesCategory))) {
            unset($this->NonStockItemSalesCategory);
        } else {
            $this->NonStockItemSalesCategory = $nonStockItemSalesCategory;
        }
        return $this;
    }
    /**
     * Add item to NonStockItemSalesCategory value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\NonStockItemSalesCategory $item
     * @return \AcumaticaConfig\StructType\SalesCategories
     */
    public function addToNonStockItemSalesCategory(\AcumaticaConfig\StructType\NonStockItemSalesCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\NonStockItemSalesCategory) {
            throw new \InvalidArgumentException(sprintf('The NonStockItemSalesCategory property can only contain items of \AcumaticaConfig\StructType\NonStockItemSalesCategory, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NonStockItemSalesCategory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SalesCategories
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
