<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The EmailProcessingRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\EmailProcessingRow[]
     */
    public $EmailProcessingRow;
    /**
     * Constructor method for Result
     * @uses Result::setEmailProcessingRow()
     * @param \AcumaticaConfig\StructType\EmailProcessingRow[] $emailProcessingRow
     */
    public function __construct(array $emailProcessingRow = array())
    {
        $this
            ->setEmailProcessingRow($emailProcessingRow);
    }
    /**
     * Get EmailProcessingRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\EmailProcessingRow[]|null
     */
    public function getEmailProcessingRow()
    {
        return isset($this->EmailProcessingRow) ? $this->EmailProcessingRow : null;
    }
    /**
     * Set EmailProcessingRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\EmailProcessingRow[] $emailProcessingRow
     * @return \AcumaticaConfig\StructType\Result
     */
    public function setEmailProcessingRow(array $emailProcessingRow = array())
    {
        foreach ($emailProcessingRow as $resultEmailProcessingRowItem) {
            // validation for constraint: itemType
            if (!$resultEmailProcessingRowItem instanceof \AcumaticaConfig\StructType\EmailProcessingRow) {
                throw new \InvalidArgumentException(sprintf('The EmailProcessingRow property can only contain items of \AcumaticaConfig\StructType\EmailProcessingRow, "%s" given', is_object($resultEmailProcessingRowItem) ? get_class($resultEmailProcessingRowItem) : gettype($resultEmailProcessingRowItem)), __LINE__);
            }
        }
        if (is_null($emailProcessingRow) || (is_array($emailProcessingRow) && empty($emailProcessingRow))) {
            unset($this->EmailProcessingRow);
        } else {
            $this->EmailProcessingRow = $emailProcessingRow;
        }
        return $this;
    }
    /**
     * Add item to EmailProcessingRow value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\EmailProcessingRow $item
     * @return \AcumaticaConfig\StructType\Result
     */
    public function addToEmailProcessingRow(\AcumaticaConfig\StructType\EmailProcessingRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\EmailProcessingRow) {
            throw new \InvalidArgumentException(sprintf('The EmailProcessingRow property can only contain items of \AcumaticaConfig\StructType\EmailProcessingRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmailProcessingRow[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
