<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrder StructType
 * @subpackage Structs
 */
class PurchaseOrder extends Entity
{
    /**
     * The ControlTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ControlTotal;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Details
     */
    public $Details;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The LineTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $LineTotal;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Location;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OrderTotal;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Owner;
    /**
     * The PromisedOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $PromisedOn;
    /**
     * The ShippingInstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShippingInstructions
     */
    public $ShippingInstructions;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Type;
    /**
     * The VendorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $VendorID;
    /**
     * The VendorRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $VendorRef;
    /**
     * Constructor method for PurchaseOrder
     * @uses PurchaseOrder::setControlTotal()
     * @uses PurchaseOrder::setCurrencyID()
     * @uses PurchaseOrder::setDate()
     * @uses PurchaseOrder::setDescription()
     * @uses PurchaseOrder::setDetails()
     * @uses PurchaseOrder::setHold()
     * @uses PurchaseOrder::setLineTotal()
     * @uses PurchaseOrder::setLocation()
     * @uses PurchaseOrder::setOrderNbr()
     * @uses PurchaseOrder::setOrderTotal()
     * @uses PurchaseOrder::setOwner()
     * @uses PurchaseOrder::setPromisedOn()
     * @uses PurchaseOrder::setShippingInstructions()
     * @uses PurchaseOrder::setStatus()
     * @uses PurchaseOrder::setTaxTotal()
     * @uses PurchaseOrder::setType()
     * @uses PurchaseOrder::setVendorID()
     * @uses PurchaseOrder::setVendorRef()
     * @param \AcumaticaConfig\StructType\DecimalValue $controlTotal
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @param \AcumaticaConfig\StructType\DateTimeValue $date
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\Details $details
     * @param \AcumaticaConfig\StructType\BooleanValue $hold
     * @param \AcumaticaConfig\StructType\DecimalValue $lineTotal
     * @param \AcumaticaConfig\StructType\StringValue $location
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @param \AcumaticaConfig\StructType\DecimalValue $orderTotal
     * @param \AcumaticaConfig\StructType\StringValue $owner
     * @param \AcumaticaConfig\StructType\DateTimeValue $promisedOn
     * @param \AcumaticaConfig\StructType\ShippingInstructions $shippingInstructions
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\DecimalValue $taxTotal
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @param \AcumaticaConfig\StructType\StringValue $vendorID
     * @param \AcumaticaConfig\StructType\StringValue $vendorRef
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $controlTotal = null, \AcumaticaConfig\StructType\StringValue $currencyID = null, \AcumaticaConfig\StructType\DateTimeValue $date = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\Details $details = null, \AcumaticaConfig\StructType\BooleanValue $hold = null, \AcumaticaConfig\StructType\DecimalValue $lineTotal = null, \AcumaticaConfig\StructType\StringValue $location = null, \AcumaticaConfig\StructType\StringValue $orderNbr = null, \AcumaticaConfig\StructType\DecimalValue $orderTotal = null, \AcumaticaConfig\StructType\StringValue $owner = null, \AcumaticaConfig\StructType\DateTimeValue $promisedOn = null, \AcumaticaConfig\StructType\ShippingInstructions $shippingInstructions = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\DecimalValue $taxTotal = null, \AcumaticaConfig\StructType\StringValue $type = null, \AcumaticaConfig\StructType\StringValue $vendorID = null, \AcumaticaConfig\StructType\StringValue $vendorRef = null)
    {
        $this
            ->setControlTotal($controlTotal)
            ->setCurrencyID($currencyID)
            ->setDate($date)
            ->setDescription($description)
            ->setDetails($details)
            ->setHold($hold)
            ->setLineTotal($lineTotal)
            ->setLocation($location)
            ->setOrderNbr($orderNbr)
            ->setOrderTotal($orderTotal)
            ->setOwner($owner)
            ->setPromisedOn($promisedOn)
            ->setShippingInstructions($shippingInstructions)
            ->setStatus($status)
            ->setTaxTotal($taxTotal)
            ->setType($type)
            ->setVendorID($vendorID)
            ->setVendorRef($vendorRef);
    }
    /**
     * Get ControlTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getControlTotal()
    {
        return isset($this->ControlTotal) ? $this->ControlTotal : null;
    }
    /**
     * Set ControlTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $controlTotal
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setControlTotal(\AcumaticaConfig\StructType\DecimalValue $controlTotal = null)
    {
        if (is_null($controlTotal) || (is_array($controlTotal) && empty($controlTotal))) {
            unset($this->ControlTotal);
        } else {
            $this->ControlTotal = $controlTotal;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setCurrencyID(\AcumaticaConfig\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $date
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setDate(\AcumaticaConfig\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Details $details
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setDetails(\AcumaticaConfig\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $hold
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setHold(\AcumaticaConfig\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get LineTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getLineTotal()
    {
        return isset($this->LineTotal) ? $this->LineTotal : null;
    }
    /**
     * Set LineTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $lineTotal
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setLineTotal(\AcumaticaConfig\StructType\DecimalValue $lineTotal = null)
    {
        if (is_null($lineTotal) || (is_array($lineTotal) && empty($lineTotal))) {
            unset($this->LineTotal);
        } else {
            $this->LineTotal = $lineTotal;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $location
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setLocation(\AcumaticaConfig\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setOrderNbr(\AcumaticaConfig\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOrderTotal()
    {
        return isset($this->OrderTotal) ? $this->OrderTotal : null;
    }
    /**
     * Set OrderTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $orderTotal
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setOrderTotal(\AcumaticaConfig\StructType\DecimalValue $orderTotal = null)
    {
        if (is_null($orderTotal) || (is_array($orderTotal) && empty($orderTotal))) {
            unset($this->OrderTotal);
        } else {
            $this->OrderTotal = $orderTotal;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $owner
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setOwner(\AcumaticaConfig\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get PromisedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getPromisedOn()
    {
        return isset($this->PromisedOn) ? $this->PromisedOn : null;
    }
    /**
     * Set PromisedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $promisedOn
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setPromisedOn(\AcumaticaConfig\StructType\DateTimeValue $promisedOn = null)
    {
        if (is_null($promisedOn) || (is_array($promisedOn) && empty($promisedOn))) {
            unset($this->PromisedOn);
        } else {
            $this->PromisedOn = $promisedOn;
        }
        return $this;
    }
    /**
     * Get ShippingInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShippingInstructions|null
     */
    public function getShippingInstructions()
    {
        return isset($this->ShippingInstructions) ? $this->ShippingInstructions : null;
    }
    /**
     * Set ShippingInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShippingInstructions $shippingInstructions
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setShippingInstructions(\AcumaticaConfig\StructType\ShippingInstructions $shippingInstructions = null)
    {
        if (is_null($shippingInstructions) || (is_array($shippingInstructions) && empty($shippingInstructions))) {
            unset($this->ShippingInstructions);
        } else {
            $this->ShippingInstructions = $shippingInstructions;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $taxTotal
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setTaxTotal(\AcumaticaConfig\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setType(\AcumaticaConfig\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get VendorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVendorID()
    {
        return isset($this->VendorID) ? $this->VendorID : null;
    }
    /**
     * Set VendorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $vendorID
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setVendorID(\AcumaticaConfig\StructType\StringValue $vendorID = null)
    {
        if (is_null($vendorID) || (is_array($vendorID) && empty($vendorID))) {
            unset($this->VendorID);
        } else {
            $this->VendorID = $vendorID;
        }
        return $this;
    }
    /**
     * Get VendorRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVendorRef()
    {
        return isset($this->VendorRef) ? $this->VendorRef : null;
    }
    /**
     * Set VendorRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $vendorRef
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public function setVendorRef(\AcumaticaConfig\StructType\StringValue $vendorRef = null)
    {
        if (is_null($vendorRef) || (is_array($vendorRef) && empty($vendorRef))) {
            unset($this->VendorRef);
        } else {
            $this->VendorRef = $vendorRef;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\PurchaseOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
