<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductUpSells StructType
 * @subpackage Structs
 */
class ProductUpSells extends Entity
{
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The UpSellsDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\UpSellsDetails
     */
    public $UpSellsDetails;
    /**
     * Constructor method for ProductUpSells
     * @uses ProductUpSells::setInventoryID()
     * @uses ProductUpSells::setUpSellsDetails()
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\UpSellsDetails $upSellsDetails
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\UpSellsDetails $upSellsDetails = null)
    {
        $this
            ->setInventoryID($inventoryID)
            ->setUpSellsDetails($upSellsDetails);
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\ProductUpSells
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get UpSellsDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\UpSellsDetails|null
     */
    public function getUpSellsDetails()
    {
        return isset($this->UpSellsDetails) ? $this->UpSellsDetails : null;
    }
    /**
     * Set UpSellsDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\UpSellsDetails $upSellsDetails
     * @return \AcumaticaConfig\StructType\ProductUpSells
     */
    public function setUpSellsDetails(\AcumaticaConfig\StructType\UpSellsDetails $upSellsDetails = null)
    {
        if (is_null($upSellsDetails) || (is_array($upSellsDetails) && empty($upSellsDetails))) {
            unset($this->UpSellsDetails);
        } else {
            $this->UpSellsDetails = $upSellsDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProductUpSells
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
