<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductResults StructType
 * @subpackage Structs
 */
class ProductResults extends Entity
{
    /**
     * The ProductResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ProductResults[]
     */
    public $ProductResults;
    /**
     * The DefaultPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DefaultPrice;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * Constructor method for ProductResults
     * @uses ProductResults::setProductResults()
     * @uses ProductResults::setDefaultPrice()
     * @uses ProductResults::setInventoryID()
     * @param \AcumaticaConfig\StructType\ProductResults[] $productResults
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     */
    public function __construct(array $productResults = array(), \AcumaticaConfig\StructType\DecimalValue $defaultPrice = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        $this
            ->setProductResults($productResults)
            ->setDefaultPrice($defaultPrice)
            ->setInventoryID($inventoryID);
    }
    /**
     * Get ProductResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ProductResults[]|null
     */
    public function getProductResults()
    {
        return isset($this->ProductResults) ? $this->ProductResults : null;
    }
    /**
     * Set ProductResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProductResults[] $productResults
     * @return \AcumaticaConfig\StructType\ProductResults
     */
    public function setProductResults(array $productResults = array())
    {
        foreach ($productResults as $productResultsProductResultsItem) {
            // validation for constraint: itemType
            if (!$productResultsProductResultsItem instanceof \AcumaticaConfig\StructType\ProductResults) {
                throw new \InvalidArgumentException(sprintf('The ProductResults property can only contain items of \AcumaticaConfig\StructType\ProductResults, "%s" given', is_object($productResultsProductResultsItem) ? get_class($productResultsProductResultsItem) : gettype($productResultsProductResultsItem)), __LINE__);
            }
        }
        if (is_null($productResults) || (is_array($productResults) && empty($productResults))) {
            unset($this->ProductResults);
        } else {
            $this->ProductResults = $productResults;
        }
        return $this;
    }
    /**
     * Add item to ProductResults value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProductResults $item
     * @return \AcumaticaConfig\StructType\ProductResults
     */
    public function addToProductResults(\AcumaticaConfig\StructType\ProductResults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ProductResults) {
            throw new \InvalidArgumentException(sprintf('The ProductResults property can only contain items of \AcumaticaConfig\StructType\ProductResults, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductResults[] = $item;
        return $this;
    }
    /**
     * Get DefaultPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDefaultPrice()
    {
        return isset($this->DefaultPrice) ? $this->DefaultPrice : null;
    }
    /**
     * Set DefaultPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @return \AcumaticaConfig\StructType\ProductResults
     */
    public function setDefaultPrice(\AcumaticaConfig\StructType\DecimalValue $defaultPrice = null)
    {
        if (is_null($defaultPrice) || (is_array($defaultPrice) && empty($defaultPrice))) {
            unset($this->DefaultPrice);
        } else {
            $this->DefaultPrice = $defaultPrice;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\ProductResults
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProductResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
