<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductResult StructType
 * @subpackage Structs
 */
class ProductResult extends Entity
{
    /**
     * The ProductResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ProductResult[]
     */
    public $ProductResult;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $Count;
    /**
     * The StockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $StockItem;
    /**
     * Constructor method for ProductResult
     * @uses ProductResult::setProductResult()
     * @uses ProductResult::setCount()
     * @uses ProductResult::setStockItem()
     * @param \AcumaticaConfig\StructType\ProductResult[] $productResult
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @param \AcumaticaConfig\StructType\BooleanValue $stockItem
     */
    public function __construct(array $productResult = array(), \AcumaticaConfig\StructType\IntValue $count = null, \AcumaticaConfig\StructType\BooleanValue $stockItem = null)
    {
        $this
            ->setProductResult($productResult)
            ->setCount($count)
            ->setStockItem($stockItem);
    }
    /**
     * Get ProductResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ProductResult[]|null
     */
    public function getProductResult()
    {
        return isset($this->ProductResult) ? $this->ProductResult : null;
    }
    /**
     * Set ProductResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProductResult[] $productResult
     * @return \AcumaticaConfig\StructType\ProductResult
     */
    public function setProductResult(array $productResult = array())
    {
        foreach ($productResult as $productResultProductResultItem) {
            // validation for constraint: itemType
            if (!$productResultProductResultItem instanceof \AcumaticaConfig\StructType\ProductResult) {
                throw new \InvalidArgumentException(sprintf('The ProductResult property can only contain items of \AcumaticaConfig\StructType\ProductResult, "%s" given', is_object($productResultProductResultItem) ? get_class($productResultProductResultItem) : gettype($productResultProductResultItem)), __LINE__);
            }
        }
        if (is_null($productResult) || (is_array($productResult) && empty($productResult))) {
            unset($this->ProductResult);
        } else {
            $this->ProductResult = $productResult;
        }
        return $this;
    }
    /**
     * Add item to ProductResult value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProductResult $item
     * @return \AcumaticaConfig\StructType\ProductResult
     */
    public function addToProductResult(\AcumaticaConfig\StructType\ProductResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ProductResult) {
            throw new \InvalidArgumentException(sprintf('The ProductResult property can only contain items of \AcumaticaConfig\StructType\ProductResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductResult[] = $item;
        return $this;
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @return \AcumaticaConfig\StructType\ProductResult
     */
    public function setCount(\AcumaticaConfig\StructType\IntValue $count = null)
    {
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get StockItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getStockItem()
    {
        return isset($this->StockItem) ? $this->StockItem : null;
    }
    /**
     * Set StockItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $stockItem
     * @return \AcumaticaConfig\StructType\ProductResult
     */
    public function setStockItem(\AcumaticaConfig\StructType\BooleanValue $stockItem = null)
    {
        if (is_null($stockItem) || (is_array($stockItem) && empty($stockItem))) {
            unset($this->StockItem);
        } else {
            $this->StockItem = $stockItem;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProductResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
