<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDetails StructType
 * @subpackage Structs
 */
class ProductDetails extends Entity
{
    /**
     * The ClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ClassID;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ProductDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ProductDetails[]
     */
    public $ProductDetails;
    /**
     * Constructor method for ProductDetails
     * @uses ProductDetails::setClassID()
     * @uses ProductDetails::setInventoryID()
     * @uses ProductDetails::setProductDetails()
     * @param \AcumaticaConfig\StructType\StringValue $classID
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\ProductDetails[] $productDetails
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $classID = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, array $productDetails = array())
    {
        $this
            ->setClassID($classID)
            ->setInventoryID($inventoryID)
            ->setProductDetails($productDetails);
    }
    /**
     * Get ClassID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getClassID()
    {
        return isset($this->ClassID) ? $this->ClassID : null;
    }
    /**
     * Set ClassID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $classID
     * @return \AcumaticaConfig\StructType\ProductDetails
     */
    public function setClassID(\AcumaticaConfig\StructType\StringValue $classID = null)
    {
        if (is_null($classID) || (is_array($classID) && empty($classID))) {
            unset($this->ClassID);
        } else {
            $this->ClassID = $classID;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\ProductDetails
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ProductDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ProductDetails[]|null
     */
    public function getProductDetails()
    {
        return isset($this->ProductDetails) ? $this->ProductDetails : null;
    }
    /**
     * Set ProductDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProductDetails[] $productDetails
     * @return \AcumaticaConfig\StructType\ProductDetails
     */
    public function setProductDetails(array $productDetails = array())
    {
        foreach ($productDetails as $productDetailsProductDetailsItem) {
            // validation for constraint: itemType
            if (!$productDetailsProductDetailsItem instanceof \AcumaticaConfig\StructType\ProductDetails) {
                throw new \InvalidArgumentException(sprintf('The ProductDetails property can only contain items of \AcumaticaConfig\StructType\ProductDetails, "%s" given', is_object($productDetailsProductDetailsItem) ? get_class($productDetailsProductDetailsItem) : gettype($productDetailsProductDetailsItem)), __LINE__);
            }
        }
        if (is_null($productDetails) || (is_array($productDetails) && empty($productDetails))) {
            unset($this->ProductDetails);
        } else {
            $this->ProductDetails = $productDetails;
        }
        return $this;
    }
    /**
     * Add item to ProductDetails value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProductDetails $item
     * @return \AcumaticaConfig\StructType\ProductDetails
     */
    public function addToProductDetails(\AcumaticaConfig\StructType\ProductDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ProductDetails) {
            throw new \InvalidArgumentException(sprintf('The ProductDetails property can only contain items of \AcumaticaConfig\StructType\ProductDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProductDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
