<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessingCenters StructType
 * @subpackage Structs
 */
class ProcessingCenters extends AbstractStructBase
{
    /**
     * The PaymentMethodProcessingCenterDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail[]
     */
    public $PaymentMethodProcessingCenterDetail;
    /**
     * Constructor method for ProcessingCenters
     * @uses ProcessingCenters::setPaymentMethodProcessingCenterDetail()
     * @param \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail[] $paymentMethodProcessingCenterDetail
     */
    public function __construct(array $paymentMethodProcessingCenterDetail = array())
    {
        $this
            ->setPaymentMethodProcessingCenterDetail($paymentMethodProcessingCenterDetail);
    }
    /**
     * Get PaymentMethodProcessingCenterDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail[]|null
     */
    public function getPaymentMethodProcessingCenterDetail()
    {
        return isset($this->PaymentMethodProcessingCenterDetail) ? $this->PaymentMethodProcessingCenterDetail : null;
    }
    /**
     * Set PaymentMethodProcessingCenterDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail[] $paymentMethodProcessingCenterDetail
     * @return \AcumaticaConfig\StructType\ProcessingCenters
     */
    public function setPaymentMethodProcessingCenterDetail(array $paymentMethodProcessingCenterDetail = array())
    {
        foreach ($paymentMethodProcessingCenterDetail as $processingCentersPaymentMethodProcessingCenterDetailItem) {
            // validation for constraint: itemType
            if (!$processingCentersPaymentMethodProcessingCenterDetailItem instanceof \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail) {
                throw new \InvalidArgumentException(sprintf('The PaymentMethodProcessingCenterDetail property can only contain items of \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail, "%s" given', is_object($processingCentersPaymentMethodProcessingCenterDetailItem) ? get_class($processingCentersPaymentMethodProcessingCenterDetailItem) : gettype($processingCentersPaymentMethodProcessingCenterDetailItem)), __LINE__);
            }
        }
        if (is_null($paymentMethodProcessingCenterDetail) || (is_array($paymentMethodProcessingCenterDetail) && empty($paymentMethodProcessingCenterDetail))) {
            unset($this->PaymentMethodProcessingCenterDetail);
        } else {
            $this->PaymentMethodProcessingCenterDetail = $paymentMethodProcessingCenterDetail;
        }
        return $this;
    }
    /**
     * Add item to PaymentMethodProcessingCenterDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail $item
     * @return \AcumaticaConfig\StructType\ProcessingCenters
     */
    public function addToPaymentMethodProcessingCenterDetail(\AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentMethodProcessingCenterDetail property can only contain items of \AcumaticaConfig\StructType\PaymentMethodProcessingCenterDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentMethodProcessingCenterDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProcessingCenters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
