<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInstructions StructType
 * @subpackage Structs
 */
class PaymentInstructions extends AbstractStructBase
{
    /**
     * The BusinessAccountPaymentInstructionDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail[]
     */
    public $BusinessAccountPaymentInstructionDetail;
    /**
     * Constructor method for PaymentInstructions
     * @uses PaymentInstructions::setBusinessAccountPaymentInstructionDetail()
     * @param \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail[] $businessAccountPaymentInstructionDetail
     */
    public function __construct(array $businessAccountPaymentInstructionDetail = array())
    {
        $this
            ->setBusinessAccountPaymentInstructionDetail($businessAccountPaymentInstructionDetail);
    }
    /**
     * Get BusinessAccountPaymentInstructionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail[]|null
     */
    public function getBusinessAccountPaymentInstructionDetail()
    {
        return isset($this->BusinessAccountPaymentInstructionDetail) ? $this->BusinessAccountPaymentInstructionDetail : null;
    }
    /**
     * Set BusinessAccountPaymentInstructionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail[] $businessAccountPaymentInstructionDetail
     * @return \AcumaticaConfig\StructType\PaymentInstructions
     */
    public function setBusinessAccountPaymentInstructionDetail(array $businessAccountPaymentInstructionDetail = array())
    {
        foreach ($businessAccountPaymentInstructionDetail as $paymentInstructionsBusinessAccountPaymentInstructionDetailItem) {
            // validation for constraint: itemType
            if (!$paymentInstructionsBusinessAccountPaymentInstructionDetailItem instanceof \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountPaymentInstructionDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail, "%s" given', is_object($paymentInstructionsBusinessAccountPaymentInstructionDetailItem) ? get_class($paymentInstructionsBusinessAccountPaymentInstructionDetailItem) : gettype($paymentInstructionsBusinessAccountPaymentInstructionDetailItem)), __LINE__);
            }
        }
        if (is_null($businessAccountPaymentInstructionDetail) || (is_array($businessAccountPaymentInstructionDetail) && empty($businessAccountPaymentInstructionDetail))) {
            unset($this->BusinessAccountPaymentInstructionDetail);
        } else {
            $this->BusinessAccountPaymentInstructionDetail = $businessAccountPaymentInstructionDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountPaymentInstructionDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail $item
     * @return \AcumaticaConfig\StructType\PaymentInstructions
     */
    public function addToBusinessAccountPaymentInstructionDetail(\AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountPaymentInstructionDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountPaymentInstructionDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountPaymentInstructionDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\PaymentInstructions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
