<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Orders StructType
 * @subpackage Structs
 */
class Orders extends AbstractStructBase
{
    /**
     * The ShipmentOrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShipmentOrderDetail[]
     */
    public $ShipmentOrderDetail;
    /**
     * The BusinessAccountOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountOrder[]
     */
    public $BusinessAccountOrder;
    /**
     * Constructor method for Orders
     * @uses Orders::setShipmentOrderDetail()
     * @uses Orders::setBusinessAccountOrder()
     * @param \AcumaticaConfig\StructType\ShipmentOrderDetail[] $shipmentOrderDetail
     * @param \AcumaticaConfig\StructType\BusinessAccountOrder[] $businessAccountOrder
     */
    public function __construct(array $shipmentOrderDetail = array(), array $businessAccountOrder = array())
    {
        $this
            ->setShipmentOrderDetail($shipmentOrderDetail)
            ->setBusinessAccountOrder($businessAccountOrder);
    }
    /**
     * Get ShipmentOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShipmentOrderDetail[]|null
     */
    public function getShipmentOrderDetail()
    {
        return isset($this->ShipmentOrderDetail) ? $this->ShipmentOrderDetail : null;
    }
    /**
     * Set ShipmentOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentOrderDetail[] $shipmentOrderDetail
     * @return \AcumaticaConfig\StructType\Orders
     */
    public function setShipmentOrderDetail(array $shipmentOrderDetail = array())
    {
        foreach ($shipmentOrderDetail as $ordersShipmentOrderDetailItem) {
            // validation for constraint: itemType
            if (!$ordersShipmentOrderDetailItem instanceof \AcumaticaConfig\StructType\ShipmentOrderDetail) {
                throw new \InvalidArgumentException(sprintf('The ShipmentOrderDetail property can only contain items of \AcumaticaConfig\StructType\ShipmentOrderDetail, "%s" given', is_object($ordersShipmentOrderDetailItem) ? get_class($ordersShipmentOrderDetailItem) : gettype($ordersShipmentOrderDetailItem)), __LINE__);
            }
        }
        if (is_null($shipmentOrderDetail) || (is_array($shipmentOrderDetail) && empty($shipmentOrderDetail))) {
            unset($this->ShipmentOrderDetail);
        } else {
            $this->ShipmentOrderDetail = $shipmentOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to ShipmentOrderDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentOrderDetail $item
     * @return \AcumaticaConfig\StructType\Orders
     */
    public function addToShipmentOrderDetail(\AcumaticaConfig\StructType\ShipmentOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ShipmentOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The ShipmentOrderDetail property can only contain items of \AcumaticaConfig\StructType\ShipmentOrderDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountOrder[]|null
     */
    public function getBusinessAccountOrder()
    {
        return isset($this->BusinessAccountOrder) ? $this->BusinessAccountOrder : null;
    }
    /**
     * Set BusinessAccountOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountOrder[] $businessAccountOrder
     * @return \AcumaticaConfig\StructType\Orders
     */
    public function setBusinessAccountOrder(array $businessAccountOrder = array())
    {
        foreach ($businessAccountOrder as $ordersBusinessAccountOrderItem) {
            // validation for constraint: itemType
            if (!$ordersBusinessAccountOrderItem instanceof \AcumaticaConfig\StructType\BusinessAccountOrder) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountOrder property can only contain items of \AcumaticaConfig\StructType\BusinessAccountOrder, "%s" given', is_object($ordersBusinessAccountOrderItem) ? get_class($ordersBusinessAccountOrderItem) : gettype($ordersBusinessAccountOrderItem)), __LINE__);
            }
        }
        if (is_null($businessAccountOrder) || (is_array($businessAccountOrder) && empty($businessAccountOrder))) {
            unset($this->BusinessAccountOrder);
        } else {
            $this->BusinessAccountOrder = $businessAccountOrder;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountOrder value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountOrder $item
     * @return \AcumaticaConfig\StructType\Orders
     */
    public function addToBusinessAccountOrder(\AcumaticaConfig\StructType\BusinessAccountOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountOrder) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountOrder property can only contain items of \AcumaticaConfig\StructType\BusinessAccountOrder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountOrder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Orders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
