<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingLists StructType
 * @subpackage Structs
 */
class MarketingLists extends AbstractStructBase
{
    /**
     * The MarketingListDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\MarketingListDetail[]
     */
    public $MarketingListDetail;
    /**
     * The BusinessAccountMarketingListDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail[]
     */
    public $BusinessAccountMarketingListDetail;
    /**
     * Constructor method for MarketingLists
     * @uses MarketingLists::setMarketingListDetail()
     * @uses MarketingLists::setBusinessAccountMarketingListDetail()
     * @param \AcumaticaConfig\StructType\MarketingListDetail[] $marketingListDetail
     * @param \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail[] $businessAccountMarketingListDetail
     */
    public function __construct(array $marketingListDetail = array(), array $businessAccountMarketingListDetail = array())
    {
        $this
            ->setMarketingListDetail($marketingListDetail)
            ->setBusinessAccountMarketingListDetail($businessAccountMarketingListDetail);
    }
    /**
     * Get MarketingListDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\MarketingListDetail[]|null
     */
    public function getMarketingListDetail()
    {
        return isset($this->MarketingListDetail) ? $this->MarketingListDetail : null;
    }
    /**
     * Set MarketingListDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\MarketingListDetail[] $marketingListDetail
     * @return \AcumaticaConfig\StructType\MarketingLists
     */
    public function setMarketingListDetail(array $marketingListDetail = array())
    {
        foreach ($marketingListDetail as $marketingListsMarketingListDetailItem) {
            // validation for constraint: itemType
            if (!$marketingListsMarketingListDetailItem instanceof \AcumaticaConfig\StructType\MarketingListDetail) {
                throw new \InvalidArgumentException(sprintf('The MarketingListDetail property can only contain items of \AcumaticaConfig\StructType\MarketingListDetail, "%s" given', is_object($marketingListsMarketingListDetailItem) ? get_class($marketingListsMarketingListDetailItem) : gettype($marketingListsMarketingListDetailItem)), __LINE__);
            }
        }
        if (is_null($marketingListDetail) || (is_array($marketingListDetail) && empty($marketingListDetail))) {
            unset($this->MarketingListDetail);
        } else {
            $this->MarketingListDetail = $marketingListDetail;
        }
        return $this;
    }
    /**
     * Add item to MarketingListDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\MarketingListDetail $item
     * @return \AcumaticaConfig\StructType\MarketingLists
     */
    public function addToMarketingListDetail(\AcumaticaConfig\StructType\MarketingListDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\MarketingListDetail) {
            throw new \InvalidArgumentException(sprintf('The MarketingListDetail property can only contain items of \AcumaticaConfig\StructType\MarketingListDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MarketingListDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountMarketingListDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail[]|null
     */
    public function getBusinessAccountMarketingListDetail()
    {
        return isset($this->BusinessAccountMarketingListDetail) ? $this->BusinessAccountMarketingListDetail : null;
    }
    /**
     * Set BusinessAccountMarketingListDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail[] $businessAccountMarketingListDetail
     * @return \AcumaticaConfig\StructType\MarketingLists
     */
    public function setBusinessAccountMarketingListDetail(array $businessAccountMarketingListDetail = array())
    {
        foreach ($businessAccountMarketingListDetail as $marketingListsBusinessAccountMarketingListDetailItem) {
            // validation for constraint: itemType
            if (!$marketingListsBusinessAccountMarketingListDetailItem instanceof \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountMarketingListDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail, "%s" given', is_object($marketingListsBusinessAccountMarketingListDetailItem) ? get_class($marketingListsBusinessAccountMarketingListDetailItem) : gettype($marketingListsBusinessAccountMarketingListDetailItem)), __LINE__);
            }
        }
        if (is_null($businessAccountMarketingListDetail) || (is_array($businessAccountMarketingListDetail) && empty($businessAccountMarketingListDetail))) {
            unset($this->BusinessAccountMarketingListDetail);
        } else {
            $this->BusinessAccountMarketingListDetail = $businessAccountMarketingListDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountMarketingListDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail $item
     * @return \AcumaticaConfig\StructType\MarketingLists
     */
    public function addToBusinessAccountMarketingListDetail(\AcumaticaConfig\StructType\BusinessAccountMarketingListDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountMarketingListDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountMarketingListDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountMarketingListDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\MarketingLists
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
