<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterBranchAccountMapping StructType
 * @subpackage Structs
 */
class InterBranchAccountMapping extends Entity
{
    /**
     * The OriginatingBranch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OriginatingBranch;
    /**
     * The PostingLedger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PostingLedger;
    /**
     * The TransactionsInDestinationBranch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TransactionsInDestinationBranch
     */
    public $TransactionsInDestinationBranch;
    /**
     * The TransactionsInSourceBranch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TransactionsInSourceBranch
     */
    public $TransactionsInSourceBranch;
    /**
     * Constructor method for InterBranchAccountMapping
     * @uses InterBranchAccountMapping::setOriginatingBranch()
     * @uses InterBranchAccountMapping::setPostingLedger()
     * @uses InterBranchAccountMapping::setTransactionsInDestinationBranch()
     * @uses InterBranchAccountMapping::setTransactionsInSourceBranch()
     * @param \AcumaticaConfig\StructType\StringValue $originatingBranch
     * @param \AcumaticaConfig\StructType\StringValue $postingLedger
     * @param \AcumaticaConfig\StructType\TransactionsInDestinationBranch $transactionsInDestinationBranch
     * @param \AcumaticaConfig\StructType\TransactionsInSourceBranch $transactionsInSourceBranch
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $originatingBranch = null, \AcumaticaConfig\StructType\StringValue $postingLedger = null, \AcumaticaConfig\StructType\TransactionsInDestinationBranch $transactionsInDestinationBranch = null, \AcumaticaConfig\StructType\TransactionsInSourceBranch $transactionsInSourceBranch = null)
    {
        $this
            ->setOriginatingBranch($originatingBranch)
            ->setPostingLedger($postingLedger)
            ->setTransactionsInDestinationBranch($transactionsInDestinationBranch)
            ->setTransactionsInSourceBranch($transactionsInSourceBranch);
    }
    /**
     * Get OriginatingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOriginatingBranch()
    {
        return isset($this->OriginatingBranch) ? $this->OriginatingBranch : null;
    }
    /**
     * Set OriginatingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $originatingBranch
     * @return \AcumaticaConfig\StructType\InterBranchAccountMapping
     */
    public function setOriginatingBranch(\AcumaticaConfig\StructType\StringValue $originatingBranch = null)
    {
        if (is_null($originatingBranch) || (is_array($originatingBranch) && empty($originatingBranch))) {
            unset($this->OriginatingBranch);
        } else {
            $this->OriginatingBranch = $originatingBranch;
        }
        return $this;
    }
    /**
     * Get PostingLedger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPostingLedger()
    {
        return isset($this->PostingLedger) ? $this->PostingLedger : null;
    }
    /**
     * Set PostingLedger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $postingLedger
     * @return \AcumaticaConfig\StructType\InterBranchAccountMapping
     */
    public function setPostingLedger(\AcumaticaConfig\StructType\StringValue $postingLedger = null)
    {
        if (is_null($postingLedger) || (is_array($postingLedger) && empty($postingLedger))) {
            unset($this->PostingLedger);
        } else {
            $this->PostingLedger = $postingLedger;
        }
        return $this;
    }
    /**
     * Get TransactionsInDestinationBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TransactionsInDestinationBranch|null
     */
    public function getTransactionsInDestinationBranch()
    {
        return isset($this->TransactionsInDestinationBranch) ? $this->TransactionsInDestinationBranch : null;
    }
    /**
     * Set TransactionsInDestinationBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\TransactionsInDestinationBranch $transactionsInDestinationBranch
     * @return \AcumaticaConfig\StructType\InterBranchAccountMapping
     */
    public function setTransactionsInDestinationBranch(\AcumaticaConfig\StructType\TransactionsInDestinationBranch $transactionsInDestinationBranch = null)
    {
        if (is_null($transactionsInDestinationBranch) || (is_array($transactionsInDestinationBranch) && empty($transactionsInDestinationBranch))) {
            unset($this->TransactionsInDestinationBranch);
        } else {
            $this->TransactionsInDestinationBranch = $transactionsInDestinationBranch;
        }
        return $this;
    }
    /**
     * Get TransactionsInSourceBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TransactionsInSourceBranch|null
     */
    public function getTransactionsInSourceBranch()
    {
        return isset($this->TransactionsInSourceBranch) ? $this->TransactionsInSourceBranch : null;
    }
    /**
     * Set TransactionsInSourceBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\TransactionsInSourceBranch $transactionsInSourceBranch
     * @return \AcumaticaConfig\StructType\InterBranchAccountMapping
     */
    public function setTransactionsInSourceBranch(\AcumaticaConfig\StructType\TransactionsInSourceBranch $transactionsInSourceBranch = null)
    {
        if (is_null($transactionsInSourceBranch) || (is_array($transactionsInSourceBranch) && empty($transactionsInSourceBranch))) {
            unset($this->TransactionsInSourceBranch);
        } else {
            $this->TransactionsInSourceBranch = $transactionsInSourceBranch;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\InterBranchAccountMapping
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
