<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for History StructType
 * @subpackage Structs
 */
class History extends AbstractStructBase
{
    /**
     * The CheckHistoryDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CheckHistoryDetail[]
     */
    public $CheckHistoryDetail;
    /**
     * Constructor method for History
     * @uses History::setCheckHistoryDetail()
     * @param \AcumaticaConfig\StructType\CheckHistoryDetail[] $checkHistoryDetail
     */
    public function __construct(array $checkHistoryDetail = array())
    {
        $this
            ->setCheckHistoryDetail($checkHistoryDetail);
    }
    /**
     * Get CheckHistoryDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CheckHistoryDetail[]|null
     */
    public function getCheckHistoryDetail()
    {
        return isset($this->CheckHistoryDetail) ? $this->CheckHistoryDetail : null;
    }
    /**
     * Set CheckHistoryDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CheckHistoryDetail[] $checkHistoryDetail
     * @return \AcumaticaConfig\StructType\History
     */
    public function setCheckHistoryDetail(array $checkHistoryDetail = array())
    {
        foreach ($checkHistoryDetail as $historyCheckHistoryDetailItem) {
            // validation for constraint: itemType
            if (!$historyCheckHistoryDetailItem instanceof \AcumaticaConfig\StructType\CheckHistoryDetail) {
                throw new \InvalidArgumentException(sprintf('The CheckHistoryDetail property can only contain items of \AcumaticaConfig\StructType\CheckHistoryDetail, "%s" given', is_object($historyCheckHistoryDetailItem) ? get_class($historyCheckHistoryDetailItem) : gettype($historyCheckHistoryDetailItem)), __LINE__);
            }
        }
        if (is_null($checkHistoryDetail) || (is_array($checkHistoryDetail) && empty($checkHistoryDetail))) {
            unset($this->CheckHistoryDetail);
        } else {
            $this->CheckHistoryDetail = $checkHistoryDetail;
        }
        return $this;
    }
    /**
     * Add item to CheckHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CheckHistoryDetail $item
     * @return \AcumaticaConfig\StructType\History
     */
    public function addToCheckHistoryDetail(\AcumaticaConfig\StructType\CheckHistoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CheckHistoryDetail) {
            throw new \InvalidArgumentException(sprintf('The CheckHistoryDetail property can only contain items of \AcumaticaConfig\StructType\CheckHistoryDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CheckHistoryDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\History
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
