<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeCostRecord StructType
 * @subpackage Structs
 */
class EmployeeCostRecord extends Entity
{
    /**
     * The AnnualSalaryAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $AnnualSalaryAmount;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $EffectiveDate;
    /**
     * The HourlyRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $HourlyRate;
    /**
     * The RegularHoursPerWeek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $RegularHoursPerWeek;
    /**
     * The TypeOfEmployment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TypeOfEmployment;
    /**
     * Constructor method for EmployeeCostRecord
     * @uses EmployeeCostRecord::setAnnualSalaryAmount()
     * @uses EmployeeCostRecord::setEffectiveDate()
     * @uses EmployeeCostRecord::setHourlyRate()
     * @uses EmployeeCostRecord::setRegularHoursPerWeek()
     * @uses EmployeeCostRecord::setTypeOfEmployment()
     * @param \AcumaticaConfig\StructType\DecimalValue $annualSalaryAmount
     * @param \AcumaticaConfig\StructType\DateTimeValue $effectiveDate
     * @param \AcumaticaConfig\StructType\DecimalValue $hourlyRate
     * @param \AcumaticaConfig\StructType\DecimalValue $regularHoursPerWeek
     * @param \AcumaticaConfig\StructType\StringValue $typeOfEmployment
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $annualSalaryAmount = null, \AcumaticaConfig\StructType\DateTimeValue $effectiveDate = null, \AcumaticaConfig\StructType\DecimalValue $hourlyRate = null, \AcumaticaConfig\StructType\DecimalValue $regularHoursPerWeek = null, \AcumaticaConfig\StructType\StringValue $typeOfEmployment = null)
    {
        $this
            ->setAnnualSalaryAmount($annualSalaryAmount)
            ->setEffectiveDate($effectiveDate)
            ->setHourlyRate($hourlyRate)
            ->setRegularHoursPerWeek($regularHoursPerWeek)
            ->setTypeOfEmployment($typeOfEmployment);
    }
    /**
     * Get AnnualSalaryAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getAnnualSalaryAmount()
    {
        return isset($this->AnnualSalaryAmount) ? $this->AnnualSalaryAmount : null;
    }
    /**
     * Set AnnualSalaryAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $annualSalaryAmount
     * @return \AcumaticaConfig\StructType\EmployeeCostRecord
     */
    public function setAnnualSalaryAmount(\AcumaticaConfig\StructType\DecimalValue $annualSalaryAmount = null)
    {
        if (is_null($annualSalaryAmount) || (is_array($annualSalaryAmount) && empty($annualSalaryAmount))) {
            unset($this->AnnualSalaryAmount);
        } else {
            $this->AnnualSalaryAmount = $annualSalaryAmount;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getEffectiveDate()
    {
        return isset($this->EffectiveDate) ? $this->EffectiveDate : null;
    }
    /**
     * Set EffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $effectiveDate
     * @return \AcumaticaConfig\StructType\EmployeeCostRecord
     */
    public function setEffectiveDate(\AcumaticaConfig\StructType\DateTimeValue $effectiveDate = null)
    {
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->EffectiveDate);
        } else {
            $this->EffectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get HourlyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getHourlyRate()
    {
        return isset($this->HourlyRate) ? $this->HourlyRate : null;
    }
    /**
     * Set HourlyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $hourlyRate
     * @return \AcumaticaConfig\StructType\EmployeeCostRecord
     */
    public function setHourlyRate(\AcumaticaConfig\StructType\DecimalValue $hourlyRate = null)
    {
        if (is_null($hourlyRate) || (is_array($hourlyRate) && empty($hourlyRate))) {
            unset($this->HourlyRate);
        } else {
            $this->HourlyRate = $hourlyRate;
        }
        return $this;
    }
    /**
     * Get RegularHoursPerWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getRegularHoursPerWeek()
    {
        return isset($this->RegularHoursPerWeek) ? $this->RegularHoursPerWeek : null;
    }
    /**
     * Set RegularHoursPerWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $regularHoursPerWeek
     * @return \AcumaticaConfig\StructType\EmployeeCostRecord
     */
    public function setRegularHoursPerWeek(\AcumaticaConfig\StructType\DecimalValue $regularHoursPerWeek = null)
    {
        if (is_null($regularHoursPerWeek) || (is_array($regularHoursPerWeek) && empty($regularHoursPerWeek))) {
            unset($this->RegularHoursPerWeek);
        } else {
            $this->RegularHoursPerWeek = $regularHoursPerWeek;
        }
        return $this;
    }
    /**
     * Get TypeOfEmployment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTypeOfEmployment()
    {
        return isset($this->TypeOfEmployment) ? $this->TypeOfEmployment : null;
    }
    /**
     * Set TypeOfEmployment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $typeOfEmployment
     * @return \AcumaticaConfig\StructType\EmployeeCostRecord
     */
    public function setTypeOfEmployment(\AcumaticaConfig\StructType\StringValue $typeOfEmployment = null)
    {
        if (is_null($typeOfEmployment) || (is_array($typeOfEmployment) && empty($typeOfEmployment))) {
            unset($this->TypeOfEmployment);
        } else {
            $this->TypeOfEmployment = $typeOfEmployment;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\EmployeeCostRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
