<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Duplicates StructType
 * @subpackage Structs
 */
class Duplicates extends AbstractStructBase
{
    /**
     * The DuplicateDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DuplicateDetail[]
     */
    public $DuplicateDetail;
    /**
     * The ContactDuplicateDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ContactDuplicateDetail[]
     */
    public $ContactDuplicateDetail;
    /**
     * Constructor method for Duplicates
     * @uses Duplicates::setDuplicateDetail()
     * @uses Duplicates::setContactDuplicateDetail()
     * @param \AcumaticaConfig\StructType\DuplicateDetail[] $duplicateDetail
     * @param \AcumaticaConfig\StructType\ContactDuplicateDetail[] $contactDuplicateDetail
     */
    public function __construct(array $duplicateDetail = array(), array $contactDuplicateDetail = array())
    {
        $this
            ->setDuplicateDetail($duplicateDetail)
            ->setContactDuplicateDetail($contactDuplicateDetail);
    }
    /**
     * Get DuplicateDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DuplicateDetail[]|null
     */
    public function getDuplicateDetail()
    {
        return isset($this->DuplicateDetail) ? $this->DuplicateDetail : null;
    }
    /**
     * Set DuplicateDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\DuplicateDetail[] $duplicateDetail
     * @return \AcumaticaConfig\StructType\Duplicates
     */
    public function setDuplicateDetail(array $duplicateDetail = array())
    {
        foreach ($duplicateDetail as $duplicatesDuplicateDetailItem) {
            // validation for constraint: itemType
            if (!$duplicatesDuplicateDetailItem instanceof \AcumaticaConfig\StructType\DuplicateDetail) {
                throw new \InvalidArgumentException(sprintf('The DuplicateDetail property can only contain items of \AcumaticaConfig\StructType\DuplicateDetail, "%s" given', is_object($duplicatesDuplicateDetailItem) ? get_class($duplicatesDuplicateDetailItem) : gettype($duplicatesDuplicateDetailItem)), __LINE__);
            }
        }
        if (is_null($duplicateDetail) || (is_array($duplicateDetail) && empty($duplicateDetail))) {
            unset($this->DuplicateDetail);
        } else {
            $this->DuplicateDetail = $duplicateDetail;
        }
        return $this;
    }
    /**
     * Add item to DuplicateDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\DuplicateDetail $item
     * @return \AcumaticaConfig\StructType\Duplicates
     */
    public function addToDuplicateDetail(\AcumaticaConfig\StructType\DuplicateDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\DuplicateDetail) {
            throw new \InvalidArgumentException(sprintf('The DuplicateDetail property can only contain items of \AcumaticaConfig\StructType\DuplicateDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DuplicateDetail[] = $item;
        return $this;
    }
    /**
     * Get ContactDuplicateDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ContactDuplicateDetail[]|null
     */
    public function getContactDuplicateDetail()
    {
        return isset($this->ContactDuplicateDetail) ? $this->ContactDuplicateDetail : null;
    }
    /**
     * Set ContactDuplicateDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ContactDuplicateDetail[] $contactDuplicateDetail
     * @return \AcumaticaConfig\StructType\Duplicates
     */
    public function setContactDuplicateDetail(array $contactDuplicateDetail = array())
    {
        foreach ($contactDuplicateDetail as $duplicatesContactDuplicateDetailItem) {
            // validation for constraint: itemType
            if (!$duplicatesContactDuplicateDetailItem instanceof \AcumaticaConfig\StructType\ContactDuplicateDetail) {
                throw new \InvalidArgumentException(sprintf('The ContactDuplicateDetail property can only contain items of \AcumaticaConfig\StructType\ContactDuplicateDetail, "%s" given', is_object($duplicatesContactDuplicateDetailItem) ? get_class($duplicatesContactDuplicateDetailItem) : gettype($duplicatesContactDuplicateDetailItem)), __LINE__);
            }
        }
        if (is_null($contactDuplicateDetail) || (is_array($contactDuplicateDetail) && empty($contactDuplicateDetail))) {
            unset($this->ContactDuplicateDetail);
        } else {
            $this->ContactDuplicateDetail = $contactDuplicateDetail;
        }
        return $this;
    }
    /**
     * Add item to ContactDuplicateDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ContactDuplicateDetail $item
     * @return \AcumaticaConfig\StructType\Duplicates
     */
    public function addToContactDuplicateDetail(\AcumaticaConfig\StructType\ContactDuplicateDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ContactDuplicateDetail) {
            throw new \InvalidArgumentException(sprintf('The ContactDuplicateDetail property can only contain items of \AcumaticaConfig\StructType\ContactDuplicateDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactDuplicateDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Duplicates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
