<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Discounts StructType
 * @subpackage Structs
 */
class Discounts extends AbstractStructBase
{
    /**
     * The OpportunityDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\OpportunityDiscount[]
     */
    public $OpportunityDiscount;
    /**
     * Constructor method for Discounts
     * @uses Discounts::setOpportunityDiscount()
     * @param \AcumaticaConfig\StructType\OpportunityDiscount[] $opportunityDiscount
     */
    public function __construct(array $opportunityDiscount = array())
    {
        $this
            ->setOpportunityDiscount($opportunityDiscount);
    }
    /**
     * Get OpportunityDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\OpportunityDiscount[]|null
     */
    public function getOpportunityDiscount()
    {
        return isset($this->OpportunityDiscount) ? $this->OpportunityDiscount : null;
    }
    /**
     * Set OpportunityDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OpportunityDiscount[] $opportunityDiscount
     * @return \AcumaticaConfig\StructType\Discounts
     */
    public function setOpportunityDiscount(array $opportunityDiscount = array())
    {
        foreach ($opportunityDiscount as $discountsOpportunityDiscountItem) {
            // validation for constraint: itemType
            if (!$discountsOpportunityDiscountItem instanceof \AcumaticaConfig\StructType\OpportunityDiscount) {
                throw new \InvalidArgumentException(sprintf('The OpportunityDiscount property can only contain items of \AcumaticaConfig\StructType\OpportunityDiscount, "%s" given', is_object($discountsOpportunityDiscountItem) ? get_class($discountsOpportunityDiscountItem) : gettype($discountsOpportunityDiscountItem)), __LINE__);
            }
        }
        if (is_null($opportunityDiscount) || (is_array($opportunityDiscount) && empty($opportunityDiscount))) {
            unset($this->OpportunityDiscount);
        } else {
            $this->OpportunityDiscount = $opportunityDiscount;
        }
        return $this;
    }
    /**
     * Add item to OpportunityDiscount value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OpportunityDiscount $item
     * @return \AcumaticaConfig\StructType\Discounts
     */
    public function addToOpportunityDiscount(\AcumaticaConfig\StructType\OpportunityDiscount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\OpportunityDiscount) {
            throw new \InvalidArgumentException(sprintf('The OpportunityDiscount property can only contain items of \AcumaticaConfig\StructType\OpportunityDiscount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OpportunityDiscount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Discounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
